/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import java.io.IOException;
import java.io.InputStream;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.t3client.MarshalReaderImpl;
import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;
import weblogic.jms.dotnet.transport.t3client.T3;
import weblogic.jms.dotnet.transport.t3client.T3Abbrev;
import weblogic.jms.dotnet.transport.t3client.T3Header;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;

public class T3Message {
    private T3Header hdr;
    private T3Abbrev[] abbrevs;
    private MarshalReaderImpl payload;
    private byte[] abbrevAsByte;
    private static final boolean DEBUG_READ_ABBREVS = false;

    private T3Message() {
    }

    T3Message(T3Header t3Header, T3Abbrev[] t3AbbrevArray) {
        this.hdr = t3Header;
        this.abbrevs = t3AbbrevArray;
    }

    void cleanup() {
        if (this.payload != null) {
            this.payload.internalClose();
        }
    }

    T3Header getMessageHeader() {
        return this.hdr;
    }

    MarshalReaderImpl getPayload() {
        return this.payload;
    }

    T3Abbrev[] getAbbrevs() {
        return this.abbrevs;
    }

    int getBodyLength() {
        return this.hdr.getOffset() - T3.PROTOCOL_HDR_SIZE;
    }

    void write(MarshalWriterImpl marshalWriterImpl) throws Exception {
        int n;
        int n2 = this.abbrevs != null ? this.abbrevs.length : 0;
        int n3 = 0;
        if (this.abbrevs != null) {
            n3 = T3.getLengthNumBytes(this.abbrevs.length);
            T3Abbrev[] t3AbbrevArray = this.abbrevs;
            n = t3AbbrevArray.length;
            for (int i = 0; i < n; ++i) {
                T3Abbrev t3Abbrev = t3AbbrevArray[i];
                n3 += t3Abbrev.size();
            }
        }
        this.hdr.setMessageLength(marshalWriterImpl.getPosition() + n3);
        this.hdr.setOffset(marshalWriterImpl.getPosition());
        int n4 = marshalWriterImpl.getPosition();
        marshalWriterImpl.setPosition(0);
        this.hdr.write(marshalWriterImpl);
        marshalWriterImpl.setPosition(n4);
        T3.writeLength(marshalWriterImpl, n2);
        if (this.abbrevs != null) {
            for (n = 0; n < this.abbrevs.length; ++n) {
                this.abbrevs[n].write(marshalWriterImpl);
            }
        }
    }

    static T3Message readT3Message(InputStream inputStream, Transport transport) throws Exception {
        T3Message t3Message = new T3Message();
        Chunk chunk = Chunk.getChunk();
        chunk.end = T3.PROTOCOL_HDR_SIZE;
        for (int i = 0; i < T3.PROTOCOL_HDR_SIZE; i += inputStream.read(chunk.buf, i, T3.PROTOCOL_HDR_SIZE - i)) {
        }
        ChunkedDataInputStream chunkedDataInputStream = new ChunkedDataInputStream(chunk, 0);
        chunkedDataInputStream.mark(0);
        MarshalReaderImpl marshalReaderImpl = new MarshalReaderImpl(chunkedDataInputStream, transport);
        t3Message.hdr = new T3Header(marshalReaderImpl);
        int n = t3Message.hdr.getMessageLength();
        if ((n -= T3.PROTOCOL_HDR_SIZE) != Chunk.chunk((Chunk)chunk, (InputStream)inputStream, (int)n)) {
            throw new IOException("EOF reached");
        }
        chunkedDataInputStream.reset();
        chunkedDataInputStream.skipBytes(T3.PROTOCOL_HDR_SIZE);
        t3Message.payload = marshalReaderImpl;
        return t3Message;
    }

    void print() {
        System.out.println(this.hdr);
        System.out.println("{  ***** abbrev *****");
        if (this.abbrevAsByte != null) {
            for (int i = 1; i <= this.abbrevAsByte.length; ++i) {
                System.out.print("" + this.abbrevAsByte[i - 1] + " ");
                if (i % 10 != 0) continue;
                System.out.print("\n");
            }
            System.out.println("");
        } else if (this.abbrevs != null) {
            for (int i = 0; i < this.abbrevs.length; ++i) {
                System.out.println("id: " + this.abbrevs[i].getId());
                byte[] byArray = this.abbrevs[i].getContent();
                if (byArray == null || byArray.length == 0) continue;
                for (int j = 1; j <= byArray.length; ++j) {
                    System.out.print("" + byArray[j - 1] + " ");
                    if (j % 10 != 0) continue;
                    System.out.print("\n");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("}\n");
    }

    void printAbbrevs() throws Exception {
    }

    private static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new IOException("EOF");
        }
        return (byte)n;
    }

    private static int readLength(InputStream inputStream) throws Exception {
        byte by = T3Message.readByte(inputStream);
        int n = by & 0xFF;
        if (n < 254) {
            return n;
        }
        if (n == 254) {
            int n2 = T3Message.readByte(inputStream) & 0xFF;
            int n3 = T3Message.readByte(inputStream) & 0xFF;
            return (n2 << 8) + n3;
        }
        int n4 = T3Message.readByte(inputStream) & 0xFF;
        int n5 = T3Message.readByte(inputStream) & 0xFF;
        int n6 = T3Message.readByte(inputStream) & 0xFF;
        int n7 = T3Message.readByte(inputStream) & 0xFF;
        return (n4 << 24) + (n5 << 16) + (n6 << 8) + (n7 << 0);
    }
}

