/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import java.util.StringTokenizer;
import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;

public class T3PeerInfo {
    public static int DEFAULT_PROTOCOL_VERSION_MAJOR = 10;
    public static int DEFAULT_PROTOCOL_VERSION_MINOR = 0;
    public static int DEFAULT_PROTOCOL_VERSION_SERVICEPACK = 0;
    public static int DEFAULT_PROTOCOL_VERSION_ROLLINGPATCH = 0;
    public static boolean DEFAULT_PROTOCOL_VERSION_TEMPORARYPATCH = false;
    public static T3PeerInfo defaultPeerInfo = new T3PeerInfo(DEFAULT_PROTOCOL_VERSION_MAJOR, DEFAULT_PROTOCOL_VERSION_MINOR, DEFAULT_PROTOCOL_VERSION_SERVICEPACK, DEFAULT_PROTOCOL_VERSION_ROLLINGPATCH, DEFAULT_PROTOCOL_VERSION_TEMPORARYPATCH);
    private int major;
    private int minor;
    private int servicepack;
    private int rollingpatch;
    private boolean temporarypatch;

    T3PeerInfo(int n, int n2, int n3, int n4, boolean bl) {
        this.major = n;
        this.minor = n2;
        this.servicepack = n3;
        this.rollingpatch = n4;
        this.temporarypatch = bl;
    }

    T3PeerInfo(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 5) {
            throw new Exception("Unknown version syntax " + string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            switch (++n) {
                case 1: {
                    n2 = Integer.parseInt(string2);
                    break;
                }
                case 2: {
                    n3 = Integer.parseInt(string2);
                    break;
                }
                case 3: {
                    n4 = Integer.parseInt(string2);
                    break;
                }
                case 4: {
                    n5 = Integer.parseInt(string2);
                    break;
                }
                case 5: {
                    bl = new Boolean(string2);
                }
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getServicePack() {
        return this.servicepack;
    }

    public int getRollingPatch() {
        return this.rollingpatch;
    }

    public boolean isTemporaryPatch() {
        return this.temporarypatch;
    }

    public String getVersion() {
        return "" + this.major + "." + this.minor + "." + this.servicepack + "." + this.rollingpatch;
    }

    public void write(MarshalWriterImpl marshalWriterImpl) {
        marshalWriterImpl.writeInt(this.major);
        marshalWriterImpl.writeInt(this.minor);
        marshalWriterImpl.writeInt(this.servicepack);
        marshalWriterImpl.writeInt(this.rollingpatch);
        marshalWriterImpl.writeBoolean(this.temporarypatch);
    }

    public String getDefaultVersion() {
        return DEFAULT_PROTOCOL_VERSION_MAJOR + "." + DEFAULT_PROTOCOL_VERSION_MINOR + "." + DEFAULT_PROTOCOL_VERSION_SERVICEPACK + "." + DEFAULT_PROTOCOL_VERSION_ROLLINGPATCH;
    }
}

