/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import weblogic.jms.dotnet.transport.MarshalReadableFactory;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.TransportFactory;
import weblogic.jms.dotnet.transport.TransportPluginSPI;
import weblogic.jms.dotnet.transport.TransportThreadPool;
import weblogic.jms.dotnet.transport.t3client.MarshalReaderImpl;
import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;
import weblogic.jms.dotnet.transport.t3client.ShutdownListener;
import weblogic.jms.dotnet.transport.t3client.T3Connection;

public class TransportSPIImpl
implements Runnable,
TransportPluginSPI {
    private final T3Connection t3conn;
    private Transport transport;
    private static final long HALFLONG = 0x3FFFFFFFFFFFFFFFL;

    private TransportSPIImpl(T3Connection t3Connection) {
        this.t3conn = t3Connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Transport startClient(String string, int n, MarshalReadableFactory marshalReadableFactory, TransportThreadPool transportThreadPool) throws Exception {
        T3Connection t3Connection = new T3Connection(string, n, null, 1);
        TransportSPIImpl transportSPIImpl = new TransportSPIImpl(t3Connection);
        Transport transport = TransportFactory.createTransport(transportSPIImpl, transportThreadPool);
        transport.addMarshalReadableFactory(marshalReadableFactory);
        Runnable runnable = transportSPIImpl;
        synchronized (runnable) {
            transportSPIImpl.transport = transport;
        }
        runnable = new Thread(transportSPIImpl);
        ((Thread)runnable).setDaemon(true);
        ((Thread)runnable).start();
        long l = transport.allocateServiceID();
        transport.registerService(l, new ShutdownListener(t3Connection));
        return transport;
    }

    public MarshalWriter createMarshalWriter() {
        MarshalWriterImpl marshalWriterImpl = new MarshalWriterImpl(this.transport);
        return T3Connection.createOneWay(marshalWriterImpl);
    }

    public synchronized void send(MarshalWriter marshalWriter) {
        MarshalWriterImpl marshalWriterImpl = (MarshalWriterImpl)marshalWriter;
        Throwable throwable = null;
        try {
            this.t3conn.sendOneWay(marshalWriterImpl);
        }
        catch (Error error) {
            throwable = error;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Exception exception) {
            throwable = exception;
        }
        if (throwable != null) {
            this.transport.shutdown(new TransportError(throwable));
        }
    }

    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    MarshalReaderImpl marshalReaderImpl = this.t3conn.receiveOneWay(this.transport);
                    try {
                        this.transport.dispatch(marshalReaderImpl);
                        continue block4;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.transport.shutdown(new TransportError(throwable));
                return;
            }
        }
    }

    public long getScratchID() {
        long l = this.t3conn.getScratchID();
        long l2 = l / 11L * 6L & 0x413949D71031057FL & 0x3FFFFFFFFFFFFFFFL;
        return l2;
    }

    public void terminateConnection() {
        this.t3conn.close();
    }
}

