/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3plugin;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.utils.io.ChunkedDataInputStream;

public class MarshalReaderImpl
extends InputStream
implements MarshalReader,
DataInput {
    private final Transport transport;
    private final ChunkedDataInputStream cdis;

    MarshalReaderImpl(Transport transport, ChunkedDataInputStream chunkedDataInputStream) {
        this.transport = transport;
        this.cdis = chunkedDataInputStream;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public MarshalReadable readMarshalable() {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.cdis.pos() + n2;
        if (this.cdis.peek(n2) == -1) {
            throw new RuntimeException("EOF detected. Stream does not have enough bytes for reading entire MarshalReadable object(Marshal type code=" + n + ")");
        }
        MarshalReadable marshalReadable = this.transport.createMarshalReadable(n);
        marshalReadable.unmarshal(this);
        if (this.cdis.pos() < n3) {
            try {
                this.cdis.skip((long)(n3 - this.cdis.pos()));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return marshalReadable;
    }

    public int read() {
        try {
            return this.cdis.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public byte readByte() {
        try {
            return this.cdis.readByte();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        try {
            return this.cdis.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean readBoolean() {
        try {
            return this.cdis.readBoolean();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public short readShort() {
        try {
            return this.cdis.readShort();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public char readChar() {
        try {
            return this.cdis.readChar();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public int readInt() {
        try {
            return this.cdis.readInt();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public long readLong() {
        try {
            return this.cdis.readLong();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public float readFloat() {
        try {
            return this.cdis.readFloat();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public double readDouble() {
        try {
            return this.cdis.readDouble();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String readString() {
        try {
            return this.cdis.readUTF8();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public byte[] readStringAsBytes() {
        try {
            int n = this.cdis.peekInt();
            byte[] byArray = new byte[n + 4];
            this.cdis.read(byArray, 0, byArray.length);
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void internalClose() {
        this.cdis.close();
    }

    public DataInput getDataInputStream() {
        return this;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("unresolvable");
    }

    public void readFully(byte[] byArray) throws IOException {
        throw new IOException("unresolvable");
    }

    public String readLine() throws IOException {
        throw new IOException("unresolvable");
    }

    public int readUnsignedByte() throws IOException {
        throw new IOException("unresolvable");
    }

    public int readUnsignedShort() throws IOException {
        throw new IOException("unresolvable");
    }

    public String readUTF() throws IOException {
        throw new IOException("unresolvable");
    }

    public int skipBytes(int n) throws IOException {
        throw new IOException("unresolvable");
    }
}

