/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3plugin;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.utils.io.ChunkedDataOutputStream;

public class MarshalWriterImpl
extends OutputStream
implements MarshalWriter,
DataOutput {
    private final Transport transport;
    private final ChunkedDataOutputStream cdos;
    private final Throwable throwable;

    MarshalWriterImpl(Transport transport, ChunkedDataOutputStream chunkedDataOutputStream) {
        this.transport = transport;
        this.cdos = chunkedDataOutputStream;
        this.throwable = null;
    }

    MarshalWriterImpl(Transport transport, Throwable throwable) {
        this.transport = transport;
        this.cdos = new ChunkedDataOutputStream();
        this.throwable = throwable;
    }

    Throwable getThrowable() {
        return this.throwable;
    }

    ChunkedDataOutputStream getChunkedDataOutputStream() {
        return this.cdos;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void writeMarshalable(MarshalWritable marshalWritable) {
        this.writeInt(marshalWritable.getMarshalTypeCode());
        int n = this.cdos.getPosition();
        this.writeInt(Integer.MIN_VALUE);
        int n2 = this.cdos.getPosition();
        marshalWritable.marshal(this);
        int n3 = this.cdos.getPosition();
        int n4 = n3 - n2;
        this.cdos.setPosition(n);
        this.writeInt(n4);
        this.cdos.setPosition(n3);
    }

    public void writeByte(byte by) {
        this.cdos.writeByte((int)by);
    }

    public void writeUnsignedByte(int n) {
        this.cdos.writeByte((int)((byte)(n & 0xFF)));
    }

    public void write(byte[] byArray, int n, int n2) {
        this.cdos.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) {
        this.cdos.writeBoolean(bl);
    }

    public void writeShort(short s) {
        this.cdos.writeShort((int)s);
    }

    public void writeChar(char c) {
        this.cdos.writeChar((int)c);
    }

    public void writeInt(int n) {
        this.cdos.writeInt(n);
    }

    public void writeLong(long l) {
        this.cdos.writeLong(l);
    }

    public void writeFloat(float f) {
        this.cdos.writeFloat(f);
    }

    public void writeDouble(double d) {
        this.cdos.writeDouble(d);
    }

    public void writeString(String string) {
        this.cdos.writeUTF8(string);
    }

    void closeInternal() {
        try {
            this.cdos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataOutput getDataOutputStream() {
        return this;
    }

    public void writeByte(int n) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeBytes(String string) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeChar(int n) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeChars(String string) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeShort(int n) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeUTF(String string) throws IOException {
        throw new IOException("unresolvable");
    }

    public void write(int n) throws IOException {
        throw new IOException("unresolvable");
    }
}

