/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3plugin;

import weblogic.jms.dotnet.t3.server.spi.T3Connection;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.TransportPluginSPI;
import weblogic.jms.dotnet.transport.t3plugin.MarshalWriterImpl;
import weblogic.jms.dotnet.transport.t3plugin.T3ConnectionHandleImpl;

class SPIImpl
implements TransportPluginSPI {
    private final T3ConnectionHandleImpl chi;
    private final T3Connection t3Conn;
    private static final long HALFLONG = 0x3FFFFFFFFFFFFFFFL;

    SPIImpl(T3ConnectionHandleImpl t3ConnectionHandleImpl, T3Connection t3Connection) {
        this.t3Conn = t3Connection;
        this.chi = t3ConnectionHandleImpl;
    }

    public MarshalWriter createMarshalWriter() {
        try {
            return new MarshalWriterImpl(this.chi.getTransport(), this.t3Conn.getRequestStream());
        }
        catch (Throwable throwable) {
            return new MarshalWriterImpl(this.chi.getTransport(), throwable);
        }
    }

    public void send(MarshalWriter marshalWriter) {
        Throwable throwable = null;
        MarshalWriterImpl marshalWriterImpl = (MarshalWriterImpl)marshalWriter;
        throwable = marshalWriterImpl.getThrowable();
        if (throwable == null) {
            try {
                this.t3Conn.send(marshalWriterImpl.getChunkedDataOutputStream());
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        } else {
            marshalWriterImpl.closeInternal();
        }
        this.chi.shutdown(new TransportError(throwable));
    }

    public long getScratchID() {
        long l = this.t3Conn.getRJVMId().getDifferentiator();
        long l2 = l / 11L * 6L & 0x413949D71031057FL & 0x3FFFFFFFFFFFFFFFL;
        return l2;
    }

    public void terminateConnection() {
        this.t3Conn.shutdown();
    }
}

