/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3plugin;

import java.io.IOException;
import weblogic.jms.dotnet.t3.server.spi.T3Connection;
import weblogic.jms.dotnet.t3.server.spi.T3ConnectionGoneEvent;
import weblogic.jms.dotnet.t3.server.spi.T3ConnectionHandle;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.TransportFactory;
import weblogic.jms.dotnet.transport.t3plugin.MarshalReaderImpl;
import weblogic.jms.dotnet.transport.t3plugin.SPIImpl;
import weblogic.jms.dotnet.transport.t3plugin.ThreadPoolImpl;
import weblogic.utils.io.ChunkedDataInputStream;

public class T3ConnectionHandleImpl
implements T3ConnectionHandle {
    private final Object lock = new Object();
    private final T3Connection client;
    private final Transport transport;
    private boolean isClosed;

    T3ConnectionHandleImpl(T3Connection t3Connection) {
        this.client = t3Connection;
        SPIImpl sPIImpl = new SPIImpl(this, t3Connection);
        ThreadPoolImpl threadPoolImpl = new ThreadPoolImpl();
        this.transport = TransportFactory.createTransport(sPIImpl, threadPoolImpl);
    }

    Transport getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPeerGone(T3ConnectionGoneEvent t3ConnectionGoneEvent) {
        IOException iOException = t3ConnectionGoneEvent.getReason();
        if (iOException == null) {
            iOException = new IOException("unknown");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.transport.shutdown(new TransportError(iOException));
    }

    public void onMessage(ChunkedDataInputStream chunkedDataInputStream) {
        MarshalReaderImpl marshalReaderImpl = new MarshalReaderImpl(this.transport, chunkedDataInputStream);
        this.transport.dispatch(marshalReaderImpl);
    }

    void shutdown(TransportError transportError) {
        this.transport.shutdown(transportError);
        this.client.shutdown();
    }
}

