/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import weblogic.jms.common.SecHelper;
import weblogic.security.internal.ServerAuthenticate;

public class ClientSAFEncrypt {
    private static final String QUIT_WORD = "quit";
    private static final String TAG_START = "<password-encrypted>";
    private static final String TAG_END = "</password-encrypted>";

    private String composeLine(String string) {
        return TAG_START + string + TAG_END;
    }

    private void go(String[] stringArray) throws Throwable {
        char[] cArray;
        String string;
        if (stringArray.length <= 0) {
            string = ServerAuthenticate.promptValue("Password Key (\"quit\" to end): ", false);
            if (string == null || QUIT_WORD.equals(string)) {
                return;
            }
            cArray = string.toCharArray();
        } else {
            cArray = stringArray[0].toCharArray();
        }
        if (stringArray.length <= 1) {
            while ((string = ServerAuthenticate.promptValue("Password (\"quit\" to end): ", false)) != null && !QUIT_WORD.equals(string)) {
                System.out.println(this.composeLine(SecHelper.encryptString(cArray, string)));
            }
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                System.out.println(this.composeLine(SecHelper.encryptString(cArray, string2)));
            }
        }
    }

    public static void main(String[] stringArray) {
        ClientSAFEncrypt clientSAFEncrypt = new ClientSAFEncrypt();
        try {
            clientSAFEncrypt.go(stringArray);
        }
        catch (Throwable throwable) {
            int n = 0;
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                System.err.println("\nERROR: run threw an exception: level " + n);
                ++n;
                throwable2.printStackTrace();
            }
        }
    }
}

