/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.jms.JMSException;
import weblogic.jms.extensions.ClientSAF;
import weblogic.jms.extensions.ClientSAFDuplicateException;
import weblogic.jms.safclient.ClientSAFImpl;
import weblogic.kernel.KernelStatus;

public class ClientSAFFactory {
    private static final String DEFAULT_FILENAME = "ClientSAF.xml";

    public static ClientSAF getClientSAF() throws ClientSAFDuplicateException, JMSException {
        try {
            return ClientSAFFactory.getClientSAF(new FileInputStream(new File(DEFAULT_FILENAME)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new weblogic.jms.common.JMSException(fileNotFoundException);
        }
    }

    public static ClientSAF getClientSAF(InputStream inputStream) throws ClientSAFDuplicateException, JMSException {
        String string = System.getProperty("user.dir");
        if (string == null) {
            throw new JMSException("Cannot get the users current working directory");
        }
        return ClientSAFFactory.getClientSAF(new File(string), inputStream);
    }

    public static ClientSAF getClientSAF(File file, InputStream inputStream) throws ClientSAFDuplicateException, JMSException {
        if (KernelStatus.isServer()) {
            throw new JMSException("An attempt was made to create a SAF client on a WLS server");
        }
        if (inputStream == null) {
            throw new JMSException("Must have an input stream");
        }
        ClientSAFImpl clientSAFImpl = new ClientSAFImpl(file, inputStream);
        return clientSAFImpl;
    }
}

