/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.ClientSAFBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.j2ee.descriptor.wl.SAFLoginContextBean;
import weblogic.j2ee.descriptor.wl.SAFQueueBean;
import weblogic.j2ee.descriptor.wl.SAFRemoteContextBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedQueueBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.jms.common.BeanHelper;
import weblogic.jms.extensions.ClientSAFParser;
import weblogic.jms.module.JMSParser;
import weblogic.management.ManagementException;
import weblogic.utils.Getopt2;

public class ClientSAFGenerate {
    private static final String URL_OPT = "url";
    private static final String URL_PARAM = "admin-server-url";
    private static final String URL_DOC = "The URL of the admin server to connect to. If not specified then this utility will run in off-line mode";
    private static final String UN_OPT = "username";
    private static final String UN_PARAM = "name-of-user";
    private static final String UN_DOC = "The username of a user with read access to the Domain. Only used in connected mode";
    private static final String ECF_OPT = "existingClientFile";
    private static final String ECF_PARAM = "file-path";
    private static final String ECF_DOC = "The name of an existing client Store & Forward configuration file. If this parameter is specified then the existing file will be read and new entries will be added. If there are any conflicts detected between items being added and items already in the client configuration file a warning will be emitted and the new item will not be added. If this is specified but the file cannot be found an error is printed and the utility exits";
    private static final String MF_OPT = "moduleFile";
    private static final String MF_PARAM = "module-file-path ['@' plan-path ]";
    private static final String MF_DOC = "The name of a JMS module file. This file is not associated with any specific deployment. Only a few of the fields in the client configuration file can be filled in. This parameter can be used in both connected and off-line mode";
    private static final String OF_OPT = "outputFile";
    private static final String OF_PARAM = "output-file-path";
    private static final String OF_DOC = "The path to the output file";
    private static final String PROGRAM = "weblogic.jms.extensions.ClientSAFGenerate";
    private Getopt2 optionsParser = new Getopt2();
    private ClientSAFBean config;
    private static final String ALL = "All";

    public ClientSAFGenerate() {
        this.optionsParser.addOption(URL_OPT, URL_PARAM, URL_DOC);
        this.optionsParser.addOption(UN_OPT, UN_PARAM, UN_DOC);
        this.optionsParser.addOption(ECF_OPT, ECF_PARAM, ECF_DOC);
        this.optionsParser.addMultiOption(MF_OPT, MF_PARAM, MF_DOC);
        this.optionsParser.addOption(OF_OPT, OF_PARAM, OF_DOC);
        this.optionsParser.setFailOnUnrecognizedOpts(true);
    }

    private void initFile() {
    }

    private void extractFromJMSBean(String string, String string2, JMSBean jMSBean) throws ManagementException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string3;
        String string4;
        QueueBean[] queueBeanArray;
        JMSConnectionFactoryBean[] jMSConnectionFactoryBeanArray = jMSBean.getConnectionFactories();
        for (int i = 0; i < jMSConnectionFactoryBeanArray.length; ++i) {
            queueBeanArray = jMSConnectionFactoryBeanArray[i];
            if (this.config.lookupConnectionFactory(queueBeanArray.getName()) != null) {
                System.err.println("Warning: The connection factory " + queueBeanArray.getName() + "" + "already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            JMSConnectionFactoryBean jMSConnectionFactoryBean = this.config.createConnectionFactory(queueBeanArray.getName());
            BeanHelper.copyConnectionFactory(jMSConnectionFactoryBean, (JMSConnectionFactoryBean)queueBeanArray);
        }
        SAFImportedDestinationsBean sAFImportedDestinationsBean = this.config.lookupSAFImportedDestinations(string);
        if (sAFImportedDestinationsBean == null) {
            sAFImportedDestinationsBean = this.config.createSAFImportedDestinations(string);
        }
        if (string2 != null) {
            sAFImportedDestinationsBean.setSAFRemoteContext(this.config.lookupSAFRemoteContext(string2));
        }
        queueBeanArray = jMSBean.getQueues();
        for (int i = 0; i < queueBeanArray.length; ++i) {
            QueueBean queueBean = queueBeanArray[i];
            string4 = queueBean.getSAFExportPolicy();
            if (string4 != null && !ALL.equals(string4)) continue;
            string3 = queueBean.getJNDIName();
            if (string3 == null) {
                string3 = queueBean.getLocalJNDIName();
            }
            if ((object5 = sAFImportedDestinationsBean.lookupSAFQueue(queueBean.getName())) != null) {
                System.err.println("Warning: The queue " + queueBean.getName() + " in module " + string + " already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            object5 = sAFImportedDestinationsBean.createSAFQueue(queueBean.getName());
            if (string3 == null) continue;
            object5.setLocalJNDIName(string3);
            object5.setRemoteJNDIName(string3);
        }
        TopicBean[] topicBeanArray = jMSBean.getTopics();
        for (int i = 0; i < topicBeanArray.length; ++i) {
            string4 = topicBeanArray[i];
            string3 = string4.getSAFExportPolicy();
            if (string3 != null && !ALL.equals(string3)) continue;
            object5 = string4.getJNDIName();
            if (object5 == null) {
                object5 = string4.getLocalJNDIName();
            }
            if ((object4 = sAFImportedDestinationsBean.lookupSAFTopic(string4.getName())) != null) {
                System.err.println("Warning: The topic " + string4.getName() + " in module " + string + " already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            object4 = sAFImportedDestinationsBean.createSAFTopic(string4.getName());
            if (object5 == null) continue;
            object4.setLocalJNDIName((String)object5);
            object4.setRemoteJNDIName((String)object5);
        }
        DistributedQueueBean[] distributedQueueBeanArray = jMSBean.getDistributedQueues();
        for (int i = 0; i < distributedQueueBeanArray.length; ++i) {
            string3 = distributedQueueBeanArray[i];
            object5 = string3.getSAFExportPolicy();
            if (object5 != null && !ALL.equals(object5)) continue;
            object4 = string3.getJNDIName();
            object3 = sAFImportedDestinationsBean.lookupSAFQueue(string3.getName());
            if (object3 != null) {
                System.err.println("Warning: The distributed queue " + string3.getName() + " in module " + string + " already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            object3 = sAFImportedDestinationsBean.createSAFQueue(string3.getName());
            if (object4 == null) continue;
            object3.setLocalJNDIName((String)object4);
            object3.setRemoteJNDIName((String)object4);
        }
        DistributedTopicBean[] distributedTopicBeanArray = jMSBean.getDistributedTopics();
        for (int i = 0; i < distributedTopicBeanArray.length; ++i) {
            object5 = distributedTopicBeanArray[i];
            object4 = object5.getSAFExportPolicy();
            if (object4 != null && !ALL.equals(object4)) continue;
            object3 = object5.getJNDIName();
            object2 = sAFImportedDestinationsBean.lookupSAFQueue(object5.getName());
            if (object2 != null) {
                System.err.println("Warning: The distributed queue " + object5.getName() + " in module " + string + " already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            object2 = sAFImportedDestinationsBean.createSAFQueue(object5.getName());
            if (object3 == null) continue;
            object2.setLocalJNDIName((String)object3);
            object2.setRemoteJNDIName((String)object3);
        }
        UniformDistributedQueueBean[] uniformDistributedQueueBeanArray = jMSBean.getUniformDistributedQueues();
        for (int i = 0; i < uniformDistributedQueueBeanArray.length; ++i) {
            object4 = uniformDistributedQueueBeanArray[i];
            object3 = object4.getSAFExportPolicy();
            if (object3 != null && !ALL.equals(object3)) continue;
            object2 = object4.getJNDIName();
            object = sAFImportedDestinationsBean.lookupSAFQueue(object4.getName());
            if (object != null) {
                System.err.println("Warning: The distributed queue " + object4.getName() + " in module " + string + " already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            object = sAFImportedDestinationsBean.createSAFQueue(object4.getName());
            if (object2 == null) continue;
            object.setLocalJNDIName((String)object2);
            object.setRemoteJNDIName((String)object2);
        }
        UniformDistributedTopicBean[] uniformDistributedTopicBeanArray = jMSBean.getUniformDistributedTopics();
        for (int i = 0; i < uniformDistributedTopicBeanArray.length; ++i) {
            object3 = uniformDistributedTopicBeanArray[i];
            object2 = object3.getSAFExportPolicy();
            if (object2 != null && !ALL.equals(object2)) continue;
            object = object3.getJNDIName();
            SAFQueueBean sAFQueueBean = sAFImportedDestinationsBean.lookupSAFQueue(object3.getName());
            if (sAFQueueBean != null) {
                System.err.println("Warning: The uniform distributed queue " + object3.getName() + " in module " + string + " already exists in the client SAF configuration file.  Skipping...");
                continue;
            }
            sAFQueueBean = sAFImportedDestinationsBean.createSAFQueue(object3.getName());
            if (object == null) continue;
            sAFQueueBean.setLocalJNDIName((String)object);
            sAFQueueBean.setRemoteJNDIName((String)object);
        }
    }

    private String generateRemoteContext(ClientSAFBean clientSAFBean, String string, String string2) {
        String string3;
        Object object;
        int n;
        if (string == null) {
            return null;
        }
        SAFRemoteContextBean[] sAFRemoteContextBeanArray = clientSAFBean.getSAFRemoteContexts();
        for (n = 0; n < sAFRemoteContextBeanArray.length; ++n) {
            SAFRemoteContextBean sAFRemoteContextBean = sAFRemoteContextBeanArray[n];
            object = sAFRemoteContextBean.getSAFLoginContext();
            string3 = object.getLoginURL();
            if (!string.equals(string3)) continue;
            return sAFRemoteContextBean.getName();
        }
        n = 0;
        boolean bl = false;
        object = null;
        while (!bl) {
            string3 = "RemoteContext" + n++;
            if (clientSAFBean.lookupSAFRemoteContext(string3) != null) continue;
            object = string3;
            bl = true;
        }
        string3 = clientSAFBean.createSAFRemoteContext((String)object);
        SAFLoginContextBean sAFLoginContextBean = string3.getSAFLoginContext();
        sAFLoginContextBean.setLoginURL(string);
        if (string2 != null) {
            sAFLoginContextBean.setUsername(string2);
        }
        return object;
    }

    private void go(String[] stringArray) throws Throwable {
        Object object;
        Object object2;
        try {
            this.optionsParser.grok(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.optionsParser.usageError(PROGRAM);
            return;
        }
        String string = this.optionsParser.getOption(ECF_OPT);
        if (string != null) {
            this.config = ClientSAFParser.createClientSAFDescriptor(string);
        } else {
            this.config = (ClientSAFBean)new DescriptorManager().createDescriptorRoot(ClientSAFBean.class).getRootBean();
            this.initFile();
        }
        String string2 = this.optionsParser.getOption(URL_OPT);
        String string3 = this.optionsParser.getOption(UN_OPT);
        String string4 = this.generateRemoteContext(this.config, string2, string3);
        String[] stringArray2 = this.optionsParser.getMultiOption(MF_OPT, new String[100]);
        for (int i = 0; i < stringArray2.length; ++i) {
            object2 = stringArray2[i];
            object = new StringTokenizer((String)object2, "@");
            int n = ((StringTokenizer)object).countTokens();
            String string5 = ((StringTokenizer)object).nextToken();
            String string6 = null;
            if (n > 1) {
                string6 = ((StringTokenizer)object).nextToken();
            }
            File file = new File(string5);
            String string7 = file.getName().toLowerCase();
            JMSBean jMSBean = JMSParser.createJMSDescriptor(string5, string6);
            int n2 = string7.indexOf("-jms.xml");
            String string8 = string7.substring(0, n2);
            this.extractFromJMSBean(string8, string4, jMSBean);
        }
        String string9 = this.optionsParser.getOption(OF_OPT);
        if (string9 == null) {
            DescriptorUtils.writeAsXML((DescriptorBean)this.config);
            return;
        }
        object2 = new File(string9);
        object = new FileOutputStream((File)object2);
        Descriptor descriptor = ((DescriptorBean)this.config).getDescriptor();
        new EditableDescriptorManager().writeDescriptorAsXML(descriptor, (OutputStream)object);
    }

    public static void main(String[] stringArray) {
        ClientSAFGenerate clientSAFGenerate = new ClientSAFGenerate();
        try {
            clientSAFGenerate.go(stringArray);
        }
        catch (Throwable throwable) {
            int n = 0;
            for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                System.err.println("\nERROR: run threw an exception: level " + n);
                ++n;
                throwable2.printStackTrace();
            }
        }
    }
}

