/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ConsumerInfo {
    private static final String OPEN_TYPE_NAME = "ConsumerInfo";
    private static final String OPEN_DESCRIPTION = "This object represents a JMS Consumer.";
    private static final String ITEM_VERSION_NUMBER = "VersionNumber";
    private static final String ITEM_NAME = "Name";
    private static final String ITEM_DURABLE = "Durable";
    private static final String ITEM_SELECTOR = "Selector";
    private static final String ITEM_CLIENT_ID = "ClientID";
    private static final String ITEM_NO_LOCAL = "NoLocal";
    private static final String ITEM_CONNECTION_ADDRESS = "ConnectionAddress";
    private static String[] itemNames = new String[]{"VersionNumber", "Name", "Durable", "Selector", "ClientID", "NoLocal", "ConnectionAddress"};
    private static String[] itemDescriptions = new String[]{"The version number.", "The name of the consumer/subscription.", "Indicates whether this consumer is a durable subscriber.", "The JMS message selector associated with this consumer.", "The clientID of this consumer's connection.", "The NoLocal attribute of this subscriber.", "Addressing information about the consumer's connection that consists of the client's host address"};
    private static OpenType[] itemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING};
    private static final int VERSION = 1;
    private String name;
    private boolean durable;
    private String selector;
    private String clientID;
    private boolean noLocal;
    private String connectionAddress;

    public ConsumerInfo(CompositeData compositeData) {
        this.readCompositeData(compositeData);
    }

    public ConsumerInfo(String string, boolean bl, String string2, String string3, boolean bl2, String string4) {
        this.name = string;
        this.durable = bl;
        this.selector = string2;
        this.clientID = string3;
        this.noLocal = bl2;
        this.connectionAddress = string4;
    }

    public CompositeData toCompositeData() throws OpenDataException {
        CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this.getCompositeType(), this.getCompositeDataMap());
        return compositeDataSupport;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String string) {
        this.clientID = string;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public void setConnectionAddress(String string) {
        this.connectionAddress = string;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean bl) {
        this.durable = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean bl) {
        this.noLocal = bl;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String string) {
        this.selector = string;
    }

    protected void readCompositeData(CompositeData compositeData) {
        String string;
        Boolean bl;
        String string2;
        String string3;
        Boolean bl2;
        String string4 = (String)compositeData.get(ITEM_NAME);
        if (string4 != null) {
            this.setName(string4);
        }
        if ((bl2 = (Boolean)compositeData.get(ITEM_DURABLE)) != null) {
            this.setDurable(bl2);
        }
        if ((string3 = (String)compositeData.get(ITEM_SELECTOR)) != null) {
            this.setSelector(string3);
        }
        if ((string2 = (String)compositeData.get(ITEM_CLIENT_ID)) != null) {
            this.setClientID(string2);
        }
        if ((bl = (Boolean)compositeData.get(ITEM_NO_LOCAL)) != null) {
            this.setNoLocal(bl);
        }
        if ((string = (String)compositeData.get(ITEM_CONNECTION_ADDRESS)) != null) {
            this.setConnectionAddress(string);
        }
    }

    protected Map getCompositeDataMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ITEM_VERSION_NUMBER, new Integer(1));
        hashMap.put(ITEM_NAME, this.name);
        hashMap.put(ITEM_DURABLE, new Boolean(this.durable));
        hashMap.put(ITEM_SELECTOR, this.selector);
        hashMap.put(ITEM_CLIENT_ID, this.clientID);
        hashMap.put(ITEM_NO_LOCAL, new Boolean(this.noLocal));
        hashMap.put(ITEM_CONNECTION_ADDRESS, this.connectionAddress);
        return hashMap;
    }

    protected CompositeType getCompositeType() throws OpenDataException {
        CompositeType compositeType = new CompositeType(OPEN_TYPE_NAME, OPEN_DESCRIPTION, itemNames, itemDescriptions, itemTypes);
        return compositeType;
    }
}

