/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.extensions.WLDestination;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class DestinationInfo {
    private static final String OPEN_TYPE_NAME = "DestinationInfo";
    private static final String OPEN_DESCRIPTION = "This object represents a JMS Destination.";
    private static final String ITEM_VERSION_NUMBER = "VersionNumber";
    private static final String ITEM_NAME = "Name";
    private static final String ITEM_SERVER_NAME = "ServerName";
    private static final String ITEM_APPLICATION_NAME = "ApplicationName";
    private static final String ITEM_MODULE_NAME = "ModuleName";
    private static final String ITEM_TOPIC = "Topic";
    private static final String ITEM_QUEUE = "Queue";
    private static final String ITEM_SERIALIZED_DESTINATION = "SerializedDestination";
    private static String[] itemNames = new String[]{"VersionNumber", "Name", "ServerName", "ApplicationName", "ModuleName", "Topic", "Queue", "SerializedDestination"};
    private static String[] itemDescriptions = new String[]{"The version number.", "The name of the destination.", "The name of the JMS server hosting the destination.", "The name of the application that the destination is associated with.", "The name of the module that the destination is associated with.", "Indicates whether the destination is a topic.", "Indicates whether the destination is a queue.", "The serialized Destination instance."};
    private static OpenType[] itemTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.STRING};
    private static final int VERSION = 1;
    private String name;
    private String serverName;
    private String applicationName;
    private String moduleName;
    private boolean topic;
    private boolean queue;
    private WLDestination destination;

    public DestinationInfo(CompositeData compositeData) throws OpenDataException {
        this.readCompositeData(compositeData);
    }

    public DestinationInfo(WLDestination wLDestination) {
        this.destination = wLDestination;
        DestinationImpl destinationImpl = (DestinationImpl)wLDestination;
        this.name = destinationImpl.getName();
        this.serverName = destinationImpl.getServerName();
        this.applicationName = destinationImpl.getApplicationName();
        this.moduleName = destinationImpl.getModuleName();
        this.topic = destinationImpl.isTopic();
        this.queue = destinationImpl.isQueue();
    }

    public CompositeData toCompositeData() throws OpenDataException {
        CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this.getCompositeType(), this.getCompositeDataMap());
        return compositeDataSupport;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public WLDestination getDestination() {
        return this.destination;
    }

    public void setDestination(WLDestination wLDestination) {
        this.destination = wLDestination;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public boolean isQueue() {
        return this.queue;
    }

    public void setQueue(boolean bl) {
        this.queue = bl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public void setTopic(boolean bl) {
        this.topic = bl;
    }

    protected void readCompositeData(CompositeData compositeData) throws OpenDataException {
        String string;
        Boolean bl;
        Boolean bl2;
        String string2;
        String string3;
        String string4;
        String string5 = (String)compositeData.get(ITEM_NAME);
        if (string5 != null) {
            this.setName(string5);
        }
        if ((string4 = (String)compositeData.get(ITEM_SERVER_NAME)) != null) {
            this.setServerName(string4);
        }
        if ((string3 = (String)compositeData.get(ITEM_APPLICATION_NAME)) != null) {
            this.setApplicationName(string3);
        }
        if ((string2 = (String)compositeData.get(ITEM_MODULE_NAME)) != null) {
            this.setModuleName(string2);
        }
        if ((bl2 = (Boolean)compositeData.get(ITEM_QUEUE)) != null) {
            this.setQueue(bl2);
        }
        if ((bl = (Boolean)compositeData.get(ITEM_TOPIC)) != null) {
            this.setTopic(bl);
        }
        if ((string = (String)compositeData.get(ITEM_SERIALIZED_DESTINATION)) != null) {
            try {
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.setDestination((WLDestination)objectInputStream.readObject());
            }
            catch (IOException iOException) {
                OpenDataException openDataException = new OpenDataException("Unable to deserialize destination.");
                openDataException.initCause(iOException);
                throw openDataException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                OpenDataException openDataException = new OpenDataException("Unable to deserialize destination.");
                openDataException.initCause(classNotFoundException);
                throw openDataException;
            }
        }
    }

    protected Map getCompositeDataMap() throws OpenDataException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ITEM_VERSION_NUMBER, new Integer(1));
        hashMap.put(ITEM_NAME, this.name);
        hashMap.put(ITEM_SERVER_NAME, this.serverName);
        hashMap.put(ITEM_APPLICATION_NAME, this.applicationName);
        hashMap.put(ITEM_MODULE_NAME, this.moduleName);
        hashMap.put(ITEM_TOPIC, new Boolean(this.topic));
        hashMap.put(ITEM_QUEUE, new Boolean(this.queue));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.destination);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            String string = bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray());
            hashMap.put(ITEM_SERIALIZED_DESTINATION, string);
        }
        catch (IOException iOException) {
            OpenDataException openDataException = new OpenDataException("Unable to serialize destination.");
            openDataException.initCause(iOException);
            throw openDataException;
        }
        return hashMap;
    }

    protected CompositeType getCompositeType() throws OpenDataException {
        CompositeType compositeType = new CompositeType(OPEN_TYPE_NAME, OPEN_DESCRIPTION, itemNames, itemDescriptions, itemTypes);
        return compositeType;
    }
}

