/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.extensions.WLMessageProducer;

public class JMSForwardHelper {
    private static int Default = 0;
    private static long LDefault = 0L;

    public static final void Forward(WLMessageProducer wLMessageProducer, Message message, boolean bl) throws JMSException {
        JMSForwardHelper.ForwardInternal(wLMessageProducer, null, message, Default, Default, LDefault, false, true, bl);
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Destination destination, Message message, boolean bl) throws JMSException {
        JMSForwardHelper.ForwardInternal(wLMessageProducer, destination, message, Default, Default, LDefault, false, true, bl);
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Message message, int n, int n2, long l, boolean bl) throws JMSException {
        JMSForwardHelper.ForwardInternal(wLMessageProducer, null, message, n, n2, l, false, false, bl);
    }

    public static final void Forward(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l, boolean bl) throws JMSException {
        JMSForwardHelper.ForwardInternal(wLMessageProducer, destination, message, n, n2, l, false, false, bl);
    }

    public static final void ForwardFromMessage(WLMessageProducer wLMessageProducer, Message message, boolean bl) throws JMSException {
        JMSForwardHelper.ForwardInternal(wLMessageProducer, null, message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSForwardHelper.getRelativeTimeToLive(message), true, false, bl);
    }

    public static final void ForwardFromMessage(WLMessageProducer wLMessageProducer, Destination destination, Message message, boolean bl) throws JMSException {
        JMSForwardHelper.ForwardInternal(wLMessageProducer, destination, message, message.getJMSDeliveryMode(), message.getJMSPriority(), JMSForwardHelper.getRelativeTimeToLive(message), true, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void ForwardInternal(WLMessageProducer wLMessageProducer, Destination destination, Message message, int n, int n2, long l, boolean bl, boolean bl2, boolean bl3) throws JMSException {
        Preserve preserve = null;
        try {
            preserve = new Preserve(wLMessageProducer, message, bl, bl3);
            if (destination == null) {
                if (bl2) {
                    wLMessageProducer.forward(message);
                } else {
                    wLMessageProducer.forward(message, n, n2, l);
                }
            } else if (bl2) {
                wLMessageProducer.forward(destination, message);
            } else {
                wLMessageProducer.forward(destination, message, n, n2, l);
            }
            Object var12_10 = null;
            if (preserve == null) return;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            if (preserve == null) throw throwable;
            preserve.restore();
            throw throwable;
        }
        preserve.restore();
    }

    public static long getRelativeTimeToLive(Message message) throws JMSException {
        long l = message.getJMSExpiration();
        if (l != 0L) {
            if (l < 0L) {
                l = Long.MAX_VALUE + l <= System.currentTimeMillis() ? Long.MIN_VALUE : (l -= System.currentTimeMillis());
            } else if ((l -= System.currentTimeMillis()) == 0L) {
                l = -1L;
            }
        } else {
            l = 0L;
        }
        return l;
    }

    public static void copyHeaders(Message message, Message message2) throws JMSException {
        if (message.propertyExists("JMS_BEA_UnitOfWork")) {
            message2.setStringProperty("JMS_BEA_UnitOfWork", message.getStringProperty("JMS_BEA_UnitOfWork"));
        }
        if (message.propertyExists("JMS_BEA_UnitOfWorkSequenceNumber")) {
            message2.setIntProperty("JMS_BEA_UnitOfWorkSequenceNumber", message.getIntProperty("JMS_BEA_UnitOfWorkSequenceNumber"));
        }
        if (message.propertyExists("JMS_BEA_IsUnitOfWorkEnd")) {
            message2.setBooleanProperty("JMS_BEA_IsUnitOfWorkEnd", message.getBooleanProperty("JMS_BEA_IsUnitOfWorkEnd"));
        }
    }

    private static class Preserve {
        private long absoluteExpirationTime;
        private long absoluteTimeToDeliver;
        private Destination destination;
        private int deliveryMode;
        private boolean redelivered;
        private int priority;
        private int redeliveryLimit;
        private String unitOfOrderName;
        private boolean forwardFlag;
        private WLMessage message;
        private WLMessageProducer producer;
        private String unitOfOrderName_p;
        private long timeToDelivery_p;
        private int redeliveryLimit_p;
        private boolean restoreAfterDone;
        private boolean fromMessage;
        private String jmsxuserid = null;

        Preserve(WLMessageProducer wLMessageProducer, Message message, boolean bl, boolean bl2) throws JMSException {
            this.producer = wLMessageProducer;
            this.message = (WLMessage)message;
            this.fromMessage = bl;
            this.restoreAfterDone = bl2;
            if (bl2) {
                this.absoluteExpirationTime = this.message.getJMSExpiration();
                this.destination = this.message.getJMSDestination();
                this.deliveryMode = this.message.getJMSDeliveryMode();
                this.redelivered = this.message.getJMSRedelivered();
                this.priority = this.message.getJMSPriority();
                this.forwardFlag = ((MessageImpl)this.message).isForwardable();
                if (this.message.propertyExists("JMSXUserID")) {
                    this.jmsxuserid = this.message.getStringProperty("JMSXUserID");
                }
            }
            if (bl2 || bl) {
                this.unitOfOrderName = ((MessageImpl)this.message).getUnitOfOrder();
                this.redeliveryLimit = this.message.getJMSRedeliveryLimit();
                this.absoluteTimeToDeliver = this.message.getJMSDeliveryTime();
            }
            if (bl) {
                this.unitOfOrderName_p = wLMessageProducer.getUnitOfOrder();
                this.timeToDelivery_p = wLMessageProducer.getTimeToDeliver();
                this.redeliveryLimit_p = wLMessageProducer.getRedeliveryLimit();
                wLMessageProducer.setUnitOfOrder(this.unitOfOrderName);
                wLMessageProducer.setRedeliveryLimit(this.redeliveryLimit);
                if (this.absoluteTimeToDeliver > System.currentTimeMillis()) {
                    wLMessageProducer.setTimeToDeliver(this.absoluteTimeToDeliver - System.currentTimeMillis());
                } else {
                    wLMessageProducer.setTimeToDeliver(0L);
                }
            }
        }

        void restore() throws JMSException {
            if (this.restoreAfterDone) {
                this.message.setJMSExpiration(this.absoluteExpirationTime);
                this.message.setJMSDeliveryTime(this.absoluteTimeToDeliver);
                this.message.setJMSDestination(this.destination);
                this.message.setJMSDeliveryMode(this.deliveryMode);
                this.message.setJMSRedelivered(this.redelivered);
                this.message.setJMSPriority(this.priority);
                this.message.setJMSRedeliveryLimit(this.redeliveryLimit);
                ((MessageImpl)this.message).setUnitOfOrderName(this.unitOfOrderName);
                ((MessageImpl)this.message).setForward(this.forwardFlag);
                ((MessageImpl)this.message).setJMSXUserID(this.jmsxuserid);
            }
            if (this.fromMessage) {
                this.producer.setUnitOfOrder(this.unitOfOrderName_p);
                this.producer.setTimeToDeliver(this.timeToDelivery_p);
                this.producer.setRedeliveryLimit(this.redeliveryLimit_p);
            }
        }
    }
}

