/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.naming.Context;
import weblogic.jms.common.ConfigurationException;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.extensions.JMSRuntimeHelper;
import weblogic.management.MBeanHome;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSDistributedDestinationMBean;
import weblogic.management.configuration.JMSDistributedDestinationMemberMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBean;
import weblogic.management.configuration.JMSDistributedTopicMBean;
import weblogic.management.configuration.JMSDistributedTopicMemberMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;

public final class JMSHelper
extends JMSRuntimeHelper {
    private static TargetMBean getDDTarget(String[] stringArray, MBeanHome mBeanHome, String string) throws Exception {
        if (stringArray.length == 1) {
            return JMSHelper.getJMSServerTarget(stringArray[0], mBeanHome, string, true);
        }
        ClusterMBean clusterMBean = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ClusterMBean clusterMBean2;
            try {
                clusterMBean2 = (ClusterMBean)JMSHelper.getJMSServerTarget(stringArray[i], mBeanHome, string, true);
            }
            catch (ClassCastException classCastException) {
                throw new JMSException("Distributed destination has multiple members, but JMS server " + stringArray[i] + " is not targeted to a cluster");
            }
            if (clusterMBean == null) {
                clusterMBean = clusterMBean2;
                continue;
            }
            if (clusterMBean.getName().equals(clusterMBean2.getName())) continue;
            throw new JMSException("JMS servers for the distributed destination may not be members  of different clusters");
        }
        return clusterMBean;
    }

    private static TargetMBean getJMSServerTarget(String string, MBeanHome mBeanHome, String string2) throws Exception {
        return JMSHelper.getJMSServerTarget(string, mBeanHome, string2, false);
    }

    private static TargetMBean getJMSServerTarget(String string, MBeanHome mBeanHome, String string2, boolean bl) throws Exception {
        WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string, "JMSServer", string2);
        JMSServerMBean jMSServerMBean = (JMSServerMBean)mBeanHome.getMBean((ObjectName)webLogicObjectName);
        TargetMBean[] targetMBeanArray = jMSServerMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            throw new JMSException("JMS server " + string + " has no targets");
        }
        if (targetMBeanArray.length > 1) {
            throw new JMSException("JMS server " + string + " has multiple targets");
        }
        try {
            TargetMBean targetMBean = null;
            targetMBean = targetMBeanArray[0] instanceof MigratableTargetMBean ? ((MigratableTargetMBean)targetMBeanArray[0]).getCluster() : ((ServerMBean)targetMBeanArray[0]).getCluster();
            if (targetMBean == null && !bl) {
                targetMBean = targetMBeanArray[0];
            }
            return targetMBean;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new JMSException("JMS server " + string + " is not targeted");
        }
    }

    private static JMSDestinationMBean createPermanentDestination(Context context, String string, String string2, String string3, JMSTemplateMBean jMSTemplateMBean, String string4) throws JMSException {
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string5 = mBeanHome.getActiveDomain().getName();
            JMSServerMBean jMSServerMBean = (JMSServerMBean)mBeanHome.getAdminMBean(string, "JMSServer", string5);
            JMSDestinationMBean jMSDestinationMBean = (JMSDestinationMBean)mBeanHome.createAdminMBean(string2, string4, string5, null);
            jMSDestinationMBean.setJNDIName(string3);
            if (jMSTemplateMBean != null) {
                jMSDestinationMBean.setTemplate(jMSTemplateMBean);
            }
            jMSDestinationMBean.setParent(jMSServerMBean);
            return jMSDestinationMBean;
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(exception);
        }
    }

    public static void createPermanentQueueAsync(Context context, String string, String string2, String string3) throws JMSException {
        JMSHelper.createPermanentDestination(context, string, string2, string3, null, "JMSQueue");
    }

    public static void createPermanentTopicAsync(Context context, String string, String string2, String string3) throws JMSException {
        JMSHelper.createPermanentDestination(context, string, string2, string3, null, "JMSTopic");
    }

    private static void deletePermanentDestination(Context context, String string, String string2, String string3) throws ConfigurationException {
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string4 = mBeanHome.getActiveDomain().getName();
            WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string, "JMSServer", string4);
            WebLogicObjectName webLogicObjectName2 = new WebLogicObjectName(string2, string3, string4, webLogicObjectName);
            JMSDestinationMBean jMSDestinationMBean = (JMSDestinationMBean)mBeanHome.getMBean((ObjectName)webLogicObjectName2);
            if (jMSDestinationMBean == null) {
                throw new weblogic.jms.common.JMSException("Destination " + string2 + " not found");
            }
            mBeanHome.deleteMBean(jMSDestinationMBean);
        }
        catch (Exception exception) {
            if (exception instanceof ConfigurationException) {
                throw (ConfigurationException)((Object)exception);
            }
            ConfigurationException configurationException = new ConfigurationException(exception.toString());
            configurationException.setLinkedException(exception);
            throw configurationException;
        }
    }

    public static void deletePermanentQueue(Context context, String string, String string2) throws ConfigurationException {
        JMSHelper.deletePermanentDestination(context, string, string2, "JMSQueue");
    }

    public static void deletePermanentTopic(Context context, String string, String string2) throws ConfigurationException {
        JMSHelper.deletePermanentDestination(context, string, string2, "JMSTopic");
    }

    private static JMSDistributedDestinationMBean createDistributedDest(String string, String string2, String string3, MBeanHome mBeanHome, String string4) throws Exception {
        JMSTemplateMBean jMSTemplateMBean = (JMSTemplateMBean)mBeanHome.createAdminMBean(string, "JMSTemplate", string4, null);
        JMSDistributedDestinationMBean jMSDistributedDestinationMBean = (JMSDistributedDestinationMBean)mBeanHome.createAdminMBean(string, string2, string4, null);
        jMSDistributedDestinationMBean.setJNDIName(string3);
        jMSDistributedDestinationMBean.setTemplate(jMSTemplateMBean);
        return jMSDistributedDestinationMBean;
    }

    public static void createDistributedQueueAsync(Context context, String string, String string2, String[] stringArray) throws JMSException {
        if (stringArray == null || stringArray.length == 0) {
            throw new JMSException("jmsServerNames parameter may not be null");
        }
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string3 = mBeanHome.getActiveDomain().getName();
            TargetMBean targetMBean = JMSHelper.getDDTarget(stringArray, mBeanHome, string3);
            JMSDistributedQueueMBean jMSDistributedQueueMBean = (JMSDistributedQueueMBean)JMSHelper.createDistributedDest(string, "JMSDistributedQueue", string2, mBeanHome, string3);
            for (int i = 0; i < stringArray.length; ++i) {
                JMSQueueMBean jMSQueueMBean = (JMSQueueMBean)JMSHelper.createPermanentDestination(context, stringArray[i], string + "@" + stringArray[i], string2 + "@" + stringArray[i], jMSDistributedQueueMBean.getTemplate(), "JMSQueue");
                JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean = (JMSDistributedQueueMemberMBean)mBeanHome.createAdminMBean(string + "@" + stringArray[i], "JMSDistributedQueueMember", string3, jMSDistributedQueueMBean);
                jMSDistributedQueueMemberMBean.setJMSQueue(jMSQueueMBean);
                jMSDistributedQueueMBean.addMember(jMSDistributedQueueMemberMBean);
            }
            TargetMBean[] targetMBeanArray = new TargetMBean[]{targetMBean};
            jMSDistributedQueueMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static void createDistributedTopicAsync(Context context, String string, String string2, String[] stringArray) throws JMSException {
        if (stringArray == null) {
            throw new JMSException("jmsServerNames parameter may not be null");
        }
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string3 = mBeanHome.getActiveDomain().getName();
            TargetMBean targetMBean = JMSHelper.getDDTarget(stringArray, mBeanHome, string3);
            JMSDistributedTopicMBean jMSDistributedTopicMBean = (JMSDistributedTopicMBean)JMSHelper.createDistributedDest(string, "JMSDistributedTopic", string2, mBeanHome, string3);
            for (int i = 0; i < stringArray.length; ++i) {
                JMSTopicMBean jMSTopicMBean = (JMSTopicMBean)JMSHelper.createPermanentDestination(context, stringArray[i], string + "@" + stringArray[i], string2 + "@" + stringArray[i], jMSDistributedTopicMBean.getTemplate(), "JMSTopic");
                JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean = (JMSDistributedTopicMemberMBean)mBeanHome.createAdminMBean(string + "@" + stringArray[i], "JMSDistributedTopicMember", string3, jMSDistributedTopicMBean);
                jMSDistributedTopicMemberMBean.setJMSTopic(jMSTopicMBean);
                jMSDistributedTopicMBean.addMember(jMSDistributedTopicMemberMBean);
            }
            TargetMBean[] targetMBeanArray = new TargetMBean[]{targetMBean};
            jMSDistributedTopicMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static void deleteDistributedQueue(Context context, String string) throws JMSException {
        JMSHelper.deleteDistributedDestination(context, string, "JMSDistributedQueue");
    }

    public static void deleteDistributedTopic(Context context, String string) throws JMSException {
        JMSHelper.deleteDistributedDestination(context, string, "JMSDistributedTopic");
    }

    private static void deleteDistributedDestination(Context context, String string, String string2) throws JMSException {
        try {
            JMSDestinationMBean jMSDestinationMBean;
            int n;
            Object object;
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string3 = mBeanHome.getActiveDomain().getName();
            WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string, string2, string3);
            JMSDistributedDestinationMBean jMSDistributedDestinationMBean = (JMSDistributedDestinationMBean)mBeanHome.getMBean((ObjectName)webLogicObjectName);
            ArrayList<JMSQueueMBean> arrayList = new ArrayList<JMSQueueMBean>();
            if (jMSDistributedDestinationMBean instanceof JMSDistributedQueueMBean) {
                object = ((JMSDistributedQueueMBean)jMSDistributedDestinationMBean).getMembers();
                for (n = 0; n < ((JMSDistributedDestinationMemberMBean[])object).length; ++n) {
                    jMSDestinationMBean = object[n].getJMSQueue();
                    if (jMSDestinationMBean != null) {
                        arrayList.add((JMSQueueMBean)jMSDestinationMBean);
                    }
                    mBeanHome.deleteMBean((WebLogicMBean)object[n]);
                }
            } else if (jMSDistributedDestinationMBean instanceof JMSDistributedTopicMBean) {
                object = ((JMSDistributedTopicMBean)jMSDistributedDestinationMBean).getMembers();
                for (n = 0; n < ((JMSDistributedDestinationMemberMBean[])object).length; ++n) {
                    jMSDestinationMBean = object[n].getJMSTopic();
                    if (jMSDestinationMBean != null) {
                        arrayList.add((JMSQueueMBean)jMSDestinationMBean);
                    }
                    mBeanHome.deleteMBean((WebLogicMBean)object[n]);
                }
            } else {
                throw new JMSException("Invalid destination type");
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                mBeanHome.deleteMBean((JMSDestinationMBean)object.next());
            }
            JMSTemplateMBean jMSTemplateMBean = jMSDistributedDestinationMBean.getTemplate();
            mBeanHome.deleteMBean(jMSDistributedDestinationMBean);
            if (jMSTemplateMBean != null && jMSTemplateMBean.getName().equals(string)) {
                mBeanHome.deleteMBean(jMSTemplateMBean);
            }
        }
        catch (Exception exception) {
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSTemplateMBean getJMSTemplateConfigMBean(Context context, String string) throws JMSException {
        if (string == null || string.length() == 0) {
            throw new JMSException("Null or empty template name");
        }
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string2 = mBeanHome.getActiveDomain().getName();
            WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string, "JMSTemplate", string2);
            JMSTemplateMBean jMSTemplateMBean = (JMSTemplateMBean)mBeanHome.getMBean((ObjectName)webLogicObjectName);
            if (jMSTemplateMBean == null) {
                throw new JMSException("JMS template config mbean not found");
            }
            return jMSTemplateMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSTopicMBean getJMSTopicConfigMBean(Context context, Topic topic) throws JMSException {
        if (!(topic instanceof DestinationImpl)) {
            throw new JMSException("Unknown foreign destination");
        }
        DestinationImpl destinationImpl = (DestinationImpl)topic;
        return (JMSTopicMBean)JMSHelper.getDestinationMBean(context, destinationImpl.getServerName(), destinationImpl.getName(), "JMSTopic");
    }

    public static JMSTopicMBean getJMSTopicConfigMBean(Context context, String string, String string2) throws JMSException {
        return (JMSTopicMBean)JMSHelper.getDestinationMBean(context, string, string2, "JMSTopic");
    }

    public static JMSQueueMBean getJMSQueueConfigMBean(Context context, Queue queue) throws JMSException {
        if (!(queue instanceof DestinationImpl)) {
            throw new JMSException("Unknown foreign destination");
        }
        DestinationImpl destinationImpl = (DestinationImpl)queue;
        return (JMSQueueMBean)JMSHelper.getDestinationMBean(context, destinationImpl.getServerName(), destinationImpl.getName(), "JMSQueue");
    }

    public static JMSQueueMBean getJMSQueueConfigMBean(Context context, String string, String string2) throws JMSException {
        return (JMSQueueMBean)JMSHelper.getDestinationMBean(context, string, string2, "JMSQueue");
    }

    public static JMSServerMBean getJMSServerConfigMBean(Context context, String string) throws JMSException {
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string2 = mBeanHome.getActiveDomain().getName();
            JMSServerMBean jMSServerMBean = (JMSServerMBean)mBeanHome.getAdminMBean(string, "JMSServer", string2);
            if (jMSServerMBean == null) {
                throw new JMSException("JMS server config mbean not found");
            }
            return jMSServerMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(exception.toString());
            throw jMSException;
        }
    }

    private static JMSDestinationMBean getDestinationMBean(Context context, String string, String string2, String string3) throws JMSException {
        try {
            MBeanHome mBeanHome = (MBeanHome)context.lookup("weblogic.management.adminhome");
            String string4 = mBeanHome.getActiveDomain().getName();
            WebLogicObjectName webLogicObjectName = new WebLogicObjectName(string, "JMSServer", string4);
            WebLogicObjectName webLogicObjectName2 = new WebLogicObjectName(string2, string3, string4, webLogicObjectName);
            JMSDestinationMBean jMSDestinationMBean = (JMSDestinationMBean)mBeanHome.getMBean((ObjectName)webLogicObjectName2);
            if (jMSDestinationMBean == null) {
                throw new weblogic.jms.common.JMSException("Destination " + string2 + " not found");
            }
            return jMSDestinationMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            weblogic.jms.common.JMSException jMSException = new weblogic.jms.common.JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }
}

