/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.io.IOException;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.StreamMessage;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.XMLHelper;
import weblogic.jms.extensions.WLMessage;
import weblogic.messaging.Message;
import weblogic.messaging.runtime.MessageInfo;

public class JMSMessageInfo
extends MessageInfo {
    private static final String OPEN_TYPE_NAME = "JMSMessageInfo";
    private static final String OPEN_DESCRIPTION = "This object represents information about a JMS message.  In addition to the message itself, meta-data is included that describes the context of the message at the time the management operation was invoked.";
    private static final String ITEM_VERSION_NUMBER = "VersionNumber";
    private static final String ITEM_MESSAGE_XMLTEXT = "MessageXMLText";
    private static final String ITEM_MESSAGE_SIZE = "MessageSize";
    private static final String ITEM_DESTINATION_NAME = "DestinationName";
    private static final String ITEM_BODY_INCLUDED = "BodyIncluded";
    private static final int VERSION = 1;
    private WLMessage message;
    private long messageSize;
    private String destinationName;
    private boolean bodyIncluded;

    public JMSMessageInfo(CompositeData compositeData) throws OpenDataException {
        super(compositeData);
    }

    public JMSMessageInfo(long l, int n, String string, long l2, String string2, WLMessage wLMessage, String string3, boolean bl) {
        super(l, n, string, l2, string2);
        this.message = wLMessage;
        if (wLMessage != null) {
            this.messageSize = ((Message)wLMessage).size();
        }
        this.destinationName = string3;
        this.bodyIncluded = bl;
    }

    public JMSMessageInfo(WLMessage wLMessage) {
        this.message = wLMessage;
        this.bodyIncluded = true;
    }

    protected void initOpenInfo() {
        super.initOpenInfo();
        this.openItemNames.add(ITEM_VERSION_NUMBER);
        this.openItemNames.add(ITEM_MESSAGE_XMLTEXT);
        this.openItemNames.add(ITEM_MESSAGE_SIZE);
        this.openItemNames.add(ITEM_DESTINATION_NAME);
        this.openItemNames.add(ITEM_BODY_INCLUDED);
        this.openItemDescriptions.add("The JMS version number.");
        this.openItemDescriptions.add("The message in XML String representation.  Note that the message body may be ommitted if the IncludeBody attribute is false.");
        this.openItemDescriptions.add("The size of the message in bytes.");
        this.openItemDescriptions.add("The destination name on which the message is pending.");
        this.openItemDescriptions.add("A boolean that indicates whether the JMS message item includes the body.");
        this.openItemTypes.add(SimpleType.INTEGER);
        this.openItemTypes.add(SimpleType.STRING);
        this.openItemTypes.add(SimpleType.LONG);
        this.openItemTypes.add(SimpleType.STRING);
        this.openItemTypes.add(SimpleType.BOOLEAN);
    }

    public WLMessage getMessage() {
        return this.message;
    }

    public void setMessage(WLMessage wLMessage) {
        this.message = wLMessage;
    }

    public long getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(long l) {
        this.messageSize = l;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String string) {
        this.destinationName = string;
    }

    public boolean isBodyIncluded() {
        return this.bodyIncluded;
    }

    public void setBodyIncluded(boolean bl) {
        this.bodyIncluded = bl;
    }

    protected void readCompositeData(CompositeData compositeData) throws OpenDataException {
        Boolean bl;
        String string;
        Object object;
        super.readCompositeData(compositeData);
        String string2 = (String)compositeData.get(ITEM_MESSAGE_XMLTEXT);
        if (string2 != null) {
            try {
                object = XMLHelper.createMessage(string2);
                ((MessageImpl)object).setPropertiesWritable(false);
                ((MessageImpl)object).setBodyWritable(false);
                ((MessageImpl)object).includeJMSXDeliveryCount(true);
                if (object instanceof BytesMessage) {
                    ((BytesMessage)object).reset();
                }
                if (object instanceof StreamMessage) {
                    ((StreamMessage)object).reset();
                }
            }
            catch (JMSException jMSException) {
                throw new OpenDataException(jMSException.toString());
            }
            catch (IOException iOException) {
                throw new OpenDataException(iOException.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new OpenDataException(classNotFoundException.toString());
            }
            this.setMessage((WLMessage)object);
        }
        if ((object = (Long)compositeData.get(ITEM_MESSAGE_SIZE)) != null) {
            this.setMessageSize((Long)object);
        }
        if ((string = (String)compositeData.get(ITEM_DESTINATION_NAME)) != null) {
            this.setDestinationName(string);
        }
        if ((bl = (Boolean)compositeData.get(ITEM_BODY_INCLUDED)) != null) {
            this.setBodyIncluded(bl);
        }
    }

    protected Map getCompositeDataMap() throws OpenDataException {
        Map map = super.getCompositeDataMap();
        map.put(ITEM_VERSION_NUMBER, new Integer(1));
        if (this.message != null) {
            try {
                map.put(ITEM_MESSAGE_XMLTEXT, XMLHelper.getXMLText(this.message, this.bodyIncluded));
                map.put(ITEM_MESSAGE_SIZE, new Long(((Message)this.message).size()));
            }
            catch (JMSException jMSException) {
                throw new OpenDataException(jMSException.toString());
            }
        } else {
            map.put(ITEM_MESSAGE_XMLTEXT, null);
            map.put(ITEM_MESSAGE_SIZE, new Long(0L));
        }
        map.put(ITEM_DESTINATION_NAME, this.destinationName);
        map.put(ITEM_BODY_INCLUDED, new Boolean(this.bodyIncluded));
        return map;
    }
}

