/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.SAFErrorHandlingBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.j2ee.descriptor.wl.SAFQueueBean;
import weblogic.j2ee.descriptor.wl.SAFRemoteContextBean;
import weblogic.j2ee.descriptor.wl.SAFTopicBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedQueueBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.common.JMSEditHelper;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.extensions.JMSNamedEntityModifier;
import weblogic.jms.extensions.JMSRuntimeHelper;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.mbeanservers.edit.ActivationTaskMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditTimedOutException;
import weblogic.management.mbeanservers.edit.NotEditorException;
import weblogic.management.mbeanservers.edit.ValidationException;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class JMSModuleHelper
extends JMSRuntimeHelper {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static DestinationBean findDestinationBean(String string, JMSBean jMSBean) {
        QueueBean queueBean = null;
        queueBean = jMSBean.lookupQueue(string);
        if (queueBean == null) {
            queueBean = jMSBean.lookupTopic(string);
        }
        return queueBean;
    }

    public static DestinationBean[] findAllInheritedDestinations(String string, JMSBean jMSBean) {
        int n;
        QueueBean[] queueBeanArray = JMSModuleHelper.findAllInheritedQueueBeans(string, jMSBean);
        TopicBean[] topicBeanArray = JMSModuleHelper.findAllInheritedTopicBeans(string, jMSBean);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (queueBeanArray != null) {
            for (n = 0; n < queueBeanArray.length; ++n) {
                arrayList.add(queueBeanArray[n]);
            }
        }
        if (topicBeanArray != null) {
            for (n = 0; n < topicBeanArray.length; ++n) {
                arrayList.add(topicBeanArray[n]);
            }
        }
        return arrayList.toArray(new DestinationBean[0]);
    }

    public static QueueBean[] findAllInheritedQueueBeans(String string, JMSBean jMSBean) {
        ArrayList<QueueBean> arrayList = new ArrayList<QueueBean>();
        QueueBean[] queueBeanArray = jMSBean.getQueues();
        for (int i = 0; i < queueBeanArray.length; ++i) {
            String string2;
            TemplateBean templateBean = queueBeanArray[i].getTemplate();
            String string3 = string2 = templateBean == null ? null : templateBean.getName();
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(queueBeanArray[i]);
        }
        return arrayList.toArray(new QueueBean[0]);
    }

    public static TopicBean[] findAllInheritedTopicBeans(String string, JMSBean jMSBean) {
        ArrayList<TopicBean> arrayList = new ArrayList<TopicBean>();
        TopicBean[] topicBeanArray = jMSBean.getTopics();
        for (int i = 0; i < topicBeanArray.length; ++i) {
            String string2;
            TemplateBean templateBean = topicBeanArray[i].getTemplate();
            String string3 = string2 = templateBean == null ? null : templateBean.getName();
            if (string2 == null || !string2.equals(string)) continue;
            arrayList.add(topicBeanArray[i]);
        }
        return arrayList.toArray(new TopicBean[0]);
    }

    public static JMSSystemResourceMBean findJMSSystemResource(Context context, String string) throws JMSException {
        if (string == null) {
            return null;
        }
        JMSSystemResourceMBean jMSSystemResourceMBean = null;
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
        return jMSSystemResourceMBean;
    }

    public static JMSSystemResourceMBean findJMSSystemResource(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        return domainMBean.lookupJMSSystemResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJMSSystemResource(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createJMSSystemResource(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void createJMSSystemResource(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string == null || string.trim().equals("")) {
            throw new JMSException("ERROR: resourceName cannot be null or empty");
        }
        try {
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string2);
            if (targetMBeanArray[0] instanceof MigratableTargetMBean || targetMBeanArray[0] instanceof JMSServerMBean) {
                throw new JMSException("ERROR: MigratableTarget and JMSServer cannot be set as target for JMSSystemResource");
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = domainMBean.createJMSSystemResource(string);
            jMSSystemResourceMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInDomainLoggable((String)domainMBean.getName(), (String)"JMSSystemResource", (String)string).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteJMSSystemResource(Context context, String string) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteJMSSystemResource(domainMBean, string);
            bl = true;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void deleteJMSSystemResource(DomainMBean domainMBean, String string) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            domainMBean.destroyJMSSystemResource(jMSSystemResourceMBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromDomainLoggable((String)domainMBean.getName(), (String)"JMSSystemResource", (String)string).getMessage(), (Throwable)exception);
        }
    }

    public static void createTemplate(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.createTemplate(context, string, string2, null);
    }

    public static void createTemplate(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.createTemplate(domainMBean, string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTemplate(Context context, String string, String string2, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createTemplate(domainMBean, string, string2, jMSNamedEntityModifier);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void createTemplate(DomainMBean domainMBean, String string, String string2, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: templateName cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            TemplateBean templateBean = jMSBean.createTemplate(string2);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)templateBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"Template", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTemplate(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteTemplate(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteTemplate(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            TemplateBean templateBean = jMSBean.lookupTemplate(string2);
            if (templateBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"Template", (String)string2).getMessage());
            }
            jMSBean.destroyTemplate(templateBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"Template", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createQuota(Context context, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createQuota(context, string, string2, string3, null);
    }

    public static void createQuota(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createQuota(domainMBean, string, string2, string3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createQuota(Context context, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createQuota(domainMBean, string, string2, string3, jMSNamedEntityModifier);
            bl = true;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createQuota(DomainMBean domainMBean, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: quotaName cannot be null or empty");
        }
        try {
            JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string3);
            if (jMSServerMBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string3).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            QuotaBean quotaBean = jMSBean.createQuota(string2);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)quotaBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"Quota", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteQuota(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteQuota(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteQuota(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            QuotaBean quotaBean = jMSBean.lookupQuota(string2);
            if (quotaBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"Quota", (String)string2).getMessage());
            }
            jMSBean.destroyQuota(quotaBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"Quota", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createDestinationKey(Context context, String string, String string2, String string3, String string4, String string5) throws JMSException {
        JMSModuleHelper.createDestinationKey(context, string, string2, string3, string4, string5, null);
    }

    public static void createDestinationKey(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5) throws JMSException {
        JMSModuleHelper.createDestinationKey(domainMBean, string, string2, string3, string4, string5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDestinationKey(Context context, String string, String string2, String string3, String string4, String string5, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createDestinationKey(domainMBean, string, string2, string3, string4, string5, jMSNamedEntityModifier);
            bl = true;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createDestinationKey(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: destinationKeyName cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DestinationKeyBean destinationKeyBean = jMSBean.createDestinationKey(string2);
            destinationKeyBean.setProperty(string3);
            destinationKeyBean.setKeyType(string4);
            destinationKeyBean.setSortOrder(string5);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)destinationKeyBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"DestinationKey", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDestinationKey(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteDestinationKey(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteDestinationKey(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DestinationKeyBean destinationKeyBean = jMSBean.lookupDestinationKey(string2);
            if (destinationKeyBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DestinationKey", (String)string2).getMessage());
            }
            jMSBean.destroyDestinationKey(destinationKeyBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"DestinationKey", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createConnectionFactory(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createConnectionFactory(context, string, string2, string3, string4, null);
    }

    public static void createConnectionFactory(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createConnectionFactory(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createConnectionFactory(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createConnectionFactory(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void createConnectionFactory(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: factoryName cannot be null or empty");
        }
        try {
            String string5;
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string4);
            if (targetMBeanArray[0] instanceof MigratableTargetMBean) {
                throw new JMSException(JMSExceptionLogger.logInvalidSubDeploymentTargetLoggable((String)string, (String)string4, (String)"MigratableTargetMBean", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            JMSConnectionFactoryBean jMSConnectionFactoryBean = jMSBean.createConnectionFactory(string2);
            jMSConnectionFactoryBean.setJNDIName(string3);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)jMSConnectionFactoryBean);
            }
            if ((string5 = jMSConnectionFactoryBean.getSubDeploymentName()) == null) {
                string5 = string2;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string5);
            subDeploymentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"ConnectionFactory", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConnectionFactory(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteConnectionFactory(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteConnectionFactory(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            JMSConnectionFactoryBean jMSConnectionFactoryBean = jMSBean.lookupConnectionFactory(string2);
            if (jMSConnectionFactoryBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ConnectionFactory", (String)string2).getMessage());
            }
            jMSBean.destroyConnectionFactory(jMSConnectionFactoryBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"ConnectionFactory", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createQueue(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createQueue(context, string, string2, string3, string4, null);
    }

    public static void createQueue(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createQueue(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createQueue(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createQueue(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createQueue(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.equals("")) {
            throw new JMSException("ERROR: queueName cannot be null or empty");
        }
        try {
            String string5;
            JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string2);
            if (jMSServerMBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            QueueBean queueBean = jMSBean.createQueue(string3);
            queueBean.setJNDIName(string4);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)queueBean);
            }
            if ((string5 = queueBean.getSubDeploymentName()) == null) {
                string5 = string3;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string5);
            subDeploymentMBean.addTarget(jMSServerMBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"Queue", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    public static void deleteQueue(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(context, string, string2, "JMSQueue");
    }

    public static void deleteQueue(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(domainMBean, string, string2, "JMSQueue");
    }

    public static void createTopic(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createTopic(context, string, string2, string3, string4, null);
    }

    public static void createTopic(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createTopic(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTopic(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createTopic(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createTopic(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: topicName cannot be null or empty");
        }
        try {
            String string5;
            JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string2);
            if (jMSServerMBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            TopicBean topicBean = jMSBean.createTopic(string3);
            topicBean.setJNDIName(string4);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)topicBean);
            }
            if ((string5 = topicBean.getSubDeploymentName()) == null) {
                string5 = string3;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string5);
            subDeploymentMBean.addTarget(jMSServerMBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"Topic", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    public static void deleteTopic(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(context, string, string2, "JMSTopic");
    }

    public static void deleteTopic(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(domainMBean, string, string2, "JMSTopic");
    }

    public static void createDistributedQueue(Context context, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createDistributedQueue(context, string, string2, string3, null);
    }

    public static void createDistributedQueue(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createDistributedQueue(domainMBean, string, string2, string3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDistributedQueue(Context context, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createDistributedQueue(domainMBean, string, string2, string3, jMSNamedEntityModifier);
            bl = true;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createDistributedQueue(DomainMBean domainMBean, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: distributedQueueName cannot be null or empty");
        }
        try {
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            DistributedQueueBean distributedQueueBean = jMSBean.createDistributedQueue(string2);
            distributedQueueBean.setJNDIName(string3);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)distributedQueueBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDistributedQueue(Context context, String string, String string2, boolean bl) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl2 = false;
        try {
            JMSModuleHelper.deleteDistributedQueue(domainMBean, string, string2, bl);
            bl2 = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl2);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl2);
    }

    public static void deleteDistributedQueue(DomainMBean domainMBean, String string, String string2, boolean bl) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray;
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(string2);
            if (distributedQueueBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage());
            }
            if (bl && (distributedDestinationMemberBeanArray = distributedQueueBean.getDistributedQueueMembers()) != null) {
                for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
                    distributedQueueBean.destroyDistributedQueueMember(distributedDestinationMemberBeanArray[i]);
                }
            }
            jMSBean.destroyDistributedQueue(distributedQueueBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createDistributedQueueMember(Context context, String string, String string2, String string3, int n) throws JMSException {
        JMSModuleHelper.createDistributedQueueMember(context, string, string2, string3, n, null);
    }

    public static void createDistributedQueueMember(DomainMBean domainMBean, String string, String string2, String string3, int n) throws JMSException {
        JMSModuleHelper.createDistributedQueueMember(domainMBean, string, string2, string3, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDistributedQueueMember(Context context, String string, String string2, String string3, int n, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createDistributedQueueMember(domainMBean, string, string2, string3, n, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createDistributedQueueMember(DomainMBean domainMBean, String string, String string2, String string3, int n, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: distributedQueueMemberName cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(string2);
            if (distributedQueueBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage());
            }
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedQueueBean.createDistributedQueueMember(string3);
            distributedDestinationMemberBean.setWeight(n);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)distributedDestinationMemberBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"DistributedQueueMember", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDistributedQueueMember(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteDistributedQueueMember(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void deleteDistributedQueueMember(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(string2);
            if (distributedQueueBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage());
            }
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedQueueBean.lookupDistributedQueueMember(string3);
            if (distributedDestinationMemberBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedQueueMember", (String)string3).getMessage());
            }
            distributedQueueBean.destroyDistributedQueueMember(distributedDestinationMemberBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"DistributedQueueMember", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDistributedQueueMemberNames(Context context, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            stringArray = JMSModuleHelper.getDistributedQueueMemberNames(domainMBean, string, string);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
        return stringArray;
    }

    public static String[] getDistributedQueueMemberNames(DomainMBean domainMBean, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
        DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(string2);
        if (distributedQueueBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage());
        }
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = distributedQueueBean.getDistributedQueueMembers();
        stringArray = new String[distributedDestinationMemberBeanArray.length];
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            stringArray[i] = distributedDestinationMemberBeanArray[i].getPhysicalDestinationName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDistributedQueueMemberJndiNames(Context context, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            stringArray = JMSModuleHelper.getDistributedQueueMemberJndiNames(domainMBean, string, string2);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
        return stringArray;
    }

    public static String[] getDistributedQueueMemberJndiNames(DomainMBean domainMBean, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
        DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(string2);
        if (distributedQueueBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedQueue", (String)string2).getMessage());
        }
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = distributedQueueBean.getDistributedQueueMembers();
        stringArray = new String[distributedDestinationMemberBeanArray.length];
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            QueueBean queueBean = jMSBean.lookupQueue(distributedDestinationMemberBeanArray[i].getPhysicalDestinationName());
            if (queueBean == null) continue;
            stringArray[i] = queueBean.getJNDIName();
        }
        return stringArray;
    }

    public static void createDistributedTopic(Context context, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createDistributedTopic(context, string, string2, string3, null);
    }

    public static void createDistributedTopic(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createDistributedTopic(domainMBean, string, string2, string3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDistributedTopic(Context context, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createDistributedTopic(domainMBean, string, string2, string3, jMSNamedEntityModifier);
            bl = true;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createDistributedTopic(DomainMBean domainMBean, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: distributedTopicName cannot be null or empty");
        }
        try {
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            DistributedTopicBean distributedTopicBean = jMSBean.createDistributedTopic(string2);
            distributedTopicBean.setJNDIName(string3);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)distributedTopicBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDistributedTopic(Context context, String string, String string2, boolean bl) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl2 = false;
        try {
            JMSModuleHelper.deleteDistributedTopic(domainMBean, string, string2, bl);
            bl2 = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl2);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl2);
    }

    public static void deleteDistributedTopic(DomainMBean domainMBean, String string, String string2, boolean bl) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray;
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(string2);
            if (distributedTopicBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage());
            }
            if (bl && (distributedDestinationMemberBeanArray = distributedTopicBean.getDistributedTopicMembers()) != null) {
                for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
                    distributedTopicBean.destroyDistributedTopicMember(distributedDestinationMemberBeanArray[i]);
                }
            }
            jMSBean.destroyDistributedTopic(distributedTopicBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createDistributedTopicMember(Context context, String string, String string2, String string3, int n) throws JMSException {
        JMSModuleHelper.createDistributedTopicMember(context, string, string2, string3, n, null);
    }

    public static void createDistributedTopicMember(DomainMBean domainMBean, String string, String string2, String string3, int n) throws JMSException {
        JMSModuleHelper.createDistributedTopicMember(domainMBean, string, string2, string3, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDistributedTopicMember(Context context, String string, String string2, String string3, int n, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createDistributedTopicMember(domainMBean, string, string2, string3, n, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createDistributedTopicMember(DomainMBean domainMBean, String string, String string2, String string3, int n, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: distributedTopicMemberName cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(string2);
            if (distributedTopicBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage());
            }
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedTopicBean.createDistributedTopicMember(string3);
            distributedDestinationMemberBean.setWeight(n);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)distributedDestinationMemberBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"DistributedTopicMember", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDistributedTopicMember(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteDistributedTopicMember(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void deleteDistributedTopicMember(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(string2);
            if (distributedTopicBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage());
            }
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedTopicBean.lookupDistributedTopicMember(string3);
            if (distributedDestinationMemberBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedTopicMember", (String)string3).getMessage());
            }
            distributedTopicBean.destroyDistributedTopicMember(distributedDestinationMemberBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"DistributedTopicMember", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDistributedTopicMemberNames(Context context, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            stringArray = JMSModuleHelper.getDistributedTopicMemberNames(domainMBean, string, string2);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
        return stringArray;
    }

    public static String[] getDistributedTopicMemberNames(DomainMBean domainMBean, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
        DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(string2);
        if (distributedTopicBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage());
        }
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = distributedTopicBean.getDistributedTopicMembers();
        stringArray = new String[distributedDestinationMemberBeanArray.length];
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            stringArray[i] = distributedDestinationMemberBeanArray[i].getPhysicalDestinationName();
        }
        return stringArray;
    }

    public static void createUniformDistributedTopic(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createUniformDistributedTopic(context, string, string2, string3, string4, null);
    }

    public static void createUniformDistributedTopic(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createUniformDistributedTopic(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUniformDistributedTopic(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createUniformDistributedTopic(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createUniformDistributedTopic(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: uniformDistributedTopicName cannot be null or empty");
        }
        try {
            String string5;
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string4);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof MigratableTargetMBean)) continue;
                throw new JMSException(JMSExceptionLogger.logInvalidSubDeploymentTargetLoggable((String)string, (String)string4, (String)"MigratableTargetMBean", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            UniformDistributedTopicBean uniformDistributedTopicBean = jMSBean.createUniformDistributedTopic(string2);
            uniformDistributedTopicBean.setJNDIName(string3);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)uniformDistributedTopicBean);
            }
            if ((string5 = uniformDistributedTopicBean.getSubDeploymentName()) == null) {
                string5 = string2;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string5);
            subDeploymentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"UniformDistributedTopic", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createUniformDistributedQueue(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createUniformDistributedQueue(context, string, string2, string3, string4, null);
    }

    public static void createUniformDistributedQueue(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createUniformDistributedQueue(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUniformDistributedQueue(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createUniformDistributedQueue(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createUniformDistributedQueue(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: uniformDistributedQueueName cannot be null or empty");
        }
        try {
            String string5;
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string4);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof MigratableTargetMBean)) continue;
                throw new JMSException(JMSExceptionLogger.logInvalidSubDeploymentTargetLoggable((String)string, (String)string4, (String)"MigratableTargetMBean", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            UniformDistributedQueueBean uniformDistributedQueueBean = jMSBean.createUniformDistributedQueue(string2);
            uniformDistributedQueueBean.setJNDIName(string3);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)uniformDistributedQueueBean);
            }
            if ((string5 = uniformDistributedQueueBean.getSubDeploymentName()) == null) {
                string5 = string2;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string5);
            subDeploymentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"UniformDistributedQueue", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void deleteUniformDistributedQueue(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(context, string, string2, "UniformDistributedQueue");
    }

    public static void deleteUniformDistributedQueue(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(domainMBean, string, string2, "UniformDistributedQueue");
    }

    public static void deleteUniformDistributedTopic(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(context, string, string2, "UniformDistributedTopic");
    }

    public static void deleteUniformDistributedTopic(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.deleteDestination(domainMBean, string, string2, "UniformDistributedTopic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDistributedTopicMemberJndiNames(Context context, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.getDistributedTopicMemberJndiNames(domainMBean, string, string2);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
        return stringArray;
    }

    public static String[] getDistributedTopicMemberJndiNames(DomainMBean domainMBean, String string, String string2) throws JMSException {
        String[] stringArray = new String[]{};
        JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
        DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(string2);
        if (distributedTopicBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"DistributedTopic", (String)string2).getMessage());
        }
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = distributedTopicBean.getDistributedTopicMembers();
        stringArray = new String[distributedDestinationMemberBeanArray.length];
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            TopicBean topicBean = jMSBean.lookupTopic(distributedDestinationMemberBeanArray[i].getPhysicalDestinationName());
            if (topicBean == null) continue;
            stringArray[i] = topicBean.getJNDIName();
        }
        return stringArray;
    }

    public static void createForeignServer(Context context, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createForeignServer(context, string, string2, string3, null);
    }

    public static void createForeignServer(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        JMSModuleHelper.createForeignServer(domainMBean, string, string2, string3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createForeignServer(Context context, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createForeignServer(domainMBean, string, string2, string3, jMSNamedEntityModifier);
            bl = true;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createForeignServer(DomainMBean domainMBean, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: foreignServerName cannot be null or empty");
        }
        try {
            String string4;
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string3);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof MigratableTargetMBean)) continue;
                throw new JMSException(JMSExceptionLogger.logInvalidSubDeploymentTargetLoggable((String)string, (String)string3, (String)"MigratableTargetMBean", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            ForeignServerBean foreignServerBean = jMSBean.createForeignServer(string2);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)foreignServerBean);
            }
            if ((string4 = foreignServerBean.getSubDeploymentName()) == null) {
                string4 = string2;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string4);
            subDeploymentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteForeignServer(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteForeignServer(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteForeignServer(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            ForeignDestinationBean[] foreignDestinationBeanArray;
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(string2);
            if (foreignServerBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage());
            }
            ForeignConnectionFactoryBean[] foreignConnectionFactoryBeanArray = foreignServerBean.getForeignConnectionFactories();
            if (foreignConnectionFactoryBeanArray != null) {
                for (int i = 0; i < foreignConnectionFactoryBeanArray.length; ++i) {
                    foreignServerBean.destroyForeignConnectionFactory(foreignConnectionFactoryBeanArray[i]);
                }
            }
            if ((foreignDestinationBeanArray = foreignServerBean.getForeignDestinations()) != null) {
                for (int i = 0; i < foreignDestinationBeanArray.length; ++i) {
                    foreignServerBean.destroyForeignDestination(foreignDestinationBeanArray[i]);
                }
            }
            jMSBean.destroyForeignServer(foreignServerBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createForeignDestination(Context context, String string, String string2, String string3, String string4, String string5) throws JMSException {
        JMSModuleHelper.createForeignDestination(context, string, string2, string3, string4, string5, null);
    }

    public static void createForeignDestination(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5) throws JMSException {
        JMSModuleHelper.createForeignDestination(domainMBean, string, string2, string3, string4, string5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createForeignDestination(Context context, String string, String string2, String string3, String string4, String string5, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createForeignDestination(domainMBean, string, string2, string3, string4, string5, jMSNamedEntityModifier);
            bl = true;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createForeignDestination(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: foreignDestinationName cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(string2);
            if (foreignServerBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage());
            }
            ForeignDestinationBean foreignDestinationBean = foreignServerBean.createForeignDestination(string3);
            foreignDestinationBean.setLocalJNDIName(string4);
            foreignDestinationBean.setRemoteJNDIName(string5);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)foreignDestinationBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"ForeignDestination", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteForeignDestination(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteForeignDestination(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void deleteForeignDestination(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(string2);
            if (foreignServerBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage());
            }
            ForeignDestinationBean foreignDestinationBean = foreignServerBean.lookupForeignDestination(string3);
            if (foreignDestinationBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignDestination", (String)string3).getMessage());
            }
            foreignServerBean.destroyForeignDestination(foreignDestinationBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"ForeignDestination", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    public static void createForeignConnectionFactory(Context context, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws JMSException {
        JMSModuleHelper.createForeignConnectionFactory(context, string, string2, string3, string4, string5, string6, string7, null);
    }

    public static void createForeignConnectionFactory(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws JMSException {
        JMSModuleHelper.createForeignConnectionFactory(domainMBean, string, string2, string3, string4, string5, string6, string7, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createForeignConnectionFactory(Context context, String string, String string2, String string3, String string4, String string5, String string6, String string7, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createForeignConnectionFactory(domainMBean, string, string2, string3, string4, string5, string6, string7, jMSNamedEntityModifier);
            bl = true;
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createForeignConnectionFactory(DomainMBean domainMBean, String string, String string2, String string3, String string4, String string5, String string6, String string7, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: foreignConnectionFactoryName cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(string2);
            if (foreignServerBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage());
            }
            ForeignConnectionFactoryBean foreignConnectionFactoryBean = foreignServerBean.createForeignConnectionFactory(string3);
            foreignConnectionFactoryBean.setLocalJNDIName(string4);
            foreignConnectionFactoryBean.setRemoteJNDIName(string5);
            foreignConnectionFactoryBean.setUsername(string6);
            foreignConnectionFactoryBean.setPassword(string7);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)foreignConnectionFactoryBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"ForeignConnectionFactory", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteForeignConnectionFactory(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteForeignConnectionFactory(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void deleteForeignConnectionFactory(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(string2);
            if (foreignServerBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignServer", (String)string2).getMessage());
            }
            ForeignConnectionFactoryBean foreignConnectionFactoryBean = foreignServerBean.lookupForeignConnectionFactory(string3);
            if (foreignConnectionFactoryBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"ForeignConnectionFactory", (String)string3).getMessage());
            }
            foreignServerBean.destroyForeignConnectionFactory(foreignConnectionFactoryBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"ForeignConnectionFactory", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    public static void createSAFImportedDestinations(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createSAFImportedDestinations(context, string, string2, string3, string4, null);
    }

    public static void createSAFImportedDestinations(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createSAFImportedDestinations(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSAFImportedDestinations(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createSAFImportedDestinations(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createSAFImportedDestinations(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: safImportedDestinationsName cannot be null or empty");
        }
        try {
            String string5;
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string4);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof MigratableTargetMBean) && !(targetMBeanArray[i] instanceof JMSServerMBean)) continue;
                throw new JMSException(JMSExceptionLogger.logInvalidSubDeploymentTargetLoggable((String)string, (String)string4, (String)"MigratableTargetMBean", (String)string2).getMessage());
            }
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            SAFRemoteContextBean sAFRemoteContextBean = jMSBean.lookupSAFRemoteContext(string3);
            if (sAFRemoteContextBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFRemoteContext", (String)string3).getMessage());
            }
            SAFImportedDestinationsBean sAFImportedDestinationsBean = jMSBean.createSAFImportedDestinations(string2);
            sAFImportedDestinationsBean.setSAFRemoteContext(sAFRemoteContextBean);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)sAFImportedDestinationsBean);
            }
            if ((string5 = sAFImportedDestinationsBean.getSubDeploymentName()) == null) {
                string5 = string2;
            }
            SubDeploymentMBean subDeploymentMBean = JMSModuleHelper.findOrCreateSubDeployment(jMSSystemResourceMBean, string5);
            subDeploymentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSAFImportedDestinations(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteSAFImportedDestinations(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteSAFImportedDestinations(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            SAFTopicBean[] sAFTopicBeanArray;
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFImportedDestinationsBean sAFImportedDestinationsBean = jMSBean.lookupSAFImportedDestinations(string2);
            if (sAFImportedDestinationsBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage());
            }
            SAFQueueBean[] sAFQueueBeanArray = sAFImportedDestinationsBean.getSAFQueues();
            if (sAFQueueBeanArray != null) {
                for (int i = 0; i < sAFQueueBeanArray.length; ++i) {
                    sAFImportedDestinationsBean.destroySAFQueue(sAFQueueBeanArray[i]);
                }
            }
            if ((sAFTopicBeanArray = sAFImportedDestinationsBean.getSAFTopics()) != null) {
                for (int i = 0; i < sAFTopicBeanArray.length; ++i) {
                    sAFImportedDestinationsBean.destroySAFTopic(sAFTopicBeanArray[i]);
                }
            }
            jMSBean.destroySAFImportedDestinations(sAFImportedDestinationsBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createSAFRemoteContext(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.createSAFRemoteContext(context, string, string2, null);
    }

    public static void createSAFRemoteContext(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.createSAFRemoteContext(domainMBean, string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSAFRemoteContext(Context context, String string, String string2, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createSAFRemoteContext(domainMBean, string, string2, jMSNamedEntityModifier);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createSAFRemoteContext(DomainMBean domainMBean, String string, String string2, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: SAFRemoteContextName cannot be null or empty");
        }
        try {
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            SAFRemoteContextBean sAFRemoteContextBean = jMSBean.createSAFRemoteContext(string2);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)sAFRemoteContextBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFRemoteContext", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSAFRemoteContext(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteSAFRemoteContext(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteSAFRemoteContext(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFRemoteContextBean sAFRemoteContextBean = jMSBean.lookupSAFRemoteContext(string2);
            if (sAFRemoteContextBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFRemoteContext", (String)string2).getMessage());
            }
            jMSBean.destroySAFRemoteContext(sAFRemoteContextBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFRemoteContext", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createSAFErrorHandling(Context context, String string, String string2) throws JMSException {
        JMSModuleHelper.createSAFErrorHandling(context, string, string2, null);
    }

    public static void createSAFErrorHandling(DomainMBean domainMBean, String string, String string2) throws JMSException {
        JMSModuleHelper.createSAFErrorHandling(domainMBean, string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSAFErrorHandling(Context context, String string, String string2, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createSAFErrorHandling(domainMBean, string, string2, jMSNamedEntityModifier);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void createSAFErrorHandling(DomainMBean domainMBean, String string, String string2, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: SAFErrorHandlingName cannot be null or empty");
        }
        try {
            JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
            JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
            SAFErrorHandlingBean sAFErrorHandlingBean = jMSBean.createSAFErrorHandling(string2);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)sAFErrorHandlingBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFErrorHandling", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSAFErrorHandling(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteSAFErrorHandling(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void deleteSAFErrorHandling(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFErrorHandlingBean sAFErrorHandlingBean = jMSBean.lookupSAFErrorHandling(string2);
            if (sAFErrorHandlingBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFErrorHandling", (String)string2).getMessage());
            }
            jMSBean.destroySAFErrorHandling(sAFErrorHandlingBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFErrorHandling", (String)string2).getMessage(), (Throwable)exception);
        }
    }

    public static void createSAFQueue(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createSAFQueue(context, string, string2, string3, string4, null);
    }

    public static void createSAFQueue(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createSAFQueue(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSAFQueue(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createSAFQueue(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createSAFQueue(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: safQueueName cannot be null or empty");
        }
        if (string4 == null || string4.trim().equals("")) {
            throw new JMSException("ERROR: RemoteJNDIName of a SAFQueue cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFImportedDestinationsBean sAFImportedDestinationsBean = jMSBean.lookupSAFImportedDestinations(string2);
            if (sAFImportedDestinationsBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage());
            }
            SAFQueueBean sAFQueueBean = sAFImportedDestinationsBean.createSAFQueue(string3);
            sAFQueueBean.setRemoteJNDIName(string4);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)sAFQueueBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFQueue", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSAFQueue(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteSAFQueue(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void deleteSAFQueue(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFImportedDestinationsBean sAFImportedDestinationsBean = jMSBean.lookupSAFImportedDestinations(string2);
            if (sAFImportedDestinationsBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage());
            }
            SAFQueueBean sAFQueueBean = sAFImportedDestinationsBean.lookupSAFQueue(string3);
            if (sAFQueueBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFQueue", (String)string3).getMessage());
            }
            sAFImportedDestinationsBean.destroySAFQueue(sAFQueueBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"SAFQueue", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    public static void createSAFTopic(Context context, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createSAFTopic(context, string, string2, string3, string4, null);
    }

    public static void createSAFTopic(DomainMBean domainMBean, String string, String string2, String string3, String string4) throws JMSException {
        JMSModuleHelper.createSAFTopic(domainMBean, string, string2, string3, string4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSAFTopic(Context context, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createSAFTopic(domainMBean, string, string2, string3, string4, jMSNamedEntityModifier);
            bl = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void createSAFTopic(DomainMBean domainMBean, String string, String string2, String string3, String string4, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: topicName cannot be null or empty");
        }
        if (string4 == null || string4.trim().equals("")) {
            throw new JMSException("ERROR: RemoteJNDIName of a SAFTopic cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFImportedDestinationsBean sAFImportedDestinationsBean = jMSBean.lookupSAFImportedDestinations(string2);
            if (sAFImportedDestinationsBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage());
            }
            SAFTopicBean sAFTopicBean = sAFImportedDestinationsBean.createSAFTopic(string3);
            sAFTopicBean.setRemoteJNDIName(string4);
            if (jMSNamedEntityModifier != null) {
                jMSNamedEntityModifier.modify((NamedEntityBean)sAFTopicBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInJMSSystemResourceLoggable((String)string, (String)"SAFTopic", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSAFTopic(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteSAFTopic(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string3, bl);
    }

    public static void deleteSAFTopic(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            SAFImportedDestinationsBean sAFImportedDestinationsBean = jMSBean.lookupSAFImportedDestinations(string2);
            if (sAFImportedDestinationsBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFImportedDestinations", (String)string2).getMessage());
            }
            SAFTopicBean sAFTopicBean = sAFImportedDestinationsBean.lookupSAFTopic(string3);
            if (sAFTopicBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)"SAFTopic", (String)string3).getMessage());
            }
            sAFImportedDestinationsBean.destroySAFTopic(sAFTopicBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)"SAFTopic", (String)string3).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findAndModifyEntity(Context context, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (jMSNamedEntityModifier == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logInvalidModuleEntityModifierLoggable((String)string, (String)string3, (String)string2).getMessage());
        }
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.findAndModifyEntity(domainMBean, string, string2, string3, jMSNamedEntityModifier);
            bl = true;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    public static void findAndModifyEntity(DomainMBean domainMBean, String string, String string2, String string3, JMSNamedEntityModifier jMSNamedEntityModifier) throws JMSException {
        if (jMSNamedEntityModifier == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logInvalidModuleEntityModifierLoggable((String)string, (String)string3, (String)string2).getMessage());
        }
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string == null || string.trim().equals("")) {
            throw new JMSException("ERROR: resourceName cannot be null or empty");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new JMSException("ERROR: entityName cannot be null or empty");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new JMSException("ERROR: entityType cannot be null or empty");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            Class<?> clazz = jMSBean.getClass();
            String string4 = "lookup" + string3;
            Method method = null;
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string2};
            NamedEntityBean namedEntityBean = null;
            try {
                method = clazz.getMethod(string4, classArray);
            }
            catch (Exception exception) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotFindAndModifyEntityFromJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage(), (Throwable)exception);
            }
            try {
                namedEntityBean = (NamedEntityBean)method.invoke((Object)jMSBean, objectArray);
            }
            catch (Exception exception) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotFindAndModifyEntityFromJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage(), (Throwable)exception);
            }
            if (namedEntityBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage());
            }
            jMSNamedEntityModifier.modify(namedEntityBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotFindAndModifyEntityFromJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJMSServer(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createJMSServer(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void createJMSServer(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string == null || string.trim().equals("")) {
            throw new JMSException("ERROR: jmsServerName cannot be null or empty");
        }
        try {
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string2);
            if (targetMBeanArray.length != 1) {
                throw new JMSException("ERROR: A JMSServer cannot be targeted multiple targets");
            }
            if (targetMBeanArray[0] instanceof ClusterMBean || targetMBeanArray[0] instanceof SAFAgentMBean || targetMBeanArray[0] instanceof JMSServerMBean) {
                throw new JMSException("ERROR: Cluster, SAFAgent and JMSServer cannot be set as target for JMSServer");
            }
            JMSServerMBean jMSServerMBean = domainMBean.createJMSServer(string);
            jMSServerMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteJMSServer(Context context, String string) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteJMSServer(domainMBean, string);
            bl = true;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void deleteJMSServer(DomainMBean domainMBean, String string) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string);
            if (jMSServerMBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string).getMessage());
            }
            TargetMBean targetMBean = jMSServerMBean.getTargets()[0];
            jMSServerMBean.removeTarget(targetMBean);
            domainMBean.destroyJMSServer(jMSServerMBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployJMSServer(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deployJMSServer(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void deployJMSServer(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string);
        if (jMSServerMBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string).getMessage());
        }
        try {
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string2);
            if (targetMBeanArray.length != 1) {
                throw new JMSException("ERROR: A JMSServer cannot be targeted multiple targets");
            }
            if (targetMBeanArray[0] instanceof ClusterMBean || targetMBeanArray[0] instanceof SAFAgentMBean || targetMBeanArray[0] instanceof JMSServerMBean) {
                throw new JMSException("ERROR: Cluster, SAFAgent and JMSServer cannot be set as target for JMSServer");
            }
            jMSServerMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("ERROR: Could not deploy JMSSerever " + string + " in the domain " + domainMBean.getName(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void undeployJMSServer(Context context, String string) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.undeployJMSServer(domainMBean, string);
            bl = true;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void undeployJMSServer(DomainMBean domainMBean, String string) throws JMSException {
        TargetMBean[] targetMBeanArray;
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer(string);
        if (jMSServerMBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)domainMBean.getName(), (String)"JMSServer", (String)string).getMessage());
        }
        TargetMBean[] targetMBeanArray2 = jMSServerMBean.getTargets();
        if (targetMBeanArray2 == null || targetMBeanArray2.length == 0) {
            throw new weblogic.jms.common.JMSException("ERROR: Could not undeploy JMSServer " + string + " in the domain " + domainMBean.getName() + ", it is not currently deployed");
        }
        TargetMBean targetMBean = targetMBeanArray2[0];
        TargetMBean targetMBean2 = null;
        if (targetMBean == null) {
            throw new JMSException("JMSServer " + string + " is not currently deployed");
        }
        if (targetMBean instanceof MigratableTargetMBean) {
            targetMBeanArray = domainMBean.getMigratableTargets();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!targetMBean.getName().equals(targetMBeanArray[i].getName())) continue;
                targetMBean2 = targetMBeanArray[i].getUserPreferredServer();
                break;
            }
        } else {
            targetMBeanArray = domainMBean.getServers();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!targetMBean.getName().equals(targetMBeanArray[i].getName())) continue;
                targetMBean2 = targetMBeanArray[i];
                break;
            }
        }
        try {
            if (targetMBean2 != null) {
                jMSServerMBean.removeTarget(targetMBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("ERROR: Could not undeploy JMSServer " + string + " in the domain " + domainMBean.getName(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSAFAgent(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.createSAFAgent(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void createSAFAgent(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        if (string == null || string.trim().equals("")) {
            throw new JMSException("ERROR: safAgentName cannot be null or empty");
        }
        try {
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string2);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof MigratableTargetMBean) && !(targetMBeanArray[i] instanceof JMSServerMBean) && !(targetMBeanArray[i] instanceof SAFAgentMBean)) continue;
                throw new JMSException("ERROR: MigratableTarget, JMSServer and SAFAgent cannot be set as target for SAFAgent");
            }
            SAFAgentMBean sAFAgentMBean = domainMBean.createSAFAgent(string);
            sAFAgentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotCreateEntityInDomainLoggable((String)domainMBean.getName(), (String)"SAFAgent", (String)string).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSAFAgent(Context context, String string) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteSAFAgent(domainMBean, string);
            bl = true;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void deleteSAFAgent(DomainMBean domainMBean, String string) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            SAFAgentMBean sAFAgentMBean = domainMBean.lookupSAFAgent(string);
            if (sAFAgentMBean == null) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"SAFAgent", (String)string).getMessage());
            }
            TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                sAFAgentMBean.removeTarget(targetMBeanArray[i]);
            }
            domainMBean.destroySAFAgent(sAFAgentMBean);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromDomainLoggable((String)domainMBean.getName(), (String)"SAFAgent", (String)string).getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deploySAFAgent(Context context, String string, String string2) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deploySAFAgent(domainMBean, string, string2);
            bl = true;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void deploySAFAgent(DomainMBean domainMBean, String string, String string2) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        SAFAgentMBean sAFAgentMBean = domainMBean.lookupSAFAgent(string);
        if (sAFAgentMBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInDomainLoggable((String)domainMBean.getName(), (String)"SAFAgent", (String)string).getMessage());
        }
        try {
            TargetMBean[] targetMBeanArray = JMSModuleHelper.targetNames2TargetMBeans(domainMBean, string2);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (!(targetMBeanArray[i] instanceof MigratableTargetMBean) && !(targetMBeanArray[i] instanceof JMSServerMBean) && !(targetMBeanArray[i] instanceof SAFAgentMBean)) continue;
                throw new JMSException("ERROR: MigratableTarget, JMSServer and SAFAgent cannot be set as target for SAFAgent");
            }
            sAFAgentMBean.setTargets(targetMBeanArray);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("ERROR: Could not deploy SAFAgent " + string + " in the domain " + domainMBean.getName(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void undeploySAFAgent(Context context, String string) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.undeploySAFAgent(domainMBean, string);
            bl = true;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string, bl);
    }

    public static void undeploySAFAgent(DomainMBean domainMBean, String string) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        SAFAgentMBean sAFAgentMBean = domainMBean.lookupSAFAgent(string);
        if (sAFAgentMBean == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)domainMBean.getName(), (String)"SAFAgent", (String)string).getMessage());
        }
        TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            throw new JMSException("SAFAgent " + string + " is not currently deployed");
        }
        try {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                sAFAgentMBean.removeTarget(targetMBeanArray[i]);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("ERROR: Could not deploy SAFAgent " + string + " in the domain " + domainMBean.getName(), (Throwable)exception);
        }
    }

    private static TargetMBean findMatchingTargetMBean(DomainMBean domainMBean, String string) throws JMSException {
        TargetMBean targetMBean = domainMBean.lookupMigratableTarget(string);
        if (targetMBean == null && (targetMBean = domainMBean.lookupCluster(string)) == null && (targetMBean = domainMBean.lookupServer(string)) == null && (targetMBean = domainMBean.lookupJMSServer(string)) == null && (targetMBean = domainMBean.lookupSAFAgent(string)) == null) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)domainMBean.getName(), (String)"MigratableTarget/Cluster/Server/JMSServer/SAFAgent", (String)string).getMessage());
        }
        return targetMBean;
    }

    private static TargetMBean[] targetNames2TargetMBeans(DomainMBean domainMBean, String string) throws JMSException {
        String[] stringArray = string.split(",");
        TargetMBean[] targetMBeanArray = new TargetMBean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            targetMBeanArray[i] = JMSModuleHelper.findMatchingTargetMBean(domainMBean, stringArray[i]);
        }
        return targetMBeanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteDestination(Context context, String string, String string2, String string3) throws JMSException {
        ConfigurationManagerMBean configurationManagerMBean = JMSEditHelper.getConfigurationManager(context);
        DomainMBean domainMBean = JMSModuleHelper.beginEditSession(configurationManagerMBean);
        boolean bl = false;
        try {
            JMSModuleHelper.deleteDestination(domainMBean, string, string2, string3);
            bl = true;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
            throw throwable;
        }
        JMSModuleHelper.endEditSession(configurationManagerMBean, string2, bl);
    }

    private static void deleteDestination(DomainMBean domainMBean, String string, String string2, String string3) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: domain cannot be null");
        }
        try {
            JMSBean jMSBean = JMSModuleHelper.getJMSBean(domainMBean, string);
            if (string3.equals("JMSQueue")) {
                QueueBean queueBean = jMSBean.lookupQueue(string2);
                if (queueBean == null) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage());
                }
                jMSBean.destroyQueue(queueBean);
            } else if (string3.equals("JMSTopic")) {
                TopicBean topicBean = jMSBean.lookupTopic(string2);
                if (topicBean == null) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage());
                }
                jMSBean.destroyTopic(topicBean);
            } else if (string3.equals("UniformDistributedQueue")) {
                UniformDistributedQueueBean uniformDistributedQueueBean = jMSBean.lookupUniformDistributedQueue(string2);
                if (uniformDistributedQueueBean == null) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage());
                }
                jMSBean.destroyUniformDistributedQueue(uniformDistributedQueueBean);
            } else if (string3.equals("UniformDistributedTopic")) {
                UniformDistributedTopicBean uniformDistributedTopicBean = jMSBean.lookupUniformDistributedTopic(string2);
                if (uniformDistributedTopicBean == null) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logEntityNotFoundInJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage());
                }
                jMSBean.destroyUniformDistributedTopic(uniformDistributedTopicBean);
            }
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logCannotDeleteEntityFromJMSSystemResourceLoggable((String)string, (String)string3, (String)string2).getMessage(), (Throwable)exception);
        }
    }

    private static void activateEdit(ConfigurationManagerMBean configurationManagerMBean) throws JMSException {
        ActivationTaskMBean activationTaskMBean;
        try {
            configurationManagerMBean.save();
        }
        catch (NotEditorException notEditorException) {
            throw new weblogic.jms.common.JMSException("ERROR: Not editor while saving edit", (Throwable)((Object)notEditorException));
        }
        catch (ValidationException validationException) {
            throw new weblogic.jms.common.JMSException("ERROR: Validation error while saving edit", (Throwable)((Object)validationException));
        }
        try {
            activationTaskMBean = configurationManagerMBean.activate(-1L);
        }
        catch (NotEditorException notEditorException) {
            throw new weblogic.jms.common.JMSException("ERROR: Edit session activation failed", (Throwable)((Object)notEditorException));
        }
        Exception exception = activationTaskMBean.getError();
        if (exception != null) {
            throw new weblogic.jms.common.JMSException("ERROR: Edit session activation failed. Reason:" + exception.getMessage(), (Throwable)exception);
        }
    }

    public static String uddMakeName(String string, String string2) {
        int n = (string2 = JMSServerUtilities.transformJNDIName(string2)).indexOf("!");
        String string3 = n != -1 ? string2.substring(n + 1) : string2;
        return string + "@" + string3;
    }

    public static String uddMemberName(String string, String string2) {
        return JMSModuleHelper.uddMakeName(string, string2);
    }

    public static String uddMemberJNDIName(String string, String string2) {
        return JMSModuleHelper.uddMakeName(string, string2);
    }

    private static void uddFillWithJMSServers(Map map, DomainMBean domainMBean, ServerMBean[] serverMBeanArray) {
        if (serverMBeanArray == null) {
            return;
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            JMSModuleHelper.uddFillWithJMSServers(map, domainMBean, serverMBeanArray[i]);
        }
    }

    private static void uddFillWithJMSServers(Map map, DomainMBean domainMBean, ServerMBean serverMBean) {
        if (serverMBean == null) {
            return;
        }
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = jMSServerMBeanArray[i].getTargets();
            if (targetMBeanArray == null || targetMBeanArray.length == 0) continue;
            TargetMBean targetMBean = targetMBeanArray[0];
            if (targetMBean.getName().equals(serverMBean.getName())) {
                if (map.put(jMSServerMBeanArray[i].getName(), jMSServerMBeanArray[i].getName()) == null) continue;
                throw new IllegalArgumentException("Targets of UDD overlap");
            }
            ClusterMBean clusterMBean = serverMBean.getCluster();
            if (clusterMBean == null || !(targetMBean instanceof MigratableTargetMBean)) continue;
            ClusterMBean clusterMBean2 = ((MigratableTargetMBean)targetMBean).getCluster();
            ServerMBean[] serverMBeanArray = ((MigratableTargetMBean)targetMBean).getAllCandidateServers();
            if (serverMBeanArray == null) continue;
            if (serverMBeanArray.length == 0) {
                if (clusterMBean2 == null || !clusterMBean.getName().equals(clusterMBean2.getName()) || map.get(jMSServerMBeanArray[i].getName()) != null) continue;
                map.put(jMSServerMBeanArray[i].getName(), jMSServerMBeanArray[i].getName());
                continue;
            }
            for (int j = 0; j < serverMBeanArray.length; ++j) {
                if (!serverMBeanArray[j].getName().equals(serverMBean.getName()) || map.get(jMSServerMBeanArray[i].getName()) != null) continue;
                map.put(jMSServerMBeanArray[i].getName(), jMSServerMBeanArray[i].getName());
            }
        }
    }

    public static void uddFillWithMyTargets(Map map, DomainMBean domainMBean, SubDeploymentMBean subDeploymentMBean) {
        JMSModuleHelper.uddFillWithMyTargets(map, domainMBean, subDeploymentMBean.getTargets());
    }

    public static void uddFillWithMyTargets(Map map, DomainMBean domainMBean, TargetMBean[] targetMBeanArray) {
        Object object;
        Object object2;
        if (targetMBeanArray == null) {
            return;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            object2 = targetMBeanArray[i];
            if (object2 instanceof ClusterMBean) {
                object = ((ClusterMBean)object2).getServers();
                JMSModuleHelper.uddFillWithJMSServers(map, domainMBean, object);
                continue;
            }
            if (object2 instanceof ServerMBean) {
                JMSModuleHelper.uddFillWithJMSServers(map, domainMBean, (ServerMBean)object2);
                continue;
            }
            if (object2 instanceof JMSServerMBean) {
                if (map.put(object2.getName(), object2.getName()) == null) continue;
                throw new IllegalArgumentException("Targets of UDD overlap");
            }
            throw new IllegalArgumentException("A UDD cannot be targeted to a migratable target");
        }
        if (map.size() == 1) {
            return;
        }
        Iterator iterator = map.values().iterator();
        object2 = null;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            JMSServerMBean jMSServerMBean = domainMBean.lookupJMSServer((String)object);
            if (jMSServerMBean.getTargets().length == 0) continue;
            TargetMBean targetMBean = jMSServerMBean.getTargets()[0];
            ClusterMBean clusterMBean = targetMBean instanceof MigratableTargetMBean ? ((MigratableTargetMBean)targetMBean).getCluster() : ((ServerMBean)targetMBean).getCluster();
            String string = clusterMBean == null ? "Stand Alone Server " + ((ServerMBean)targetMBean).getName() : "Cluster " + clusterMBean.getName();
            if (object2 == null) {
                object2 = string;
                continue;
            }
            if (string.equals(object2)) continue;
            throw new IllegalArgumentException("A UDD must be targeted to servers within a single cluster or a single stand-alone server, rather than " + (String)object2 + " and " + string);
        }
    }

    public static String[] uddReturnJMSServers(DomainMBean domainMBean, SubDeploymentMBean subDeploymentMBean) {
        HashMap hashMap = new HashMap();
        JMSModuleHelper.uddFillWithMyTargets(hashMap, domainMBean, subDeploymentMBean);
        return hashMap.values().toArray(new String[1]);
    }

    private static JMSSystemResourceMBean findJMSSystemResource(DomainMBean domainMBean, String string) throws JMSException {
        if (domainMBean == null) {
            throw new JMSException("ERROR: Invalid domain: DomainMBean cannot be null ");
        }
        if (string == null || string.trim().equals("")) {
            throw new JMSException("ERROR: Invalid JMS System Resource Name: resource name cannot be null or empty");
        }
        JMSSystemResourceMBean jMSSystemResourceMBean = domainMBean.lookupJMSSystemResource(string);
        if (jMSSystemResourceMBean == null) {
            throw new JMSException("ERROR: Could not find JMSSystemResource " + string + " in the domain " + domainMBean.getName());
        }
        return jMSSystemResourceMBean;
    }

    private static JMSBean getJMSBean(DomainMBean domainMBean, String string) throws JMSException {
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSModuleHelper.findJMSSystemResource(domainMBean, string);
        return jMSSystemResourceMBean.getJMSResource();
    }

    private static DomainMBean beginEditSession(ConfigurationManagerMBean configurationManagerMBean) throws JMSException {
        DomainMBean domainMBean = null;
        try {
            domainMBean = configurationManagerMBean.startEdit(-1, -1);
        }
        catch (EditTimedOutException editTimedOutException) {
            throw new weblogic.jms.common.JMSException("ERROR: Unable to start the edit session", (Throwable)((Object)editTimedOutException));
        }
        return domainMBean;
    }

    private static void endEditSession(ConfigurationManagerMBean configurationManagerMBean, String string, boolean bl) throws JMSException {
        if (!bl) {
            configurationManagerMBean.cancelEdit();
        } else {
            try {
                JMSModuleHelper.activateEdit(configurationManagerMBean);
            }
            catch (JMSException jMSException) {
                configurationManagerMBean.cancelEdit();
                Throwable throwable = jMSException.getCause();
                throw new weblogic.jms.common.JMSException("ERROR: Could not activate update for the entity " + string + ". The edit session was cancelled and the changes made " + "in this edit session were discarded. \nREASON: ", throwable == null ? jMSException : throwable);
            }
        }
    }

    private static SubDeploymentMBean findOrCreateSubDeployment(JMSSystemResourceMBean jMSSystemResourceMBean, String string) {
        SubDeploymentMBean subDeploymentMBean = jMSSystemResourceMBean.lookupSubDeployment(string);
        if (subDeploymentMBean == null) {
            subDeploymentMBean = jMSSystemResourceMBean.createSubDeployment(string);
        }
        return subDeploymentMBean;
    }
}

