/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.ConsumerInternal;
import weblogic.jms.client.ProducerInternal;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSEditHelper;
import weblogic.jms.common.JMSException;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.runtime.JMSConnectionRuntimeMBean;
import weblogic.management.runtime.JMSConsumerRuntimeMBean;
import weblogic.management.runtime.JMSDestinationRuntimeMBean;
import weblogic.management.runtime.JMSProducerRuntimeMBean;
import weblogic.management.runtime.JMSRuntimeMBean;
import weblogic.management.runtime.JMSServerRuntimeMBean;
import weblogic.management.runtime.JMSSessionRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;

public class JMSRuntimeHelper {
    public static JMSConnectionRuntimeMBean getJMSConnectionRuntimeMBean(Context context, Connection connection) throws JMSException {
        if (!(connection instanceof ConnectionInternal)) {
            throw new JMSException("Unknown foreign connection");
        }
        ConnectionInternal connectionInternal = (ConnectionInternal)connection;
        try {
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean serverRuntimeMBean = domainRuntimeServiceMBean.lookupServerRuntime(connectionInternal.getWLSServerName());
            JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
            JMSConnectionRuntimeMBean[] jMSConnectionRuntimeMBeanArray = jMSRuntimeMBean.getConnections();
            JMSConnectionRuntimeMBean jMSConnectionRuntimeMBean = null;
            for (int i = 0; i < jMSConnectionRuntimeMBeanArray.length; ++i) {
                if (!connectionInternal.getRuntimeMBeanName().equals(jMSConnectionRuntimeMBeanArray[i].getName())) continue;
                jMSConnectionRuntimeMBean = jMSConnectionRuntimeMBeanArray[i];
                break;
            }
            if (jMSConnectionRuntimeMBean == null) {
                throw new JMSException("JMS Connection runtime mbean not found");
            }
            return jMSConnectionRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSProducerRuntimeMBean getJMSMessageProducerRuntimeMBean(Context context, MessageProducer messageProducer) throws JMSException {
        if (!(messageProducer instanceof ProducerInternal)) {
            throw new JMSException("Unknown foreign message producer");
        }
        ProducerInternal producerInternal = (ProducerInternal)messageProducer;
        try {
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean serverRuntimeMBean = domainRuntimeServiceMBean.lookupServerRuntime(producerInternal.getWLSServerName());
            JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
            JMSConnectionRuntimeMBean[] jMSConnectionRuntimeMBeanArray = jMSRuntimeMBean.getConnections();
            JMSProducerRuntimeMBean jMSProducerRuntimeMBean = null;
            for (int i = 0; i < jMSConnectionRuntimeMBeanArray.length; ++i) {
                JMSSessionRuntimeMBean[] jMSSessionRuntimeMBeanArray = jMSConnectionRuntimeMBeanArray[i].getSessions();
                block3: for (int j = 0; j < jMSSessionRuntimeMBeanArray.length; ++j) {
                    JMSProducerRuntimeMBean[] jMSProducerRuntimeMBeanArray = jMSSessionRuntimeMBeanArray[j].getProducers();
                    for (int k = 0; k < jMSProducerRuntimeMBeanArray.length; ++k) {
                        if (!producerInternal.getRuntimeMBeanName().equals(jMSProducerRuntimeMBeanArray[k].getName())) continue;
                        jMSProducerRuntimeMBean = jMSProducerRuntimeMBeanArray[k];
                        continue block3;
                    }
                }
            }
            if (jMSProducerRuntimeMBean == null) {
                throw new JMSException("JMS Prodcuer runtime mbean not found");
            }
            return jMSProducerRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSConsumerRuntimeMBean getJMSMessageConsumerRuntimeMBean(Context context, MessageConsumer messageConsumer) throws JMSException {
        if (!(messageConsumer instanceof ConsumerInternal)) {
            throw new JMSException("Unknown foreign message consumer");
        }
        ConsumerInternal consumerInternal = (ConsumerInternal)messageConsumer;
        try {
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean serverRuntimeMBean = domainRuntimeServiceMBean.lookupServerRuntime(consumerInternal.getWLSServerName());
            JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
            JMSConnectionRuntimeMBean[] jMSConnectionRuntimeMBeanArray = jMSRuntimeMBean.getConnections();
            JMSConsumerRuntimeMBean jMSConsumerRuntimeMBean = null;
            for (int i = 0; i < jMSConnectionRuntimeMBeanArray.length; ++i) {
                JMSSessionRuntimeMBean[] jMSSessionRuntimeMBeanArray = jMSConnectionRuntimeMBeanArray[i].getSessions();
                block3: for (int j = 0; j < jMSSessionRuntimeMBeanArray.length; ++j) {
                    JMSConsumerRuntimeMBean[] jMSConsumerRuntimeMBeanArray = jMSSessionRuntimeMBeanArray[j].getConsumers();
                    for (int k = 0; k < jMSConsumerRuntimeMBeanArray.length; ++k) {
                        if (!consumerInternal.getRuntimeMBeanName().equals(jMSConsumerRuntimeMBeanArray[k].getName())) continue;
                        jMSConsumerRuntimeMBean = jMSConsumerRuntimeMBeanArray[k];
                        continue block3;
                    }
                }
            }
            if (jMSConsumerRuntimeMBean == null) {
                throw new JMSException("JMS Consumer runtime mbean not found");
            }
            return jMSConsumerRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSSessionRuntimeMBean getJMSSessionRuntimeMBean(Context context, Session session) throws JMSException {
        if (!(session instanceof SessionInternal)) {
            throw new JMSException("Unknown foreign customerSession");
        }
        SessionInternal sessionInternal = (SessionInternal)session;
        try {
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean serverRuntimeMBean = domainRuntimeServiceMBean.lookupServerRuntime(sessionInternal.getWLSServerName());
            JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
            JMSConnectionRuntimeMBean[] jMSConnectionRuntimeMBeanArray = jMSRuntimeMBean.getConnections();
            JMSSessionRuntimeMBean jMSSessionRuntimeMBean = null;
            block2: for (int i = 0; i < jMSConnectionRuntimeMBeanArray.length; ++i) {
                JMSSessionRuntimeMBean[] jMSSessionRuntimeMBeanArray = jMSConnectionRuntimeMBeanArray[i].getSessions();
                for (int j = 0; j < jMSSessionRuntimeMBeanArray.length; ++j) {
                    if (!sessionInternal.getRuntimeMBeanName().equals(jMSSessionRuntimeMBeanArray[j].getName())) continue;
                    jMSSessionRuntimeMBean = jMSSessionRuntimeMBeanArray[j];
                    continue block2;
                }
            }
            if (jMSSessionRuntimeMBean == null) {
                throw new JMSException("JMS Session runtime mbean not found");
            }
            return jMSSessionRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSServerRuntimeMBean getJMSServerRuntimeMBean(Context context, Destination destination) throws JMSException {
        if (!(destination instanceof DestinationImpl)) {
            throw new JMSException("Unknown foreign destination");
        }
        DestinationImpl destinationImpl = (DestinationImpl)destination;
        String string = destinationImpl.getServerName();
        try {
            JMSServerRuntimeMBean jMSServerRuntimeMBean = null;
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean[] serverRuntimeMBeanArray = domainRuntimeServiceMBean.getServerRuntimes();
            block2: for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
                ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
                JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
                JMSServerRuntimeMBean[] jMSServerRuntimeMBeanArray = jMSRuntimeMBean.getJMSServers();
                for (int j = 0; j < jMSServerRuntimeMBeanArray.length; ++j) {
                    if (!string.equals(jMSServerRuntimeMBeanArray[j].getName())) continue;
                    jMSServerRuntimeMBean = jMSServerRuntimeMBeanArray[j];
                    continue block2;
                }
            }
            if (jMSServerRuntimeMBean == null) {
                throw new JMSException("JMS Server runtime mbean not found");
            }
            return jMSServerRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSDestinationRuntimeMBean getJMSDestinationRuntimeMBean(Context context, String string, String string2) throws JMSException {
        try {
            JMSDestinationRuntimeMBean jMSDestinationRuntimeMBean = null;
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean[] serverRuntimeMBeanArray = domainRuntimeServiceMBean.getServerRuntimes();
            for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
                ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
                JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
                JMSServerRuntimeMBean[] jMSServerRuntimeMBeanArray = jMSRuntimeMBean.getJMSServers();
                block3: for (int j = 0; j < jMSServerRuntimeMBeanArray.length; ++j) {
                    JMSDestinationRuntimeMBean[] jMSDestinationRuntimeMBeanArray = jMSServerRuntimeMBeanArray[j].getDestinations();
                    for (int k = 0; k < jMSDestinationRuntimeMBeanArray.length; ++k) {
                        if (!string2.equals(jMSDestinationRuntimeMBeanArray[k].getName())) continue;
                        jMSDestinationRuntimeMBean = jMSDestinationRuntimeMBeanArray[k];
                        continue block3;
                    }
                }
            }
            if (jMSDestinationRuntimeMBean == null) {
                throw new JMSException("JMS Destination runtime mbean not found");
            }
            return jMSDestinationRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSDestinationRuntimeMBean getJMSDestinationRuntimeMBean(Context context, Destination destination) throws JMSException {
        if (!(destination instanceof DestinationImpl)) {
            throw new JMSException("Unknown foreign destination");
        }
        DestinationImpl destinationImpl = (DestinationImpl)destination;
        try {
            JMSDestinationRuntimeMBean jMSDestinationRuntimeMBean = null;
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean[] serverRuntimeMBeanArray = domainRuntimeServiceMBean.getServerRuntimes();
            for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
                ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
                JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
                JMSServerRuntimeMBean[] jMSServerRuntimeMBeanArray = jMSRuntimeMBean.getJMSServers();
                block3: for (int j = 0; j < jMSServerRuntimeMBeanArray.length; ++j) {
                    JMSDestinationRuntimeMBean[] jMSDestinationRuntimeMBeanArray = jMSServerRuntimeMBeanArray[j].getDestinations();
                    for (int k = 0; k < jMSDestinationRuntimeMBeanArray.length; ++k) {
                        if (!destinationImpl.getName().equals(jMSDestinationRuntimeMBeanArray[k].getName())) continue;
                        jMSDestinationRuntimeMBean = jMSDestinationRuntimeMBeanArray[k];
                        continue block3;
                    }
                }
            }
            if (jMSDestinationRuntimeMBean == null) {
                throw new JMSException("JMS Destination runtime mbean not found");
            }
            return jMSDestinationRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public static JMSServerRuntimeMBean getJMSServerRuntimeMBean(Context context, String string) throws JMSException {
        try {
            JMSServerRuntimeMBean jMSServerRuntimeMBean = null;
            DomainRuntimeServiceMBean domainRuntimeServiceMBean = JMSEditHelper.getDomainRuntimeService(context);
            ServerRuntimeMBean[] serverRuntimeMBeanArray = domainRuntimeServiceMBean.getServerRuntimes();
            block2: for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
                ServerRuntimeMBean serverRuntimeMBean = serverRuntimeMBeanArray[i];
                JMSRuntimeMBean jMSRuntimeMBean = serverRuntimeMBean.getJMSRuntime();
                JMSServerRuntimeMBean[] jMSServerRuntimeMBeanArray = jMSRuntimeMBean.getJMSServers();
                for (int j = 0; j < jMSServerRuntimeMBeanArray.length; ++j) {
                    if (!string.equals(jMSServerRuntimeMBeanArray[j].getName())) continue;
                    jMSServerRuntimeMBean = jMSServerRuntimeMBeanArray[j];
                    continue block2;
                }
            }
            if (jMSServerRuntimeMBean == null) {
                throw new JMSException("JMS Server runtime mbean not found");
            }
            return jMSServerRuntimeMBean;
        }
        catch (Exception exception) {
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            JMSException jMSException = new JMSException(exception.toString());
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
    }

    public String oldJMSMessageIDToNew(String string, long l) throws JMSException {
        try {
            String string2 = string.substring(0, 4);
            long l2 = new Long(string.substring(4));
            int n = (int)(l2 >>> 32);
            int n2 = (int)(l2 - ((long)n << 32));
            return string2 + "<" + n + "." + l + "." + n2 + ">";
        }
        catch (Throwable throwable) {
            throw new JMSException("Invalid JMSMessageID, failed to convert it into 6.0 format");
        }
    }

    public String newJMSMessageIDToOld(String string) throws JMSException {
        try {
            String string2 = string.substring(0, 4);
            int n = string.indexOf(".", 5);
            int n2 = new Integer(string.substring(5, n));
            int n3 = string.indexOf(".", n + 1);
            n = string.indexOf(".", n3 + 1);
            int n4 = new Integer(string.substring(n3 + 1, n));
            long l = n2;
            l = (l << 32) + (long)n4;
            return string2 + l;
        }
        catch (Throwable throwable) {
            throw new JMSException("Invalid JMSMessageID, failed to convert it into pre-6.0 format");
        }
    }
}

