/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.extensions;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import weblogic.jms.JMSLogger;

public final class Schedule {
    private static final int MILLISECOND = 0;
    private static final int SECOND = 1;
    private static final int MINUTE = 2;
    private static final int HOUR_OF_DAY = 3;
    private static final int DAY_OF_MONTH = 4;
    private static final int MONTH = 5;
    private static final int DAY_OF_WEEK = 6;
    private static final int MILLIDIVISOR = 20;
    private static final String[] CALNAMES = new String[]{"ms", "sec", "min", "hr", "dom", "mth", "dow"};
    private static final int[] MINIMUMS = new int[]{0, 0, 0, 0, 1, 1, 1};
    private static final int[] MAXIMUMS = new int[]{49, 59, 59, 23, 31, 12, 7};
    private static final int[] CALCODES = new int[]{14, 13, 12, 11, 5, 2, 7};

    private static void handleParseError(char[] cArray, int[] nArray, String string) throws ParseException {
        String string2 = "";
        for (int i = nArray[0]; i > 0; --i) {
            string2 = string2 + ' ';
        }
        throw new ParseException("Parse error at or before position " + nArray[0] + " in scheduling string:\n   \"" + new String(cArray) + "\"\n    " + string2 + "^ " + string, nArray[0]);
    }

    private static int parseInt(char[] cArray, int[] nArray, int n, int n2, int n3) throws ParseException {
        char c;
        if (nArray[0] >= cArray.length) {
            Schedule.handleParseError(cArray, nArray, "Unexpected end of string. Expected '0'-'9', 'l', or 'last'.");
        }
        if ((c = cArray[nArray[0]]) == 'l' || c == 'L') {
            nArray[0] = nArray[0] + 1;
            if (!(nArray[0] == cArray.length || cArray[nArray[0]] != 'a' && cArray[nArray[0]] != 'A' || (nArray[0] = nArray[0] + 1) == cArray.length || cArray[nArray[0]] != 's' && cArray[nArray[0]] != 'S' || (nArray[0] = nArray[0] + 1) == cArray.length || cArray[nArray[0]] != 't' && cArray[nArray[0]] != 'T')) {
                nArray[0] = nArray[0] + 1;
            }
            return n2;
        }
        if (c < '0' || c > '9') {
            Schedule.handleParseError(cArray, nArray, "Expected '0'-'9', 'l', or 'last'.");
        }
        nArray[0] = nArray[0] + 1;
        int n4 = c - 48;
        while (nArray[0] != cArray.length && (c = cArray[nArray[0]]) >= '0' && c <= '9') {
            nArray[0] = nArray[0] + 1;
            n4 = n4 * 10 + (c - 48);
        }
        if (n3 == 1) {
            if (n4 < n || n4 > n2) {
                Schedule.handleParseError(cArray, nArray, "Value " + n4 + " out of range, expect " + n + " <= value <= " + n2);
            }
        } else {
            if (n4 < n || n4 >= (n2 + 1) * n3) {
                Schedule.handleParseError(cArray, nArray, "Value " + n4 + " out of range, expect " + n + " <= value <= " + ((n2 + 1) * n3 - 1));
            }
            n4 /= n3;
        }
        return n4;
    }

    private static long parseRange(char[] cArray, int[] nArray, int n, int n2, int n3) throws ParseException {
        char c;
        long l = 0L;
        if (nArray[0] >= cArray.length) {
            Schedule.handleParseError(cArray, nArray, "Unexpected end of string.");
        }
        if ((c = cArray[nArray[0]]) == '*') {
            nArray[0] = nArray[0] + 1;
            return -1L;
        }
        int n4 = Schedule.parseInt(cArray, nArray, n, n2, n3);
        l = 1L << n4;
        if (nArray[0] == cArray.length) {
            return l;
        }
        if (cArray[nArray[0]] == '-') {
            nArray[0] = nArray[0] + 1;
            int n5 = Schedule.parseInt(cArray, nArray, n, n2, n3);
            if (n5 < n4) {
                Schedule.handleParseError(cArray, nArray, "Start of range (" + n4 + ") is greater than end of range (" + n5 + ").");
            }
            while (++n4 <= n5) {
                l |= 1L << n4;
            }
        }
        if (nArray[0] == cArray.length) {
            return l;
        }
        if (cArray[nArray[0]] == ',') {
            nArray[0] = nArray[0] + 1;
            return l | Schedule.parseRange(cArray, nArray, n, n2, n3);
        }
        return l;
    }

    private static void skipWhiteSpace(char[] cArray, int[] nArray) {
        while (cArray.length != nArray[0] && (cArray[nArray[0]] == ' ' || cArray[nArray[0]] == '\t')) {
            nArray[0] = nArray[0] + 1;
        }
    }

    private static void parseCron(char[] cArray, int[] nArray, long[] lArray) throws ParseException {
        Schedule.skipWhiteSpace(cArray, nArray);
        for (int i = 0; i < MINIMUMS.length; ++i) {
            int n = i;
            lArray[n] = lArray[n] | Schedule.parseRange(cArray, nArray, MINIMUMS[i], MAXIMUMS[i], i == 0 ? 20 : 1);
            if (i >= MINIMUMS.length - 1) continue;
            if (cArray.length == nArray[0]) {
                Schedule.handleParseError(cArray, nArray, "Unexpected end of string.");
            }
            int n2 = nArray[0];
            Schedule.skipWhiteSpace(cArray, nArray);
            if (nArray[0] != n2) continue;
            Schedule.handleParseError(cArray, nArray, "Expected white space character (tab or space).");
        }
        Schedule.skipWhiteSpace(cArray, nArray);
    }

    private static long[][] parseCrons(String string) throws ParseException {
        Object object = new long[1][MINIMUMS.length];
        long[] lArray = object[0];
        int[] nArray = new int[1];
        if (string == null) {
            Schedule.handleParseError("<null>".toCharArray(), nArray, "Attempt to parse null string.");
        }
        char[] cArray = string.toCharArray();
        try {
            Schedule.parseCron(cArray, nArray, lArray);
            while (nArray[0] != cArray.length) {
                if (cArray[nArray[0]] != ';') {
                    Schedule.handleParseError(cArray, nArray, "Unexpected character '" + cArray[nArray[0]] + "', expected ';' or end of string.");
                }
                nArray[0] = nArray[0] + 1;
                long[][] lArrayArray = new long[((long[][])object).length + 1][];
                for (int i = 0; i < ((long[][])object).length; ++i) {
                    lArrayArray[i] = object[i];
                }
                long[] lArray2 = new long[MINIMUMS.length];
                lArrayArray[((long[][])object).length] = lArray2;
                lArray = lArray2;
                object = lArrayArray;
                Schedule.parseCron(cArray, nArray, lArray);
            }
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] != 0L) continue;
                throw new Throwable("Programming error.");
            }
            return object;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof ParseException)) {
                JMSLogger.logStackTrace((Throwable)throwable);
                Schedule.handleParseError(cArray, nArray, "Unhandled exception. " + throwable.toString());
            }
            throw (ParseException)throwable;
        }
    }

    private static int minimumBitPosition(long l, int n) {
        int n2 = n;
        while ((l & 1L << n2) == 0L) {
            ++n2;
        }
        return n2;
    }

    private static int firstMatchingBitPos(long l, int n, int n2, int n3) {
        while (n <= n3) {
            if ((l & 1L << n) != 0L) {
                return n;
            }
            ++n;
        }
        n = n2;
        while ((l & 1L << n) == 0L) {
            ++n;
        }
        return n;
    }

    private static int addThis(long l, int n, int n2, int n3) {
        int n4 = 0;
        while (n <= n3) {
            if ((l & 1L << n) != 0L) {
                return n4;
            }
            ++n4;
            ++n;
        }
        n = n2;
        while ((l & 1L << n) == 0L) {
            ++n4;
            ++n;
        }
        return n4;
    }

    private static void minimize(int n, Calendar calendar, long[] lArray) {
        if (n == 0) {
            return;
        }
        if (n == 6) {
            n = 4;
        }
        int n2 = Schedule.minimumBitPosition(lArray[0], MINIMUMS[0]);
        calendar.set(14, n2 * 20);
        for (int i = 1; i < n; ++i) {
            int n3;
            int n4 = Schedule.minimumBitPosition(lArray[i], MINIMUMS[i]);
            if (i == 5) {
                --n4;
            } else if (i == 4 && n4 > (n3 = calendar.getActualMaximum(5))) {
                n4 = n3;
            }
            calendar.set(CALCODES[i], n4);
        }
    }

    private static void scheduleField(int n, Calendar calendar, long[] lArray) {
        int n2;
        int n3 = calendar.get(CALCODES[n]);
        if (n == 5) {
            ++n3;
        }
        if (n == 0) {
            n2 = n3 % 20;
            if (n2 != 0) {
                calendar.add(CALCODES[n], 20 - n2);
                n3 = calendar.get(CALCODES[n]);
            }
            n3 /= 20;
        }
        if ((n2 = Schedule.addThis(lArray[n], n3, MINIMUMS[n], MAXIMUMS[n])) != 0) {
            if (n == 0) {
                n2 *= 20;
            }
            if (n == 5) {
                calendar.set(5, 1);
            }
            calendar.add(CALCODES[n], n2);
            Schedule.minimize(n, calendar, lArray);
        }
    }

    private static void nextScheduledTime(long[] lArray, Calendar calendar) {
        int n;
        int n2;
        int n3;
        calendar.setFirstDayOfWeek(1);
        calendar.add(CALCODES[0], 1);
        if (lArray[0] != -1L) {
            Schedule.scheduleField(0, calendar, lArray);
        }
        if (lArray[1] != -1L) {
            Schedule.scheduleField(1, calendar, lArray);
        }
        if (lArray[2] != -1L) {
            Schedule.scheduleField(2, calendar, lArray);
        }
        if (lArray[3] != -1L) {
            Schedule.scheduleField(3, calendar, lArray);
        }
        if (lArray[4] != -1L && (n3 = calendar.get(5)) != (n2 = Schedule.firstMatchingBitPos(lArray[4], n3, MINIMUMS[4], MAXIMUMS[4]))) {
            n = calendar.getActualMaximum(5);
            if (n2 > n) {
                n2 = n;
            } else if (n2 < n3) {
                calendar.set(5, 1);
                calendar.add(2, 1);
            }
            calendar.set(5, n2);
            Schedule.minimize(4, calendar, lArray);
        }
        if (lArray[5] != -1L) {
            Schedule.scheduleField(5, calendar, lArray);
        }
        if (lArray[6] != -1L) {
            Schedule.scheduleField(6, calendar, lArray);
            n3 = calendar.get(2) + 1;
            if ((lArray[5] & 1L << n3) == 0L) {
                Schedule.nextScheduledTime(lArray, calendar);
            } else {
                n2 = calendar.get(5);
                if ((lArray[4] & 1L << n2) == 0L) {
                    n = calendar.getActualMaximum(5);
                    int n4 = Schedule.firstMatchingBitPos(lArray[4], n2, MINIMUMS[4], MAXIMUMS[4]);
                    if (n4 < n || n2 != n) {
                        Schedule.nextScheduledTime(lArray, calendar);
                    }
                }
            }
        }
    }

    private static void nextScheduledTime(long[][] lArray, Calendar calendar) {
        Calendar calendar2 = null;
        if (lArray.length > 1) {
            calendar2 = (Calendar)calendar.clone();
        }
        Schedule.nextScheduledTime(lArray[0], calendar);
        for (int i = 1; i < lArray.length; ++i) {
            Calendar calendar3 = null;
            if (i + 1 < lArray.length) {
                calendar3 = (Calendar)calendar2.clone();
            }
            Schedule.nextScheduledTime(lArray[i], calendar2);
            if (calendar2.getTime().getTime() < calendar.getTime().getTime()) {
                calendar.setTime(calendar2.getTime());
            }
            calendar2 = calendar3;
        }
    }

    private static String longAsBitsReversed(long l) {
        int n = 64;
        String string = "";
        while (--n >= 0) {
            string = (l & 1L) != 0L ? string + '1' : string + '0';
            l >>>= 1;
        }
        return string;
    }

    private static String leftJustify5(String string) {
        while (string.length() < 5) {
            string = ' ' + string;
        }
        return string;
    }

    private static String leftJustify5(int n) {
        return Schedule.leftJustify5(n + "");
    }

    private static void printCalendar(Calendar calendar, boolean bl) {
        int n;
        String[] stringArray = new String[]{"yr", "dow", "mth", "dom", "hr", "mn", "sec", "ms"};
        int[] nArray = new int[]{1, 7, 2, 5, 11, 12, 13, 14};
        if (bl) {
            for (n = nArray.length - 1; n >= 0; --n) {
                System.out.print(Schedule.leftJustify5(stringArray[n]));
            }
            System.out.println();
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            System.out.print(Schedule.leftJustify5(calendar.get(nArray[n]) + (nArray[n] == 2 ? 1 : 0)));
        }
        System.out.println();
    }

    private static void printSchedule(long[][] lArray) {
        int n;
        int n2;
        System.out.print(Schedule.leftJustify5("") + " ");
        for (n2 = 0; n2 < 6; ++n2) {
            System.out.print("" + n2 + "         ");
        }
        System.out.println();
        System.out.print(Schedule.leftJustify5("") + " ");
        for (n2 = 0; n2 < 6; ++n2) {
            for (n = 0; n <= 9; ++n) {
                System.out.print(n);
            }
        }
        System.out.println();
        System.out.println();
        for (n2 = 0; n2 < lArray.length; ++n2) {
            if (n2 > 0) {
                System.out.println();
            }
            for (n = 0; n < lArray[n2].length; ++n) {
                System.out.print(Schedule.leftJustify5(CALNAMES[n]) + " ");
                System.out.println(Schedule.longAsBitsReversed(lArray[n2][n]));
            }
        }
    }

    private static void throwUsage() throws Exception {
        throw new Exception("\nUsage:  java weblogic.jms.extensions.Schedule \"schedule\" [msecs secs mins hrs day mnth yr]\nExample:  java weblogic.jms.extensions.Schedule \"* * * * * * 1\" 0 0 0 0 23 4 2001\n     (first Sunday after 23rd April 2001)");
    }

    private static void testEOM() throws ParseException {
        long[][] lArray = Schedule.parseCrons("* * * * 31 * *");
        for (int i = 0; i < 367; ++i) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(2001, 0, 1, 0, 0, 0);
            ((Calendar)gregorianCalendar).add(6, i);
            Schedule.printCalendar(gregorianCalendar, true);
            Schedule.nextScheduledTime(lArray, (Calendar)gregorianCalendar);
            Schedule.printCalendar(gregorianCalendar, false);
            System.out.println();
        }
    }

    public static void parseSchedule(String string) throws ParseException {
        Schedule.parseCrons(string);
    }

    public static Calendar nextScheduledTime(String string, Calendar calendar) throws ParseException {
        int n = calendar.getFirstDayOfWeek();
        Calendar calendar2 = (Calendar)calendar.clone();
        Schedule.nextScheduledTime(Schedule.parseCrons(string), calendar2);
        calendar2.setFirstDayOfWeek(n);
        return calendar2;
    }

    public static Calendar nextScheduledTime(String string) throws ParseException {
        return Schedule.nextScheduledTime(string, (Calendar)new GregorianCalendar());
    }

    public static long nextScheduledTimeInMillis(String string, long l) throws ParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(new Date(l));
        Schedule.nextScheduledTime(Schedule.parseCrons(string), (Calendar)gregorianCalendar);
        return gregorianCalendar.getTime().getTime();
    }

    public static long nextScheduledTimeInMillis(String string) throws ParseException {
        return Schedule.nextScheduledTimeInMillis(string, System.currentTimeMillis());
    }

    public static long nextScheduledTimeInMillisRelative(String string, long l) throws ParseException {
        return Schedule.nextScheduledTimeInMillis(string, l) - l;
    }

    public static long nextScheduledTimeInMillisRelative(String string) throws ParseException {
        return Schedule.nextScheduledTimeInMillisRelative(string, System.currentTimeMillis());
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            Schedule.throwUsage();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (stringArray.length > 1) {
            if (stringArray.length != 8) {
                Schedule.throwUsage();
            }
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            int n3 = Integer.parseInt(stringArray[3]);
            int n4 = Integer.parseInt(stringArray[4]);
            int n5 = Integer.parseInt(stringArray[5]);
            int n6 = Integer.parseInt(stringArray[6]) - 1;
            int n7 = Integer.parseInt(stringArray[7]);
            gregorianCalendar = new GregorianCalendar(n7, n6, n5, n4, n3, n2);
            gregorianCalendar.set(14, n);
        }
        gregorianCalendar.setFirstDayOfWeek(1);
        long[][] lArray = Schedule.parseCrons(stringArray[0]);
        Schedule.printSchedule(lArray);
        System.out.println();
        Schedule.printCalendar(gregorianCalendar, true);
        Schedule.nextScheduledTime(lArray, (Calendar)gregorianCalendar);
        Schedule.printCalendar(gregorianCalendar, false);
        System.out.println();
    }
}

