/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.foreign;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignJNDIObjectBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.PropertyBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.foreign.ForeignJNDIObjectImpl;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.utils.GenericBeanListener;

public class ForeignJMSImpl
implements JMSModuleManagedEntity {
    private ForeignServerBean foreignServerBean;
    private HashMap factoryImpls;
    private HashMap destinationImpls;
    private JMSService jmsService = JMSService.getJMSService();
    private String initialContextFactory;
    private String connectionURL;
    private transient PropertyBean[] jndiPropertyBeans;
    private boolean defaultTargetingEnabled;
    private transient GenericBeanListener foreignServerBeanListener;
    private static final HashMap foreignServerBeanSignatures = new HashMap();
    private static final HashMap foreignServerAdditionSignatures = new HashMap();
    private String name;

    public ForeignJMSImpl(ForeignServerBean foreignServerBean, String string) {
        this.foreignServerBean = foreignServerBean;
        this.name = JMSBeanHelper.getDecoratedName(string, this.foreignServerBean.getName());
    }

    private void validateJNDI() throws ModuleException {
        for (Object object : this.factoryImpls.values()) {
            ((ForeignJNDIObjectImpl)object).validateJNDI();
        }
        for (ForeignJNDIObjectImpl foreignJNDIObjectImpl : this.destinationImpls.values()) {
            foreignJNDIObjectImpl.validateJNDI();
        }
    }

    private void bind() throws JMSException {
        for (Object object : this.factoryImpls.values()) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("ForeignJMSImpl: Binding factory impl=" + object);
            }
            ((ForeignJNDIObjectImpl)object).bind(false);
        }
        for (ForeignJNDIObjectImpl foreignJNDIObjectImpl : this.destinationImpls.values()) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("ForeignJMSImpl: Binding destination impl=" + foreignJNDIObjectImpl);
            }
            foreignJNDIObjectImpl.bind(false);
        }
    }

    private void unbind() {
        for (Object object : this.factoryImpls.values()) {
            ((ForeignJNDIObjectImpl)object).unbind();
        }
        for (ForeignJNDIObjectImpl foreignJNDIObjectImpl : this.destinationImpls.values()) {
            foreignJNDIObjectImpl.unbind();
        }
    }

    private void prepareForeignJNDIObject(ForeignJNDIObjectImpl foreignJNDIObjectImpl, boolean bl) throws BeanUpdateRejectedException {
        try {
            foreignJNDIObjectImpl.bind(false);
        }
        catch (JMSException jMSException) {
            throw new BeanUpdateRejectedException(jMSException.getMessage(), (Throwable)((Object)jMSException));
        }
        if (bl) {
            this.factoryImpls.put(foreignJNDIObjectImpl.getName(), foreignJNDIObjectImpl);
        } else {
            this.destinationImpls.put(foreignJNDIObjectImpl.getName(), foreignJNDIObjectImpl);
        }
    }

    private void unprepareForeignJNDIObject(ForeignJNDIObjectBean foreignJNDIObjectBean, boolean bl) {
        ForeignJNDIObjectImpl foreignJNDIObjectImpl = bl ? (ForeignJNDIObjectImpl)this.factoryImpls.remove(foreignJNDIObjectBean.getName()) : (ForeignJNDIObjectImpl)this.destinationImpls.remove(foreignJNDIObjectBean.getName());
        if (foreignJNDIObjectImpl == null) {
            throw new AssertionError((Object)("ERROR: ForeignJNDIObject " + foreignJNDIObjectBean.getName() + " previously not in prepared state"));
        }
        foreignJNDIObjectImpl.unbind();
        foreignJNDIObjectImpl.close();
    }

    public void prepare() throws ModuleException {
        ForeignJNDIObjectImpl foreignJNDIObjectImpl;
        DescriptorBean descriptorBean = (DescriptorBean)this.foreignServerBean;
        this.foreignServerBeanListener = new GenericBeanListener(descriptorBean, this, foreignServerBeanSignatures, foreignServerAdditionSignatures, false);
        try {
            this.foreignServerBeanListener.initialize();
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException.getMessage(), managementException);
        }
        ForeignConnectionFactoryBean[] foreignConnectionFactoryBeanArray = this.foreignServerBean.getForeignConnectionFactories();
        this.factoryImpls = new HashMap();
        for (int i = 0; i < foreignConnectionFactoryBeanArray.length; ++i) {
            try {
                foreignJNDIObjectImpl = new ForeignJNDIObjectImpl(this.foreignServerBean, foreignConnectionFactoryBeanArray[i]);
            }
            catch (JMSException jMSException) {
                throw new ModuleException(jMSException.getMessage(), (Throwable)((Object)jMSException));
            }
            this.factoryImpls.put(foreignConnectionFactoryBeanArray[i].getName(), foreignJNDIObjectImpl);
        }
        ForeignDestinationBean[] foreignDestinationBeanArray = this.foreignServerBean.getForeignDestinations();
        this.destinationImpls = new HashMap();
        for (int i = 0; i < foreignDestinationBeanArray.length; ++i) {
            try {
                foreignJNDIObjectImpl = new ForeignJNDIObjectImpl(this.foreignServerBean, foreignDestinationBeanArray[i]);
            }
            catch (JMSException jMSException) {
                throw new ModuleException(jMSException.getMessage(), (Throwable)((Object)jMSException));
            }
            this.destinationImpls.put(foreignDestinationBeanArray[i].getName(), foreignJNDIObjectImpl);
        }
        this.validateJNDI();
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        this.foreignServerBean = jMSBean.lookupForeignServer(this.getEntityName());
        this.registerBeanUpdateListeners();
        try {
            this.bind();
            JMSLogger.logForeignJMSDeployed((String)this.foreignServerBean.getName());
        }
        catch (JMSException jMSException) {
            JMSLogger.logErrorBindForeignJMS((String)this.foreignServerBean.getName(), (Exception)((Object)jMSException));
            throw new ModuleException("ERROR: binding the Foreign JMS Server components", (Throwable)((Object)jMSException));
        }
    }

    public void deactivate() throws ModuleException {
        this.unregisterBeanUpdateListeners();
        if (this.jmsService.isActive()) {
            this.unbind();
        }
    }

    public void unprepare() throws ModuleException {
        Object object;
        Iterator iterator = this.factoryImpls.values().iterator();
        while (iterator.hasNext()) {
            object = (ForeignJNDIObjectImpl)iterator.next();
            ((ForeignJNDIObjectImpl)object).close();
            iterator.remove();
        }
        object = this.destinationImpls.values().iterator();
        while (object.hasNext()) {
            ForeignJNDIObjectImpl foreignJNDIObjectImpl = (ForeignJNDIObjectImpl)object.next();
            foreignJNDIObjectImpl.close();
            object.remove();
        }
    }

    public void remove() throws ModuleException {
    }

    public void destroy() throws ModuleException {
    }

    public String getEntityName() {
        return this.foreignServerBean.getName();
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) {
    }

    public void activateChangeOfTargets() {
    }

    public void rollbackChangeOfTargets() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        throw new AssertionError((Object)("Name setter only here to satisfy interface: " + string));
    }

    public String getNotes() {
        return this.foreignServerBean.getNotes();
    }

    public void setNotes(String string) {
        throw new AssertionError((Object)("Notes setter only here to satisfy interface: " + string));
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public void setInitialContextFactory(String string) {
        this.initialContextFactory = string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public PropertyBean[] getJNDIProperties() {
        return this.jndiPropertyBeans;
    }

    public void setJNDIProperties(PropertyBean[] propertyBeanArray) {
        this.jndiPropertyBeans = propertyBeanArray;
    }

    public boolean isDefaultTargetingEnabled() {
        return this.defaultTargetingEnabled;
    }

    public void setDefaultTargetingEnabled(boolean bl) {
        this.defaultTargetingEnabled = bl;
    }

    public PropertyBean createJNDIProperty(String string) {
        throw new AssertionError((Object)("JNDI property setter only here to satisfy interface: " + this.name));
    }

    public void destroyJNDIProperty(PropertyBean propertyBean) {
        throw new AssertionError((Object)("JNDI Property destructor only here to satisfy interface: " + this.name));
    }

    public String getSubDeploymentName() {
        return this.foreignServerBean.getSubDeploymentName();
    }

    public void setSubDeploymentName(String string) {
        throw new AssertionError((Object)("SubDeployment setter only here to satisfy interface: " + string));
    }

    public ForeignDestinationBean[] getForeignDestinations() {
        return this.foreignServerBean.getForeignDestinations();
    }

    public void setForeignDestinations(ForeignDestinationBean[] foreignDestinationBeanArray) {
        throw new AssertionError((Object)"Foreign Destination setter only here to satisfy interface");
    }

    public ForeignDestinationBean createForeignDestination(String string) {
        throw new AssertionError((Object)"Foreign Destination creator only here to satisfy interface");
    }

    public void destroyForeignDestination(ForeignDestinationBean foreignDestinationBean) {
        throw new AssertionError((Object)"Foreign Destination destroyer only here to satisfy interface");
    }

    public ForeignConnectionFactoryBean[] getForeignConnectionFactories() {
        return this.foreignServerBean.getForeignConnectionFactories();
    }

    public void setForeignConnectionFactories(ForeignConnectionFactoryBean[] foreignConnectionFactoryBeanArray) {
        throw new AssertionError((Object)"Foreign Connection Factory setter only here to satisfy interface");
    }

    public ForeignConnectionFactoryBean createForeignConnectionFactory(String string) {
        throw new AssertionError((Object)"Foreign Connection Factory creator only here to satisfy interface");
    }

    public void destroyForeignConnectionFactory(ForeignConnectionFactoryBean foreignConnectionFactoryBean) {
        throw new AssertionError((Object)"Foreign Connection Factory destroyer only here to satisfy interface");
    }

    private void registerBeanUpdateListeners() {
        if (this.foreignServerBeanListener != null) {
            this.foreignServerBeanListener.close();
            this.foreignServerBeanListener = null;
        }
        DescriptorBean descriptorBean = (DescriptorBean)this.foreignServerBean;
        this.foreignServerBeanListener = new GenericBeanListener(descriptorBean, (Object)this, (Map)foreignServerBeanSignatures, foreignServerAdditionSignatures);
    }

    private void unregisterBeanUpdateListeners() {
        if (this.foreignServerBeanListener != null) {
            this.foreignServerBeanListener.close();
            this.foreignServerBeanListener = null;
        }
    }

    public void startAddForeignDestinations(ForeignDestinationBean foreignDestinationBean) throws BeanUpdateRejectedException {
        ForeignJNDIObjectImpl foreignJNDIObjectImpl;
        try {
            foreignJNDIObjectImpl = new ForeignJNDIObjectImpl(this.foreignServerBean, foreignDestinationBean);
        }
        catch (JMSException jMSException) {
            throw new BeanUpdateRejectedException(jMSException.getMessage(), (Throwable)((Object)jMSException));
        }
        this.prepareForeignJNDIObject(foreignJNDIObjectImpl, false);
    }

    public void startAddForeignConnectionFactories(ForeignConnectionFactoryBean foreignConnectionFactoryBean) throws BeanUpdateRejectedException {
        ForeignJNDIObjectImpl foreignJNDIObjectImpl;
        try {
            foreignJNDIObjectImpl = new ForeignJNDIObjectImpl(this.foreignServerBean, foreignConnectionFactoryBean);
        }
        catch (JMSException jMSException) {
            throw new BeanUpdateRejectedException(jMSException.getMessage(), (Throwable)((Object)jMSException));
        }
        this.prepareForeignJNDIObject(foreignJNDIObjectImpl, true);
    }

    public void finishAddForeignDestinations(ForeignDestinationBean foreignDestinationBean, boolean bl) {
        if (!bl) {
            this.unprepareForeignJNDIObject((ForeignJNDIObjectBean)foreignDestinationBean, false);
        }
    }

    public void finishAddForeignConnectionFactories(ForeignConnectionFactoryBean foreignConnectionFactoryBean, boolean bl) {
        if (!bl) {
            this.unprepareForeignJNDIObject((ForeignJNDIObjectBean)foreignConnectionFactoryBean, true);
        }
    }

    public void startRemoveForeignDestinations(ForeignDestinationBean foreignDestinationBean) throws BeanUpdateRejectedException {
    }

    public void startRemoveForeignConnectionFactories(ForeignConnectionFactoryBean foreignConnectionFactoryBean) throws BeanUpdateRejectedException {
    }

    public void finishRemoveForeignDestinations(ForeignDestinationBean foreignDestinationBean, boolean bl) {
        if (bl) {
            this.unprepareForeignJNDIObject((ForeignJNDIObjectBean)foreignDestinationBean, false);
        }
    }

    public void finishRemoveForeignConnectionFactories(ForeignConnectionFactoryBean foreignConnectionFactoryBean, boolean bl) {
        if (bl) {
            this.unprepareForeignJNDIObject((ForeignJNDIObjectBean)foreignConnectionFactoryBean, true);
        }
    }

    public ForeignDestinationBean lookupForeignDestination(String string) {
        return null;
    }

    public ForeignConnectionFactoryBean lookupForeignConnectionFactory(String string) {
        return null;
    }

    static {
        foreignServerBeanSignatures.put("InitialContextFactory", String.class);
        foreignServerBeanSignatures.put("ConnectionURL", String.class);
        foreignServerBeanSignatures.put("JNDIProperties", PropertyBean[].class);
        foreignServerBeanSignatures.put("DefaultTargetingEnabled", Boolean.TYPE);
        foreignServerAdditionSignatures.put("ForeignDestinations", ForeignDestinationBean.class);
        foreignServerAdditionSignatures.put("ForeignConnectionFactories", ForeignConnectionFactoryBean.class);
    }
}

