/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.foreign;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.application.ModuleException;
import weblogic.deployment.jms.ForeignOpaqueReference;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignJNDIObjectBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.management.ManagementException;
import weblogic.management.utils.GenericBeanListener;

public class ForeignJNDIObjectImpl {
    private ForeignServerBean parent;
    private ForeignJNDIObjectBean foreignJNDIObjectBean;
    private boolean bound;
    private String localJNDIName;
    private String remoteJNDIName;
    private String username;
    private String password;
    private byte[] encryptedPassword;
    private boolean isDestination;
    private transient GenericBeanListener foreignJNDIObjectBeanListener;
    private static final HashMap foreignDestinationBeanSignatures = new HashMap();
    private static final HashMap foreignConnectionFactoryBeanSignatures = new HashMap();

    private ForeignJNDIObjectImpl(ForeignServerBean foreignServerBean, ForeignJNDIObjectBean foreignJNDIObjectBean, boolean bl, HashMap hashMap) throws JMSException {
        this.parent = foreignServerBean;
        this.foreignJNDIObjectBean = foreignJNDIObjectBean;
        this.isDestination = bl;
        DescriptorBean descriptorBean = (DescriptorBean)this.foreignJNDIObjectBean;
        this.foreignJNDIObjectBeanListener = new GenericBeanListener(descriptorBean, (Object)this, (Map)hashMap, false);
        try {
            this.foreignJNDIObjectBeanListener.initialize();
        }
        catch (ManagementException managementException) {
            throw new JMSException(managementException);
        }
    }

    public ForeignJNDIObjectImpl(ForeignServerBean foreignServerBean, ForeignDestinationBean foreignDestinationBean) throws JMSException {
        this(foreignServerBean, (ForeignJNDIObjectBean)foreignDestinationBean, true, foreignDestinationBeanSignatures);
    }

    public ForeignJNDIObjectImpl(ForeignServerBean foreignServerBean, ForeignConnectionFactoryBean foreignConnectionFactoryBean) throws JMSException {
        this(foreignServerBean, (ForeignJNDIObjectBean)foreignConnectionFactoryBean, false, foreignConnectionFactoryBeanSignatures);
    }

    public void close() {
        this.unregisterBeanUpdateListeners();
    }

    synchronized void bind(boolean bl) throws JMSException {
        this.registerBeanUpdateListeners();
        this.doBind(this.foreignJNDIObjectBean.getLocalJNDIName(), bl);
    }

    void validateJNDI() throws ModuleException {
        Object object;
        String string = this.foreignJNDIObjectBean.getLocalJNDIName();
        Context context = JMSService.getContext();
        try {
            object = context.lookup(string);
        }
        catch (NamingException namingException) {
            return;
        }
        throw new ModuleException("The foreign object of name \"" + this.foreignJNDIObjectBean.getName() + "\" cannot bind to JNDI name \"" + string + "\" because another object is already bound there of type " + (object == null ? "null" : object.getClass().getName()));
    }

    private void doBind(String string, boolean bl) throws JMSException {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            Object object = this.getJNDIReference();
            Context context = JMSService.getContext(false);
            if (bl) {
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("Replacing binding of MBean " + this.foreignJNDIObjectBean.getName() + " bound to JNDI name " + string);
                }
                context.rebind(string, object);
            } else {
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("Binding MBean " + this.foreignJNDIObjectBean.getName() + " to JNDI name " + string);
                }
                context.bind(string, object);
            }
            this.bound = true;
        }
        catch (NamingException namingException) {
            throw new JMSException(JMSExceptionLogger.logErrorInJNDIBindLoggable((String)string), (Throwable)namingException);
        }
    }

    synchronized void unbind() {
        this.unregisterBeanUpdateListeners();
        this.doUnbind(this.foreignJNDIObjectBean.getLocalJNDIName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnbind(String string) {
        if (!this.bound || string == null || string.length() == 0) {
            return;
        }
        try {
            Context context = JMSService.getContext(false);
            try {
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("Un-binding remote JMS object from " + string);
                }
                context.unbind(string);
                this.bound = false;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                context.close();
                throw throwable;
            }
            context.close();
            {
            }
        }
        catch (NamingException namingException) {
            JMSLogger.logErrorInJNDIUnbind((String)string, (String)namingException.toString());
        }
    }

    private Object getJNDIReference() {
        return new ForeignOpaqueReference(this.parent, this.foreignJNDIObjectBean);
    }

    public String getLocalJNDIName() {
        return this.localJNDIName;
    }

    public void setLocalJNDIName(String string) {
        this.localJNDIName = string;
    }

    public String getRemoteJNDIName() {
        return this.remoteJNDIName;
    }

    public void setRemoteJNDIName(String string) {
        this.remoteJNDIName = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public byte[] getPasswordEncrypted() {
        return this.encryptedPassword;
    }

    public void setPasswordEncrypted(byte[] byArray) {
        this.encryptedPassword = byArray;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getName() {
        return this.foreignJNDIObjectBean.getName();
    }

    public void setName(String string) {
        throw new AssertionError((Object)("Name setter only here to satisfy interface: " + string));
    }

    public String getNotes() {
        return this.foreignJNDIObjectBean.getNotes();
    }

    public void setNotes(String string) {
        throw new AssertionError((Object)("Notes setter only here to satisfy interface: " + string));
    }

    private void registerBeanUpdateListeners() {
        if (this.foreignJNDIObjectBeanListener != null) {
            this.foreignJNDIObjectBeanListener.open();
        } else {
            DescriptorBean descriptorBean = (DescriptorBean)this.foreignJNDIObjectBean;
            HashMap hashMap = this.isDestination ? foreignDestinationBeanSignatures : foreignConnectionFactoryBeanSignatures;
            this.foreignJNDIObjectBeanListener = new GenericBeanListener(descriptorBean, this, hashMap);
        }
    }

    private void unregisterBeanUpdateListeners() {
        if (this.foreignJNDIObjectBeanListener != null) {
            this.foreignJNDIObjectBeanListener.close();
            this.foreignJNDIObjectBeanListener = null;
        }
    }

    static {
        foreignDestinationBeanSignatures.put("LocalJNDIName", String.class);
        foreignDestinationBeanSignatures.put("RemoteJNDIName", String.class);
        foreignConnectionFactoryBeanSignatures.put("LocalJNDIName", String.class);
        foreignConnectionFactoryBeanSignatures.put("RemoteJNDIName", String.class);
        foreignConnectionFactoryBeanSignatures.put("Username", String.class);
        foreignConnectionFactoryBeanSignatures.put("Password", String.class);
        foreignConnectionFactoryBeanSignatures.put("PasswordEncrypted", byte[].class);
    }
}

