/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageProcessor;
import weblogic.jms.common.PasswordStore;
import weblogic.jms.extensions.JMSForwardHelper;
import weblogic.jms.extensions.WLConnection;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.forwarder.RuntimeHandler;
import weblogic.jms.forwarder.dd.DDLoadBalancerDelegate;
import weblogic.jms.forwarder.dd.internal.DDInfoImpl;
import weblogic.jms.forwarder.dd.internal.DDLoadBalancerDelegateImpl;
import weblogic.jms.forwarder.internal.SessionRuntimeContextImpl;
import weblogic.jndi.ClientEnvironmentFactory;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.Listener;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.util.DeliveryList;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.store.PersistentStoreException;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class Forwarder
implements TimerListener {
    private static final AbstractSubject kernelID = Forwarder.getKernelIdentity();
    private static final char[] key = new char[]{'S', 'a', 'F', ' ', 'I', 's', ' ', '5', 'U', 'n'};
    public static final int AT_MOST_ONCE = 1;
    public static final int EXACTLY_ONCE = 2;
    public static final int AT_LEAST_ONCE = 3;
    private static final String DEFAULT_CF = "weblogic.jms.ConnectionFactory";
    private static final int REDELIVERY_DELAY = 5000;
    private static final int REFRESH_MINIMUM = 1000;
    private final HashMap connectedForwarders = new HashMap();
    private final HashMap disconnectedForwarders = new HashMap();
    private Connection targetConn;
    private Session targetSession;
    private WLMessageProducer producer;
    private Timer timer;
    private ClientEnvironmentFactory environmentFactory;
    private Context remoteInitialCtx;
    private AbstractSubject subject;
    private String loginURL;
    private String username;
    private PasswordStore passwordStore = new PasswordStore(key);
    private Object passwordHandle;
    private int compressionThreshold = Integer.MAX_VALUE;
    private String lastMsgId;
    private long retryDelayBase = 2000L;
    private long retryDelayMaximum = 180000L;
    private double retryDelayMultiplier = 1.0;
    private long nextRetry;
    private int windowSize = 10;
    private boolean scheduled;
    private boolean poisoned;
    private final MessageProcessor processor;
    private boolean localServerContext;
    private final Object scheduleLock = new Object();
    private long windowInterval;
    private long refreshInterval = Long.MAX_VALUE;
    private long connectionStart;
    private boolean forceResolveDNS = false;
    private static final boolean enableServerAffinity;

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public Forwarder(boolean bl, MessageProcessor messageProcessor, ClientEnvironmentFactory clientEnvironmentFactory) {
        this.localServerContext = bl;
        this.processor = messageProcessor;
        this.environmentFactory = clientEnvironmentFactory;
        Long l = Long.getLong("weblogic.jms.saf.WindowInterval", 0L);
        this.windowInterval = l == null ? 0L : l;
        String string = System.getProperty("weblogic.jms.saf.RefreshInterval");
        if (string != null) {
            this.forceResolveDNS = true;
            this.refreshInterval = Long.parseLong(string);
            if (this.refreshInterval < 1000L) {
                this.refreshInterval = 1000L;
            }
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Forwarder windowInterval:" + this.windowInterval + " refreshInterval:" + this.refreshInterval);
        }
    }

    public void start() {
        this.scheduleReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.poisoned) {
                return;
            }
            this.poisoned = true;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.scheduled = false;
        }
        object = this;
        synchronized (object) {
            HashMap hashMap = new HashMap(this.connectedForwarders);
            for (Object object2 : this.connectedForwarders.values()) {
                ((Subforwarder)object2).close();
            }
            if (hashMap.size() > 0) {
                Object object2;
                object2 = this.disconnectedForwarders;
                synchronized (object2) {
                    this.disconnectedForwarders.putAll(hashMap);
                }
            }
            this.connectedForwarders.clear();
            if (this.targetConn != null) {
                this.pushSubject();
                try {
                    try {
                        this.targetConn.close();
                    }
                    catch (JMSException jMSException) {
                        Object var7_9 = null;
                        this.popSubject();
                    }
                    Object var7_8 = null;
                    this.popSubject();
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.popSubject();
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.scheduled || this.poisoned) {
                return;
            }
            this.scheduled = true;
            if (this.timer != null) {
                this.timer.cancel();
            }
            TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
            TimerManager timerManager = timerManagerFactory.getDefaultTimerManager();
            this.timer = timerManager.schedule((TimerListener)this, this.getNextRetry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReconnect() {
        Forwarder forwarder = this;
        synchronized (forwarder) {
            this.remoteInitialCtx = null;
            this.poisoned = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnect() {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.poisoned) {
                return false;
            }
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            if (this.remoteInitialCtx == null) {
                JMSDebug.JMSSAF.debug("Forwarder reconnect(): remoteInitialCtx= null");
            } else {
                try {
                    JMSDebug.JMSSAF.debug("Forwarder reconnect(): java.naming.provider.url " + this.remoteInitialCtx.getEnvironment().get("java.naming.provider.url"));
                }
                catch (Throwable throwable) {
                    JMSDebug.JMSSAF.debug("Forwarder reconnect(): java.naming.provider.url ", throwable);
                }
            }
        }
        object = this;
        synchronized (object) {
            HashMap hashMap;
            Throwable throwable = null;
            try {
                this.connectTarget();
            }
            catch (SecurityException securityException) {
                throwable = securityException;
            }
            catch (NamingException namingException) {
                throwable = namingException;
            }
            catch (JMSException jMSException) {
                throwable = jMSException;
            }
            catch (Exception exception) {
                throwable = exception;
            }
            if (throwable != null) {
                this.remoteInitialCtx = null;
                this.reportDisconnectedToAll((Exception)throwable);
                return true;
            }
            HashMap hashMap2 = this.disconnectedForwarders;
            synchronized (hashMap2) {
                hashMap = new HashMap(this.disconnectedForwarders);
                this.disconnectedForwarders.clear();
            }
            hashMap2 = hashMap;
            synchronized (hashMap2) {
                Object object2;
                Iterator iterator = hashMap.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (Subforwarder)iterator.next();
                    try {
                        ((Subforwarder)object2).connectLocalJMS();
                        iterator.remove();
                        this.connectedForwarders.put(((Subforwarder)object2).sourceQueue.getName(), object2);
                    }
                    catch (JMSException jMSException) {
                        if (!JMSDebug.JMSSAF.isDebugEnabled()) continue;
                        JMSDebug.JMSSAF.debug(" subforwarder to " + ((Subforwarder)object2).getTargetJNDI() + " failed to reconnect, due to " + (Object)((Object)jMSException));
                    }
                    catch (NamingException namingException) {
                        if (!JMSDebug.JMSSAF.isDebugEnabled()) continue;
                        JMSDebug.JMSSAF.debug(" subforwarder to " + ((Subforwarder)object2).getTargetJNDI() + " failed to reconnect, due to " + namingException);
                    }
                    catch (Exception exception) {
                        if (!JMSDebug.JMSSAF.isDebugEnabled()) continue;
                        JMSDebug.JMSSAF.debug(" subforwarder to " + ((Subforwarder)object2).getTargetJNDI() + " failed to reconnect, due to " + exception);
                    }
                }
                if (hashMap.size() > 0) {
                    object2 = this.disconnectedForwarders;
                    synchronized (object2) {
                        this.disconnectedForwarders.putAll(hashMap);
                    }
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        Object object = this.scheduleLock;
        synchronized (object) {
            this.timer = null;
        }
        boolean bl = this.reconnect();
        Object object2 = this.scheduleLock;
        synchronized (object2) {
            this.scheduled = false;
        }
        if (bl) {
            this.schedule();
        } else {
            this.resetRetry();
        }
    }

    public void addSubforwarder(PersistentStoreXA persistentStoreXA, WorkManager workManager, RuntimeHandler runtimeHandler, Queue queue, String string, int n) {
        this.addSubforwarder(persistentStoreXA, workManager, runtimeHandler, queue, string, n, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubforwarder(PersistentStoreXA persistentStoreXA, WorkManager workManager, RuntimeHandler runtimeHandler, Queue queue, String string, int n, int n2) {
        HashMap hashMap = this.disconnectedForwarders;
        synchronized (hashMap) {
            this.disconnectedForwarders.put(queue.getName(), new Subforwarder(persistentStoreXA, workManager, runtimeHandler, queue, string, n, n2));
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSubforwarder(Queue queue) {
        Subforwarder subforwarder = (Subforwarder)this.connectedForwarders.remove(queue.getName());
        if (subforwarder != null) {
            subforwarder.close();
        }
        HashMap hashMap = this.disconnectedForwarders;
        synchronized (hashMap) {
            this.disconnectedForwarders.remove(queue.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportDisconnectedToAll(Exception exception) {
        HashMap hashMap = this.disconnectedForwarders;
        synchronized (hashMap) {
            Iterator iterator = this.disconnectedForwarders.values().iterator();
            while (iterator.hasNext()) {
                ((Subforwarder)iterator.next()).reportDisconnected(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getInitialContext() throws NamingException {
        Object object;
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            object = this.loginURL == null ? "LOCAL" : this.loginURL;
            JMSDebug.JMSSAF.debug("Retry for '" + (String)object + (this.lastMsgId != null ? "' on behalf of '" + this.lastMsgId + "'" : "'") + " to '" + this.loginURL + "'");
        }
        object = this.environmentFactory.getNewEnvironment();
        if (this.loginURL != null) {
            object.setProviderURL(this.loginURL);
        }
        object.setSecurityPrincipal(this.username);
        String string = this.getPassword();
        object.setSecurityCredentials(string);
        object.setEnableServerAffinity(enableServerAffinity);
        if (this.forceResolveDNS) {
            System.setProperty("weblogic.jndi.forceResolveDNSName", "true");
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Forwarder::getInitialContext()::Password=XXXX,username=" + this.username + " forceResolveDNS " + this.forceResolveDNS);
        }
        Context context = object.getContext();
        Forwarder forwarder = this;
        synchronized (forwarder) {
            this.subject = object.getSubject();
        }
        this.popSubject();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectTarget() throws SecurityException, JMSException, NamingException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Forwarder connectTarget()");
        }
        if (this.remoteInitialCtx == null) {
            this.remoteInitialCtx = this.getInitialContext();
        }
        this.refreshDDLoadBalanceDelegate(this.targetConn, this.targetSession);
        this.pushSubject();
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)this.remoteInitialCtx.lookup(DEFAULT_CF);
            this.targetConn = connectionFactory.createConnection();
            ((WLConnection)this.targetConn).setReconnectPolicy(JMSConstants.RECONNECT_POLICY_NONE);
            this.targetSession = this.targetConn.createSession(true, 2);
            this.producer = (WLMessageProducer)this.targetSession.createProducer(null);
            this.producer.setCompressionThreshold(this.compressionThreshold);
            this.targetConn.start();
            this.refreshDDLoadBalanceDelegate(this.targetConn, this.targetSession);
            this.connectionStart = System.currentTimeMillis();
            Object var3_2 = null;
            this.popSubject();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.popSubject();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompressionThreshold(int n) {
        this.compressionThreshold = n;
        this.pushSubject();
        try {
            block4: {
                try {
                    if (this.producer == null) break block4;
                    this.producer.setCompressionThreshold(n);
                }
                catch (JMSException jMSException) {
                    Object var4_3 = null;
                    this.popSubject();
                }
            }
            Object var4_2 = null;
            this.popSubject();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.popSubject();
            throw throwable;
        }
    }

    private synchronized void refreshDDLoadBalanceDelegate(Connection connection, Session session) {
        for (Subforwarder subforwarder : this.connectedForwarders.values()) {
            subforwarder.refreshDDLoadBalanceDelegate(this.remoteInitialCtx, connection, session, this.subject);
        }
        for (Subforwarder subforwarder : this.disconnectedForwarders.values()) {
            subforwarder.refreshDDLoadBalanceDelegate(this.remoteInitialCtx, connection, session, this.subject);
        }
    }

    private synchronized void pushSubject() {
        if (this.subject != null) {
            SubjectManager.getSubjectManager().pushSubject(kernelID, this.subject);
        }
    }

    private synchronized void popSubject() {
        if (this.subject != null) {
            SubjectManager.getSubjectManager().popSubject(kernelID);
        }
    }

    public void setLoginURL(String string) {
        this.loginURL = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        if (this.passwordHandle != null) {
            this.passwordStore.removePassword(this.passwordHandle);
            this.passwordHandle = null;
        }
        try {
            this.passwordHandle = this.passwordStore.storePassword(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError((Object)generalSecurityException);
        }
    }

    private String getPassword() throws NamingException {
        String string = null;
        if (this.passwordHandle != null) {
            try {
                string = (String)this.passwordStore.retrievePassword(this.passwordHandle);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new NamingException(generalSecurityException.getMessage());
            }
            catch (IOException iOException) {
                throw new NamingException(iOException.getMessage());
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetryDelayBase(long l) {
        Object object = this.scheduleLock;
        synchronized (object) {
            this.retryDelayBase = l;
            this.resetRetry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetryDelayMaximum(long l) {
        Object object = this.scheduleLock;
        synchronized (object) {
            this.retryDelayMaximum = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetryDelayMultiplier(double d) {
        Object object = this.scheduleLock;
        synchronized (object) {
            this.retryDelayMultiplier = d;
        }
    }

    public void setWindowSize(int n) {
        this.windowSize = n;
    }

    public void setWindowInterval(long l) {
        this.windowInterval = l;
    }

    private long getNextRetry() {
        if (this.nextRetry == 0L) {
            this.nextRetry = this.retryDelayBase;
        }
        long l = this.nextRetry;
        this.nextRetry = (long)((double)this.nextRetry * this.retryDelayMultiplier);
        if (this.nextRetry > this.retryDelayMaximum) {
            this.nextRetry = this.retryDelayMaximum;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRetry() {
        Object object = this.scheduleLock;
        synchronized (object) {
            this.nextRetry = this.retryDelayBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantRetry() {
        Object object = this.scheduleLock;
        synchronized (object) {
            this.nextRetry = 1L;
        }
    }

    static {
        String string = System.getProperty("weblogic.jms.saf.enableServerAffinity", "false");
        enableServerAffinity = string.equals("true");
    }

    private final class Subforwarder
    extends DeliveryList
    implements Listener {
        private static final int MAX_FAILURES = 100;
        private final PersistentStoreXA persistentStore;
        private final RuntimeHandler remoteEndpointRuntime;
        private final Queue sourceQueue;
        private final String targetJNDI;
        private Destination target;
        private ListenRequest listenRequest;
        private int nonPersistentQos = 1;
        private int persistentQos = 2;
        private boolean isTargetDD;
        private AtomicInteger failureCount = new AtomicInteger();
        private DDExactlyOnceForwardHelper ddExactlyOnceForwardHelper;

        Subforwarder(PersistentStoreXA persistentStoreXA, WorkManager workManager, RuntimeHandler runtimeHandler, Queue queue, String string, int n, int n2) {
            this.setWorkManager(workManager);
            this.persistentStore = persistentStoreXA;
            this.remoteEndpointRuntime = runtimeHandler;
            this.sourceQueue = queue;
            this.targetJNDI = string;
            this.nonPersistentQos = n;
            this.persistentQos = n2;
        }

        private void connectLocalJMS() throws JMSException, NamingException {
            try {
                this.target = this.lookupTargetDestination();
                this.verifyTargetSupportsSAF(this.target);
            }
            catch (JMSException jMSException) {
                this.reportDisconnected((Exception)((Object)jMSException));
                throw jMSException;
            }
            catch (NamingException namingException) {
                this.reportDisconnected(namingException);
                throw namingException;
            }
            catch (Exception exception) {
                this.reportDisconnected(exception);
                throw new JMSException(exception.toString());
            }
            try {
                int n = Forwarder.this.windowSize;
                if (this.isTargetDD) {
                    n = 1;
                }
                if (this.listenRequest != null) {
                    this.listenRequest.incrementCount(n);
                } else {
                    this.listenRequest = this.sourceQueue.listen(null, n, false, (Object)this, (Listener)this, null, WorkManagerFactory.getInstance().getSystem());
                }
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
            this.reportConnected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Destination lookupTargetDestination() throws NamingException, JMSException {
            Destination destination;
            Forwarder.this.pushSubject();
            try {
                Destination destination2 = (Destination)Forwarder.this.remoteInitialCtx.lookup(this.targetJNDI);
                this.isTargetDD = destination2 instanceof DistributedDestinationImpl;
                if (this.isTargetDD) {
                    if (this.ddExactlyOnceForwardHelper != null) {
                        this.closeDDLoadBalancerDelegate();
                    }
                    this.ddExactlyOnceForwardHelper = new DDExactlyOnceForwardHelper((DistributedDestinationImpl)destination2);
                }
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug(this + " ddExactlyOnceForwardHelper= " + this.ddExactlyOnceForwardHelper + " target " + destination2 + " targetJNDI " + this.targetJNDI);
                }
                destination = destination2;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Forwarder.this.popSubject();
                throw throwable;
            }
            Forwarder.this.popSubject();
            return destination;
        }

        private void verifyTargetSupportsSAF(Destination destination) throws JMSException {
            String[] stringArray;
            if (destination instanceof DestinationImpl && ((stringArray = ((DestinationImpl)destination).getSafAllowedArray()) == null || stringArray[0] == null || stringArray[0].equals("All"))) {
                return;
            }
            throw new JMSException("Endpoint '" + this.targetJNDI + "' does not allow Store-and-forwardInternal operation");
        }

        protected List getPendingMessages() {
            if (Forwarder.this.windowInterval <= 0L) {
                return super.getPendingMessages();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            long l = System.currentTimeMillis();
            do {
                Object object;
                if ((object = this.deliveryQueue.poll()) == null) {
                    long l2 = Forwarder.this.windowInterval - (System.currentTimeMillis() - l);
                    if (l2 <= 0L) break;
                    try {
                        object = this.deliveryQueue.poll(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (object == null) continue;
                arrayList.add(object);
                ++n;
            } while (n < Forwarder.this.windowSize);
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pushMessages(List list) {
            long l = System.currentTimeMillis();
            long l2 = 0L;
            try {
                if (this.nonPersistentQos == 1) {
                    if (this.persistentQos == 1) {
                        this.ackMessages(this.filterNonUOO(list));
                    } else {
                        this.ackMessages(this.filterNonPersistentAndNoUOO(list));
                    }
                } else if (this.persistentQos == 1) {
                    this.ackMessages(this.filterPersistentAndNoUOO(list));
                }
            }
            catch (KernelException kernelException) {
                Forwarder.this.schedule();
                return;
            }
            Forwarder forwarder = Forwarder.this;
            synchronized (forwarder) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ++l2;
                    MessageElement messageElement = (MessageElement)iterator.next();
                    MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                    boolean bl = this.isTargetDD && messageImpl.getUnitOfOrder() == null && (messageImpl.getJMSDeliveryMode() == 2 && this.persistentQos == 2 || messageImpl.getJMSDeliveryMode() == 1 && this.nonPersistentQos == 2);
                    Sequence sequence = messageElement.getSequence();
                    if (sequence != null) {
                        this.decorateMessageWithSequence(messageElement, messageImpl);
                    }
                    Forwarder.this.processor.process(messageImpl);
                    this.setLastMessageIdPushed(messageImpl);
                    boolean bl2 = !iterator.hasNext();
                    boolean bl3 = this.forward(messageImpl, bl, bl2, list);
                    if (!bl3) continue;
                    return;
                }
            }
            try {
                if (this.nonPersistentQos == 1) {
                    if (this.persistentQos == 1) {
                        this.ackMessages(this.filterUOO(list));
                    } else {
                        this.ackMessages(this.filterPersistentOrUOO(list));
                    }
                } else if (this.persistentQos == 1) {
                    this.ackMessages(this.filterNonPersistentOrUOO(list));
                } else {
                    this.ackMessages(list);
                }
            }
            catch (KernelException kernelException) {
                Forwarder.this.schedule();
                return;
            }
            if (l - Forwarder.this.connectionStart > Forwarder.this.refreshInterval) {
                this.disconnectForwarder(new Exception("SAF refresh interval elapsed"));
                Forwarder.this.instantRetry();
                Forwarder.this.scheduleReconnect();
            }
            try {
                forwarder = Forwarder.this;
                synchronized (forwarder) {
                    if (this.listenRequest != null) {
                        this.listenRequest.incrementCount(list.size());
                    }
                }
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + " incrementCount " + list.size());
            }
        }

        String getTargetJNDI() {
            return this.targetJNDI;
        }

        private void decorateMessageWithSequence(MessageElement messageElement, MessageImpl messageImpl) {
            messageImpl.setSAFSeqNumber(messageElement.getSequenceNum());
            messageImpl.setSAFSequenceName(messageElement.getSequence().getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean forward(MessageImpl messageImpl, boolean bl, boolean bl2, List list) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug("Forwarder is trying to forward the message " + messageImpl.getId() + "ddExactlyOnceForwardHelper= " + this.ddExactlyOnceForwardHelper);
            }
            boolean bl3 = true;
            boolean bl4 = true;
            try {
                Destination destination = null;
                Object object = bl ? this.ddExactlyOnceForwardHelper.getDDLoabBalancerDelegate() : Forwarder.this;
                synchronized (object) {
                    try {
                        destination = this.getEndpoint(messageImpl, bl);
                        if (JMSDebug.JMSSAF.isDebugEnabled()) {
                            JMSDebug.JMSSAF.debug("Forwarder is trying to forward the message with id " + messageImpl.getId() + " to " + destination);
                        }
                        this.forwardInternal(messageImpl, destination, bl2);
                        bl3 = false;
                        bl4 = false;
                        this.failureCount.set(0);
                    }
                    catch (JMSException jMSException) {
                        bl3 = this.handleForwardFailure(messageImpl, destination, bl, list, (Exception)((Object)jMSException));
                    }
                    catch (EndpointNotAvailableException endpointNotAvailableException) {
                        this.handleForwardFailure(messageImpl, destination, bl, list, endpointNotAvailableException);
                    }
                    catch (AssertionError assertionError) {
                        bl3 = false;
                        throw assertionError;
                    }
                }
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("needsSchedule= " + bl3 + " isExactlyOnceDDForwarding " + bl);
                }
                if (bl3) {
                    if (bl) {
                        this.closeDDLoadBalancerDelegate();
                    }
                    Forwarder.this.schedule();
                }
                throw throwable;
            }
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug("needsSchedule= " + bl3 + " isExactlyOnceDDForwarding " + bl);
            }
            if (bl3) {
                if (bl) {
                    this.closeDDLoadBalancerDelegate();
                }
                Forwarder.this.schedule();
            }
            return bl4;
        }

        private List filterNonPersistentAndNoUOO(List list) {
            LinkedList<MessageElement> linkedList = new LinkedList<MessageElement>();
            for (MessageElement messageElement : list) {
                MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                if (messageImpl.getJMSDeliveryMode() != 1 || messageImpl.getUnitOfOrder() != null) continue;
                linkedList.add(messageElement);
            }
            return linkedList;
        }

        private List filterPersistentAndNoUOO(List list) {
            LinkedList<MessageElement> linkedList = new LinkedList<MessageElement>();
            for (MessageElement messageElement : list) {
                MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                if (messageImpl.getJMSDeliveryMode() != 2 || messageImpl.getUnitOfOrder() != null) continue;
                linkedList.add(messageElement);
            }
            return linkedList;
        }

        private List filterPersistentOrUOO(List list) {
            LinkedList<MessageElement> linkedList = new LinkedList<MessageElement>();
            for (MessageElement messageElement : list) {
                MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                if (messageImpl.getJMSDeliveryMode() != 2 && messageImpl.getUnitOfOrder() == null) continue;
                linkedList.add(messageElement);
            }
            return linkedList;
        }

        private List filterNonPersistentOrUOO(List list) {
            LinkedList<MessageElement> linkedList = new LinkedList<MessageElement>();
            for (MessageElement messageElement : list) {
                MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                if (messageImpl.getJMSDeliveryMode() != 1 && messageImpl.getUnitOfOrder() == null) continue;
                linkedList.add(messageElement);
            }
            return linkedList;
        }

        private List filterNonUOO(List list) {
            LinkedList<MessageElement> linkedList = new LinkedList<MessageElement>();
            for (MessageElement messageElement : list) {
                MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                if (messageImpl.getUnitOfOrder() != null) continue;
                linkedList.add(messageElement);
            }
            return linkedList;
        }

        private List filterUOO(List list) {
            LinkedList<MessageElement> linkedList = new LinkedList<MessageElement>();
            for (MessageElement messageElement : list) {
                MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                if (messageImpl.getUnitOfOrder() == null) continue;
                linkedList.add(messageElement);
            }
            return linkedList;
        }

        private void ackMessages(List list) throws KernelException {
            try {
                KernelRequest kernelRequest = this.sourceQueue.acknowledge(list);
                if (kernelRequest != null) {
                    kernelRequest.getResult();
                }
                if (this.isTargetDD && this.ddExactlyOnceForwardHelper != null) {
                    this.ddExactlyOnceForwardHelper.unfreezeDDLBTable();
                }
            }
            catch (KernelException kernelException) {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Acknowledge failed " + list.size());
                }
                throw kernelException;
            }
        }

        private void nakMessages(List list, int n) {
            try {
                KernelRequest kernelRequest = new KernelRequest();
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Negatively acknowledging " + list.size() + " messages with delay " + n);
                }
                this.sourceQueue.negativeAcknowledge(list, (long)n, kernelRequest);
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }

        private void setLastMessageIdPushed(Message message) {
            try {
                Forwarder.this.lastMsgId = message.getJMSMessageID();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forwardInternal(MessageImpl messageImpl, Destination destination, boolean bl) throws JMSException {
            messageImpl.setForward(true);
            messageImpl.setJMSXUserID(null);
            messageImpl.requestJMSXUserID(false);
            Forwarder.this.pushSubject();
            try {
                JMSForwardHelper.ForwardFromMessage(Forwarder.this.producer, destination, messageImpl, true);
                if (bl) {
                    Forwarder.this.targetSession.commit();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Forwarder.this.popSubject();
                throw throwable;
            }
            Forwarder.this.popSubject();
        }

        private void closeDDLoadBalancerDelegate() {
            this.ddExactlyOnceForwardHelper.close();
        }

        private void refreshDDLoadBalanceDelegate(Context context, Connection connection, Session session, AbstractSubject abstractSubject) {
            if (this.ddExactlyOnceForwardHelper != null) {
                this.ddExactlyOnceForwardHelper.refreshDDLoadBalanceDelegate(context, connection, session, abstractSubject);
            }
        }

        private boolean hasNonFailedDDMembers() {
            if (this.ddExactlyOnceForwardHelper != null) {
                return this.ddExactlyOnceForwardHelper.hasNonFailedDDMembers();
            }
            return false;
        }

        private boolean handleForwardFailure(MessageImpl messageImpl, Destination destination, boolean bl, List list, Exception exception) {
            boolean bl2;
            block28: {
                boolean bl3 = bl2 = this.shouldPipelineBeStopped(bl) || this.failureCount.intValue() >= 100;
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Forwarder failed to forward the message " + messageImpl + " to " + destination + " stopPipeline= " + bl2 + " hasNonFailedDDMembers " + this.hasNonFailedDDMembers() + " isExactlyOnceDDForwarding " + bl + " failureCount " + this.failureCount.intValue() + " \n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)exception));
                }
                if (bl2 && this.listenRequest != null) {
                    this.listenRequest.stopAndWait();
                    this.failureCount.set(0);
                }
                if (this.nonPersistentQos == 1) {
                    list = this.persistentQos == 1 ? this.filterUOO(list) : this.filterPersistentOrUOO(list);
                } else if (this.persistentQos == 1) {
                    list = this.filterNonPersistentOrUOO(list);
                }
                list.addAll(super.getPendingMessages());
                if (bl) {
                    this.nakMessages(list, 5000);
                    if (destination == null && !bl2) {
                        this.failureCount.incrementAndGet();
                    }
                } else if (this.isTargetDD && messageImpl.getUnitOfOrder() != null && this.hasNonFailedDDMembers()) {
                    this.nakMessages(list, 5000);
                    this.failureCount.incrementAndGet();
                } else {
                    this.nakMessages(list, 0);
                }
                this.rollbackSession();
                if (bl2) {
                    this.disconnectForwarder(exception);
                }
                try {
                    if (destination != null && bl) {
                        this.addFailedEndpoint(messageImpl, (DestinationImpl)destination);
                    }
                }
                catch (PersistentStoreException persistentStoreException) {
                    if (JMSDebug.JMSSAF.isDebugEnabled()) {
                        JMSDebug.JMSSAF.debug("addFailedEndpoint() failed \n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)persistentStoreException));
                    }
                    throw new AssertionError((Object)persistentStoreException);
                }
                try {
                    if (!bl2 && this.listenRequest != null) {
                        this.listenRequest.incrementCount(1);
                    }
                    if (!bl || bl2) break block28;
                    Throwable throwable = null;
                    try {
                        try {
                            ((SessionInternal)Forwarder.this.targetSession).checkSAFClosed();
                        }
                        catch (JMSException jMSException) {
                            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                                JMSDebug.JMSSAF.debug("checkSAFClosed got JMSException:\n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)jMSException));
                            }
                            Forwarder.this.connectTarget();
                        }
                    }
                    catch (SecurityException securityException) {
                        throwable = securityException;
                    }
                    catch (JMSException jMSException) {
                        throwable = jMSException;
                    }
                    catch (NamingException namingException) {
                        throwable = namingException;
                    }
                    catch (Exception exception2) {
                        throwable = exception2;
                    }
                    if (throwable != null) {
                        if (JMSDebug.JMSSAF.isDebugEnabled()) {
                            JMSDebug.JMSSAF.debug("reconnectTarget got Exception: \n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)throwable));
                        }
                        bl2 = true;
                    }
                }
                catch (KernelException kernelException) {
                    if (!JMSDebug.JMSSAF.isDebugEnabled()) break block28;
                    JMSDebug.JMSSAF.debug("handleForwardFailure() got KernelException: \n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)kernelException));
                }
            }
            return bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnectForwarder(Exception exception) {
            this.remoteEndpointRuntime.disconnected(exception);
            this.close();
            Subforwarder subforwarder = (Subforwarder)Forwarder.this.connectedForwarders.remove(this.sourceQueue.getName());
            HashMap hashMap = Forwarder.this.disconnectedForwarders;
            synchronized (hashMap) {
                if (subforwarder != null) {
                    Forwarder.this.disconnectedForwarders.put(this.sourceQueue.getName(), subforwarder);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void rollbackSession() {
            Forwarder.this.pushSubject();
            try {
                try {
                    Forwarder.this.targetSession.rollback();
                }
                catch (JMSException jMSException) {
                    Object var3_2 = null;
                    Forwarder.this.popSubject();
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Forwarder.this.popSubject();
                throw throwable;
            }
            Forwarder.this.popSubject();
        }

        private boolean shouldPipelineBeStopped(boolean bl) {
            return !bl || !this.isTargetDD || !this.hasNonFailedDDMembers();
        }

        private Destination getEndpoint(MessageImpl messageImpl, boolean bl) throws EndpointNotAvailableException {
            Destination destination = null;
            destination = bl ? this.ddExactlyOnceForwardHelper.getEndpoint(messageImpl) : this.target;
            if (destination == null) {
                throw new EndpointNotAvailableException();
            }
            return destination;
        }

        private void addFailedEndpoint(MessageImpl messageImpl, DestinationImpl destinationImpl) throws PersistentStoreException {
            this.ddExactlyOnceForwardHelper.addFailedEndpoint(messageImpl, destinationImpl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            Object object = Forwarder.this;
            synchronized (object) {
                if (this.listenRequest != null) {
                    this.listenRequest.stopAndWait();
                }
                this.listenRequest = null;
            }
            if (this.ddExactlyOnceForwardHelper != null) {
                this.closeDDLoadBalancerDelegate();
            }
            object = new LinkedList();
            object.addAll(super.getPendingMessages());
            if (object.size() == 0) {
                return;
            }
            KernelRequest kernelRequest = new KernelRequest();
            try {
                this.sourceQueue.negativeAcknowledge((List)object, 0L, false, kernelRequest);
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }

        private void reportConnected() {
            this.remoteEndpointRuntime.connected();
        }

        private void reportDisconnected(Exception exception) {
            this.remoteEndpointRuntime.disconnected(exception);
        }

        public String toString() {
            return "[Subforward: targetJNDI = " + this.targetJNDI + "]";
        }

        private class EndpointNotAvailableException
        extends Exception {
            static final long serialVersionUID = -1747190651859301179L;

            private EndpointNotAvailableException() {
            }
        }

        private class DDExactlyOnceForwardHelper {
            private DDLoadBalancerDelegate ddLoadBalancerDelegate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            DDExactlyOnceForwardHelper(DistributedDestinationImpl distributedDestinationImpl) throws JMSException {
                DDInfoImpl dDInfoImpl = new DDInfoImpl(distributedDestinationImpl.getDDJNDIName(), distributedDestinationImpl.getName(), distributedDestinationImpl.getDestinationInstanceType(), distributedDestinationImpl.getApplicationName(), distributedDestinationImpl.getModuleName(), distributedDestinationImpl.getLoadBalancingPolicy(), distributedDestinationImpl.getMessageForwardingPolicy());
                SessionRuntimeContextImpl sessionRuntimeContextImpl = null;
                Forwarder forwarder = Forwarder.this;
                synchronized (forwarder) {
                    if (Forwarder.this.forceResolveDNS) {
                        String string = null;
                        try {
                            string = Forwarder.this.getPassword();
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        sessionRuntimeContextImpl = new SessionRuntimeContextImpl(Subforwarder.this.sourceQueue.getName(), Forwarder.this.remoteInitialCtx, Forwarder.this.loginURL, Forwarder.this.targetConn, Forwarder.this.targetSession, Forwarder.this.localServerContext, Forwarder.this.subject, Forwarder.this.username, string, Forwarder.this.forceResolveDNS);
                    } else {
                        sessionRuntimeContextImpl = new SessionRuntimeContextImpl(Subforwarder.this.sourceQueue.getName(), Forwarder.this.remoteInitialCtx, Forwarder.this.loginURL, Forwarder.this.targetConn, Forwarder.this.targetSession, Forwarder.this.localServerContext, Forwarder.this.subject);
                    }
                }
                this.ddLoadBalancerDelegate = new DDLoadBalancerDelegateImpl(sessionRuntimeContextImpl, dDInfoImpl, Subforwarder.this.persistentStore);
            }

            Object getDDLoabBalancerDelegate() {
                return this.ddLoadBalancerDelegate;
            }

            void unfreezeDDLBTable() {
                this.ddLoadBalancerDelegate.unfreezeDDLBTable();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Destination getEndpoint(MessageImpl messageImpl) {
                DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
                synchronized (dDLoadBalancerDelegate) {
                    return this.ddLoadBalancerDelegate.loadBalance(messageImpl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void addFailedEndpoint(MessageImpl messageImpl, DestinationImpl destinationImpl) throws PersistentStoreException {
                DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
                synchronized (dDLoadBalancerDelegate) {
                    this.ddLoadBalancerDelegate.addFailedEndPoint(messageImpl, destinationImpl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void close() {
                DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
                synchronized (dDLoadBalancerDelegate) {
                    this.ddLoadBalancerDelegate.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean hasNonFailedDDMembers() {
                DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
                synchronized (dDLoadBalancerDelegate) {
                    return this.ddLoadBalancerDelegate.hasNonFailedDDMembers();
                }
            }

            void refreshDDLoadBalanceDelegate(Context context, Connection connection, Session session, AbstractSubject abstractSubject) {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Forwarder for " + Subforwarder.this.targetJNDI + " is refreshing the session runtime context");
                }
                this.ddLoadBalancerDelegate.refreshSessionRuntimeContext(context, connection, session, abstractSubject);
            }

            public String toString() {
                return "[DDExactlyOnceForwardHelper: ddLoadBalancerDelegate = " + this.ddLoadBalancerDelegate + "]";
            }
        }
    }
}

