/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder.dd.internal;

import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.forwarder.dd.DDForwardStore;
import weblogic.jms.forwarder.dd.DDInfo;
import weblogic.jms.forwarder.dd.DDLBTable;
import weblogic.jms.forwarder.dd.DDMemberInfo;
import weblogic.jms.forwarder.dd.internal.DDLBTableImpl;
import weblogic.jms.store.JMSObjectHandler;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.xa.PersistentStoreXA;

public class DDForwardStoreImpl
implements DDForwardStore {
    private PersistentStoreXA persistentStore;
    private String name;
    private DDInfo ddInfo;
    private PersistentStoreConnection storeConnection;
    private DDLBTable ddLBTable;
    private PersistentHandle handle;
    private static final int NO_FLAGS = 0;
    private boolean poisoned;

    public DDForwardStoreImpl(String string, DDInfo dDInfo, PersistentStoreXA persistentStoreXA) throws JMSException {
        this.name = string;
        this.persistentStore = persistentStoreXA;
        this.ddInfo = dDInfo;
        try {
            this.storeConnection = persistentStoreXA.createConnection(string, (ObjectHandler)new JMSObjectHandler());
            this.open();
        }
        catch (PersistentStoreException persistentStoreException) {
            JMSException jMSException = new JMSException(persistentStoreException.getMessage());
            jMSException.setLinkedException((Exception)((Object)persistentStoreException));
            throw jMSException;
        }
    }

    private void open() throws JMSException {
        this.recover();
    }

    private void recover() throws JMSException {
        Object object;
        DDLBTable dDLBTable = null;
        try {
            PersistentStoreRecord persistentStoreRecord;
            object = this.storeConnection.createCursor(32);
            while ((persistentStoreRecord = object.next()) != null) {
                this.handle = persistentStoreRecord.getHandle();
                dDLBTable = (DDLBTable)persistentStoreRecord.getData();
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            JMSException jMSException = new JMSException(persistentStoreException.getMessage());
            jMSException.setLinkedException((Exception)((Object)persistentStoreException));
            throw jMSException;
        }
        this.ddLBTable = new DDLBTableImpl(this.name, this.ddInfo);
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("ddLBTableOnBoot = " + dDLBTable);
        }
        if (dDLBTable != null) {
            Object object22;
            object = dDLBTable.getFailedDDMemberInfosBySeqNum();
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug("failedDDMemberInfos = " + object);
            }
            for (Object object22 : ((HashMap)object).values()) {
                DestinationImpl destinationImpl = object22.getDestination();
                if (destinationImpl == null) continue;
                destinationImpl.markStale();
            }
            object22 = dDLBTable.getDDMemberInfos();
            if (object22 != null) {
                for (int i = 0; i < ((Object)object22).length; ++i) {
                    Object object3 = object22[i];
                    DestinationImpl destinationImpl = object3.getDestination();
                    if (destinationImpl == null) continue;
                    destinationImpl.markStale();
                }
            }
            dDLBTable.removeDDMemberInfos();
            dDLBTable.removeInDoubtDDMemberInfos();
            this.ddLBTable.setFailedDDMemberInfosBySeqNum((HashMap)object);
            this.ddLBTable.addInDoubtDDMemberInfos((DDMemberInfo[])object22);
        }
    }

    public PersistentStoreXA getStore() {
        return this.persistentStore;
    }

    public void addOrUpdateDDLBTable(DDLBTable dDLBTable) throws PersistentStoreException {
        PersistentStoreTransaction persistentStoreTransaction = this.persistentStore.begin();
        if (this.handle == null) {
            this.handle = this.storeConnection.create(persistentStoreTransaction, (Object)dDLBTable, 0);
        } else {
            this.storeConnection.update(persistentStoreTransaction, this.handle, (Object)dDLBTable, 0);
        }
        persistentStoreTransaction.commit();
    }

    public void removeDDLBTable() throws PersistentStoreException {
        if (this.handle == null) {
            return;
        }
        PersistentStoreTransaction persistentStoreTransaction = this.persistentStore.begin();
        this.storeConnection.delete(persistentStoreTransaction, this.handle, 0);
        persistentStoreTransaction.commit();
        this.handle = null;
    }

    public void close() {
        this.storeConnection.close();
    }

    public void poisoned() {
        this.poisoned = true;
    }

    public boolean isPoisoned() {
        return this.poisoned;
    }

    public DDLBTable getDDLBTable() {
        return this.ddLBTable;
    }
}

