/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder.dd.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.forwarder.dd.DDInfo;
import weblogic.jms.forwarder.dd.DDLBTable;
import weblogic.jms.forwarder.dd.DDMemberInfo;
import weblogic.jms.forwarder.dd.internal.DDMemberInfoImpl;

public class DDLBTableImpl
implements DDLBTable {
    static final long serialVersionUID = 3958010586618335512L;
    private static final byte EXTVERSION1 = 1;
    private static int versionmask = 255;
    private static final int _HASDDLBMembers = 256;
    private static final int _HASFAILEDDESTINATIONS = 512;
    private String name;
    private DDInfo ddInfo;
    private ArrayList ddMemberInfoArrayList = new ArrayList();
    private DDMemberInfo[] ddMemberInfos;
    private ArrayList ddMemberInfoInDoubtArrayList = new ArrayList();
    private DDMemberInfo[] ddMemberInfosInDoubt;
    private HashMap failedDDMemberInfosbySeqNum = new HashMap();
    private List failedDestinations = new ArrayList();

    public DDLBTableImpl() {
    }

    public DDLBTableImpl(String string, DDInfo dDInfo) {
        this.ddInfo = dDInfo;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public DDInfo getDDInfo() {
        return this.ddInfo;
    }

    public void addFailedDDMemberInfo(MessageImpl messageImpl, DDMemberInfo dDMemberInfo) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("DDLBTableImpl: addFailedDDMemberInfo");
        }
        long l = messageImpl.getSAFSeqNumber();
        this.addFailedDDMemberInfo(l, dDMemberInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailedDDMemberInfo(long l, DDMemberInfo dDMemberInfo) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("DDLBTableImpl: addFailedDDMemberInfo():  sequenceNumber= " + l + " ddMemberInfo =" + dDMemberInfo);
        }
        DDLBTableImpl dDLBTableImpl = this;
        synchronized (dDLBTableImpl) {
            Long l2 = new Long(l);
            this.failedDDMemberInfosbySeqNum.put(l2, dDMemberInfo);
            this.failedDestinations.add(dDMemberInfo);
        }
    }

    public synchronized DDMemberInfo getFailedDDMemberInfo(long l) {
        return (DDMemberInfo)this.failedDDMemberInfosbySeqNum.get(new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFailedDDMemberInfo(long l) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("DDLBTableImpl: removeFailedDDMemberInfo():  sequenceNumber= " + l);
        }
        DDLBTableImpl dDLBTableImpl = this;
        synchronized (dDLBTableImpl) {
            DDMemberInfo dDMemberInfo = (DDMemberInfo)this.failedDDMemberInfosbySeqNum.remove(new Long(l));
            this.failedDestinations.remove(dDMemberInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDDMemberInfo(DDMemberInfo dDMemberInfo) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("DDLBTableImpl: addDDMemberInfo(): ddMemberInfo= " + dDMemberInfo);
        }
        DDLBTableImpl dDLBTableImpl = this;
        synchronized (dDLBTableImpl) {
            if (this.ddMemberInfoArrayList.contains(dDMemberInfo)) {
                this.ddMemberInfoArrayList.remove(dDMemberInfo);
            }
            this.ddMemberInfoArrayList.add(dDMemberInfo);
            DDMemberInfo[] dDMemberInfoArray = new DDMemberInfo[this.ddMemberInfoArrayList.size()];
            this.ddMemberInfos = this.ddMemberInfoArrayList.toArray(dDMemberInfoArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDDMemberInfo(DDMemberInfo dDMemberInfo) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("DDLBTableImpl: removeDDMemberInfo():   ddMemberInfo= " + dDMemberInfo);
        }
        DDLBTableImpl dDLBTableImpl = this;
        synchronized (dDLBTableImpl) {
            this.ddMemberInfoArrayList.remove(dDMemberInfo);
            DDMemberInfo[] dDMemberInfoArray = new DDMemberInfo[this.ddMemberInfoArrayList.size()];
            this.ddMemberInfos = this.ddMemberInfoArrayList.toArray(dDMemberInfoArray);
        }
    }

    public synchronized void addDDMemberInfos(DDMemberInfo[] dDMemberInfoArray) {
        this.ddMemberInfos = dDMemberInfoArray;
    }

    public synchronized DDMemberInfo[] getDDMemberInfos() {
        return this.ddMemberInfos;
    }

    public synchronized void removeDDMemberInfos() {
        this.ddMemberInfos = null;
    }

    public synchronized void addInDoubtDDMemberInfos(DDMemberInfo[] dDMemberInfoArray) {
        this.ddMemberInfosInDoubt = dDMemberInfoArray;
    }

    public synchronized DDMemberInfo[] getInDoubtDDMemberInfos() {
        return this.ddMemberInfosInDoubt;
    }

    public synchronized void removeInDoubtDDMemberInfos() {
        this.ddMemberInfosInDoubt = null;
    }

    public synchronized HashMap getFailedDDMemberInfosBySeqNum() {
        return this.failedDDMemberInfosbySeqNum;
    }

    public synchronized void setFailedDDMemberInfosBySeqNum(HashMap hashMap) {
        this.failedDDMemberInfosbySeqNum = hashMap;
    }

    public synchronized List getFailedDDMemberInfos() {
        return this.failedDestinations;
    }

    public String toString() {
        String string = "<DDLBTableImpl> = { name=" + this.name + "," + " ddInfo=" + this.ddInfo + "," + " ddMemberInfos=";
        if (this.ddMemberInfos != null && this.ddMemberInfos.length != 0) {
            for (int i = 0; i < this.ddMemberInfos.length; ++i) {
                string = string + this.ddMemberInfos[i] + " ";
            }
        } else {
            string = string + "null";
        }
        string = string + " ddMemberInfosInDoubt=" + this.ddMemberInfosInDoubt + "}";
        return string;
    }

    protected int getVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        int n;
        if (object instanceof PeerInfoable && (n = (peerInfo = ((PeerInfoable)object).getPeerInfo()).getMajor()) < 9) {
            throw new IOException(JMSClientExceptionLogger.logIncompatibleVersion9Loggable((byte)1, (byte)1, (byte)1, (byte)1, (String)peerInfo.toString()).getMessage());
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getVersion(objectOutput);
        DDLBTableImpl dDLBTableImpl = this;
        synchronized (dDLBTableImpl) {
            int n2;
            if (this.ddMemberInfos.length > 0) {
                n |= 0x100;
            }
            if ((n2 = this.failedDestinations.size()) > 0) {
                n |= 0x200;
            }
            objectOutput.writeInt(n);
            objectOutput.writeObject(this.failedDDMemberInfosbySeqNum);
            if (n2 > 0) {
                objectOutput.writeObject(this.failedDestinations);
            }
            if (this.ddMemberInfos.length > 0) {
                objectOutput.writeInt(this.ddMemberInfos.length);
                for (int i = 0; i < this.ddMemberInfos.length; ++i) {
                    this.ddMemberInfos[i].writeExternal(objectOutput);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & versionmask;
        DDLBTableImpl dDLBTableImpl = this;
        synchronized (dDLBTableImpl) {
            if (n2 < 1) {
                throw JMSUtilities.versionIOException(n2, 1, 1);
            }
            this.failedDDMemberInfosbySeqNum = (HashMap)objectInput.readObject();
            if ((n & 0x200) != 0) {
                this.failedDestinations = (List)objectInput.readObject();
            }
            if ((n & 0x100) != 0) {
                int n3 = objectInput.readInt();
                for (int i = 0; i < n3; ++i) {
                    DDMemberInfoImpl dDMemberInfoImpl = new DDMemberInfoImpl();
                    dDMemberInfoImpl.readExternal(objectInput);
                    this.ddMemberInfoArrayList.add(dDMemberInfoImpl);
                }
                DDMemberInfo[] dDMemberInfoArray = new DDMemberInfo[this.ddMemberInfoArrayList.size()];
                this.ddMemberInfos = this.ddMemberInfoArrayList.toArray(dDMemberInfoArray);
            }
        }
    }
}

