/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder.dd.internal;

import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import weblogic.jms.cache.CacheEntry;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.LoadBalancer;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.RRLoadBalancer;
import weblogic.jms.common.RandomLoadBalancer;
import weblogic.jms.forwarder.DestinationName;
import weblogic.jms.forwarder.SessionRuntimeContext;
import weblogic.jms.forwarder.dd.DDForwardStore;
import weblogic.jms.forwarder.dd.DDInfo;
import weblogic.jms.forwarder.dd.DDLBTable;
import weblogic.jms.forwarder.dd.DDLoadBalancerDelegate;
import weblogic.jms.forwarder.dd.DDMemberInfo;
import weblogic.jms.forwarder.dd.DDMembersCache;
import weblogic.jms.forwarder.dd.DDMembersCacheChangeListener;
import weblogic.jms.forwarder.dd.internal.DDForwardStoreImpl;
import weblogic.jms.forwarder.dd.internal.DDMemberInfoImpl;
import weblogic.jms.forwarder.dd.internal.DDMembersCacheImpl;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.store.PersistentStoreException;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.utils.StackTraceUtilsClient;

public class DDLoadBalancerDelegateImpl
implements DDLoadBalancerDelegate {
    private String name;
    private DDInfo ddInfo;
    private SessionRuntimeContext jmsSessionRuntimeContext;
    private DDForwardStore ddForwardStore;
    private DDLBTable ddLBTable;
    private LoadBalancer loadBalancer = new RRLoadBalancer();
    private ArrayList ddImplArrayList = new ArrayList();
    private HashMap memberInformationDDImplMap = new HashMap();
    private HashMap ddMemberNameDImplMap = new HashMap();
    private LoadBalancerHandler loadBalancerHandler;
    private static final int ADD_MEMBER = 1;
    private static final int REMOVE_MEMBER = 2;
    private ArrayList notifications = new ArrayList();
    private boolean freezed;
    private AbstractSubject subject = null;
    private static final AbstractSubject kernelID = DDLoadBalancerDelegateImpl.getKernelIdentity();
    private boolean isFirstPushedMessageNotInFailedMap = true;

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public DDLoadBalancerDelegateImpl(SessionRuntimeContext sessionRuntimeContext, DDInfo dDInfo, PersistentStoreXA persistentStoreXA) throws JMSException {
        this.name = sessionRuntimeContext.getName();
        this.ddInfo = dDInfo;
        this.jmsSessionRuntimeContext = sessionRuntimeContext;
        this.createDDForwardStore(persistentStoreXA);
        this.createLoadBalancer();
    }

    private void createDDForwardStore(PersistentStoreXA persistentStoreXA) throws JMSException {
        String string = persistentStoreXA.getName() + "." + this.name + "." + this.ddInfo.getDestinationName().getConfigName();
        this.ddForwardStore = new DDForwardStoreImpl(string, this.ddInfo, persistentStoreXA);
        this.ddLBTable = this.ddForwardStore.getDDLBTable();
    }

    private void createLoadBalancer() {
        switch (this.ddInfo.getLoadBalancingPolicy()) {
            case 0: {
                this.loadBalancer = new RRLoadBalancer();
                break;
            }
            case 1: {
                this.loadBalancer = new RandomLoadBalancer();
                break;
            }
        }
        this.loadBalancerHandler = new LoadBalancerHandler();
    }

    public DestinationName getDestinationName() {
        return this.ddInfo.getDestinationName();
    }

    public int getLoadBalancingPolicy() {
        return this.ddInfo.getLoadBalancingPolicy();
    }

    public int getForwardingPolicy() {
        return this.ddInfo.getForwardingPolicy();
    }

    public boolean isDDInLocalCluster() {
        return this.jmsSessionRuntimeContext.isForLocalCluster();
    }

    public synchronized Destination loadBalance() {
        DistributedDestinationImpl distributedDestinationImpl = this.loadBalancer.getNext(null);
        return (Destination)this.ddMemberNameDImplMap.get(distributedDestinationImpl.getMemberName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Destination loadBalance(MessageImpl messageImpl) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": loadBlance() for message = " + messageImpl.getId());
        }
        long l = messageImpl.getSAFSeqNumber();
        DDMemberInfo dDMemberInfo = null;
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": loadBalance()for sequence number :" + l);
        }
        boolean bl = messageImpl.getJMSDeliveryMode() == 2;
        try {
            dDMemberInfo = this.ddLBTable.getFailedDDMemberInfo(l);
            if (dDMemberInfo != null) {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug(this + ": loadbalance() : failedDDMeberInfo=" + dDMemberInfo);
                }
                this.ddLBTable.removeFailedDDMemberInfo(l);
                Destination destination = this.findOrCreateDestination(dDMemberInfo);
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug(this + ": loadbalance() : destination=" + destination);
                }
                if (destination == null) {
                    return null;
                }
                this.addDestination(dDMemberInfo, this.ddInfo.getDestinationName().getConfigName(), this.ddInfo.getDestinationName().getJNDIName());
                return destination;
            }
        }
        catch (JMSException jMSException) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + ": loadbalance() : failed \n" + StackTraceUtilsClient.throwable2StackTrace((Throwable)jMSException));
            }
            if (dDMemberInfo != null) {
                this.ddLBTable.addFailedDDMemberInfo(l, dDMemberInfo);
                return dDMemberInfo.getDestination();
            }
            return null;
        }
        DDMemberInfo[] dDMemberInfoArray = this.ddLBTable.getInDoubtDDMemberInfos();
        try {
            try {
                if (bl && this.isFirstPushedMessageNotInFailedMap && dDMemberInfoArray != null && dDMemberInfoArray.length != 0) {
                    this.ddLBTable.removeInDoubtDDMemberInfos();
                    int n = dDMemberInfoArray.length;
                    DDMemberInfo dDMemberInfo2 = dDMemberInfoArray[(int)l % n];
                    Destination destination = this.findOrCreateDestination(dDMemberInfo2);
                    Object var11_16 = null;
                    this.isFirstPushedMessageNotInFailedMap = false;
                    return destination;
                }
                Object var11_17 = null;
                this.isFirstPushedMessageNotInFailedMap = false;
            }
            catch (JMSException jMSException) {
                Destination destination = null;
                Object var11_18 = null;
                this.isFirstPushedMessageNotInFailedMap = false;
                return destination;
            }
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            this.isFirstPushedMessageNotInFailedMap = false;
            throw throwable;
        }
        DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = this;
        synchronized (dDLoadBalancerDelegateImpl) {
            if (this.ddImplArrayList.size() == 0) {
                return null;
            }
            this.freezeDDLBTable();
            int n = (int)l % this.ddImplArrayList.size();
            DistributedDestinationImpl distributedDestinationImpl = this.loadBalancer.getNext(n);
            return (Destination)this.ddMemberNameDImplMap.get(distributedDestinationImpl.getMemberName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination findOrCreateDestination(DDMemberInfo dDMemberInfo) throws JMSException {
        DestinationImpl destinationImpl = dDMemberInfo.getDestination();
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": findOrCreateDestination() : " + " ddMeberInfo=" + dDMemberInfo + " dImpl =" + destinationImpl);
            if (destinationImpl != null) {
                JMSDebug.JMSSAF.debug(this + ": findOrCreateDestination() : " + " dImpl.isStale= " + destinationImpl.isStale() + "dImpl.id= " + destinationImpl.getId());
            }
        }
        if (destinationImpl != null && !destinationImpl.isStale() && destinationImpl.getId() != null) {
            return destinationImpl;
        }
        String string = dDMemberInfo.getType();
        String string2 = dDMemberInfo.getJMSServerName();
        String string3 = dDMemberInfo.getDDMemberConfigName();
        String string4 = string2 + "/" + string3;
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": findOrCreateDestination() : " + " about to create " + string + " for " + string4);
        }
        this.subject = this.jmsSessionRuntimeContext.getSubject();
        this.pushSubject();
        try {
            destinationImpl = string.equals("javax.jms.Queue") ? (DestinationImpl)this.jmsSessionRuntimeContext.getJMSSession().createQueue(string4) : (DestinationImpl)this.jmsSessionRuntimeContext.getJMSSession().createTopic(string4);
            Object var8_7 = null;
            this.popSubject();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.popSubject();
            throw throwable;
        }
        dDMemberInfo.setDestination(destinationImpl);
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": found destination " + destinationImpl);
        }
        return destinationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfDDMemberInfoHadFailedInLastRun(DDMemberInfo dDMemberInfo) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": checkifDDMemberInfoHadFailedInlastRun()" + " ddMemberInfo= " + dDMemberInfo);
        }
        DDLBTable dDLBTable = this.ddLBTable;
        synchronized (dDLBTable) {
            List list = this.ddLBTable.getFailedDDMemberInfos();
            boolean bl = list.remove(dDMemberInfo);
            if (bl) {
                list.add(dDMemberInfo);
            }
            return bl;
        }
    }

    private void addDestination(DDMemberInformation dDMemberInformation) throws JMSException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": addDestination(): single: ddJNDIname= " + this.ddInfo.getDestinationName().getJNDIName() + " ddConfigName = " + dDMemberInformation.getDDConfigName() + " isProductionPaused= " + dDMemberInformation.isProductionPaused() + " isInsertionPaused= " + dDMemberInformation.isInsertionPaused());
        }
        if (dDMemberInformation.isProductionPaused() || dDMemberInformation.isInsertionPaused()) {
            return;
        }
        String string = this.ddInfo.getDestinationName().getJNDIName();
        String string2 = dDMemberInformation.getDDConfigName();
        DestinationImpl destinationImpl = (DestinationImpl)dDMemberInformation.getDestination();
        String string3 = dDMemberInformation.getDDType();
        DDMemberInfoImpl dDMemberInfoImpl = new DDMemberInfoImpl(destinationImpl.getServerName(), destinationImpl.getName(), string3, destinationImpl);
        if (this.checkIfDDMemberInfoHadFailedInLastRun(dDMemberInfoImpl)) {
            return;
        }
        this.addDestination(dDMemberInfoImpl, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDestination(DDMemberInfo dDMemberInfo, String string, String string2) throws JMSException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": addDestination: ddMemberInfo= " + dDMemberInfo + " ddConfigName=" + string + " ddJNIDName=" + string2);
        }
        String string3 = dDMemberInfo.getJMSServerName();
        String string4 = dDMemberInfo.getDDMemberConfigName();
        DestinationImpl destinationImpl = dDMemberInfo.getDestination();
        String string5 = string3 + "/" + string4;
        destinationImpl = (DestinationImpl)this.findOrCreateDestination(dDMemberInfo);
        DistributedDestinationImpl distributedDestinationImpl = new DistributedDestinationImpl(destinationImpl.getType(), destinationImpl.getServerName(), string, destinationImpl.getApplicationName(), destinationImpl.getModuleName(), this.getLoadBalancingPolicy(), this.getForwardingPolicy(), string5, string2, destinationImpl.getBackEndId(), destinationImpl.getDestinationId(), destinationImpl.getBackEndId().getDispatcherId(), true, destinationImpl.getPersistentStoreName(), this.ddInfo.getSAFExportPolicy(), false);
        DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = this;
        synchronized (dDLoadBalancerDelegateImpl) {
            if (this.freezed) {
                this.notifications.add(new NotificationItemAdd(distributedDestinationImpl, string5, destinationImpl, dDMemberInfo));
            } else {
                this.addDestinationToList(distributedDestinationImpl, string5, destinationImpl, dDMemberInfo);
            }
        }
    }

    private synchronized void addDestinationToList(DistributedDestinationImpl distributedDestinationImpl, String string, DestinationImpl destinationImpl, DDMemberInfo dDMemberInfo) {
        int n = this.ddImplArrayList.indexOf(distributedDestinationImpl);
        if (n != -1) {
            this.ddImplArrayList.set(n, distributedDestinationImpl);
        } else {
            this.ddImplArrayList.add(distributedDestinationImpl);
        }
        this.memberInformationDDImplMap.put(string, distributedDestinationImpl);
        this.ddMemberNameDImplMap.put(string, destinationImpl);
        DistributedDestinationImpl[] distributedDestinationImplArray = this.getDDImpls(this.ddImplArrayList);
        this.loadBalancer.refresh(distributedDestinationImplArray);
        this.persistLoadBalancerInfo(1, dDMemberInfo);
    }

    private void removeDestination(DDMemberInformation dDMemberInformation) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": removeDestination() single");
        }
        DestinationImpl destinationImpl = (DestinationImpl)dDMemberInformation.getDestination();
        String string = dDMemberInformation.getDDType();
        DDMemberInfoImpl dDMemberInfoImpl = new DDMemberInfoImpl(destinationImpl.getServerName(), destinationImpl.getName(), string, destinationImpl);
        this.removeDestination(dDMemberInfoImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDestination(DDMemberInfo dDMemberInfo, boolean bl) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": removeDestination() : ddMemberInfo = " + dDMemberInfo + " persist=" + bl);
        }
        String string = dDMemberInfo.getJMSServerName();
        String string2 = dDMemberInfo.getDDMemberConfigName();
        String string3 = string + "/" + string2;
        DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = this;
        synchronized (dDLoadBalancerDelegateImpl) {
            if (this.freezed) {
                this.notifications.add(new NotificationItemRemove(string3, dDMemberInfo, bl));
            } else {
                this.removeDestinationFromList(string3, dDMemberInfo, bl);
            }
        }
    }

    private synchronized void removeDestinationFromList(String string, DDMemberInfo dDMemberInfo, boolean bl) {
        DistributedDestinationImpl distributedDestinationImpl = (DistributedDestinationImpl)this.memberInformationDDImplMap.remove(string);
        this.ddImplArrayList.remove(distributedDestinationImpl);
        this.ddMemberNameDImplMap.remove(string);
        DistributedDestinationImpl[] distributedDestinationImplArray = this.getDDImpls(this.ddImplArrayList);
        this.loadBalancer.refresh(distributedDestinationImplArray);
        if (bl) {
            this.persistLoadBalancerInfo(2, dDMemberInfo);
        }
    }

    public void close() {
        this.loadBalancerHandler.close();
        this.ddForwardStore.close();
    }

    public boolean hasNonFailedDDMembers() {
        DDMemberInfo[] dDMemberInfoArray = this.ddLBTable.getDDMemberInfos();
        if (dDMemberInfoArray == null) {
            return false;
        }
        return dDMemberInfoArray.length != 0;
    }

    public void addFailedEndPoint(MessageImpl messageImpl, DestinationImpl destinationImpl) throws PersistentStoreException {
        String string = null;
        if (destinationImpl.isQueue()) {
            string = new String("javax.jms.Queue");
        } else if (destinationImpl.isTopic()) {
            string = new String("javax.jms.Topic");
        }
        destinationImpl.markStale();
        DDMemberInfoImpl dDMemberInfoImpl = new DDMemberInfoImpl(destinationImpl.getServerName(), destinationImpl.getName(), string, destinationImpl);
        this.ddLBTable.addFailedDDMemberInfo(messageImpl.getSAFSeqNumber(), dDMemberInfoImpl);
        this.removeDestination(dDMemberInfoImpl, messageImpl.getJMSDeliveryMode() == 2);
    }

    private DistributedDestinationImpl[] getDDImpls(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        DistributedDestinationImpl[] distributedDestinationImplArray = new DistributedDestinationImpl[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            distributedDestinationImplArray[n2] = (DistributedDestinationImpl)iterator.next();
            ++n2;
        }
        return distributedDestinationImplArray;
    }

    private void addDestination(DDMemberInformation[] dDMemberInformationArray) throws JMSException {
        for (int i = 0; i < dDMemberInformationArray.length; ++i) {
            this.addDestination(dDMemberInformationArray[i]);
        }
    }

    private void removeDestination(DDMemberInformation[] dDMemberInformationArray) {
        for (int i = 0; i < dDMemberInformationArray.length; ++i) {
            this.removeDestination(dDMemberInformationArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistLoadBalancerInfo(int n, DDMemberInfo dDMemberInfo) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": persistLoadBalancerInfo() : event = " + n + " ddMemberInfo=" + dDMemberInfo);
        }
        try {
            switch (n) {
                case 1: {
                    DDLBTable dDLBTable = this.ddLBTable;
                    synchronized (dDLBTable) {
                        this.ddLBTable.addDDMemberInfo(dDMemberInfo);
                        this.ddForwardStore.addOrUpdateDDLBTable(this.ddLBTable);
                        break;
                    }
                }
                case 2: {
                    DDLBTable dDLBTable = this.ddLBTable;
                    synchronized (dDLBTable) {
                        this.ddLBTable.removeDDMemberInfo(dDMemberInfo);
                        this.ddForwardStore.addOrUpdateDDLBTable(this.ddLBTable);
                        break;
                    }
                }
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.printStackTrace();
            throw new AssertionError((Object)persistentStoreException);
        }
    }

    public void refreshSessionRuntimeContext(Context context, Connection connection, Session session, AbstractSubject abstractSubject) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(this + ": refrshSessionRuntimeContext");
        }
        this.jmsSessionRuntimeContext.refresh(context, connection, session, abstractSubject);
    }

    private synchronized void freezeDDLBTable() {
        this.freezed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezeDDLBTable() {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("DDLoadBalancerDelegateImpl: unfreeze the LB table");
        }
        DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = this;
        synchronized (dDLoadBalancerDelegateImpl) {
            if (!this.freezed) {
                return;
            }
            this.freezed = false;
            Iterator iterator = this.notifications.iterator();
            try {
                while (iterator.hasNext()) {
                    NotificationItem notificationItem = (NotificationItem)iterator.next();
                    notificationItem.processNotification();
                }
                Object var5_4 = null;
                this.notifications.clear();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.notifications.clear();
                throw throwable;
            }
        }
    }

    private synchronized void pushSubject() {
        if (this.subject != null) {
            SubjectManager.getSubjectManager().pushSubject(kernelID, this.subject);
        }
    }

    private synchronized void popSubject() {
        if (this.subject != null) {
            SubjectManager.getSubjectManager().popSubject(kernelID);
        }
    }

    public String toString() {
        return "[DDLoadBalancerDelegateImpl:  ddLBTable = " + this.ddLBTable + "]";
    }

    private final class NotificationItemRemove
    extends NotificationItem {
        private String name;
        private DDMemberInfo ddMemberInfo;
        private boolean persist;

        public NotificationItemRemove(String string, DDMemberInfo dDMemberInfo, boolean bl) {
            this.name = string;
            this.ddMemberInfo = dDMemberInfo;
            this.persist = bl;
        }

        void processNotification() {
            DDLoadBalancerDelegateImpl.this.removeDestinationFromList(this.name, this.ddMemberInfo, this.persist);
        }
    }

    private final class NotificationItemAdd
    extends NotificationItem {
        private DistributedDestinationImpl ddImpl;
        private String name;
        private DestinationImpl destImpl;
        private DDMemberInfo ddMemberInfo;

        public NotificationItemAdd(DistributedDestinationImpl distributedDestinationImpl, String string, DestinationImpl destinationImpl, DDMemberInfo dDMemberInfo) {
            this.ddImpl = distributedDestinationImpl;
            this.name = string;
            this.destImpl = destinationImpl;
            this.ddMemberInfo = dDMemberInfo;
        }

        void processNotification() {
            DDLoadBalancerDelegateImpl.this.addDestinationToList(this.ddImpl, this.name, this.destImpl, this.ddMemberInfo);
        }
    }

    private abstract class NotificationItem {
        private NotificationItem() {
        }

        abstract void processNotification();
    }

    private class LoadBalancerHandler
    implements DDMembersCacheChangeListener {
        private DDMembersCache ddMembersCache;

        public LoadBalancerHandler() {
            this.ddMembersCache = new DDMembersCacheImpl(DDLoadBalancerDelegateImpl.this.jmsSessionRuntimeContext, DDLoadBalancerDelegateImpl.this.ddInfo.getDestinationName(), DDLoadBalancerDelegateImpl.this.jmsSessionRuntimeContext.isForLocalCluster());
            this.ddMembersCache.addDDMembersCacheChangeListener(this);
        }

        public JMSID getId() {
            return null;
        }

        public void close() {
            this.ddMembersCache.removeDDMembersCacheChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCacheEntryAdd(CacheEntry cacheEntry) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + ": onCacheEntryAdd() single: " + " Entry = " + cacheEntry + " isProductionPaused= " + ((DDMemberInformation)cacheEntry).isProductionPaused() + " isInsertionPaused= " + ((DDMemberInformation)cacheEntry).isInsertionPaused());
            }
            DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = DDLoadBalancerDelegateImpl.this;
            synchronized (dDLoadBalancerDelegateImpl) {
                try {
                    DDLoadBalancerDelegateImpl.this.addDestination((DDMemberInformation)cacheEntry);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCacheEntryRemove(CacheEntry cacheEntry) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + ": onCacheEntryRemove() single");
            }
            DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = DDLoadBalancerDelegateImpl.this;
            synchronized (dDLoadBalancerDelegateImpl) {
                DDLoadBalancerDelegateImpl.this.removeDestination((DDMemberInformation)cacheEntry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCacheEntryAdd(CacheEntry[] cacheEntryArray) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + ": onCacheEntryAdd() multiple");
            }
            DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = DDLoadBalancerDelegateImpl.this;
            synchronized (dDLoadBalancerDelegateImpl) {
                try {
                    DDLoadBalancerDelegateImpl.this.addDestination((DDMemberInformation[])cacheEntryArray);
                }
                catch (JMSException jMSException) {
                    jMSException.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCacheEntryRemove(CacheEntry[] cacheEntryArray) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + ": onCacheEntryRemove() multiple");
            }
            DDLoadBalancerDelegateImpl dDLoadBalancerDelegateImpl = DDLoadBalancerDelegateImpl.this;
            synchronized (dDLoadBalancerDelegateImpl) {
                DDLoadBalancerDelegateImpl.this.removeDestination((DDMemberInformation[])cacheEntryArray);
            }
        }
    }
}

