/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder.dd.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.forwarder.dd.DDMemberInfo;
import weblogic.jms.forwarder.dd.DDMemberRuntimeInformation;

public class DDMemberInfoImpl
implements DDMemberInfo {
    private static final byte EXTVERSION1 = 1;
    private static int versionmask = 255;
    private String jmsServerName;
    private String ddMemberConfigName;
    private String destinationType;
    private transient DDMemberRuntimeInformation ddMemberRuntimeInformation;
    private transient DestinationImpl dImpl;

    public DDMemberInfoImpl() {
    }

    public DDMemberInfoImpl(String string, String string2, String string3, DestinationImpl destinationImpl) {
        this(string, string2, string3, destinationImpl, null);
    }

    public DDMemberInfoImpl(String string, String string2, String string3, DestinationImpl destinationImpl, DDMemberRuntimeInformation dDMemberRuntimeInformation) {
        this.jmsServerName = string;
        this.ddMemberConfigName = string2;
        this.destinationType = string3;
        this.dImpl = destinationImpl;
        this.ddMemberRuntimeInformation = dDMemberRuntimeInformation;
    }

    public String toString() {
        return "<DDMemnerInoImpl> = { ddMemberConfigName=" + this.ddMemberConfigName + "," + " destinationType=" + this.destinationType + "," + " JmsServerName=" + this.jmsServerName + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DDMemberInfoImpl)) {
            return false;
        }
        DDMemberInfoImpl dDMemberInfoImpl = (DDMemberInfoImpl)object;
        if (this.ddMemberConfigName != null ? !this.ddMemberConfigName.equals(dDMemberInfoImpl.ddMemberConfigName) : dDMemberInfoImpl.ddMemberConfigName != null) {
            return false;
        }
        if (this.destinationType != null ? !this.destinationType.equals(dDMemberInfoImpl.destinationType) : dDMemberInfoImpl.destinationType != null) {
            return false;
        }
        return !(this.jmsServerName != null ? !this.jmsServerName.equals(dDMemberInfoImpl.jmsServerName) : dDMemberInfoImpl.jmsServerName != null);
    }

    public int hashCode() {
        int n = this.jmsServerName != null ? this.jmsServerName.hashCode() : 0;
        n = 29 * n + (this.ddMemberConfigName != null ? this.ddMemberConfigName.hashCode() : 0);
        n = 29 * n + (this.destinationType != null ? this.destinationType.hashCode() : 0);
        return n;
    }

    public String getJMSServerName() {
        return this.jmsServerName;
    }

    public String getType() {
        return this.destinationType;
    }

    public String getDDMemberConfigName() {
        return this.ddMemberConfigName;
    }

    public DDMemberRuntimeInformation getDDMemberRuntimeInformation() {
        return this.ddMemberRuntimeInformation;
    }

    public DestinationImpl getDestination() {
        return this.dImpl;
    }

    public void setDestination(DestinationImpl destinationImpl) {
        this.dImpl = destinationImpl;
    }

    protected int getVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        int n;
        if (object instanceof PeerInfoable && (n = (peerInfo = ((PeerInfoable)object).getPeerInfo()).getMajor()) < 9) {
            throw new IOException(JMSClientExceptionLogger.logIncompatibleVersion9Loggable((byte)1, (byte)1, (byte)1, (byte)1, (String)peerInfo.toString()).getMessage());
        }
        return 1;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getVersion(objectOutput);
        objectOutput.writeInt(n);
        objectOutput.writeUTF(this.jmsServerName);
        objectOutput.writeUTF(this.ddMemberConfigName);
        objectOutput.writeUTF(this.destinationType);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & versionmask;
        if (n2 < 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        this.jmsServerName = objectInput.readUTF();
        this.ddMemberConfigName = objectInput.readUTF();
        this.destinationType = objectInput.readUTF();
    }
}

