/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder.dd.internal;

import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jms.cache.CacheContextInfo;
import weblogic.jms.cache.CacheEntry;
import weblogic.jms.common.CDS;
import weblogic.jms.common.DDMemberInformation;
import weblogic.jms.common.DDMembershipChangeEventImpl;
import weblogic.jms.common.DDMembershipChangeListener;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.forwarder.DestinationName;
import weblogic.jms.forwarder.SessionRuntimeContext;
import weblogic.jms.forwarder.dd.DDMembersCache;
import weblogic.jms.forwarder.dd.DDMembersCacheChangeListener;
import weblogic.jms.forwarder.dd.internal.DDMembersCacheManagerImpl;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class DDMembersCacheImpl
implements DDMembersCache {
    private static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final AbstractSubject kernelID = DDMembersCacheImpl.getKernelIdentity();
    private String cacheName;
    private boolean isForLocalCluster = true;
    private DestinationName destinationName;
    private CacheContextInfo cacheContextInfo;
    private Context providerContext;
    private AbstractSubject subject;
    private SessionRuntimeContext sessionRuntimeContext;
    private static DDMembersCacheManagerImpl ddMembersCacheManager = DDMembersCacheManagerImpl.ddMembersCacheManager;
    private DDMembershipHandler ddMembershipHandler;
    private HashMap ddEventListenersMap = new HashMap();
    private DDMemberInformation[] ddMemberConfigInformation;
    private Map ddMemberRuntimeInformationMap = new HashMap();
    private String loginUrl;

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public DDMembersCacheImpl(DestinationName destinationName) {
        this.init(destinationName);
        if (this.ddMembershipHandler == null) {
            this.ddMembershipHandler = new DDMembershipHandler();
        }
    }

    public DDMembersCacheImpl(CacheContextInfo cacheContextInfo, DestinationName destinationName) {
        this.isForLocalCluster = false;
        this.setCacheContextInfo(cacheContextInfo);
        this.init(destinationName);
        if (this.ddMembershipHandler == null) {
            this.ddMembershipHandler = new DDMembershipHandler();
        }
    }

    public DDMembersCacheImpl(SessionRuntimeContext sessionRuntimeContext, DestinationName destinationName, boolean bl) {
        this.sessionRuntimeContext = sessionRuntimeContext;
        this.isForLocalCluster = bl;
        this.loginUrl = sessionRuntimeContext.getLoginUrl();
        this.setProviderContext(sessionRuntimeContext.getProviderContext());
        this.setSubject(sessionRuntimeContext.getSubject());
        this.init(destinationName);
        if (this.ddMembershipHandler == null) {
            this.ddMembershipHandler = new DDMembershipHandler();
        }
    }

    private void init(DestinationName destinationName) {
        this.setName(destinationName);
        this.setDestinationName(destinationName);
    }

    private void setName(DestinationName destinationName) {
        this.setName("[ProviderUrl = " + (this.isForLocalCluster ? " Local Cluster" : (this.cacheContextInfo == null ? this.loginUrl : this.cacheContextInfo.getProviderUrl())) + "]" + destinationName);
    }

    public String getName() {
        return this.cacheName;
    }

    public void setName(String string) {
        this.cacheName = string;
    }

    public synchronized CacheEntry[] getCacheEntries() {
        if (this.ddMembershipHandler == null) {
            this.ddMembershipHandler = new DDMembershipHandler();
        }
        return new CacheEntry[0];
    }

    public void setCacheContextInfo(CacheContextInfo cacheContextInfo) {
        this.cacheContextInfo = cacheContextInfo;
    }

    public CacheContextInfo getCacheContextInfo() {
        return this.cacheContextInfo;
    }

    public void setProviderContext(Context context) {
        this.providerContext = context;
    }

    public Context getProviderContext() {
        if (this.sessionRuntimeContext != null) {
            return this.sessionRuntimeContext.getProviderContext();
        }
        return this.providerContext;
    }

    public void setSubject(AbstractSubject abstractSubject) {
        this.subject = abstractSubject;
    }

    public boolean isForLocalCluster() {
        return this.isForLocalCluster;
    }

    public DDMemberInformation[] getDDMemberConfigInformation() {
        CacheEntry[] cacheEntryArray = this.getCacheEntries();
        return (DDMemberInformation[])cacheEntryArray;
    }

    public Map getDDMemberRuntimeInformation() {
        return this.ddMemberRuntimeInformationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDDMembersCacheChangeListener(DDMembersCacheChangeListener dDMembersCacheChangeListener) {
        DDMembersCacheImpl dDMembersCacheImpl = this;
        synchronized (dDMembersCacheImpl) {
            if (this.ddMembershipHandler != null) {
                this.ddMembershipHandler.close();
            }
            this.ddEventListenersMap.remove(dDMembersCacheChangeListener.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDDMembersCacheChangeListener(DDMembersCacheChangeListener dDMembersCacheChangeListener) {
        DDMembersCacheChangeListener dDMembersCacheChangeListener2 = null;
        int n = 0;
        DDMemberInformation[] dDMemberInformationArray = null;
        DDMembersCacheImpl dDMembersCacheImpl = this;
        synchronized (dDMembersCacheImpl) {
            dDMembersCacheChangeListener2 = (DDMembersCacheChangeListener)this.ddEventListenersMap.get(dDMembersCacheChangeListener.getId());
            if (this.ddMemberConfigInformation == null) {
                if (dDMembersCacheChangeListener2 == null) {
                    this.ddEventListenersMap.put(dDMembersCacheChangeListener.getId(), dDMembersCacheChangeListener);
                }
                return;
            }
            n = this.ddMemberConfigInformation.length;
            dDMemberInformationArray = (DDMemberInformation[])this.ddMemberConfigInformation.clone();
        }
        for (int i = 0; i < n; ++i) {
            dDMembersCacheChangeListener.onCacheEntryAdd(dDMemberInformationArray[i]);
        }
        DDMembersCacheImpl dDMembersCacheImpl2 = this;
        synchronized (dDMembersCacheImpl2) {
            if (dDMembersCacheChangeListener2 == null) {
                this.ddEventListenersMap.put(dDMembersCacheChangeListener.getId(), dDMembersCacheChangeListener);
            }
        }
    }

    public void setDestinationName(DestinationName destinationName) {
        this.destinationName = destinationName;
    }

    public DestinationName getDestinationName() {
        return this.destinationName;
    }

    static /* synthetic */ DDMemberInformation[] access$002(DDMembersCacheImpl dDMembersCacheImpl, DDMemberInformation[] dDMemberInformationArray) {
        dDMembersCacheImpl.ddMemberConfigInformation = dDMemberInformationArray;
        return dDMemberInformationArray;
    }

    private class DDMembershipHandler
    implements DDMembershipChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DDMembershipHandler() {
            DDMembersCacheImpl dDMembersCacheImpl2 = DDMembersCacheImpl.this;
            synchronized (dDMembersCacheImpl2) {
                DDMembersCacheImpl.access$002(DDMembersCacheImpl.this, CDS.getCDS().getDDMembershipInformation(this));
            }
        }

        void close() {
            CDS.getCDS().unregisterDDMembershipChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDDMembershipChange(DDMembershipChangeEventImpl dDMembershipChangeEventImpl) {
            Iterator iterator = null;
            CacheEntry[] cacheEntryArray = DDMembersCacheImpl.this;
            synchronized (DDMembersCacheImpl.this) {
                iterator = ((HashMap)DDMembersCacheImpl.this.ddEventListenersMap.clone()).values().iterator();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                cacheEntryArray = dDMembershipChangeEventImpl.getRemovedDDMemberInformation();
                CacheEntry[] cacheEntryArray2 = dDMembershipChangeEventImpl.getAddedDDMemberInformation();
                while (iterator.hasNext()) {
                    try {
                        DDMembersCacheChangeListener dDMembersCacheChangeListener = (DDMembersCacheChangeListener)iterator.next();
                        if (cacheEntryArray != null) {
                            dDMembersCacheChangeListener.onCacheEntryRemove(cacheEntryArray);
                        }
                        if (cacheEntryArray2 == null) continue;
                        dDMembersCacheChangeListener.onCacheEntryAdd(cacheEntryArray2);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                return;
            }
        }

        public String getDestinationName() {
            return DDMembersCacheImpl.this.destinationName.getJNDIName();
        }

        public String getProviderURL() {
            return DDMembersCacheImpl.this.loginUrl;
        }

        public Context getInitialContext() throws NamingException {
            JMSDebug.JMSSAF.debug(this + ": getInitialContext() " + "sessionRuntimeContext " + DDMembersCacheImpl.this.sessionRuntimeContext + " loginURL " + this.getProviderURL());
            if (DDMembersCacheImpl.this.sessionRuntimeContext != null) {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug(this + ": CACHED getInitialContext returning sessionRuntimeContext.getProviderContext() " + DDMembersCacheImpl.this.sessionRuntimeContext.getProviderContext() + " with subject " + DDMembersCacheImpl.this.sessionRuntimeContext.getSubject() + " forceResolveDNS " + DDMembersCacheImpl.this.sessionRuntimeContext.getForceResolveDNS());
                }
                if (!DDMembersCacheImpl.this.sessionRuntimeContext.getForceResolveDNS()) {
                    DDMembersCacheImpl.this.providerContext = DDMembersCacheImpl.this.sessionRuntimeContext.getProviderContext();
                }
            }
            String string = this.getProviderURL();
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            if (DDMembersCacheImpl.this.sessionRuntimeContext != null) {
                string3 = DDMembersCacheImpl.this.sessionRuntimeContext.getPassword();
                string2 = DDMembersCacheImpl.this.sessionRuntimeContext.getUsername();
                bl = DDMembersCacheImpl.this.sessionRuntimeContext.getForceResolveDNS();
            }
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug(this + ": NEW PATH getInitialContext url " + string + " username " + string2 + " pass " + "XXXX" + " forceResolveDNS " + bl);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", DDMembersCacheImpl.JNDI_FACTORY);
            if (string != null) {
                hashtable.put("java.naming.provider.url", string);
            }
            if (string2 != null) {
                hashtable.put("java.naming.security.principal", string2);
            }
            if (string3 != null) {
                hashtable.put("java.naming.security.credentials", string3);
            }
            if (bl) {
                System.setProperty("weblogic.jndi.forceResolveDNSName", "true");
            }
            DDMembersCacheImpl.this.providerContext = new InitialContext(hashtable);
            DDMembersCacheImpl.this.subject = SubjectManager.getSubjectManager().getCurrentSubject(kernelID);
            if (DDMembersCacheImpl.this.sessionRuntimeContext != null) {
                DDMembersCacheImpl.this.sessionRuntimeContext.setSubject(DDMembersCacheImpl.this.subject);
                DDMembersCacheImpl.this.sessionRuntimeContext.setProviderContext(DDMembersCacheImpl.this.providerContext);
            }
            JMSDebug.JMSSAF.debug(this + ": getInitialcontext , return providerContext " + DDMembersCacheImpl.this.providerContext + " subject " + DDMembersCacheImpl.this.subject);
            return DDMembersCacheImpl.this.providerContext;
        }

        public AbstractSubject getSubject() {
            if (DDMembersCacheImpl.this.sessionRuntimeContext != null) {
                return DDMembersCacheImpl.this.sessionRuntimeContext.getSubject();
            }
            return DDMembersCacheImpl.this.subject;
        }

        public void onFailure(String string, Exception exception) {
        }
    }
}

