/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.forwarder.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.jms.common.PasswordStore;
import weblogic.jms.forwarder.SessionRuntimeContext;
import weblogic.security.subject.AbstractSubject;

public final class SessionRuntimeContextImpl
implements SessionRuntimeContext {
    private static final char[] key = new char[]{'S', 'r', 'C', 'i', ' ', 'S', 'a', 'F', '5', ' ', 'n'};
    private String name;
    private Context providerContext;
    private Connection connection;
    private Session session;
    private boolean isForLocalCluster;
    private String loginUrl;
    private AbstractSubject subject;
    private boolean forceResolveDNS = false;
    private String username;
    private PasswordStore passwordStore = new PasswordStore(key);
    private Object passwordHandle;

    public SessionRuntimeContextImpl(String string, Context context, String string2, Connection connection, Session session, boolean bl, AbstractSubject abstractSubject) {
        this.name = string;
        this.providerContext = context;
        this.loginUrl = string2;
        this.connection = connection;
        this.session = session;
        this.isForLocalCluster = bl;
        this.subject = abstractSubject;
    }

    public SessionRuntimeContextImpl(String string, String string2, String string3, String string4) throws NamingException, JMSException {
        if (string == null) {
            this.providerContext = new InitialContext();
            this.isForLocalCluster = true;
        } else {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            hashtable.put("java.naming.provider.url", string);
            hashtable.put("java.naming.security.principal", string2);
            hashtable.put("java.naming.security.credentials", string3);
            this.providerContext = new InitialContext(hashtable);
        }
        this.connection = (Connection)this.providerContext.lookup(string4);
        this.session = this.connection.createSession(false, 1);
    }

    public SessionRuntimeContextImpl(String string, Context context, String string2, Connection connection, Session session, boolean bl, AbstractSubject abstractSubject, String string3, String string4, boolean bl2) {
        this.name = string;
        this.providerContext = context;
        this.loginUrl = string2;
        this.connection = connection;
        this.session = session;
        this.isForLocalCluster = bl;
        this.subject = abstractSubject;
        this.username = string3;
        this.setPassword(string4);
        this.forceResolveDNS = bl2;
    }

    private void setPassword(String string) {
        if (this.passwordHandle != null) {
            this.passwordStore.removePassword(this.passwordHandle);
            this.passwordHandle = null;
        }
        try {
            this.passwordHandle = this.passwordStore.storePassword(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError((Object)generalSecurityException);
        }
    }

    public String getPassword() {
        String string = null;
        if (this.passwordHandle != null) {
            try {
                string = (String)this.passwordStore.retrievePassword(this.passwordHandle);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getUsername() {
        return this.username;
    }

    public String getName() {
        return this.name;
    }

    public boolean getForceResolveDNS() {
        return this.forceResolveDNS;
    }

    public synchronized Context getProviderContext() {
        return this.providerContext;
    }

    public synchronized void setProviderContext(Context context) {
        this.providerContext = context;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public synchronized Connection getJMSConnection() {
        return this.connection;
    }

    public synchronized Session getJMSSession() {
        return this.session;
    }

    public boolean isForLocalCluster() {
        return this.isForLocalCluster;
    }

    public synchronized void refresh(Context context, Connection connection, Session session, AbstractSubject abstractSubject) {
        this.providerContext = context;
        this.connection = connection;
        this.session = session;
        this.subject = abstractSubject;
    }

    public synchronized AbstractSubject getSubject() {
        return this.subject;
    }

    public synchronized void setSubject(AbstractSubject abstractSubject) {
        this.subject = abstractSubject;
    }
}

