/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.jms.backend.BEBrowserCloseRequest;
import weblogic.jms.backend.BEBrowserGetEnumerationRequest;
import weblogic.jms.common.JMSBrowserGetEnumerationResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.frontend.FEBrowserCloseRequest;
import weblogic.jms.frontend.FEBrowserGetEnumerationRequest;
import weblogic.jms.frontend.FEConnection;
import weblogic.jms.frontend.FEEnumeration;
import weblogic.jms.frontend.FESession;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;

public final class FEBrowser
implements Invocable {
    private final JMSID browserId;
    private final JMSDispatcher dispatcher;
    private final FEConnection connection;
    private final FESession session;
    private final InvocableMonitor invocableMonitor;
    private final HashMap enumerations = new HashMap();

    public FEBrowser(FEConnection fEConnection, FESession fESession, JMSID jMSID, JMSDispatcher jMSDispatcher) {
        this.connection = fEConnection;
        this.session = fESession;
        this.browserId = jMSID;
        this.dispatcher = jMSDispatcher;
        this.invocableMonitor = fESession.getInvocableMonitor();
    }

    public JMSID getJMSID() {
        return this.browserId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    FEConnection getConnection() {
        return this.connection;
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int close(FEBrowserCloseRequest fEBrowserCloseRequest) throws JMSException {
        JMSException jMSException;
        block19: {
            jMSException = null;
            switch (fEBrowserCloseRequest.getState()) {
                case 0: {
                    BEBrowserCloseRequest bEBrowserCloseRequest = new BEBrowserCloseRequest(this.browserId);
                    FEBrowserCloseRequest fEBrowserCloseRequest2 = fEBrowserCloseRequest;
                    synchronized (fEBrowserCloseRequest2) {
                        fEBrowserCloseRequest.rememberChild(bEBrowserCloseRequest);
                        fEBrowserCloseRequest.setState(1);
                    }
                    try {
                        fEBrowserCloseRequest.dispatchAsync(this.dispatcher, (Request)bEBrowserCloseRequest);
                    }
                    catch (DispatcherException dispatcherException) {
                        throw new weblogic.jms.common.JMSException("Error closing browser", (Throwable)dispatcherException);
                    }
                    return fEBrowserCloseRequest.getState();
                }
            }
            try {
                fEBrowserCloseRequest.useChildResult(VoidResponse.class);
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) break block19;
                jMSException = jMSException2;
            }
        }
        FEBrowser fEBrowser = this;
        synchronized (fEBrowser) {
            for (FEEnumeration fEEnumeration : ((HashMap)this.enumerations.clone()).values()) {
                try {
                    this.enumerationRemove(fEEnumeration.getJMSID());
                }
                catch (JMSException jMSException3) {
                    if (jMSException != null) continue;
                    jMSException = jMSException3;
                }
            }
        }
        if (this.session == null) {
            this.connection.browserRemove(this.browserId);
        } else {
            this.session.browserRemove(this.browserId);
        }
        if (jMSException != null) {
            throw jMSException;
        }
        return Integer.MAX_VALUE;
    }

    private synchronized void enumerationAdd(FEEnumeration fEEnumeration) throws JMSException {
        if (this.enumerations.put(fEEnumeration.getJMSID(), fEEnumeration) == null) {
            InvocableManagerDelegate.delegate.invocableAdd(12, fEEnumeration);
        }
    }

    synchronized void enumerationRemove(JMSID jMSID) throws JMSException {
        if (this.enumerations.remove(jMSID) == null) {
            throw new weblogic.jms.common.JMSException("Enumeration not found, " + jMSID);
        }
        InvocableManagerDelegate.delegate.invocableRemove(12, jMSID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Request request) throws JMSException {
        FEBrowserGetEnumerationRequest fEBrowserGetEnumerationRequest = (FEBrowserGetEnumerationRequest)request;
        switch (fEBrowserGetEnumerationRequest.getState()) {
            case 0: {
                BEBrowserGetEnumerationRequest bEBrowserGetEnumerationRequest = new BEBrowserGetEnumerationRequest(this.browserId);
                FEBrowserGetEnumerationRequest fEBrowserGetEnumerationRequest2 = fEBrowserGetEnumerationRequest;
                synchronized (fEBrowserGetEnumerationRequest2) {
                    fEBrowserGetEnumerationRequest.rememberChild(bEBrowserGetEnumerationRequest);
                    fEBrowserGetEnumerationRequest.setState(1);
                }
                try {
                    fEBrowserGetEnumerationRequest.dispatchAsync(this.dispatcher, (Request)bEBrowserGetEnumerationRequest);
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error getting enumeration", (Throwable)dispatcherException);
                }
                return fEBrowserGetEnumerationRequest.getState();
            }
        }
        JMSBrowserGetEnumerationResponse jMSBrowserGetEnumerationResponse = (JMSBrowserGetEnumerationResponse)fEBrowserGetEnumerationRequest.useChildResult(JMSBrowserGetEnumerationResponse.class);
        this.enumerationAdd(new FEEnumeration(this, jMSBrowserGetEnumerationResponse.getEnumerationId(), this.dispatcher));
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pushException(Request request) throws JMSException {
        JMSPushExceptionRequest jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
        JMSPushExceptionRequest jMSPushExceptionRequest2 = new JMSPushExceptionRequest(22, this.browserId, jMSPushExceptionRequest.getException());
        if (this.session != null) {
            JMSServerUtilities.anonDispatchNoReply(jMSPushExceptionRequest2, this.session.getConnection().getClientDispatcher());
        } else if (this.connection != null) {
            JMSServerUtilities.anonDispatchNoReply(jMSPushExceptionRequest2, this.connection.getClientDispatcher());
        }
        FEBrowser fEBrowser = this;
        synchronized (fEBrowser) {
            for (FEEnumeration fEEnumeration : ((HashMap)this.enumerations.clone()).values()) {
                this.enumerationRemove(fEEnumeration.getJMSID());
            }
        }
        if (this.session == null) {
            this.connection.browserRemove(this.browserId);
        } else {
            this.session.browserRemove(this.browserId);
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 267: {
                return this.close((FEBrowserCloseRequest)request);
            }
            case 779: {
                return this.enumerate(request);
            }
            case 15371: {
                return this.pushException(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + this.getClass().getName() + "." + request.getMethodId());
    }
}

