/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.SingularAggregatable;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.jms.frontend.FEConnection;

public final class FEClientIDSingularAggregatable
extends SingularAggregatable
implements Externalizable {
    static final long serialVersionUID = 9144798830174213957L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private String clientID;
    private JMSID feConnectionID;

    public FEClientIDSingularAggregatable(String string, JMSID jMSID) {
        this.clientID = string;
        this.feConnectionID = jMSID;
    }

    public final void hadConflict(boolean bl) {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("FEClientIDSingularAggregatable.hadConflict clientId = " + this.toString() + " didWin=" + bl);
        }
        if (bl) {
            return;
        }
        try {
            Invocable invocable = (Invocable)InvocableManagerDelegate.delegate.invocableFind(7, this.feConnectionID);
            if (!(invocable instanceof FEConnection)) {
                return;
            }
            FEConnection fEConnection = (FEConnection)invocable;
            fEConnection.close(false, new ConsumerClosedException(null, "ClientID conflict, " + this.clientID));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public final String toString() {
        return new String("FEClientIDSingularAggregatable(" + super.toString() + ":" + this.clientID + ")");
    }

    public FEClientIDSingularAggregatable() {
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.clientID);
        this.feConnectionID.writeExternal(objectOutput);
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.clientID = objectInput.readUTF();
        this.feConnectionID = new JMSID();
        this.feConnectionID.readExternal(objectInput);
    }
}

