/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEBrowserCreateRequest;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEConnectionConsumerCloseRequest;
import weblogic.jms.backend.BEConnectionConsumerCommon;
import weblogic.jms.backend.BEConnectionConsumerCreateRequest;
import weblogic.jms.backend.BEConnectionStartRequest;
import weblogic.jms.backend.BEConnectionStopRequest;
import weblogic.jms.backend.BEDestinationCreateRequest;
import weblogic.jms.backend.BEServerSessionPoolCreateRequest;
import weblogic.jms.backend.BETemporaryDestinationDestroyRequest;
import weblogic.jms.client.JMSConnectionConsumer;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DestinationPeerGoneAdapter;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.InvalidClientIDException;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSConnectionConsumerCreateResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.PeerVersionable;
import weblogic.jms.common.SingularAggregatable;
import weblogic.jms.common.SingularAggregatableManager;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.frontend.FEBrowser;
import weblogic.jms.frontend.FEBrowserCreateRequest;
import weblogic.jms.frontend.FEClientIDSingularAggregatable;
import weblogic.jms.frontend.FEConnectionConsumerCloseRequest;
import weblogic.jms.frontend.FEConnectionConsumerCreateRequest;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.jms.frontend.FEConnectionRuntimeDelegate;
import weblogic.jms.frontend.FEConnectionSetClientIdRequest;
import weblogic.jms.frontend.FEConsumer;
import weblogic.jms.frontend.FEDDHandler;
import weblogic.jms.frontend.FEManager;
import weblogic.jms.frontend.FEServerSessionPoolCreateRequest;
import weblogic.jms.frontend.FESession;
import weblogic.jms.frontend.FESessionCreateRequest;
import weblogic.jms.frontend.FESessionCreateResponse;
import weblogic.jms.frontend.FETempDestinationFactory;
import weblogic.jms.frontend.FETemporaryDestinationCreateRequest;
import weblogic.jms.frontend.FETemporaryDestinationCreateResponse;
import weblogic.jms.frontend.FETemporaryDestinationDestroyRequest;
import weblogic.jms.frontend.FrontEnd;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSSessionRuntimeMBean;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;

public final class FEConnection
implements JMSPeerGoneListener,
Invocable,
PeerVersionable {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static final long serialVersionUID = -3238866726804665330L;
    private long startStopSequenceNumber;
    private final HashMap temporaryDestinations = new HashMap();
    private final HashMap connectionConsumers = new HashMap();
    private final HashMap sessions = new HashMap();
    private final HashMap browsers = new HashMap();
    public static final String JMS_CONNECTION_CLIENTID = "weblogic.jms.connection.clientid";
    private boolean allowedToSetClientId = true;
    private boolean closed = false;
    private JMSDispatcher clientDispatcher;
    private final FEConnectionFactory connectionFactory;
    private final String mbeanName;
    private final JMSID connectionId;
    private String clientId;
    private int clientIdPolicy;
    private int subscriptionSharingPolicy;
    private final int deliveryMode;
    private final FrontEnd frontEnd;
    private final int priority;
    private final long timeToDeliver;
    private final long timeToLive;
    private final long sendTimeout;
    private final long redeliveryDelay;
    private final boolean userTransactionsEnabled;
    private final boolean allowCloseInOnMessage;
    private final long transactionTimeout;
    private final int messagesMaximum;
    private final int overrunPolicy;
    private final int acknowledgePolicy;
    private final boolean loadBalancingEnabled;
    private final boolean serverAffinityEnabled;
    private final String unitOfOrder;
    private final boolean isLocal;
    private boolean stopped = true;
    private String clientAddress = null;
    private static TransactionManager tranManager;
    private final InvocableMonitor invocableMonitor;
    private int state = 0;
    private byte peerVersion;
    private FEConnectionRuntimeDelegate myRuntimeDelegate;
    private int compressionThreshold;
    private transient int refCount;

    public final int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FEConnection(FEConnectionFactory fEConnectionFactory, String string, JMSID jMSID, JMSDispatcher jMSDispatcher, int n, int n2, long l, long l2, long l3, long l4, String string2, int n3, int n4, long l5, boolean bl, boolean bl2, int n5, int n6, int n7, boolean bl3, boolean bl4, String string3, int n8) throws JMSException, ManagementException {
        this.connectionFactory = fEConnectionFactory;
        this.frontEnd = fEConnectionFactory.getFrontEnd();
        this.mbeanName = string;
        this.connectionId = jMSID;
        this.clientDispatcher = jMSDispatcher;
        this.deliveryMode = n;
        this.priority = n2;
        this.timeToDeliver = l;
        this.timeToLive = l2;
        this.sendTimeout = l3;
        this.redeliveryDelay = l4;
        this.transactionTimeout = l5;
        this.userTransactionsEnabled = bl;
        this.allowCloseInOnMessage = bl2;
        this.messagesMaximum = n5;
        this.overrunPolicy = n6;
        this.acknowledgePolicy = n7;
        this.loadBalancingEnabled = bl3;
        this.serverAffinityEnabled = bl4;
        this.unitOfOrder = string3;
        this.compressionThreshold = n8;
        this.clientIdPolicy = n3;
        this.subscriptionSharingPolicy = n4;
        if (string2 != null) {
            this.setConnectionClientId(string2);
        }
        this.invocableMonitor = FrontEnd.getFrontEnd().getInvocableMonitor();
        jMSDispatcher.addDispatcherPeerGoneListener(this);
        if (jMSDispatcher.isLocal()) {
            this.isLocal = true;
            this.clientAddress = "local";
        } else {
            this.isLocal = false;
            this.clientAddress = ServerHelper.getClientAddress();
        }
        FEConnection fEConnection = this;
        synchronized (fEConnection) {
            if (tranManager == null) {
                tranManager = TxHelper.getTransactionManager();
            }
        }
        this.myRuntimeDelegate = new FEConnectionRuntimeDelegate(string, this, this.frontEnd.getService());
    }

    FEConnectionRuntimeDelegate getRuntimeDelegate() {
        return this.myRuntimeDelegate;
    }

    JMSID getConnectionId() {
        return this.connectionId;
    }

    int getOverrunPolicy() {
        return this.overrunPolicy;
    }

    int getAcknowledgePolicy() {
        return this.acknowledgePolicy;
    }

    int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    boolean isLocal() {
        return this.isLocal;
    }

    boolean isLoadBalancingEnabled() {
        return this.loadBalancingEnabled;
    }

    boolean isServerAffinityEnabled() {
        return this.serverAffinityEnabled;
    }

    synchronized long getStartStopSequenceNumber() {
        return this.startStopSequenceNumber;
    }

    int getPriority() {
        return this.priority;
    }

    int getDeliveryMode() {
        return this.deliveryMode;
    }

    long getTimeToDeliver() {
        return this.timeToDeliver;
    }

    long getTimeToLive() {
        return this.timeToLive;
    }

    long getSendTimeout() {
        return this.sendTimeout;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    boolean userTransactionsEnabled() {
        return this.userTransactionsEnabled;
    }

    boolean getAllowCloseInOnMessage() {
        return this.allowCloseInOnMessage;
    }

    long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    boolean getAttachJMSXUserID() {
        if (this.connectionFactory == null) {
            return false;
        }
        return this.connectionFactory.isAttachJMSXUserId();
    }

    String getUnitOfOrder() {
        return this.unitOfOrder;
    }

    JMSDispatcher getClientDispatcher() throws JMSException {
        JMSDispatcher jMSDispatcher = this.clientDispatcher;
        if (jMSDispatcher == null) {
            throw new IllegalStateException("Connection is closed");
        }
        return jMSDispatcher;
    }

    synchronized void markSuspending() {
        if (this.closed || 0 != (this.state & 0x12)) {
            return;
        }
        this.state = 2;
    }

    synchronized void markShuttingDown() {
        if (this.closed || 0 != (this.state & 0x10)) {
            return;
        }
        this.state = 8;
    }

    private synchronized boolean isSuspended() {
        return (this.state & 2) != 0;
    }

    synchronized void checkShutdownOrSuspended() throws JMSException {
        if (this.closed) {
            throw new weblogic.jms.common.JMSException("Connection is closed");
        }
        if ((this.state & 0x1A) != 0) {
            throw new weblogic.jms.common.JMSException("JMS server is shutdown or suspended");
        }
    }

    private synchronized void removeClientID() {
        if (this.clientId == null) {
            return;
        }
        String string = "weblogic.jms.connection.clientid." + this.clientId;
        try {
            SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
            singularAggregatableManager.singularUnbind(string);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.clientId = null;
    }

    void normalClose() throws JMSException {
        this.close(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(boolean bl, JMSException jMSException) throws JMSException {
        Throwable throwable = null;
        InvocableManagerDelegate.delegate.invocableRemove(7, this.connectionId);
        FEConnection fEConnection = this;
        synchronized (fEConnection) {
            block38: {
                block34: {
                    block35: {
                        try {
                            block37: {
                                Object object;
                                block36: {
                                    if (this.closed) {
                                        Object var13_5 = null;
                                        this.removeClientID();
                                        if (this.clientDispatcher == null) break block34;
                                        break block35;
                                    }
                                    this.allowedToSetClientId = false;
                                    this.closed = true;
                                    this.clientDispatcher.removeDispatcherPeerGoneListener(this);
                                    try {
                                        this.stop();
                                    }
                                    catch (JMSException jMSException2) {
                                        if (throwable != null) break block36;
                                        throwable = jMSException2;
                                    }
                                }
                                Iterator iterator = ((HashMap)this.sessions.clone()).values().iterator();
                                while (iterator.hasNext()) {
                                    try {
                                        ((FESession)iterator.next()).close(bl, 0L, jMSException);
                                    }
                                    catch (JMSException jMSException3) {
                                        if (throwable != null) continue;
                                        throwable = jMSException3;
                                    }
                                }
                                Response response = null;
                                iterator = ((HashMap)this.temporaryDestinations.clone()).values().iterator();
                                JMSDispatcher jMSDispatcher = null;
                                while (iterator.hasNext()) {
                                    Object var11_20;
                                    object = (DestinationImpl)iterator.next();
                                    try {
                                        try {
                                            jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(((DestinationImpl)object).getDispatcherId());
                                            response = jMSDispatcher.dispatchSync(new BETemporaryDestinationDestroyRequest(((DestinationImpl)object).getBackEndId().getId(), ((DestinationImpl)object).getDestinationId()));
                                        }
                                        catch (DispatcherException dispatcherException) {
                                            if (throwable == null) {
                                                throwable = dispatcherException;
                                            }
                                            var11_20 = null;
                                            if (!jMSDispatcher.isLocal()) {
                                                jMSDispatcher.removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter((DestinationImpl)object, null));
                                            }
                                            jMSDispatcher = null;
                                            continue;
                                        }
                                        catch (JMSException jMSException4) {
                                            if (throwable == null) {
                                                throwable = jMSException4;
                                            }
                                            var11_20 = null;
                                            if (!jMSDispatcher.isLocal()) {
                                                jMSDispatcher.removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter((DestinationImpl)object, null));
                                            }
                                            jMSDispatcher = null;
                                            continue;
                                        }
                                        var11_20 = null;
                                    }
                                    catch (Throwable throwable2) {
                                        var11_20 = null;
                                        if (!jMSDispatcher.isLocal()) {
                                            jMSDispatcher.removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter((DestinationImpl)object, null));
                                        }
                                        jMSDispatcher = null;
                                        throw throwable2;
                                    }
                                    if (!jMSDispatcher.isLocal()) {
                                        jMSDispatcher.removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter((DestinationImpl)object, null));
                                    }
                                    jMSDispatcher = null;
                                }
                                iterator = ((HashMap)this.connectionConsumers.clone()).values().iterator();
                                while (iterator.hasNext()) {
                                    try {
                                        object = (BEConnectionConsumerCommon)iterator.next();
                                        this.connectionConsumerClose(object.getJMSID());
                                    }
                                    catch (JMSException jMSException5) {
                                        if (throwable != null) continue;
                                        throwable = jMSException5;
                                    }
                                }
                                iterator = ((HashMap)this.browsers.clone()).values().iterator();
                                while (iterator.hasNext()) {
                                    try {
                                        this.browserRemove(((FEBrowser)iterator.next()).getJMSID());
                                    }
                                    catch (JMSException jMSException6) {
                                        if (throwable != null) continue;
                                        throwable = jMSException6;
                                    }
                                }
                                try {
                                    if (this.myRuntimeDelegate != null) {
                                        PrivilegedActionUtilities.unregister(this.myRuntimeDelegate, KERNEL_ID);
                                    }
                                }
                                catch (ManagementException managementException) {
                                    JMSLogger.logErrorUnregisteringFrontEndConnection((String)this.frontEnd.getMbeanName(), (Object)this, (Throwable)managementException);
                                    if (throwable != null) break block37;
                                    throwable = managementException;
                                }
                            }
                            if (throwable != null) {
                                if (!(throwable instanceof JMSException)) throw new weblogic.jms.common.JMSException("Error closing connection", throwable);
                                throw (JMSException)throwable;
                            }
                            break block38;
                        }
                        catch (Throwable throwable3) {
                            Object var13_7 = null;
                            this.removeClientID();
                            if (this.clientDispatcher != null) {
                                JMSDispatcherManager.removeDispatcherReference(this.clientDispatcher);
                                this.clientDispatcher = null;
                            }
                            this.myRuntimeDelegate = null;
                            throw throwable3;
                        }
                    }
                    JMSDispatcherManager.removeDispatcherReference(this.clientDispatcher);
                    this.clientDispatcher = null;
                }
                this.myRuntimeDelegate = null;
                return;
            }
            Object var13_6 = null;
            this.removeClientID();
            if (this.clientDispatcher != null) {
                JMSDispatcherManager.removeDispatcherReference(this.clientDispatcher);
                this.clientDispatcher = null;
            }
            this.myRuntimeDelegate = null;
            return;
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void start() throws JMSException {
        Object object;
        ++this.startStopSequenceNumber;
        this.stopped = false;
        this.allowedToSetClientId = false;
        Iterator iterator = this.sessions.values().iterator();
        HashMap<DispatcherId, Object> hashMap = new HashMap<DispatcherId, Object>();
        while (iterator.hasNext()) {
            Object object2 = object = (FESession)iterator.next();
            synchronized (object2) {
                HashMap hashMap2 = ((FESession)object).getBEDispatchers();
                for (JMSDispatcher jMSDispatcher : hashMap2.values()) {
                    hashMap.put(jMSDispatcher.getId(), jMSDispatcher);
                }
            }
        }
        if (!this.connectionConsumers.isEmpty()) {
            object = JMSDispatcherManager.getLocalDispatcher();
            hashMap.put(object.getId(), object);
        }
        object = null;
        for (Object object2 : hashMap.values()) {
            try {
                object2.dispatchSync(new BEConnectionStartRequest(this.connectionId, this.startStopSequenceNumber));
            }
            catch (Throwable throwable) {
                object = throwable;
            }
        }
        if (object != null) {
            throw new weblogic.jms.common.JMSException(((Throwable)object).toString(), (Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() throws JMSException {
        Object object;
        Object object2;
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("FEConnection.stop()");
        }
        ++this.startStopSequenceNumber;
        if (this.stopped) {
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("FEConnection.stop(): connection stopped already, returns");
            }
            return;
        }
        this.stopped = true;
        this.allowedToSetClientId = false;
        HashMap<DispatcherId, Object> hashMap = new HashMap<DispatcherId, Object>();
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            object = object2 = (FESession)iterator.next();
            synchronized (object) {
                HashMap hashMap2 = ((FESession)object2).getConsumersMap();
                for (FEConsumer fEConsumer : hashMap2.values()) {
                    JMSDispatcher jMSDispatcher = fEConsumer.getBackEndDispatcher();
                    try {
                        hashMap.put(jMSDispatcher.getId(), jMSDispatcher);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (!this.connectionConsumers.isEmpty()) {
            object2 = JMSDispatcherManager.getLocalDispatcher();
            hashMap.put(object2.getId(), object2);
        }
        iterator = hashMap.values().iterator();
        object2 = null;
        while (iterator.hasNext()) {
            object = (JMSDispatcher)iterator.next();
            try {
                object.dispatchSync(new BEConnectionStopRequest(this.connectionId, this.startStopSequenceNumber, this.isSuspended()));
            }
            catch (Exception exception) {
                object2 = exception;
            }
        }
        if (object2 != null) {
            throw new weblogic.jms.common.JMSException(((Throwable)object2).toString(), (Throwable)object2);
        }
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("FEConnection.stop() returns");
        }
    }

    private int sessionCreate(FESessionCreateRequest fESessionCreateRequest) throws JMSException {
        this.checkShutdownOrSuspended();
        JMSID jMSID = this.sessionCreateHelper(fESessionCreateRequest);
        FESession fESession = this.sessionFind(jMSID);
        fESessionCreateRequest.setResult(new FESessionCreateResponse(jMSID, fESession.getName()));
        fESessionCreateRequest.setState(Integer.MAX_VALUE);
        return fESessionCreateRequest.getState();
    }

    private JMSID sessionCreateHelper(FESessionCreateRequest fESessionCreateRequest) throws JMSException {
        FESession fESession;
        this.allowedToSetClientId = false;
        JMSID jMSID = this.getFrontEnd().getService().getNextId();
        String string = "session" + jMSID.getCounter();
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
        try {
            try {
                fESession = new FESession(this, string, jMSID, fESessionCreateRequest.getTransacted(), fESessionCreateRequest.getXASession(), fESessionCreateRequest.getAcknowledgeMode(), fESessionCreateRequest.getPushWorkManager());
            }
            catch (ManagementException managementException) {
                throw new weblogic.jms.common.JMSException("Error creating front end session: " + (Object)((Object)managementException), (Throwable)managementException);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        this.sessionAdd(fESession, this.myRuntimeDelegate);
        return jMSID;
    }

    private synchronized void sessionAdd(FESession fESession, FEConnectionRuntimeDelegate fEConnectionRuntimeDelegate) throws JMSException {
        if (fEConnectionRuntimeDelegate == null) {
            throw new weblogic.jms.common.JMSException("connection has already closed " + this.getJMSID());
        }
        if (this.sessions.put(fESession.getJMSID(), fESession) == null) {
            fEConnectionRuntimeDelegate.increaseSessionsTotalCount();
            fEConnectionRuntimeDelegate.setSessionsHighCount(Math.max(fEConnectionRuntimeDelegate.getSessionsHighCount(), (long)this.sessions.size()));
            InvocableManagerDelegate.delegate.invocableAdd(8, fESession);
        }
    }

    synchronized void sessionRemove(FESession fESession) {
        this.sessions.remove(fESession.getJMSID());
        InvocableManagerDelegate.delegate.invocableRemove(8, fESession.getJMSID());
    }

    private FESession sessionFind(JMSID jMSID) throws JMSException {
        FESession fESession = (FESession)this.sessions.get(jMSID);
        if (fESession != null) {
            return fESession;
        }
        throw new weblogic.jms.common.JMSException("Session not found");
    }

    private synchronized void addTemporaryDestination(DestinationImpl destinationImpl) {
        this.temporaryDestinations.put(destinationImpl.getDestinationId(), destinationImpl);
    }

    public synchronized DestinationImpl removeTemporaryDestination(JMSID jMSID) {
        return (DestinationImpl)this.temporaryDestinations.remove(jMSID);
    }

    public DestinationImpl createDestination(DestinationImpl destinationImpl) throws JMSException {
        return this.createDestination(destinationImpl.getServerName(), destinationImpl.getName(), destinationImpl.getType());
    }

    public DestinationImpl createDestination(String string, String string2, int n) throws JMSException {
        JMSServerId jMSServerId = FEManager.refreshBackEndId(string);
        DestinationImpl destinationImpl = this.frontEnd.findBackEndDestination(jMSServerId, string2);
        if (destinationImpl == null) {
            JMSDispatcher jMSDispatcher;
            try {
                jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(jMSServerId.getDispatcherId());
            }
            catch (DispatcherException dispatcherException) {
                throw new weblogic.jms.common.JMSException("Back End JMSDispatcher not found");
            }
            Response response = jMSDispatcher.dispatchSync(new BEDestinationCreateRequest(jMSServerId.getId(), string2, n, false));
            destinationImpl = ((JMSDestinationCreateResponse)response).getDestination();
            this.frontEnd.addBackEndDestination(jMSServerId, string2, destinationImpl, this);
            this.checkShutdownOrSuspended();
        }
        return destinationImpl;
    }

    private static String debugClassCastException(String string, String string2, Object object) {
        String string3 = "destination for jndi " + string + " has backend " + string2 + " found object <";
        string3 = object == null ? string3 + object + ">" : string3 + object.getClass().getName() + " " + object + ">";
        return string3;
    }

    private int serverSessionPoolCreate(Request request) throws JMSException {
        this.checkShutdownOrSuspended();
        FEServerSessionPoolCreateRequest fEServerSessionPoolCreateRequest = (FEServerSessionPoolCreateRequest)request;
        try {
            JMSDispatcher jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(fEServerSessionPoolCreateRequest.getBackEndId().getDispatcherId());
            Response response = jMSDispatcher.dispatchSync(new BEServerSessionPoolCreateRequest(fEServerSessionPoolCreateRequest.getBackEndId().getId(), this.connectionFactory.getJMSConnectionFactory(), fEServerSessionPoolCreateRequest.getSessionMaximum(), fEServerSessionPoolCreateRequest.getAcknowledgeMode(), fEServerSessionPoolCreateRequest.isTransacted(), fEServerSessionPoolCreateRequest.getMessageListenerClass(), fEServerSessionPoolCreateRequest.getClientData()));
            fEServerSessionPoolCreateRequest.setResult(response);
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException("Error creating server session pool", (Throwable)dispatcherException);
        }
        fEServerSessionPoolCreateRequest.setState(Integer.MAX_VALUE);
        return fEServerSessionPoolCreateRequest.getState();
    }

    private synchronized void connectionConsumerAdd(BEConnectionConsumerCommon bEConnectionConsumerCommon) throws JMSException {
        this.checkShutdownOrSuspended();
        if (this.connectionConsumers.put(bEConnectionConsumerCommon.getJMSID(), bEConnectionConsumerCommon) == null) {
            this.myRuntimeDelegate.increaseConnectionConsumersCurrentCount();
            if (this.myRuntimeDelegate.getConnectionConsumersCurrentCount() > this.myRuntimeDelegate.getConnectionConsumersHighCount()) {
                this.myRuntimeDelegate.increaseConnectionConsumersTotalCount();
            }
        }
    }

    private synchronized void connectionConsumerRemove(BEConnectionConsumerCommon bEConnectionConsumerCommon) {
        if (this.connectionConsumers.remove(bEConnectionConsumerCommon.getJMSID()) != null) {
            this.myRuntimeDelegate.decreaseConnectionConsumersCurrentCount();
        }
    }

    private synchronized BEConnectionConsumerCommon connectionConsumerFind(JMSID jMSID) throws JMSException {
        BEConnectionConsumerCommon bEConnectionConsumerCommon = (BEConnectionConsumerCommon)this.connectionConsumers.get(jMSID);
        if (bEConnectionConsumerCommon != null) {
            return bEConnectionConsumerCommon;
        }
        throw new weblogic.jms.common.JMSException("ConnectionConsumer not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int connectionConsumerCreate(Request request) throws JMSException {
        long l;
        boolean bl;
        this.checkShutdownOrSuspended();
        FEConnectionConsumerCreateRequest fEConnectionConsumerCreateRequest = (FEConnectionConsumerCreateRequest)request;
        DestinationImpl destinationImpl = fEConnectionConsumerCreateRequest.getDestination();
        ServerSessionPool serverSessionPool = fEConnectionConsumerCreateRequest.getServerSessionPool();
        FEDDHandler fEDDHandler = null;
        assert (destinationImpl != null);
        fEDDHandler = DDManager.findFEDDHandlerByDDName(destinationImpl.getName());
        if (fEDDHandler != null && (destinationImpl = fEDDHandler.connectionConsumerLoadBalance()) == null) {
            throw new JMSException("Destination not found on this server");
        }
        if (destinationImpl.getDestinationId() == null) {
            destinationImpl = this.createDestination(destinationImpl.getServerName(), destinationImpl.getName(), destinationImpl.getType());
        }
        JMSServerId jMSServerId = destinationImpl.getBackEndId();
        JMSID jMSID = destinationImpl.getDestinationId();
        Object object = this;
        synchronized (object) {
            bl = this.stopped;
            l = this.startStopSequenceNumber;
        }
        try {
            object = JMSDispatcherManager.dispatcherFindOrCreate(destinationImpl.getDispatcherId()).dispatchSync(new BEConnectionConsumerCreateRequest(jMSServerId, this.connectionId, serverSessionPool, this, jMSID, fEConnectionConsumerCreateRequest.isDurable(), fEConnectionConsumerCreateRequest.getMessageSelector(), fEConnectionConsumerCreateRequest.getMessagesMaximum(), bl, l));
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException("Error creating connection consumer", (Throwable)dispatcherException);
        }
        ConnectionConsumer connectionConsumer = ((JMSConnectionConsumerCreateResponse)object).getConnectionConsumer();
        this.connectionConsumerAdd((BEConnectionConsumerCommon)connectionConsumer);
        if (!this.isLocal) {
            connectionConsumer = new JMSConnectionConsumer(this.connectionId, serverSessionPool, ((BEConnectionConsumerCommon)connectionConsumer).getJMSID());
            ((JMSConnectionConsumerCreateResponse)object).setConnectionConsumer(connectionConsumer);
        }
        fEConnectionConsumerCreateRequest.setResult((Response)object);
        fEConnectionConsumerCreateRequest.setState(Integer.MAX_VALUE);
        return fEConnectionConsumerCreateRequest.getState();
    }

    private void connectionConsumerClose(Request request) throws JMSException {
        this.checkShutdownOrSuspended();
        FEConnectionConsumerCloseRequest fEConnectionConsumerCloseRequest = (FEConnectionConsumerCloseRequest)request;
        this.connectionConsumerClose(fEConnectionConsumerCloseRequest.getConnectionConsumerId());
    }

    private void connectionConsumerClose(JMSID jMSID) throws JMSException {
        BEConnectionConsumerCommon bEConnectionConsumerCommon = this.connectionConsumerFind(jMSID);
        this.connectionConsumerRemove(bEConnectionConsumerCommon);
        JMSDispatcher jMSDispatcher = ((BEConnection)InvocableManagerDelegate.delegate.invocableFind(15, this.connectionId)).getDispatcher();
        BEConnectionConsumerCloseRequest bEConnectionConsumerCloseRequest = new BEConnectionConsumerCloseRequest(this.connectionId, jMSID);
        jMSDispatcher.dispatchSync(bEConnectionConsumerCloseRequest);
    }

    public String getConnectionClientId() {
        return this.clientId;
    }

    public int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    private int setConnectionClientId(Request request) throws JMSException {
        this.checkShutdownOrSuspended();
        FEConnectionSetClientIdRequest fEConnectionSetClientIdRequest = (FEConnectionSetClientIdRequest)request;
        String string = fEConnectionSetClientIdRequest.getClientId();
        this.clientIdPolicy = fEConnectionSetClientIdRequest.getClientIdPolicy();
        String string2 = "weblogic.jms.connection.clientid." + string;
        if (this.clientIdPolicy == 1) {
            if (fEConnectionSetClientIdRequest.getState() == 0) {
                this.checkIfAllowedToSetClientID();
            }
            this.clientId = string;
            fEConnectionSetClientIdRequest.setResult(new VoidResponse());
            return Integer.MAX_VALUE;
        }
        SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
        switch (fEConnectionSetClientIdRequest.getState()) {
            case 0: {
                this.checkIfAllowedToSetClientID();
                FEClientIDSingularAggregatable fEClientIDSingularAggregatable = new FEClientIDSingularAggregatable(string, this.connectionId);
                fEConnectionSetClientIdRequest.setFocascia(fEClientIDSingularAggregatable);
                fEConnectionSetClientIdRequest.setState(1);
                singularAggregatableManager.singularBindStart(string2, fEClientIDSingularAggregatable, fEConnectionSetClientIdRequest);
                return fEConnectionSetClientIdRequest.getState();
            }
            case 1: {
                String string3 = singularAggregatableManager.singularBindFinish((SingularAggregatable)fEConnectionSetClientIdRequest.getFocascia(), fEConnectionSetClientIdRequest);
                if (string3 != null) {
                    throw new InvalidClientIDException("Client id, " + string + ", is in use.  The reason for rejection is \"" + string3 + "\"");
                }
                this.clientId = string;
                if (fEConnectionSetClientIdRequest.hasResults()) {
                    fEConnectionSetClientIdRequest.getResult();
                    fEConnectionSetClientIdRequest.setResult(new VoidResponse());
                }
                return Integer.MAX_VALUE;
            }
        }
        throw new JMSException("Unknown state: " + fEConnectionSetClientIdRequest.getState());
    }

    private void checkIfAllowedToSetClientID() throws IllegalStateException {
        if (this.clientId != null) {
            throw new IllegalStateException("ClientID has already been set");
        }
        if (!this.allowedToSetClientId) {
            throw new IllegalStateException("ClientID needs to be set first thing after creating connection");
        }
    }

    private void setConnectionClientId(String string) throws JMSException {
        this.checkIfAllowedToSetClientID();
        if (this.clientIdPolicy == 0) {
            String string2 = "weblogic.jms.connection.clientid." + string;
            FEClientIDSingularAggregatable fEClientIDSingularAggregatable = new FEClientIDSingularAggregatable(string, this.connectionId);
            SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
            String string3 = singularAggregatableManager.singularBind(string2, fEClientIDSingularAggregatable);
            if (string3 != null) {
                throw new InvalidClientIDException("Client id, " + string + ", is in use.  The reason for rejection is \"" + string3 + "\"");
            }
        }
        this.clientId = string;
    }

    public String getSubscriptionSharingPolicy() {
        return FEConnectionFactory.getSubscriptionSharingPolicyAsString(this.subscriptionSharingPolicy);
    }

    public int getSubscriptionSharingPolicyAsInt() {
        return this.subscriptionSharingPolicy;
    }

    public String toString() {
        return this.mbeanName;
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        AuthenticatedSubject authenticatedSubject;
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("FEConnection.jmsPeerGone()");
        }
        if ((authenticatedSubject = JMSSecurityHelper.getCurrentSubject()) == null || JMSSecurityHelper.isServerIdentity(authenticatedSubject)) {
            authenticatedSubject = SubjectUtils.getAnonymousSubject();
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
        try {
            try {
                this.close(true, null);
            }
            catch (JMSException jMSException) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("peer gone exception", (Throwable)jMSException);
                }
                Object var6_5 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
    }

    public FrontEnd getFrontEnd() {
        return this.frontEnd;
    }

    public synchronized HashMap getSessionMap() {
        return this.sessions;
    }

    public synchronized HashMap getBrowserMap() {
        return this.browsers;
    }

    public synchronized HashMap getConnectionConsumerMap() {
        return this.connectionConsumers;
    }

    public synchronized HashMap getTemporaryDestinationMap() {
        return this.temporaryDestinations;
    }

    public JMSSessionRuntimeMBean[] getSessions() {
        return this.myRuntimeDelegate.getSessions();
    }

    public long getSessionsCurrentCount() {
        return this.myRuntimeDelegate.getSessionsCurrentCount();
    }

    public long getSessionsHighCount() {
        return this.myRuntimeDelegate.getSessionsHighCount();
    }

    public long getSessionsTotalCount() {
        return this.myRuntimeDelegate.getSessionsTotalCount();
    }

    public synchronized void setPeerVersion(byte by) {
        this.peerVersion = by;
    }

    public synchronized byte getPeerVersion() {
        return this.peerVersion;
    }

    public void finalize() {
        try {
            super.finalize();
            this.removeClientID();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int destroyTemporaryDestination(Request request) throws JMSException {
        this.checkShutdownOrSuspended();
        DestinationImpl destinationImpl = null;
        FETemporaryDestinationDestroyRequest fETemporaryDestinationDestroyRequest = (FETemporaryDestinationDestroyRequest)request;
        switch (fETemporaryDestinationDestroyRequest.getState()) {
            case 0: {
                destinationImpl = (DestinationImpl)this.temporaryDestinations.get(fETemporaryDestinationDestroyRequest.getDestinationId());
                if (destinationImpl == null) {
                    fETemporaryDestinationDestroyRequest.setResult(new VoidResponse());
                    fETemporaryDestinationDestroyRequest.setState(Integer.MAX_VALUE);
                    return Integer.MAX_VALUE;
                }
                BETemporaryDestinationDestroyRequest bETemporaryDestinationDestroyRequest = new BETemporaryDestinationDestroyRequest(destinationImpl.getBackEndId().getId(), fETemporaryDestinationDestroyRequest.getDestinationId());
                FETemporaryDestinationDestroyRequest fETemporaryDestinationDestroyRequest2 = fETemporaryDestinationDestroyRequest;
                synchronized (fETemporaryDestinationDestroyRequest2) {
                    fETemporaryDestinationDestroyRequest.rememberChild(bETemporaryDestinationDestroyRequest);
                    fETemporaryDestinationDestroyRequest.setState(1);
                }
                try {
                    fETemporaryDestinationDestroyRequest.setDispatcher(JMSDispatcherManager.dispatcherFindOrCreate(destinationImpl.getDispatcherId()));
                    fETemporaryDestinationDestroyRequest.dispatchAsync(fETemporaryDestinationDestroyRequest.getDispatcher(), (Request)bETemporaryDestinationDestroyRequest);
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error deleting temporary destination", (Throwable)dispatcherException);
                }
                return fETemporaryDestinationDestroyRequest.getState();
            }
        }
        fETemporaryDestinationDestroyRequest.useChildResult(VoidResponse.class);
        destinationImpl = this.removeTemporaryDestination(fETemporaryDestinationDestroyRequest.getDestinationId());
        if (!fETemporaryDestinationDestroyRequest.getDispatcher().isLocal()) {
            fETemporaryDestinationDestroyRequest.getDispatcher().removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter(destinationImpl, null));
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createTemporaryDestination(Request request) throws JMSException {
        this.checkShutdownOrSuspended();
        FETempDestinationFactory fETempDestinationFactory = FEManager.getTemporaryDestinationFactory();
        DestinationImpl destinationImpl = null;
        Object object = this;
        synchronized (object) {
            destinationImpl = (DestinationImpl)fETempDestinationFactory.createTempDestination(JMSDispatcherManager.getLocalDispatcher().getId(), this.getJMSID(), this.stopped, ((FETemporaryDestinationCreateRequest)request).getDestType(), this.startStopSequenceNumber, this.getAddressAndMBeanInfo());
        }
        this.addTemporaryDestination(destinationImpl);
        try {
            object = JMSDispatcherManager.dispatcherFindOrCreate(destinationImpl.getDispatcherId());
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException("Error creating temporary destination", (Throwable)dispatcherException);
        }
        if (!object.isLocal()) {
            object.addDispatcherPeerGoneListener(new DestinationPeerGoneAdapter(destinationImpl, this));
        }
        request.setState(Integer.MAX_VALUE);
        request.setResult(new FETemporaryDestinationCreateResponse(destinationImpl));
        return Integer.MAX_VALUE;
    }

    private synchronized void browserAdd(FEBrowser fEBrowser) throws JMSException {
        if (this.browsers.put(fEBrowser.getJMSID(), fEBrowser) == null) {
            InvocableManagerDelegate.delegate.invocableAdd(11, fEBrowser);
            this.myRuntimeDelegate.setBrowsersHighCount(Math.max(this.myRuntimeDelegate.getBrowsersHighCount(), (long)this.browsers.size()));
            this.myRuntimeDelegate.increaseBrowsersTotalCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int browserCreate(Request request) throws JMSException {
        this.checkShutdownOrSuspended();
        FEBrowserCreateRequest fEBrowserCreateRequest = (FEBrowserCreateRequest)request;
        switch (fEBrowserCreateRequest.getState()) {
            case 0: {
                DestinationImpl destinationImpl = fEBrowserCreateRequest.getDestination();
                FEDDHandler fEDDHandler = null;
                assert (destinationImpl != null);
                fEDDHandler = DDManager.findFEDDHandlerByDDName(destinationImpl.getName());
                if (fEDDHandler != null) {
                    destinationImpl = fEDDHandler.consumerLoadBalance(null);
                }
                BEBrowserCreateRequest bEBrowserCreateRequest = new BEBrowserCreateRequest(null, destinationImpl.getDestinationId(), fEBrowserCreateRequest.getMessageSelector());
                FEBrowserCreateRequest fEBrowserCreateRequest2 = fEBrowserCreateRequest;
                synchronized (fEBrowserCreateRequest2) {
                    fEBrowserCreateRequest.rememberChild(bEBrowserCreateRequest);
                    fEBrowserCreateRequest.setState(1);
                }
                try {
                    fEBrowserCreateRequest.setDispatcher(JMSDispatcherManager.dispatcherFindOrCreate(destinationImpl.getDispatcherId()));
                    fEBrowserCreateRequest.dispatchAsync(fEBrowserCreateRequest.getDispatcher(), (Request)bEBrowserCreateRequest);
                    break;
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error creating browser", (Throwable)dispatcherException);
                }
            }
            case 1: {
                JMSBrowserCreateResponse jMSBrowserCreateResponse = (JMSBrowserCreateResponse)fEBrowserCreateRequest.useChildResult(JMSBrowserCreateResponse.class);
                FEBrowser fEBrowser = new FEBrowser(this, null, jMSBrowserCreateResponse.getBrowserId(), fEBrowserCreateRequest.getDispatcher());
                this.browserAdd(fEBrowser);
            }
        }
        return fEBrowserCreateRequest.getState();
    }

    synchronized void browserRemove(JMSID jMSID) throws JMSException {
        if (this.browsers.remove(jMSID) == null) {
            throw new weblogic.jms.common.JMSException("Browser not found, " + jMSID);
        }
        InvocableManagerDelegate.delegate.invocableRemove(11, jMSID);
    }

    String getAddressAndMBeanInfo() {
        return this.clientAddress + "|" + JMSService.getJMSService().getMbeanName();
    }

    String getAddress() {
        return this.clientAddress.substring(1);
    }

    public JMSID getJMSID() {
        return this.connectionId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 7687: {
                return this.createTemporaryDestination(request);
            }
            case 7431: {
                return this.destroyTemporaryDestination(request);
            }
            case 5895: {
                return this.serverSessionPoolCreate(request);
            }
            case 1543: {
                return this.connectionConsumerCreate(request);
            }
            case 519: {
                return this.browserCreate(request);
            }
            case 6663: {
                return this.sessionCreate((FESessionCreateRequest)request);
            }
            case 1799: {
                return this.setConnectionClientId(request);
            }
            case 1287: {
                this.connectionConsumerClose(request);
                break;
            }
            case 1031: {
                this.checkShutdownOrSuspended();
                this.normalClose();
                break;
            }
            case 2055: {
                this.checkShutdownOrSuspended();
                this.start();
                break;
            }
            case 2311: {
                this.checkShutdownOrSuspended();
                this.stop();
                break;
            }
            default: {
                throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
            }
        }
        request.setResult(new VoidResponse());
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        Object object3;
        Object object22;
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Connection");
        xMLStreamWriter.writeAttribute("id", this.connectionId != null ? this.connectionId.toString() : "");
        xMLStreamWriter.writeAttribute("clientID", this.clientId != null ? this.clientId : "");
        xMLStreamWriter.writeAttribute("browsersCurrentCount", String.valueOf(this.browsers.size()));
        xMLStreamWriter.writeAttribute("deliveryMode", this.deliveryMode == 2 ? "persistent" : "non-persistent");
        xMLStreamWriter.writeAttribute("priority", String.valueOf(this.priority));
        xMLStreamWriter.writeAttribute("timeToDeliver", String.valueOf(this.timeToDeliver));
        xMLStreamWriter.writeAttribute("timeToLive", String.valueOf(this.timeToLive));
        xMLStreamWriter.writeAttribute("sendTimeout", String.valueOf(this.sendTimeout));
        xMLStreamWriter.writeAttribute("redeliveryDelay", String.valueOf(this.redeliveryDelay));
        xMLStreamWriter.writeAttribute("userTransactionsEnabled", String.valueOf(this.userTransactionsEnabled));
        xMLStreamWriter.writeAttribute("messagesMaximum", String.valueOf(this.messagesMaximum));
        xMLStreamWriter.writeAttribute("overrunPolicy", String.valueOf(this.overrunPolicy));
        xMLStreamWriter.writeAttribute("acknowledgePolicy", String.valueOf(this.acknowledgePolicy));
        xMLStreamWriter.writeAttribute("loadBalancingEnabled", String.valueOf(this.loadBalancingEnabled));
        xMLStreamWriter.writeAttribute("serverAffinityEnabled", String.valueOf(this.serverAffinityEnabled));
        xMLStreamWriter.writeAttribute("unifOfOrder", this.unitOfOrder != null ? this.unitOfOrder : "");
        xMLStreamWriter.writeAttribute("isLocal", String.valueOf(this.isLocal));
        xMLStreamWriter.writeAttribute("clientAddress", this.clientAddress != null ? this.clientAddress : "");
        xMLStreamWriter.writeAttribute("state", JMSService.getStateName(this.state));
        xMLStreamWriter.writeAttribute("peerVersion", String.valueOf(this.peerVersion));
        xMLStreamWriter.writeStartElement("Sessions");
        HashMap hashMap = (HashMap)this.sessions.clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(hashMap.size()));
        for (Object object22 : hashMap.values()) {
            ((FESession)object22).dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("ConnectionConsumers");
        object22 = (HashMap)this.connectionConsumers.clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(((HashMap)object22).size()));
        for (Object object3 : ((HashMap)object22).values()) {
            object3.dumpRef(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("TemporaryDestinations");
        object3 = (HashMap)this.temporaryDestinations.clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(((HashMap)object3).size()));
        for (DestinationImpl destinationImpl : ((HashMap)object3).values()) {
            JMSDiagnosticImageSource.dumpDestinationImpl(xMLStreamWriter, destinationImpl);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }
}

