/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FEConnectionConsumerCloseRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -7095833683630182045L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private JMSID connectionConsumerId;

    public FEConnectionConsumerCloseRequest(JMSID jMSID, JMSID jMSID2) {
        super(jMSID, 1287);
        this.connectionConsumerId = jMSID2;
    }

    public final JMSID getConnectionConsumerId() {
        return this.connectionConsumerId;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FEConnectionConsumerCloseRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.connectionConsumerId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.connectionConsumerId = new JMSID();
        this.connectionConsumerId.readExternal(objectInput);
    }
}

