/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.rmi.NoSuchObjectException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import weblogic.application.ModuleException;
import weblogic.common.internal.PeerInfo;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSXAConnection;
import weblogic.jms.client.JMSXAConnectionFactory;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.common.BeanHelper;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.frontend.FEConnection;
import weblogic.jms.frontend.FEConnectionFactoryImpl;
import weblogic.jms.frontend.FrontEnd;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.rmi.server.UnicastRemoteObject;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.StringUtils;

public final class FEConnectionFactory
implements JMSModuleManagedEntity,
ObjectChangeListener {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String EMPTY_STRING = "";
    public static final String DEFAULT_DELIVERY_MODE_STRING = "Persistent";
    public static final int DEFAULT_DELIVERY_MODE = 2;
    public static final int DEFAULT_PRIORITY = 4;
    public static final String DEFAULT_TIME_TO_DELIVER_STRING = "0";
    public static final long DEFAULT_TIME_TO_DELIVER = 0L;
    public static final long DEFAULT_TIME_TO_LIVE = 0L;
    public static final long DEFAULT_SEND_TIMEOUT = 10L;
    public static final long DEFAULT_REDELIVERY_DELAY = 0L;
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 3600;
    public static final int DEFAULT_MESSAGES_MAXIMUM = 10;
    public static final boolean DEFAULT_USER_TRANSACTIONS_ENABLED = true;
    public static final String DEFAULT_MESSAGE_OVERRUN_POLICY_STRING = "KeepOld";
    public static final int DEFAULT_MESSAGE_OVERRUN_POLICY = 0;
    public static final int DEFAULT_ACKNOWLEDGE_POLICY = 1;
    public static final int DEFAULT_FLOW_MINIMUM = 50;
    public static final int DEFAULT_FLOW_MAXIMUM = 500;
    public static final int DEFAULT_FLOW_INTERVAL = 60;
    public static final int DEFAULT_FLOW_STEPS = 10;
    public static final int DEFAULT_CLIENT_ID_POLICY = 0;
    public static final int DEFAULT_SAF_TX_TIMEOUT = Integer.getInteger("weblogic.SAFTXTimeout", 3600);
    private transient GenericBeanListener connectionFactoryBeanListener;
    private transient GenericBeanListener defaultDeliveryParamsBeanListener;
    private transient GenericBeanListener clientParamsBeanListener;
    private transient GenericBeanListener transactionParamsBeanListener;
    private transient GenericBeanListener flowControlParamsBeanListener;
    private transient GenericBeanListener loadBalancingParamsBeanListener;
    private transient GenericBeanListener securityParamsBeanListener;
    private String fullyQualifiedName;
    private JMSConnectionFactory globalBoundConnectionFactory;
    private JMSConnectionFactory localBoundConnectionFactory;
    private JMSConnectionFactory appBoundConnectionFactory;
    private JMSConnectionFactoryBean connectionFactoryBean = null;
    private boolean bound;
    private boolean localBound;
    private boolean applicationBound;
    private boolean defaultConnectionFactory = false;
    private final FrontEnd frontEnd;
    private String name;
    private String moduleName;
    private String EARModuleName;
    private String jndiName = "";
    private String localJNDIName = "";
    private Context EARNamingContext;
    private Object jndiNameRebindLock = new Object();
    private boolean didUnbind;
    private boolean defaultTargetingEnabled;
    private String deliveryMode;
    private int priority;
    private String timeToDeliver;
    private long timeToLive;
    private long sendTimeout;
    private long redeliveryDelay;
    private long transactionTimeout;
    private boolean xaConnectionFactoryEnabled;
    private String clientId;
    private String clientIdPolicy;
    private String subscriptionSharingPolicy;
    private boolean allowCloseInOnMessage;
    private int messagesMaximum;
    private String overrunPolicy;
    private String acknowledgePolicy;
    private int compressionThreshold = Integer.MAX_VALUE;
    private boolean flowControlEnabled;
    private int flowMinimum;
    private int flowMaximum;
    private int flowSteps;
    private int flowInterval;
    private boolean loadBalancingEnabled = true;
    private boolean serverAffinityEnabled = true;
    private boolean attachJMSXUserID = false;
    private String synchronousPrefetchMode = "disabled";
    private String oneWaySendMode = "disabled";
    private int oneWaySendWindowSize = 1;
    private String reconnectPolicy = JMSConstants.RECONNECT_POLICY_PRODUCER;
    private long reconnectBlockingMillis = 60000L;
    private long totalReconnectPeriodMillis = -1L;
    private String defaultUnitOfOrder;
    private final JMSID factoryId;
    private int state = 0;

    public FEConnectionFactory(FrontEnd frontEnd, String string, String string2, boolean bl, boolean bl2, String string3) {
        this(frontEnd, string, string2, bl, bl2, string3, true, true);
    }

    public FEConnectionFactory(FrontEnd frontEnd, String string, String string2, boolean bl, boolean bl2, String string3, boolean bl3, boolean bl4) {
        this.factoryId = frontEnd.getService().getNextId();
        this.frontEnd = frontEnd;
        this.name = string;
        this.jndiName = StringUtils.isEmptyString((String)string2) ? EMPTY_STRING : string2;
        this.jndiName = JMSServerUtilities.transformJNDIName(string2);
        this.setupDefaultDeliveryParams();
        this.setupDefaultClientParams();
        this.setupDefaultTransactionParams();
        this.setupDefaultFlowControlParams();
        this.setupDefaultLoadBalancingParams();
        this.setupDefaultSecurityParams();
        this.xaConnectionFactoryEnabled = bl2;
        this.allowCloseInOnMessage = bl;
        this.acknowledgePolicy = string3;
        this.serverAffinityEnabled = bl4;
        this.loadBalancingEnabled = bl3;
        this.setFullyQualifiedName(null);
        this.defaultConnectionFactory = true;
    }

    public FEConnectionFactory(FrontEnd frontEnd, JMSConnectionFactoryBean jMSConnectionFactoryBean, String string, String string2, Context context) {
        this.factoryId = frontEnd.getService().getNextId();
        this.frontEnd = frontEnd;
        this.EARModuleName = string;
        this.moduleName = string2;
        this.connectionFactoryBean = jMSConnectionFactoryBean;
        this.name = JMSBeanHelper.getDecoratedName(string2, jMSConnectionFactoryBean.getName());
        this.EARNamingContext = context;
    }

    private void setFullyQualifiedName(String string) {
        this.fullyQualifiedName = string;
    }

    private JMSConnectionFactory computeJMSConnectionFactory() {
        if (this.xaConnectionFactoryEnabled) {
            return new JMSXAConnectionFactory(new FEConnectionFactoryImpl(this), this.fullyQualifiedName);
        }
        return new JMSConnectionFactory(new FEConnectionFactoryImpl(this), this.fullyQualifiedName);
    }

    public void setupDefaultDeliveryParams() {
        this.deliveryMode = DEFAULT_DELIVERY_MODE_STRING;
        this.priority = 4;
        this.timeToDeliver = DEFAULT_TIME_TO_DELIVER_STRING;
        this.timeToLive = 0L;
        this.sendTimeout = 10L;
        this.redeliveryDelay = 0L;
    }

    public void setupDefaultClientParams() {
        this.messagesMaximum = 10;
        this.overrunPolicy = DEFAULT_MESSAGE_OVERRUN_POLICY_STRING;
        this.clientIdPolicy = "Restricted";
        this.subscriptionSharingPolicy = weblogic.management.configuration.JMSConstants.SUBSCRIPTION_EXCLUSIVE;
    }

    public void setupDefaultTransactionParams() {
        this.transactionTimeout = 3600L;
        this.xaConnectionFactoryEnabled = false;
    }

    public void setupDefaultFlowControlParams() {
        this.flowControlEnabled = true;
        this.flowMinimum = 50;
        this.flowMaximum = 500;
        this.flowInterval = 60;
        this.flowSteps = 10;
        this.oneWaySendMode = "disabled";
        this.oneWaySendWindowSize = 1;
    }

    public void setupDefaultLoadBalancingParams() {
        this.loadBalancingEnabled = true;
        this.serverAffinityEnabled = true;
    }

    public void setupDefaultSecurityParams() {
        this.attachJMSXUserID = false;
    }

    private void initialize() throws ModuleException {
        try {
            this.initializeBeanUpdateListeners();
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException.getMessage(), managementException);
        }
        try {
            this.valJNDIName(this.jndiName);
            this.valLocalJNDIName(this.localJNDIName);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException(beanUpdateRejectedException.getMessage(), beanUpdateRejectedException);
        }
    }

    JMSConnection connectionCreateInternal(DispatcherWrapper dispatcherWrapper, boolean bl) throws JMSException {
        FEConnection fEConnection;
        JMSDispatcher jMSDispatcher;
        this.checkShutdownOrSuspended();
        PeerInfo peerInfo = dispatcherWrapper.getPeerInfo();
        DispatcherWrapper dispatcherWrapper2 = JMSDispatcherManager.getLocalDispatcherWrapper();
        final JMSID jMSID = this.frontEnd.getService().getNextId();
        final String string = "connection" + jMSID.getCounter();
        try {
            jMSDispatcher = JMSDispatcherManager.addDispatcherReference(dispatcherWrapper);
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException(dispatcherException);
        }
        final int n = this.getDefaultDeliveryModeAsInt();
        final long l = this.transactionTimeout;
        final int n2 = this.messagesMaximum;
        final String string2 = this.clientId;
        try {
            fEConnection = (FEConnection)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ManagementException, JMSException {
                    return new FEConnection(FEConnectionFactory.this, string, jMSID, jMSDispatcher, n, FEConnectionFactory.this.priority, Long.parseLong(FEConnectionFactory.this.timeToDeliver), FEConnectionFactory.this.timeToLive, FEConnectionFactory.this.sendTimeout, FEConnectionFactory.this.redeliveryDelay, string2, FEConnectionFactory.this.getClientIdPolicyAsInt(), FEConnectionFactory.getSubscriptionSharingPolicyAsInt(FEConnectionFactory.this.subscriptionSharingPolicy), l, FEConnectionFactory.this.xaConnectionFactoryEnabled, FEConnectionFactory.this.allowCloseInOnMessage, n2, FEConnectionFactory.this.getMulticastOverrunPolicyAsInt(), FEConnectionFactory.this.getAcknowledgePolicyAsInt(), FEConnectionFactory.this.loadBalancingEnabled, FEConnectionFactory.this.serverAffinityEnabled, FEConnectionFactory.this.defaultUnitOfOrder, FEConnectionFactory.this.compressionThreshold);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            throw new weblogic.jms.common.JMSException("Error creating connection: " + string, (Throwable)exception);
        }
        InvocableManagerDelegate.delegate.invocableAdd(7, fEConnection);
        if (this.xaConnectionFactoryEnabled && bl) {
            return new JMSXAConnection(fEConnection.getJMSID(), fEConnection.getConnectionClientId(), this.getClientIdPolicyAsInt(), FEConnectionFactory.getSubscriptionSharingPolicyAsInt(this.subscriptionSharingPolicy), fEConnection.getDeliveryMode(), fEConnection.getPriority(), fEConnection.getTimeToDeliver(), fEConnection.getTimeToLive(), fEConnection.getSendTimeout(), fEConnection.getRedeliveryDelay(), fEConnection.getTransactionTimeout(), fEConnection.userTransactionsEnabled(), fEConnection.getAllowCloseInOnMessage(), fEConnection.getMessagesMaximum(), fEConnection.getOverrunPolicy(), fEConnection.getAcknowledgePolicy(), fEConnection.isLocal(), dispatcherWrapper2, this.flowControlEnabled, this.flowMinimum, this.flowMaximum, this.flowInterval, this.flowSteps, this.defaultUnitOfOrder, fEConnection, ManagementService.getRuntimeAccess(KERNEL_ID).getServerName(), fEConnection.getRuntimeDelegate().getName(), peerInfo, this.compressionThreshold, 0, 0, 1, WLConnectionImpl.validateAndConvertReconnectPolicy(this.reconnectPolicy), this.reconnectBlockingMillis, this.totalReconnectPeriodMillis);
        }
        return new JMSConnection(fEConnection.getJMSID(), fEConnection.getConnectionClientId(), this.getClientIdPolicyAsInt(), FEConnectionFactory.getSubscriptionSharingPolicyAsInt(this.subscriptionSharingPolicy), fEConnection.getDeliveryMode(), fEConnection.getPriority(), fEConnection.getTimeToDeliver(), fEConnection.getTimeToLive(), fEConnection.getSendTimeout(), fEConnection.getRedeliveryDelay(), fEConnection.getTransactionTimeout(), fEConnection.userTransactionsEnabled(), fEConnection.getAllowCloseInOnMessage(), fEConnection.getMessagesMaximum(), fEConnection.getOverrunPolicy(), fEConnection.getAcknowledgePolicy(), fEConnection.isLocal(), dispatcherWrapper2, this.flowControlEnabled, this.flowMinimum, this.flowMaximum, this.flowInterval, this.flowSteps, this.xaConnectionFactoryEnabled, this.defaultUnitOfOrder, fEConnection, ManagementService.getRuntimeAccess(KERNEL_ID).getServerName(), fEConnection.getRuntimeDelegate().getName(), peerInfo, this.compressionThreshold, JMSConnection.convertPrefetchMode(this.synchronousPrefetchMode), JMSService.getJMSService().getUse81StyleExecuteQueues() ? 0 : JMSConnection.convertOneWaySendMode(this.oneWaySendMode), this.oneWaySendWindowSize, WLConnectionImpl.validateAndConvertReconnectPolicy(this.reconnectPolicy), this.reconnectBlockingMillis, this.totalReconnectPeriodMillis);
    }

    private void globalbind(String string) throws JMSException {
        if (!this.bound && !StringUtils.isEmptyString((String)string)) {
            try {
                JMSConnectionFactory jMSConnectionFactory = this.computeJMSConnectionFactory();
                this.frontEnd.getService();
                PrivilegedActionUtilities.bindAsSU(JMSService.getContext(true), string, jMSConnectionFactory, KERNEL_ID);
                this.globalBoundConnectionFactory = jMSConnectionFactory;
                this.bound = true;
            }
            catch (NamingException namingException) {
                throw new weblogic.jms.common.JMSException("Error binding connection factory (name = " + this.name + ") to (jndi name = " + string + ")", (Throwable)namingException);
            }
        }
    }

    private void localbind(String string) throws JMSException {
        if (!this.localBound && !StringUtils.isEmptyString((String)string)) {
            try {
                JMSConnectionFactory jMSConnectionFactory = this.computeJMSConnectionFactory();
                this.frontEnd.getService();
                PrivilegedActionUtilities.bindAsSU(JMSService.getContext(false), string, jMSConnectionFactory, KERNEL_ID);
                this.localBound = true;
                this.localBoundConnectionFactory = jMSConnectionFactory;
            }
            catch (NamingException namingException) {
                throw new weblogic.jms.common.JMSException("Error binding connection factory (name = " + this.name + ") to (local jndi name = " + string + ")", (Throwable)namingException);
            }
        }
    }

    private String constructAppscopedJNDIName() {
        if (this.EARModuleName == null) {
            return null;
        }
        return this.EARModuleName + "#" + this.getEntityName();
    }

    private void appscopedbind() throws JMSException {
        String string = this.constructAppscopedJNDIName();
        if (this.applicationBound || string == null || this.EARNamingContext == null) {
            return;
        }
        try {
            JMSConnectionFactory jMSConnectionFactory = this.computeJMSConnectionFactory();
            PrivilegedActionUtilities.bindAsSU(this.EARNamingContext, string, jMSConnectionFactory, KERNEL_ID);
            this.applicationBound = true;
            this.appBoundConnectionFactory = jMSConnectionFactory;
        }
        catch (NamingException namingException) {
            throw new weblogic.jms.common.JMSException("Error binding connection factory (name = " + this.name + ") to (application jndi name = " + string + ")", (Throwable)namingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void globalunbind(String string, String string2) {
        Object object;
        this.frontEnd.getService();
        EventContext eventContext = (EventContext)JMSService.getContext(true);
        if (StringUtils.isEmptyString((String)string) || !this.bound) return;
        if (string2 != null) {
            try {
                eventContext.addNamingListener(string, 0, (NamingListener)this);
            }
            catch (NamingException namingException) {
                JMSLogger.logErrorEstablishingJNDIListener((String)this.name, (String)namingException.toString());
                return;
            }
            object = this.jndiNameRebindLock;
            synchronized (object) {
                this.didUnbind = false;
            }
        }
        PrivilegedActionUtilities.unbindAsSU(eventContext, string, KERNEL_ID);
        UnicastRemoteObject.unexportObject((Object)this.globalBoundConnectionFactory, (boolean)true);
        if (string2 != null) {
            object = this.jndiNameRebindLock;
            synchronized (object) {
                for (int i = 0; i < 15; ++i) {
                    try {
                        this.jndiNameRebindLock.wait(20000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.didUnbind) break;
                    JMSLogger.logInfoWaitForUnbind((String)this.name, (String)string, (String)string2);
                }
                if (!this.didUnbind) {
                    JMSLogger.logErrorWaitForUnbind((String)this.name, (String)string, (String)string2);
                }
            }
        }
        this.bound = false;
        Object var9_12 = null;
        if (string2 == null) return;
        try {
            eventContext.removeNamingListener(this);
            return;
        }
        catch (NamingException namingException) {
            JMSLogger.logErrorRemovingJNDIListener((String)this.name, (String)namingException.toString());
        }
        return;
        {
            catch (NoSuchObjectException noSuchObjectException) {
                Object var9_13 = null;
                if (string2 == null) return;
                try {
                    eventContext.removeNamingListener(this);
                    return;
                }
                catch (NamingException namingException) {
                    JMSLogger.logErrorRemovingJNDIListener((String)this.name, (String)namingException.toString());
                }
                return;
            }
            catch (NamingException namingException) {
                Object var9_14 = null;
                if (string2 == null) return;
                try {
                    eventContext.removeNamingListener(this);
                    return;
                }
                catch (NamingException namingException2) {
                    JMSLogger.logErrorRemovingJNDIListener((String)this.name, (String)namingException2.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (string2 == null) throw throwable;
            try {
                eventContext.removeNamingListener(this);
                throw throwable;
            }
            catch (NamingException namingException) {
                JMSLogger.logErrorRemovingJNDIListener((String)this.name, (String)namingException.toString());
            }
            throw throwable;
        }
    }

    private void localunbind(String string) {
        if (!StringUtils.isEmptyString((String)string) && this.localBound) {
            try {
                this.frontEnd.getService();
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(false), string, KERNEL_ID);
                UnicastRemoteObject.unexportObject((Object)this.localBoundConnectionFactory, (boolean)true);
                this.localBound = false;
            }
            catch (NoSuchObjectException noSuchObjectException) {
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private void appscopedunbind() {
        String string = this.constructAppscopedJNDIName();
        if (!this.applicationBound || string == null || this.EARNamingContext == null) {
            return;
        }
        try {
            PrivilegedActionUtilities.unbindAsSU(this.EARNamingContext, string, KERNEL_ID);
            UnicastRemoteObject.unexportObject((Object)this.appBoundConnectionFactory, (boolean)true);
            this.applicationBound = false;
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws JMSException {
        this.globalbind(this.jndiName);
        this.localbind(this.localJNDIName);
        this.appscopedbind();
        FEConnectionFactory fEConnectionFactory = this;
        synchronized (fEConnectionFactory) {
            this.state = 4;
        }
    }

    public void unbind() {
        this.globalunbind(this.jndiName, null);
        this.localunbind(this.localJNDIName);
        this.appscopedunbind();
    }

    synchronized void markSuspending() {
        if ((this.state & 0x1B) != 0) {
            return;
        }
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        FEConnectionFactory fEConnectionFactory = this;
        synchronized (fEConnectionFactory) {
            if (this.state == 1) {
                return;
            }
            this.state = 1;
        }
        this.unbind();
    }

    synchronized void markShuttingDown() {
        if ((this.state & 0x18) != 0) {
            return;
        }
        this.state = 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        FEConnectionFactory fEConnectionFactory = this;
        synchronized (fEConnectionFactory) {
            if (this.state == 16) {
                return;
            }
            this.state = 16;
        }
        this.unbind();
    }

    private synchronized void checkShutdownOrSuspended() throws JMSException {
        if ((this.state & 0x1B) != 0) {
            throw new weblogic.jms.common.JMSException("JMS server is shutdown or suspended");
        }
    }

    public FrontEnd getFrontEnd() {
        return this.frontEnd;
    }

    public JMSID getId() {
        return this.factoryId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getName() {
        return this.name;
    }

    public void setDefaultTargetingEnabled(boolean bl) {
        this.defaultTargetingEnabled = bl;
    }

    public boolean isDefaultTargetingEnabled() {
        return this.defaultTargetingEnabled;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void valJNDIName(String string) throws BeanUpdateRejectedException {
        String string2;
        Object object;
        if (StringUtils.isEmptyString((String)(string = JMSServerUtilities.transformJNDIName(string)))) {
            return;
        }
        if (this.state == 4 && this.jndiName != null && this.jndiName.equals(string)) {
            return;
        }
        Context context = JMSService.getContext();
        try {
            object = context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return;
        }
        catch (NamingException namingException) {
            throw new BeanUpdateRejectedException(namingException.getMessage(), (Throwable)namingException);
        }
        if (!(object instanceof JMSConnectionFactory)) {
            throw new BeanUpdateRejectedException("The proposed JNDI name \"" + string + "\" for connection factory \"" + this.name + "\" is already bound by another object of type \"" + object.getClass().getName() + "\"");
        }
        JMSConnectionFactory jMSConnectionFactory = (JMSConnectionFactory)object;
        String string3 = string2 = this.defaultConnectionFactory ? EMPTY_STRING : this.name;
        if (!jMSConnectionFactory.getFullyQualifiedName().equals(string2)) {
            throw new BeanUpdateRejectedException("The proposed JNDI name \"" + string + "\" for connection factory \"" + this.name + "\" is already bound by another connection factory \"" + jMSConnectionFactory.getFullyQualifiedName() + "\"");
        }
    }

    public void setJNDIName(String string) throws IllegalArgumentException {
        string = JMSServerUtilities.transformJNDIName(string);
        String string2 = this.jndiName;
        String string3 = this.jndiName = StringUtils.isEmptyString((String)string) ? EMPTY_STRING : string;
        if (this.state != 4) {
            return;
        }
        if (this.jndiName == EMPTY_STRING) {
            if (this.bound) {
                this.globalunbind(string2, this.jndiName);
            }
            return;
        }
        if (string2 == EMPTY_STRING || !this.jndiName.equals(string2)) {
            if (this.bound) {
                this.globalunbind(string2, this.jndiName);
            }
            try {
                this.globalbind(this.jndiName);
            }
            catch (JMSException jMSException) {
                JMSLogger.logErrorBindCF((String)this.name, (Exception)((Object)jMSException));
                this.frontEnd.connectionFactoryRemove(this);
                throw new IllegalArgumentException("Error binding connection factory name : " + this.name + "to jndi name: " + this.jndiName);
            }
        }
    }

    public String getLocalJNDIName() {
        return this.localJNDIName;
    }

    public void valLocalJNDIName(String string) throws BeanUpdateRejectedException {
        String string2;
        Object object;
        if (StringUtils.isEmptyString((String)(string = JMSServerUtilities.transformJNDIName(string)))) {
            return;
        }
        if (this.state == 4 && this.localJNDIName.equals(string)) {
            return;
        }
        Context context = JMSService.getContext();
        try {
            object = context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return;
        }
        catch (NamingException namingException) {
            throw new BeanUpdateRejectedException(namingException.getMessage(), (Throwable)namingException);
        }
        if (!(object instanceof JMSConnectionFactory)) {
            throw new BeanUpdateRejectedException("The proposed JNDI name " + string + " for connection factory " + this.name + " is already bound by another object of type " + (object == null ? "null" : object.getClass().getName()));
        }
        JMSConnectionFactory jMSConnectionFactory = (JMSConnectionFactory)object;
        String string3 = string2 = this.defaultConnectionFactory ? EMPTY_STRING : this.name;
        if (!jMSConnectionFactory.getFullyQualifiedName().equals(string2)) {
            throw new BeanUpdateRejectedException("The proposed JNDI name " + string + " for connection factory " + this.name + " is already bound by another connection factory " + jMSConnectionFactory.getFullyQualifiedName());
        }
    }

    public void setLocalJNDIName(String string) throws IllegalArgumentException {
        string = JMSServerUtilities.transformJNDIName(string);
        String string2 = this.localJNDIName;
        String string3 = this.localJNDIName = StringUtils.isEmptyString((String)string) ? EMPTY_STRING : string;
        if (this.state != 4) {
            return;
        }
        if (this.localJNDIName == EMPTY_STRING) {
            if (this.localBound) {
                this.localunbind(string2);
            }
            return;
        }
        if (string2 == EMPTY_STRING || !this.localJNDIName.equals(string2)) {
            if (this.localBound) {
                this.localunbind(string2);
            }
            try {
                this.localbind(this.localJNDIName);
            }
            catch (JMSException jMSException) {
                JMSLogger.logErrorBindCF((String)this.name, (Exception)((Object)jMSException));
                this.frontEnd.connectionFactoryRemove(this);
                throw new IllegalArgumentException("Error binding connection factory name : " + this.name + " to local jndi name: " + this.localJNDIName);
            }
        }
    }

    public String getDefaultDeliveryMode() {
        return this.deliveryMode;
    }

    public int getDefaultDeliveryModeAsInt() {
        int n = 2;
        if (this.deliveryMode == null || this.deliveryMode.equalsIgnoreCase("No-Delivery")) {
            n = 2;
        } else if (this.deliveryMode.equalsIgnoreCase(DEFAULT_DELIVERY_MODE_STRING)) {
            n = 2;
        } else if (this.deliveryMode.equalsIgnoreCase("Non-Persistent")) {
            n = 1;
        }
        return n;
    }

    public void setDefaultDeliveryMode(String string) throws IllegalArgumentException {
        if (string == null || string.equalsIgnoreCase("No-Delivery")) {
            this.deliveryMode = DEFAULT_DELIVERY_MODE_STRING;
            return;
        }
        if (!string.equalsIgnoreCase(DEFAULT_DELIVERY_MODE_STRING) && !string.equalsIgnoreCase("Non-Persistent")) {
            throw new IllegalArgumentException("Invalid delivery mode");
        }
        this.deliveryMode = string;
    }

    public int getDefaultPriority() {
        return this.priority;
    }

    public void setDefaultPriority(int n) {
        this.priority = n;
    }

    public long getDefaultTimeToDeliverAsLong() {
        return Long.parseLong(this.timeToDeliver);
    }

    public String getDefaultTimeToDeliver() {
        return this.timeToDeliver;
    }

    public void setDefaultTimeToDeliver(String string) {
        this.timeToDeliver = string;
    }

    public long getDefaultTimeToLive() {
        return this.timeToLive;
    }

    public void setDefaultTimeToLive(long l) {
        this.timeToLive = l;
    }

    public long getDefaultRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setDefaultRedeliveryDelay(long l) {
        this.redeliveryDelay = l;
    }

    public int getDefaultCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setDefaultCompressionThreshold(int n) {
        this.compressionThreshold = n;
    }

    public void setDefaultUnitOfOrder(String string) {
        this.defaultUnitOfOrder = string;
    }

    public String getDefaultUnitOfOrder() {
        return this.defaultUnitOfOrder;
    }

    public String getSynchronousPrefetchMode() {
        return this.synchronousPrefetchMode;
    }

    public void setSynchronousPrefetchMode(String string) throws IllegalArgumentException {
        if (!(string == null || string.equals("enabled") || string.equals("disabled") || string.equals("topicSubscriberOnly"))) {
            throw new IllegalArgumentException("Invalid synchronous prefetch mode");
        }
        this.synchronousPrefetchMode = string;
    }

    public String getOneWaySendMode() {
        return this.oneWaySendMode;
    }

    public void setOneWaySendMode(String string) throws IllegalArgumentException {
        if (!(string == null || string.equals("enabled") || string.equals("disabled") || string.equals("topicOnly"))) {
            throw new IllegalArgumentException("Invalid one way send mode");
        }
        this.oneWaySendMode = string;
    }

    public int getOneWaySendWindowSize() {
        return this.oneWaySendWindowSize;
    }

    public void setOneWaySendWindowSize(int n) throws IllegalArgumentException {
        this.oneWaySendWindowSize = n;
    }

    public String getReconnectPolicy() {
        return this.reconnectPolicy;
    }

    public void setReconnectPolicy(String string) {
        WLConnectionImpl.validateAndConvertReconnectPolicy(string);
        this.reconnectPolicy = string;
    }

    public long getReconnectBlockingMillis() {
        return this.reconnectBlockingMillis;
    }

    public void setReconnectBlockingMillis(long l) {
        WLConnectionImpl.validateReconnectMillis(l);
        if (l == -1L || l > this.totalReconnectPeriodMillis) {
            l = this.totalReconnectPeriodMillis;
        }
        this.reconnectBlockingMillis = l;
    }

    public long getTotalReconnectPeriodMillis() {
        return this.totalReconnectPeriodMillis;
    }

    public void setTotalReconnectPeriodMillis(long l) {
        WLConnectionImpl.validateReconnectMillis(l);
        this.totalReconnectPeriodMillis = l;
    }

    public int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public void setMessagesMaximum(int n) throws IllegalArgumentException {
        if (n < -1 || n == 0) {
            throw new IllegalArgumentException("Invalid MessagesMaximum");
        }
        this.messagesMaximum = n;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String string) {
        if (string != null && string.length() == 0) {
            this.clientId = null;
            return;
        }
        this.clientId = string;
    }

    public String getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public int getClientIdPolicyAsInt() {
        if (this.clientIdPolicy.equals("Restricted")) {
            return 0;
        }
        if (this.clientIdPolicy.equals("Unrestricted")) {
            return 1;
        }
        return 0;
    }

    public void setClientIdPolicy(String string) throws IllegalArgumentException {
        if (string == null) {
            this.clientIdPolicy = "Restricted";
            return;
        }
        if (!string.equals("Restricted") && !string.equals("Unrestricted")) {
            throw new IllegalArgumentException("Unrecognized ClientIdPolicy " + string);
        }
        this.clientIdPolicy = string;
    }

    public String getSubscriptionSharingPolicy() {
        return this.subscriptionSharingPolicy;
    }

    public static int getSubscriptionSharingPolicyAsInt(String string) {
        if (string.equals(JMSConstants.SUBSCRIPTION_EXCLUSIVE)) {
            return 0;
        }
        if (string.equals(JMSConstants.SUBSCRIPTION_SHARABLE)) {
            return 1;
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + string);
    }

    public static String getSubscriptionSharingPolicyAsString(int n) {
        switch (n) {
            case 0: {
                return JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            }
            case 1: {
                return JMSConstants.SUBSCRIPTION_SHARABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + n);
    }

    public void setSubscriptionSharingPolicy(String string) throws IllegalArgumentException {
        if (string == null) {
            this.subscriptionSharingPolicy = JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            return;
        }
        if (!string.equals(JMSConstants.SUBSCRIPTION_EXCLUSIVE) && !string.equals(JMSConstants.SUBSCRIPTION_SHARABLE)) {
            throw new IllegalArgumentException("Unrecognized Subscription Sharing Policy " + string);
        }
        this.subscriptionSharingPolicy = string;
    }

    public boolean isAllowCloseInOnMessage() {
        return this.allowCloseInOnMessage;
    }

    public void setAllowCloseInOnMessage(boolean bl) {
        this.allowCloseInOnMessage = bl;
    }

    public String getAcknowledgePolicy() {
        return this.acknowledgePolicy;
    }

    public int getAcknowledgePolicyAsInt() {
        int n = 1;
        if (this.acknowledgePolicy == null) {
            n = 1;
        } else if (this.acknowledgePolicy.equalsIgnoreCase("All")) {
            n = 1;
        } else if (this.acknowledgePolicy.equalsIgnoreCase("Previous")) {
            n = 2;
        } else if (this.acknowledgePolicy.equalsIgnoreCase("One")) {
            n = 3;
        }
        return n;
    }

    public void setAcknowledgePolicy(String string) throws IllegalArgumentException {
        if (string == null) {
            this.acknowledgePolicy = "All";
            return;
        }
        if (!(string.equalsIgnoreCase("All") || string.equalsIgnoreCase("Previous") || string.equalsIgnoreCase("One"))) {
            throw new IllegalArgumentException("Invalid acknowledgePolicy");
        }
        this.acknowledgePolicy = string;
    }

    public String getMulticastOverrunPolicy() {
        return this.overrunPolicy;
    }

    public int getMulticastOverrunPolicyAsInt() {
        int n = 0;
        if (this.overrunPolicy == null) {
            n = 0;
        } else if (this.overrunPolicy.equalsIgnoreCase(DEFAULT_MESSAGE_OVERRUN_POLICY_STRING)) {
            n = 0;
        } else if (this.overrunPolicy.equalsIgnoreCase("KeepNew")) {
            n = 1;
        }
        return n;
    }

    public void setMulticastOverrunPolicy(String string) throws IllegalArgumentException {
        if (string == null) {
            this.overrunPolicy = DEFAULT_MESSAGE_OVERRUN_POLICY_STRING;
            return;
        }
        if (!string.equalsIgnoreCase(DEFAULT_MESSAGE_OVERRUN_POLICY_STRING) && !string.equalsIgnoreCase("KeepNew")) {
            throw new IllegalArgumentException("Invalid multicast overrun policy for connection factory");
        }
        this.overrunPolicy = string;
    }

    public boolean isXAConnectionFactoryEnabled() {
        return this.xaConnectionFactoryEnabled;
    }

    public void setXAConnectionFactoryEnabled(boolean bl) {
        this.xaConnectionFactoryEnabled = bl;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long l) throws IllegalArgumentException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid TransactionTimeout");
        }
        this.transactionTimeout = l;
    }

    public boolean isFlowControlEnabled() {
        return this.flowControlEnabled;
    }

    public void setFlowControlEnabled(boolean bl) {
        this.flowControlEnabled = bl;
    }

    public int getFlowInterval() {
        return this.flowInterval;
    }

    public void setFlowInterval(int n) {
        this.flowInterval = n;
    }

    public int getFlowMaximum() {
        return this.flowMaximum;
    }

    public void setFlowMaximum(int n) throws IllegalArgumentException {
        this.flowMaximum = n;
    }

    public int getFlowMinimum() {
        return this.flowMinimum;
    }

    public void setFlowMinimum(int n) throws IllegalArgumentException {
        this.flowMinimum = n;
    }

    public int getFlowSteps() {
        return this.flowSteps;
    }

    public void setFlowSteps(int n) {
        this.flowSteps = n;
    }

    public boolean isLoadBalancingEnabled() {
        return this.loadBalancingEnabled;
    }

    public void setLoadBalancingEnabled(boolean bl) {
        this.loadBalancingEnabled = bl;
    }

    public boolean isServerAffinityEnabled() {
        return this.serverAffinityEnabled;
    }

    public void setServerAffinityEnabled(boolean bl) {
        this.serverAffinityEnabled = bl;
    }

    public void setAttachJMSXUserId(boolean bl) {
        this.attachJMSXUserID = bl;
    }

    public boolean isAttachJMSXUserId() {
        return this.attachJMSXUserID;
    }

    public long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(long l) {
        this.sendTimeout = l;
    }

    public JMSConnectionFactory getJMSConnectionFactory() {
        if (this.globalBoundConnectionFactory != null) {
            return this.globalBoundConnectionFactory;
        }
        if (this.localBoundConnectionFactory != null) {
            return this.localBoundConnectionFactory;
        }
        if (this.appBoundConnectionFactory != null) {
            return this.appBoundConnectionFactory;
        }
        return this.computeJMSConnectionFactory();
    }

    public void prepare() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Preparing connection factory: " + this.name);
        }
        if ("WebLogic_Debug_CON_fail_prepare".equals(this.connectionFactoryBean.getName())) {
            throw new ModuleException("DEBUG: A connection factory with name WebLogic_Debug_CON_fail_prepare will force the prepare to fail");
        }
        try {
            this.frontEnd.getService().ensureInitialized();
        }
        catch (JMSException jMSException) {
            throw new ModuleException("JMS Service is not initialized", jMSException);
        }
        if (this.frontEnd.connectionFactoryFind(this.name) != null) {
            throw new ModuleException("ConnectionFactory " + this.name + " already exists");
        }
        try {
            this.initialize();
            this.frontEnd.connectionFactoryAdd(this);
        }
        catch (Exception exception) {
            JMSLogger.logErrorCreateCF((String)this.name, (Exception)exception);
            throw new ModuleException("Error preparing connection factory " + this.name, exception);
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Successfully prepared connection factory: " + this.name);
        }
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Activating connection factory " + this.name);
        }
        if ("WebLogic_Debug_CON_fail_activate".equals(this.connectionFactoryBean.getName())) {
            throw new ModuleException("DEBUG: A connection factory with name WebLogic_Debug_CON_fail_activate will force the activate to fail");
        }
        this.connectionFactoryBean = jMSBean.lookupConnectionFactory(this.getEntityName());
        this.unregisterBeanUpdateListeners();
        this.registerBeanUpdateListeners();
        if (this.frontEnd.getService().isActive()) {
            try {
                this.setFullyQualifiedName(this.name);
                this.bind();
                JMSLogger.logCFactoryDeployed((String)this.name);
            }
            catch (JMSException jMSException) {
                JMSLogger.logErrorBindCF((String)this.name, (Exception)((Object)jMSException));
                throw new ModuleException("Error binding connection factory " + this.name, jMSException);
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Successfully activated connection factory: " + this.name);
        }
    }

    public void deactivate() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("De-activating connection factory: " + this.name);
        }
        try {
            this.frontEnd.getService().ensureInitialized();
        }
        catch (JMSException jMSException) {
            throw new ModuleException("JMS Service is not initialized", jMSException);
        }
        FEConnectionFactory fEConnectionFactory = this.frontEnd.connectionFactoryFind(this.name);
        if (fEConnectionFactory == null) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Error de-activating ConnectionFactory " + this.name + ": instance not found");
            }
            throw new ModuleException("Error de-activating a non-existent connection factory " + this.name + "(jndi: " + this.jndiName + ")");
        }
        try {
            this.unregisterBeanUpdateListeners();
            fEConnectionFactory.unbind();
        }
        catch (Exception exception) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Error de-activating ConnectionFactory " + this + ": not currently in ACTIVATED state");
            }
            throw new ModuleException("Error de-activating" + this.name + "(jndi: " + this.jndiName + ") not currently in ACTIVATED state");
        }
        if ("WebLogic_Debug_CON_fail_deactivate".equals(this.connectionFactoryBean.getName())) {
            throw new ModuleException("DEBUG: A connection factory with name WebLogic_Debug_CON_fail_deactivate will force the deactivate to fail");
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Successfully de-activated connection factory: " + this.name);
        }
    }

    public void unprepare() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Un-preparing connection factory: " + this.name);
        }
        try {
            this.frontEnd.getService().ensureInitialized();
        }
        catch (JMSException jMSException) {
            throw new ModuleException("JMS Service is not initialized" + (Object)((Object)jMSException));
        }
        FEConnectionFactory fEConnectionFactory = this.frontEnd.connectionFactoryFind(this.name);
        if (fEConnectionFactory == null) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Error un-preparing ConnectionFactory " + this.name + ": instance not found");
            }
            throw new ModuleException("Error un-preparing a non-existent connection factory " + this.name + "(jndi: " + this.jndiName + ")");
        }
        try {
            this.frontEnd.connectionFactoryRemove(this);
        }
        catch (Exception exception) {
            JMSLogger.logErrorCreateCF((String)this.name, (Exception)exception);
            throw new ModuleException("Error un-preparing connection factory " + this.name, exception);
        }
        if ("WebLogic_Debug_CON_fail_unprepare".equals(this.connectionFactoryBean.getName())) {
            throw new ModuleException("DEBUG: A connection factory with name WebLogic_Debug_CON_fail_unprepare will force the unprepare to fail");
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Successfully un-prepared connection factory: " + this.name);
        }
    }

    public void remove() throws ModuleException {
        if ("WebLogic_Debug_CON_fail_remove".equals(this.connectionFactoryBean.getName())) {
            throw new ModuleException("DEBUG: A connection factory with name WebLogic_Debug_CON_fail_remove will force the remove to fail");
        }
    }

    public void destroy() throws ModuleException {
        if ("WebLogic_Debug_CON_fail_destroy".equals(this.connectionFactoryBean.getName())) {
            throw new ModuleException("DEBUG: A connection factory with name WebLogic_Debug_CON_fail_destroy will force the destroy to fail");
        }
    }

    public String getEntityName() {
        if (this.connectionFactoryBean != null) {
            return this.connectionFactoryBean.getName();
        }
        return null;
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) {
    }

    public void activateChangeOfTargets() {
    }

    public void rollbackChangeOfTargets() {
    }

    private void initializeBeanUpdateListeners() throws ManagementException {
        DescriptorBean descriptorBean = (DescriptorBean)this.connectionFactoryBean;
        this.connectionFactoryBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.connectionFactoryBeanSignatures);
        this.connectionFactoryBeanListener.initialize();
        descriptorBean = (DescriptorBean)this.connectionFactoryBean.getDefaultDeliveryParams();
        this.defaultDeliveryParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.defaultDeliveryParamsBeanSignatures);
        this.defaultDeliveryParamsBeanListener.initialize();
        descriptorBean = (DescriptorBean)this.connectionFactoryBean.getClientParams();
        this.clientParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.clientParamsBeanSignatures);
        this.clientParamsBeanListener.initialize();
        descriptorBean = (DescriptorBean)this.connectionFactoryBean.getTransactionParams();
        this.transactionParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.transactionParamsBeanSignatures);
        this.transactionParamsBeanListener.initialize();
        descriptorBean = (DescriptorBean)this.connectionFactoryBean.getFlowControlParams();
        this.flowControlParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.flowControlParamsBeanSignatures);
        this.flowControlParamsBeanListener.initialize();
        descriptorBean = (DescriptorBean)this.connectionFactoryBean.getLoadBalancingParams();
        this.loadBalancingParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.loadBalancingParamsBeanSignatures);
        this.loadBalancingParamsBeanListener.initialize();
        descriptorBean = (DescriptorBean)this.connectionFactoryBean.getSecurityParams();
        this.securityParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.securityParamsBeanSignatures);
        this.securityParamsBeanListener.initialize();
    }

    public void registerBeanUpdateListeners() {
        DescriptorBean descriptorBean;
        if (this.connectionFactoryBeanListener != null) {
            this.connectionFactoryBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean;
            this.connectionFactoryBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.connectionFactoryBeanSignatures);
        }
        if (this.defaultDeliveryParamsBeanListener != null) {
            this.defaultDeliveryParamsBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean.getDefaultDeliveryParams();
            this.defaultDeliveryParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.defaultDeliveryParamsBeanSignatures);
        }
        if (this.clientParamsBeanListener != null) {
            this.clientParamsBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean.getClientParams();
            this.clientParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.clientParamsBeanSignatures);
        }
        if (this.transactionParamsBeanListener != null) {
            this.transactionParamsBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean.getTransactionParams();
            this.transactionParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.transactionParamsBeanSignatures);
        }
        if (this.flowControlParamsBeanListener != null) {
            this.flowControlParamsBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean.getFlowControlParams();
            this.flowControlParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.flowControlParamsBeanSignatures);
        }
        if (this.loadBalancingParamsBeanListener != null) {
            this.loadBalancingParamsBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean.getLoadBalancingParams();
            this.loadBalancingParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.loadBalancingParamsBeanSignatures);
        }
        if (this.securityParamsBeanListener != null) {
            this.securityParamsBeanListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.connectionFactoryBean.getSecurityParams();
            this.securityParamsBeanListener = new GenericBeanListener(descriptorBean, this, BeanHelper.securityParamsBeanSignatures);
        }
    }

    public void unregisterBeanUpdateListeners() {
        if (this.securityParamsBeanListener != null) {
            this.securityParamsBeanListener.close();
            this.securityParamsBeanListener = null;
        }
        if (this.loadBalancingParamsBeanListener != null) {
            this.loadBalancingParamsBeanListener.close();
            this.loadBalancingParamsBeanListener = null;
        }
        if (this.flowControlParamsBeanListener != null) {
            this.flowControlParamsBeanListener.close();
            this.flowControlParamsBeanListener = null;
        }
        if (this.transactionParamsBeanListener != null) {
            this.transactionParamsBeanListener.close();
            this.transactionParamsBeanListener = null;
        }
        if (this.clientParamsBeanListener != null) {
            this.clientParamsBeanListener.close();
            this.clientParamsBeanListener = null;
        }
        if (this.defaultDeliveryParamsBeanListener != null) {
            this.defaultDeliveryParamsBeanListener.close();
            this.defaultDeliveryParamsBeanListener = null;
        }
        if (this.connectionFactoryBeanListener != null) {
            this.connectionFactoryBeanListener.close();
            this.connectionFactoryBeanListener = null;
        }
    }

    public boolean isDefaultConnectionFactory() {
        return this.defaultConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectChanged(NamingEvent namingEvent) {
        if (namingEvent.getType() == 1) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Got the unadvertise for " + this.name + " jndiName=" + this.jndiName);
            }
            Object object = this.jndiNameRebindLock;
            synchronized (object) {
                this.didUnbind = true;
                this.jndiNameRebindLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
        JMSLogger.logJNDIDynamicChangeException((String)this.name, (String)namingExceptionEvent.getException().toString());
        Object object = this.jndiNameRebindLock;
        synchronized (object) {
            this.jndiNameRebindLock.notify();
        }
    }
}

