/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import javax.jms.JMSException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.jms.client.JMSConnection;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.frontend.FEConnectionCreateRequest;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.jms.frontend.FEConnectionFactoryRemote;
import weblogic.security.SimpleCallbackHandler;

public final class FEConnectionFactoryImpl
implements FEConnectionFactoryRemote {
    private final transient FEConnectionFactory feConnectionFactory;

    public FEConnectionFactoryImpl(FEConnectionFactory fEConnectionFactory) {
        this.feConnectionFactory = fEConnectionFactory;
    }

    public JMSConnection connectionCreate(DispatcherWrapper dispatcherWrapper, String string, String string2) throws JMSException {
        if (!JMSSecurityHelper.authenticate(string, string2)) {
            throw new JMSSecurityException("Authentication failure");
        }
        return this.connectionCreateInternal(dispatcherWrapper, true);
    }

    public JMSConnection connectionCreate(DispatcherWrapper dispatcherWrapper) throws JMSException {
        return this.connectionCreateInternal(dispatcherWrapper, true);
    }

    public JMSConnection connectionCreateRequest(FEConnectionCreateRequest fEConnectionCreateRequest) throws JMSException {
        try {
            if (fEConnectionCreateRequest.getUserName() == null || JMSSecurityHelper.getJMSSecurityHelper().getPrincipalAuthenticator().authenticate((CallbackHandler)new SimpleCallbackHandler(fEConnectionCreateRequest.getUserName(), fEConnectionCreateRequest.getPassword())) != null) {
                return this.connectionCreateInternal(fEConnectionCreateRequest.getDispatcherWrapper(), fEConnectionCreateRequest.getCreateXAConnection());
            }
        }
        catch (LoginException loginException) {
            throw new JMSSecurityException("Authentication failure due to LoginException", loginException);
        }
        throw new JMSSecurityException("Authentication failure");
    }

    private JMSConnection connectionCreateInternal(DispatcherWrapper dispatcherWrapper, boolean bl) throws JMSException {
        return this.feConnectionFactory.connectionCreateInternal(dispatcherWrapper, bl);
    }
}

