/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.util.Iterator;
import javax.jms.JMSException;
import weblogic.jms.JMSService;
import weblogic.jms.client.WLConnectionImpl;
import weblogic.jms.common.DestroyConnectionException;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.frontend.FEConnection;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSConnectionRuntimeMBean;
import weblogic.management.runtime.JMSSessionRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.rjvm.JVMID;

public class FEConnectionRuntimeDelegate
extends RuntimeMBeanDelegate
implements JMSConnectionRuntimeMBean {
    private int connectionConsumersCurrentCount;
    private int connectionConsumersHighCount;
    private int connectionConsumersTotalCount;
    private long sessionsHighCount = 0L;
    private long sessionsTotalCount = 0L;
    private long browsersHighCount = 0L;
    private long browsersTotalCount = 0L;
    private FEConnection managedConnection;
    private String connectionRuntimeMBeanName;

    public FEConnectionRuntimeDelegate(String string, FEConnection fEConnection, JMSService jMSService) throws JMSException, ManagementException {
        super(string, (RuntimeMBean)jMSService, false);
        this.connectionRuntimeMBeanName = string;
        this.managedConnection = fEConnection;
        super.register();
    }

    public String getConnectionRuntimeMBeanName() {
        return this.connectionRuntimeMBeanName;
    }

    public String getClientID() {
        return this.managedConnection.getConnectionClientId();
    }

    public String getClientIDPolicy() {
        return WLConnectionImpl.convertClientIdPolicy(this.managedConnection.getClientIdPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void destroy() {
        block8: {
            JMSPushExceptionRequest jMSPushExceptionRequest = new JMSPushExceptionRequest(3, this.managedConnection.getConnectionId(), new DestroyConnectionException("Connection administratively closed"));
            JMSServerUtilities.anonDispatchNoReply(jMSPushExceptionRequest, this.managedConnection.getClientDispatcher());
            Object var4_2 = null;
            try {
                this.managedConnection.normalClose();
            }
            catch (JMSException jMSException) {}
            break block8;
            {
                catch (JMSException jMSException) {
                    Object var4_3 = null;
                    try {
                        this.managedConnection.normalClose();
                    }
                    catch (JMSException jMSException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.managedConnection.normalClose();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSSessionRuntimeMBean[] getSessions() {
        FEConnection fEConnection = this.managedConnection;
        synchronized (fEConnection) {
            int n = 0;
            FEConnectionRuntimeDelegate fEConnectionRuntimeDelegate = this;
            synchronized (fEConnectionRuntimeDelegate) {
                Iterator iterator = this.managedConnection.getSessionMap().values().iterator();
                JMSSessionRuntimeMBean[] jMSSessionRuntimeMBeanArray = new JMSSessionRuntimeMBean[this.managedConnection.getSessionMap().size()];
                while (iterator.hasNext()) {
                    jMSSessionRuntimeMBeanArray[n++] = (JMSSessionRuntimeMBean)iterator.next();
                }
                return jMSSessionRuntimeMBeanArray;
            }
        }
    }

    public String getHostAddress() {
        JMSDispatcher jMSDispatcher;
        try {
            jMSDispatcher = this.managedConnection.getClientDispatcher();
        }
        catch (JMSException jMSException) {
            return "0.0.0.0";
        }
        if (jMSDispatcher.isLocal()) {
            return JVMID.localID().getAddress();
        }
        String string = jMSDispatcher.getId().getHostAddress();
        if (string.equals("0.0.0.0")) {
            string = this.managedConnection.getAddress();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSessionsCurrentCount() {
        FEConnection fEConnection = this.managedConnection;
        synchronized (fEConnection) {
            FEConnectionRuntimeDelegate fEConnectionRuntimeDelegate = this;
            synchronized (fEConnectionRuntimeDelegate) {
                return this.managedConnection.getSessionMap().size();
            }
        }
    }

    public synchronized long getSessionsHighCount() {
        return this.sessionsHighCount;
    }

    public synchronized void setSessionsHighCount(long l) {
        this.sessionsHighCount = l;
    }

    public synchronized void increaseSessionsHighCount() {
        ++this.sessionsHighCount;
    }

    public synchronized void decreaseSessionsHighCount() {
        --this.sessionsHighCount;
    }

    public synchronized long getSessionsTotalCount() {
        return this.sessionsTotalCount;
    }

    public synchronized void increaseSessionsTotalCount() {
        ++this.sessionsTotalCount;
    }

    public synchronized void decreaseSessionsTotalCount() {
        --this.sessionsTotalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionConsumersCurrentCount() {
        FEConnection fEConnection = this.managedConnection;
        synchronized (fEConnection) {
            FEConnectionRuntimeDelegate fEConnectionRuntimeDelegate = this;
            synchronized (fEConnectionRuntimeDelegate) {
                return this.managedConnection.getConnectionConsumerMap().size();
            }
        }
    }

    public synchronized void increaseConnectionConsumersCurrentCount() {
        ++this.connectionConsumersCurrentCount;
    }

    public synchronized void decreaseConnectionConsumersCurrentCount() {
        --this.connectionConsumersCurrentCount;
    }

    public synchronized int getConnectionConsumersHighCount() {
        return this.connectionConsumersHighCount;
    }

    public synchronized void increaseConnectionConsumersHighCount() {
        ++this.connectionConsumersHighCount;
    }

    public synchronized void decreaseConnectionConsumersHighCount() {
        --this.connectionConsumersHighCount;
    }

    public synchronized int getConnectionConsumersTotalCount() {
        return this.connectionConsumersTotalCount;
    }

    public synchronized void increaseConnectionConsumersTotalCount() {
        ++this.connectionConsumersTotalCount;
    }

    public synchronized void decreaseConnectionConsumersTotalCount() {
        --this.connectionConsumersTotalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBrowsersCurrentCount() {
        FEConnection fEConnection = this.managedConnection;
        synchronized (fEConnection) {
            FEConnectionRuntimeDelegate fEConnectionRuntimeDelegate = this;
            synchronized (fEConnectionRuntimeDelegate) {
                return this.managedConnection.getBrowserMap().size();
            }
        }
    }

    public synchronized long getBrowsersHighCount() {
        return this.browsersHighCount;
    }

    public synchronized void setBrowsersHighCount(long l) {
        this.browsersHighCount = l;
    }

    public synchronized void increaseBrowsersHighCount() {
        ++this.browsersHighCount;
    }

    public synchronized void decreaseBrowsersHighCount() {
        --this.browsersHighCount;
    }

    public synchronized long getBrowsersTotalCount() {
        return this.browsersTotalCount;
    }

    public synchronized void increaseBrowsersTotalCount() {
        ++this.browsersTotalCount;
    }

    public synchronized void decreaseBrowsersTotalCount() {
        --this.browsersTotalCount;
    }
}

