/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Vector;
import javax.jms.JMSException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.JMSLogger;
import weblogic.jms.backend.BEConsumerCloseRequest;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerCreateResponse;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEConsumerIncrementWindowCurrentRequest;
import weblogic.jms.backend.BEConsumerIsActiveRequest;
import weblogic.jms.backend.BEConsumerIsActiveResponse;
import weblogic.jms.backend.BEConsumerReceiveRequest;
import weblogic.jms.backend.BEConsumerSetListenerRequest;
import weblogic.jms.backend.BERemoveSubscriptionRequest;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.DSManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSConsumerSetListenerResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageContextImpl;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageStatistics;
import weblogic.jms.common.Sequencer;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.jms.frontend.FEConsumerCloseRequest;
import weblogic.jms.frontend.FEConsumerCreateRequest;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentOneWayRequest;
import weblogic.jms.frontend.FEConsumerIncrementWindowCurrentRequest;
import weblogic.jms.frontend.FEConsumerReceiveRequest;
import weblogic.jms.frontend.FEConsumerSetListenerRequest;
import weblogic.jms.frontend.FESession;
import weblogic.jms.frontend.FrontEnd;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSConsumerRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.interception.MessageInterceptionService;
import weblogic.messaging.interception.exceptions.InterceptionProcessorException;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.CarrierCallBack;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class FEConsumer
extends RuntimeMBeanDelegate
implements JMSConsumerRuntimeMBean,
Invocable,
JMSPeerGoneListener,
CarrierCallBack {
    static final long serialVersionUID = -8556954068817891651L;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private JMSID consumerId;
    private JMSDispatcher backEndDispatcher;
    private Sequencer sequencer;
    public static final String JNDI_SUBSCRIPTIONNAME = "weblogic.jms.internal.subscription";
    final MessageStatistics statistics = new MessageStatistics();
    private InvocableMonitor invocableMonitor;
    private FESession session;
    private DestinationImpl destination;
    private String selector;
    private boolean isDurable = false;
    private boolean isLocal = true;
    private String subject = null;
    private AuthenticatedSubject authenticatedSubject;
    private InterceptionPointHandle receiveIPHandle = null;
    private DestinationImpl receiveIPDestination = null;
    private static final int DONE = 1;
    private static final int IN_PROGRESS = 2;
    private Request currentRequest;
    private static Object interceptionPointLock = new Object();
    private ConsumerReconnectInfo consumerReconnectInfo;
    private int subscriptionSharingPolicy;
    private transient int refCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FEConsumer(String string, FESession fESession, Sequencer sequencer, String string2, DestinationImpl destinationImpl, JMSID jMSID, String string3, AuthenticatedSubject authenticatedSubject, FEConsumerCreateRequest fEConsumerCreateRequest) throws JMSException, ManagementException {
        super(string, (RuntimeMBean)fESession);
        try {
            Externalizable externalizable;
            int n = 1;
            this.session = fESession;
            this.sequencer = sequencer;
            this.destination = destinationImpl;
            this.consumerId = jMSID;
            this.subject = string3;
            this.authenticatedSubject = authenticatedSubject;
            this.subscriptionSharingPolicy = fEConsumerCreateRequest.getSubscriptionSharingPolicy();
            if (this.subscriptionSharingPolicy == -1) {
                this.subscriptionSharingPolicy = this.session.getSubscriptionSharingPolicy();
            }
            try {
                this.backEndDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(destinationImpl.getDispatcherId());
                if (!this.backEndDispatcher.isLocal()) {
                    this.isLocal = false;
                }
            }
            catch (DispatcherException dispatcherException) {
                throw new weblogic.jms.common.JMSException("Error creating consumer", (Throwable)dispatcherException);
            }
            if (string2 != null && fEConsumerCreateRequest.getName() != null) {
                this.isDurable = true;
            }
            FrontEnd frontEnd = fESession.getConnection().getFrontEnd();
            this.invocableMonitor = frontEnd.getInvocableMonitor();
            this.selector = fEConsumerCreateRequest.getSelector();
            if (this.isDurable) {
                if (this.getSession().getConnection().getClientIdPolicy() == 0) {
                    DurableSubscription durableSubscription;
                    if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        JMSDebug.JMSFrontEnd.debug("in FEConsumer durable with restricted clientID");
                    }
                    if ((durableSubscription = DSManager.manager().lookup(BEConsumerImpl.JNDINameForSubscription(BEConsumerImpl.clientIdPlusName(string2, fEConsumerCreateRequest.getName())))) != null) {
                        externalizable = new DurableSubscription(BEConsumerImpl.clientIdPlusName(string2, fEConsumerCreateRequest.getName(), this.getSession().getConnection().getClientIdPolicy(), destinationImpl.getName(), destinationImpl.getServerName()), destinationImpl, fEConsumerCreateRequest.getSelector(), fEConsumerCreateRequest.getNoLocal(), this.getSession().getConnection().getClientIdPolicy(), this.subscriptionSharingPolicy);
                        Vector vector = durableSubscription.getDSVector();
                        int n2 = 0;
                        for (n2 = 0; n2 < vector.size(); ++n2) {
                            Object var21_22;
                            JMSDispatcher jMSDispatcher;
                            DurableSubscription durableSubscription2 = (DurableSubscription)vector.elementAt(n2);
                            if (durableSubscription2.equalsForSerialized(externalizable)) {
                                n = 0;
                                durableSubscription = durableSubscription2;
                                continue;
                            }
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("in FEConsumer create new consumer");
                            }
                            JMSServerId jMSServerId = durableSubscription2.getBackEndId();
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("in FEConsumer first remove old consumer");
                            }
                            try {
                                jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(jMSServerId.getDispatcherId());
                            }
                            catch (DispatcherException dispatcherException) {
                                throw new weblogic.jms.common.JMSException("Error creating consumer", (Throwable)dispatcherException);
                            }
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("in FEConnection remove consumer");
                            }
                            try {
                                SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
                                jMSDispatcher.dispatchSync(new BERemoveSubscriptionRequest(jMSServerId, durableSubscription2.getDestinationImpl().getTopicName(), string2, this.getSession().getConnection().getClientIdPolicy(), fEConsumerCreateRequest.getName()));
                                var21_22 = null;
                            }
                            catch (Throwable throwable) {
                                var21_22 = null;
                                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                                throw throwable;
                            }
                            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                            {
                                continue;
                            }
                        }
                    }
                } else if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("in FEConsumer durable with unrestricted clientID");
                }
            } else if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("in FEConsumer not durable");
            }
            externalizable = null;
            try {
                SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
                externalizable = this.backEndDispatcher.dispatchSync(new BEConsumerCreateRequest(fESession.getConnection().getJMSID(), fESession.getJMSID(), jMSID, string2, this.getSession().getConnection().getClientIdPolicy(), fEConsumerCreateRequest.getName(), destinationImpl.getDestinationId(), fEConsumerCreateRequest.getSelector(), fEConsumerCreateRequest.getNoLocal(), fEConsumerCreateRequest.getMessagesMaximum(), n, fEConsumerCreateRequest.getRedeliveryDelay(), string3, fEConsumerCreateRequest.getConsumerReconnectInfo(), this.subscriptionSharingPolicy));
                Object var23_25 = null;
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                throw throwable;
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            if (!this.isLocal) {
                this.backEndDispatcher.addDispatcherPeerGoneListener(this.getSession());
                this.backEndDispatcher.addDispatcherPeerGoneListener(this);
            }
            this.consumerReconnectInfo = ((BEConsumerCreateResponse)externalizable).getConsumerReconnectInfo();
        }
        catch (Exception exception) {
            try {
                PrivilegedActionUtilities.unregister(this, KERNEL_ID);
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                throw (ManagementException)((Object)exception);
            }
            throw new weblogic.jms.common.JMSException(exception);
        }
    }

    public ConsumerReconnectInfo getConsumerReconnectInfo() {
        return this.consumerReconnectInfo;
    }

    JMSDispatcher getBackEndDispatcher() {
        return this.backEndDispatcher;
    }

    private FESession getSession() {
        return this.session;
    }

    private Sequencer getSequencer() {
        return this.sequencer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(FEConsumerCloseRequest fEConsumerCloseRequest) throws JMSException {
        this.session.checkShutdownOrSuspended();
        long l = this.session.consumerClose(this, fEConsumerCloseRequest.getLastSequenceNumber());
        Object object = interceptionPointLock;
        synchronized (object) {
            block9: {
                if (this.receiveIPHandle != null && this.getDestination() != null && (this.getDestination().getType() == 8 || this.getDestination().getType() == 4)) {
                    try {
                        if (!this.receiveIPHandle.hasAssociation()) {
                            MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(this.receiveIPHandle);
                            this.receiveIPHandle = null;
                        }
                    }
                    catch (InterceptionServiceException interceptionServiceException) {
                        JMSLogger.logFailedToUnregisterInterceptionPoint((Exception)interceptionServiceException);
                        if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block9;
                        JMSDebug.JMSFrontEnd.debug("FEConsumer.close(), Failure to unregister " + interceptionServiceException);
                    }
                }
            }
        }
        try {
            this.backEndDispatcher.dispatchSync(new BEConsumerCloseRequest(this.consumerId, l));
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.session.consumerRemove(this.consumerId);
            throw throwable;
        }
        this.session.consumerRemove(this.consumerId);
    }

    private int pushException(Request request) throws JMSException {
        JMSPushExceptionRequest jMSPushExceptionRequest;
        block3: {
            jMSPushExceptionRequest = (JMSPushExceptionRequest)request;
            try {
                this.getSession().pushException(6, this.consumerId, jMSPushExceptionRequest.getException());
            }
            catch (Exception exception) {
                if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block3;
                JMSDebug.JMSFrontEnd.debug("Error pushing exception ", (Throwable)exception);
            }
        }
        if (jMSPushExceptionRequest.getException() instanceof ConsumerClosedException) {
            this.session.consumerRemove(this.consumerId);
        }
        jMSPushExceptionRequest.setState(Integer.MAX_VALUE);
        return jMSPushExceptionRequest.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setListener(Request request) throws JMSException {
        this.session.checkShutdownOrSuspended();
        FEConsumerSetListenerRequest fEConsumerSetListenerRequest = (FEConsumerSetListenerRequest)request;
        if (fEConsumerSetListenerRequest.getHasListener()) {
            this.session.updateQOS();
        }
        switch (fEConsumerSetListenerRequest.getState()) {
            case 0: {
                BEConsumerSetListenerRequest bEConsumerSetListenerRequest = new BEConsumerSetListenerRequest(this.consumerId, fEConsumerSetListenerRequest.getHasListener(), fEConsumerSetListenerRequest.getLastSequenceNumber());
                FEConsumerSetListenerRequest fEConsumerSetListenerRequest2 = fEConsumerSetListenerRequest;
                synchronized (fEConsumerSetListenerRequest2) {
                    fEConsumerSetListenerRequest.rememberChild(bEConsumerSetListenerRequest);
                    fEConsumerSetListenerRequest.setState(1);
                }
                try {
                    fEConsumerSetListenerRequest.dispatchAsync(this.getBackEndDispatcher(), (Request)bEConsumerSetListenerRequest);
                    break;
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error setting listener", (Throwable)dispatcherException);
                }
            }
            default: {
                fEConsumerSetListenerRequest.useChildResult(JMSConsumerSetListenerResponse.class);
            }
        }
        return fEConsumerSetListenerRequest.getState();
    }

    private int incrementWindow(Request request) throws JMSException {
        this.session.checkShutdownOrSuspended();
        FEConsumerIncrementWindowCurrentRequest fEConsumerIncrementWindowCurrentRequest = (FEConsumerIncrementWindowCurrentRequest)request;
        JMSServerUtilities.anonDispatchNoReply(new BEConsumerIncrementWindowCurrentRequest(this.consumerId, fEConsumerIncrementWindowCurrentRequest.getWindowIncrement(), fEConsumerIncrementWindowCurrentRequest.getClientResponsibleForAcknowledge()), this.backEndDispatcher);
        fEConsumerIncrementWindowCurrentRequest.setResult(new VoidResponse());
        fEConsumerIncrementWindowCurrentRequest.setState(Integer.MAX_VALUE);
        return fEConsumerIncrementWindowCurrentRequest.getState();
    }

    private int incrementWindowOneWay(Request request) throws JMSException {
        this.session.checkShutdownOrSuspended();
        FEConsumerIncrementWindowCurrentOneWayRequest fEConsumerIncrementWindowCurrentOneWayRequest = (FEConsumerIncrementWindowCurrentOneWayRequest)request;
        JMSServerUtilities.anonDispatchNoReply(new BEConsumerIncrementWindowCurrentRequest(this.consumerId, fEConsumerIncrementWindowCurrentOneWayRequest.getWindowIncrement(), fEConsumerIncrementWindowCurrentOneWayRequest.getClientResponsibleForAcknowledge()), this.backEndDispatcher);
        fEConsumerIncrementWindowCurrentOneWayRequest.setState(Integer.MAX_VALUE);
        return fEConsumerIncrementWindowCurrentOneWayRequest.getState();
    }

    public void onCallBack(boolean bl) {
        this.currentRequest.resumeExecution(true);
    }

    public void onException(InterceptionProcessorException interceptionProcessorException) {
        System.out.println("Processor throws exception" + interceptionProcessorException);
        this.currentRequest.resumeExecution(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveInterceptionPoint(DestinationImpl destinationImpl, MessageImpl messageImpl) throws JMSException {
        Object object = interceptionPointLock;
        synchronized (object) {
            String[] stringArray;
            if (this.receiveIPHandle != null && this.receiveIPDestination != destinationImpl) {
                try {
                    MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(this.receiveIPHandle);
                }
                catch (InterceptionServiceException interceptionServiceException) {
                    throw new AssertionError((Object)("Failure to unregister" + interceptionServiceException));
                }
                this.receiveIPHandle = null;
            }
            if (this.receiveIPHandle == null) {
                this.receiveIPDestination = destinationImpl;
                stringArray = new String[]{destinationImpl.getServerName(), destinationImpl.getName(), "Receive"};
                if (stringArray[0] == null) {
                    stringArray[0] = new String();
                }
                if (stringArray[1] == null) {
                    stringArray[1] = new String();
                }
                try {
                    this.receiveIPHandle = MessageInterceptionService.getSingleton().registerInterceptionPoint("JMS", stringArray);
                }
                catch (InterceptionServiceException interceptionServiceException) {
                    throw new weblogic.jms.common.JMSException("FAILED registerInterceptionPoint " + interceptionServiceException);
                }
            }
            try {
                if (this.receiveIPHandle.hasAssociation()) {
                    stringArray = new JMSMessageContextImpl(messageImpl);
                    this.receiveIPHandle.processAsync((MessageContext)stringArray, this);
                    return 2;
                }
            }
            catch (Exception exception) {
                throw new weblogic.jms.common.JMSException("FAILED in interception " + exception);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int receive(Request request) throws JMSException {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("FEConsumer.receive()");
        }
        this.session.checkShutdownOrSuspended();
        FEConsumerReceiveRequest fEConsumerReceiveRequest = (FEConsumerReceiveRequest)request;
        switch (fEConsumerReceiveRequest.getState()) {
            case 0: {
                if (this.session.isTransacted()) {
                    this.session.transactedInfect();
                }
                BEConsumerReceiveRequest bEConsumerReceiveRequest = new BEConsumerReceiveRequest(this.consumerId, fEConsumerReceiveRequest.getTimeout());
                FEConsumerReceiveRequest fEConsumerReceiveRequest2 = fEConsumerReceiveRequest;
                synchronized (fEConsumerReceiveRequest2) {
                    fEConsumerReceiveRequest.rememberChild(bEConsumerReceiveRequest);
                    fEConsumerReceiveRequest.setState(1);
                }
                try {
                    fEConsumerReceiveRequest.dispatchAsync(this.getBackEndDispatcher(), (Request)bEConsumerReceiveRequest);
                    return fEConsumerReceiveRequest.getState();
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error receiving message", (Throwable)dispatcherException);
                }
            }
            case 1: {
                try {
                    JMSConsumerReceiveResponse jMSConsumerReceiveResponse = (JMSConsumerReceiveResponse)fEConsumerReceiveRequest.useChildResult(JMSConsumerReceiveResponse.class);
                    if (jMSConsumerReceiveResponse == null) {
                        throw new AssertionError((Object)"receive got a null response");
                    }
                    MessageImpl messageImpl = jMSConsumerReceiveResponse.getMessage();
                    if (messageImpl != null) {
                        jMSConsumerReceiveResponse.setCompressionThreshold(this.session.getConnection().getCompressionThreshold());
                    }
                    if (messageImpl != null) {
                        jMSConsumerReceiveResponse.setCompressionThreshold(this.session.getConnection().getCompressionThreshold());
                        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                            JMSDebug.JMSMessagePath.debug("FRONTEND/FEConsumer (id: " + this.consumerId + ") : " + "Receipt of message " + messageImpl.getJMSMessageID());
                        }
                        if (jMSConsumerReceiveResponse.isTransactional()) {
                            this.session.transactionStat(this, null, messageImpl);
                        } else {
                            JMSPushEntry jMSPushEntry;
                            boolean bl = messageImpl.getClientResponsibleForAcknowledge();
                            if (bl) {
                                this.statistics.incrementReceivedCount(messageImpl);
                                this.getSession().getStatistics().incrementReceivedCount(messageImpl);
                            } else {
                                this.statistics.incrementPendingCount(messageImpl);
                                this.getSession().getStatistics().incrementPendingCount(messageImpl);
                            }
                            long l = jMSConsumerReceiveResponse.getSequenceNumber();
                            FESession fESession = this.session;
                            synchronized (fESession) {
                                jMSPushEntry = new JMSPushEntry(this.getSequencer().getJMSID(), this.consumerId, l, this.session.getNextSequenceNumber(), messageImpl.getDeliveryCount(), 0);
                            }
                            jMSPushEntry.setClientResponsibleForAcknowledge(bl);
                            jMSPushEntry.setDispatcher(this.getBackEndDispatcher());
                            if (!bl) {
                                this.session.addUnackedPushEntry(jMSPushEntry, messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize());
                            }
                            jMSConsumerReceiveResponse.setSequenceNumber(jMSPushEntry.getFrontEndSequenceNumber());
                        }
                    }
                    Object var13_14 = null;
                    if (!this.session.isTransacted()) return Integer.MAX_VALUE;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (!this.session.isTransacted()) throw throwable;
                    this.session.transactedDisinfect();
                    throw throwable;
                }
                this.session.transactedDisinfect();
                return Integer.MAX_VALUE;
            }
        }
        return fEConsumerReceiveRequest.getState();
    }

    public long getBytesPendingCount() {
        return this.statistics.getBytesPendingCount();
    }

    public long getBytesReceivedCount() {
        return this.statistics.getBytesReceivedCount();
    }

    public String getSubscriptionSharingPolicy() {
        return FEConnectionFactory.getSubscriptionSharingPolicyAsString(this.subscriptionSharingPolicy);
    }

    public String getClientID() {
        return this.session.getConnection().getConnectionClientId();
    }

    public String getClientIDPolicy() {
        if (this.session.getConnection().getClientIdPolicy() == 1) {
            return JMSConstants.CLIENT_ID_POLICY_UNRESTRICTED_STRING;
        }
        return JMSConstants.CLIENT_ID_POLICY_RESTRICTED_STRING;
    }

    public String getDestinationName() {
        return this.destination.getName();
    }

    public String getMemberDestinationName() {
        return this.destination.getMemberName();
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    public long getMessagesPendingCount() {
        return this.statistics.getMessagesPendingCount();
    }

    public long getMessagesReceivedCount() {
        return this.statistics.getMessagesReceivedCount();
    }

    public boolean isActive() throws RemoteException {
        try {
            Response response = this.backEndDispatcher.dispatchSync(new BEConsumerIsActiveRequest(this.getJMSID()));
            return ((BEConsumerIsActiveResponse)response).consumerIsActive;
        }
        catch (Throwable throwable) {
            throw new RemoteException("Error setting consumer state, " + throwable.toString());
        }
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public String getSelector() {
        return this.selector;
    }

    public JMSID getJMSID() {
        return this.consumerId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 3594: {
                return this.setListener(request);
            }
            case 3338: {
                return this.receive(request);
            }
            case 3082: {
                this.incrementWindow(request);
                break;
            }
            case 17418: {
                this.incrementWindowOneWay(request);
                break;
            }
            case 2570: {
                this.close((FEConsumerCloseRequest)request);
                break;
            }
            case 15370: {
                return this.pushException(request);
            }
            default: {
                throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
            }
        }
        request.setResult(new VoidResponse());
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        block5: {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("FEConsumer.jmsPeerGone()");
            }
            FESession fESession = this.getSession();
            try {
                fESession.consumerRemove(this.getJMSID());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                fESession.pushException(6, this.consumerId, new ConsumerClosedException(null, "Connection to JMSServer was lost"));
            }
            catch (Throwable throwable) {
                if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block5;
                JMSDebug.JMSFrontEnd.debug("remote error?", throwable);
            }
        }
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Consumer");
        xMLStreamWriter.writeAttribute("id", this.consumerId != null ? this.consumerId.toString() : "");
        xMLStreamWriter.writeAttribute("isDurable", String.valueOf(this.isDurable));
        xMLStreamWriter.writeAttribute("isLocal", String.valueOf(this.isLocal));
        xMLStreamWriter.writeAttribute("selector", this.selector != null ? this.selector : "");
        this.statistics.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }
}

