/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.frontend.FEConsumerCreateResponse;
import weblogic.messaging.dispatcher.Response;

public final class FEConsumerCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -2345606550673535552L;
    private static final int EXTVERSION_PRE811 = 1;
    private static final int EXTVERSION_PRE920 = 10;
    private static final int EXTVERSION_PRE1033 = 12;
    private static final int EXTVERSION4 = 14;
    private static final int EXTVERSION = 14;
    private static final int VERSION_MASK = 255;
    private static final int _HASCLIENTID = 256;
    private static final int _HASNAME = 512;
    private static final int _HASSELECTOR = 1024;
    private static final int _ISNOLOCAL = 2048;
    private static final int _HASREDELIVERYDELAY = 4096;
    private static final int _HASDISTRIBUTEDDESTINATION = 8192;
    private static final int _HAS_CONSUMER_RECON_INFO = 16384;
    private String clientId;
    private String name;
    private DestinationImpl destination;
    private String selector;
    private boolean noLocal;
    private int messagesMaximum;
    private long redeliveryDelay;
    private transient int numberOfRetries;
    private ConsumerReconnectInfo consumerReconnectInfo;
    private int subscriptionSharingPolicy = -1;

    public FEConsumerCreateRequest(JMSID jMSID, String string, String string2, DestinationImpl destinationImpl, String string3, boolean bl, int n, long l, ConsumerReconnectInfo consumerReconnectInfo, int n2) {
        super(jMSID, 2824);
        this.clientId = string;
        this.name = string2;
        this.destination = destinationImpl;
        this.selector = string3;
        this.noLocal = bl;
        this.messagesMaximum = n;
        this.redeliveryDelay = l;
        this.consumerReconnectInfo = consumerReconnectInfo;
        this.subscriptionSharingPolicy = n2;
    }

    String getClientId() {
        return this.clientId;
    }

    String getName() {
        return this.name;
    }

    DestinationImpl getDestination() {
        return this.destination;
    }

    void setDestination(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
    }

    void setSelector(String string) {
        this.selector = string;
    }

    String getSelector() {
        return this.selector;
    }

    boolean getNoLocal() {
        return this.noLocal;
    }

    int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    int getSubscriptionSharingPolicy() {
        return this.subscriptionSharingPolicy;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new FEConsumerCreateResponse();
    }

    int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    void setNumberOfRetries(int n) {
        this.numberOfRetries = n;
    }

    public ConsumerReconnectInfo getConsumerReconnectInfo() {
        return this.consumerReconnectInfo;
    }

    public void setConsumerReconnectInfo(ConsumerReconnectInfo consumerReconnectInfo) {
        this.consumerReconnectInfo = consumerReconnectInfo;
    }

    public FEConsumerCreateRequest() {
    }

    protected byte getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_61) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 14);
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_811) < 0) {
                return 1;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_920) < 0) {
                return 10;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1033) < 0) {
                return 12;
            }
        }
        return 14;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        objectOutput = this.getVersionedStream(objectOutput);
        int n2 = n = this.getVersion(objectOutput);
        boolean bl = false;
        if (this.name != null) {
            n2 |= 0x200;
        }
        if (n == 1 && this.name != null && this.clientId != null) {
            n2 |= 0x100;
            bl = true;
        }
        if (n >= 12 && this.consumerReconnectInfo != null) {
            n2 |= 0x4000;
        }
        if (this.selector != null) {
            n2 |= 0x400;
        }
        if (this.noLocal) {
            n2 |= 0x800;
        }
        if (this.redeliveryDelay != 0L) {
            n2 |= 0x1000;
        }
        if (this.destination instanceof DistributedDestinationImpl) {
            n2 |= 0x2000;
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        if (bl) {
            objectOutput.writeUTF(this.clientId);
        }
        if (this.name != null) {
            objectOutput.writeUTF(this.name);
        }
        if (this.selector != null) {
            objectOutput.writeUTF(this.selector);
        }
        this.destination.writeExternal(objectOutput);
        objectOutput.writeInt(this.messagesMaximum);
        if (this.redeliveryDelay != 0L) {
            objectOutput.writeLong(this.redeliveryDelay);
        }
        if ((n2 & 0x4000) != 0) {
            this.consumerReconnectInfo.writeExternal(objectOutput);
        }
        if (n >= 14) {
            objectOutput.writeInt(this.subscriptionSharingPolicy);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 < 1 || n2 > 14) {
            throw JMSUtilities.versionIOException(n2, 1, 14);
        }
        super.readExternal(objectInput);
        if ((n & 0x100) != 0) {
            this.clientId = objectInput.readUTF();
        }
        if ((n & 0x200) != 0) {
            this.name = objectInput.readUTF();
        }
        if ((n & 0x400) != 0) {
            this.selector = objectInput.readUTF();
        }
        if ((n & 0x800) != 0) {
            this.noLocal = true;
        }
        if ((n & 0x2000) != 0) {
            this.destination = new DistributedDestinationImpl();
            this.destination.readExternal(objectInput);
        } else {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        this.messagesMaximum = objectInput.readInt();
        if ((n & 0x1000) != 0) {
            this.redeliveryDelay = objectInput.readLong();
        }
        if ((n & 0x4000) != 0) {
            this.consumerReconnectInfo = new ConsumerReconnectInfo();
            this.consumerReconnectInfo.readExternal(objectInput);
        }
        if (n2 >= 14) {
            this.subscriptionSharingPolicy = objectInput.readInt();
        }
    }
}

