/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class FEConsumerCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = 4370603925624654360L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte EXTVERSION3 = 3;
    private static final byte VERSION_MASK = 15;
    private static final byte _HAS_CONSUMER_RECON_INFO = 16;
    private JMSID consumerId;
    private String runtimeMBeanName;
    private ConsumerReconnectInfo consumerReconnectInfo;

    public FEConsumerCreateResponse(JMSID jMSID, String string, ConsumerReconnectInfo consumerReconnectInfo) {
        this.consumerId = jMSID;
        this.runtimeMBeanName = string;
        this.consumerReconnectInfo = consumerReconnectInfo;
    }

    public JMSID getConsumerId() {
        return this.consumerId;
    }

    public ConsumerReconnectInfo getConsumerReconnectInfo() {
        return this.consumerReconnectInfo;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public FEConsumerCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo;
        int n = (objectOutput = this.getVersionedStream(objectOutput)) instanceof PeerInfoable ? ((peerInfo = ((PeerInfoable)objectOutput).getPeerInfo()) == null || peerInfo.compareTo((Object)PeerInfo.VERSION_920) >= 0 ? 3 : (peerInfo.compareTo((Object)PeerInfo.VERSION_81) >= 0 ? 2 : 1)) : 3;
        int n2 = n >= 3 && this.consumerReconnectInfo != null ? (int)((byte)(n | 0x10)) : n;
        assert (3 == n);
        objectOutput.writeByte(n2);
        super.writeExternal(objectOutput);
        this.consumerId.writeExternal(objectOutput);
        if (n >= 2) {
            objectOutput.writeUTF(this.runtimeMBeanName);
        }
        if ((n2 & 0x10) != 0) {
            this.consumerReconnectInfo.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0xF);
        if (by2 < 1 || 3 < by2) {
            throw JMSUtilities.versionIOException(by2, 1, 3);
        }
        super.readExternal(objectInput);
        this.consumerId = new JMSID();
        this.consumerId.readExternal(objectInput);
        if (by2 >= 2) {
            this.runtimeMBeanName = objectInput.readUTF();
            if (by2 >= 3 && (by & 0x10) != 0) {
                this.consumerReconnectInfo = new ConsumerReconnectInfo();
                this.consumerReconnectInfo.readExternal(objectInput);
            }
        }
    }
}

