/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.security.AccessController;
import java.util.Iterator;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSFailover;
import weblogic.jms.common.JMSLoadBalancer;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.DDStatusListener;
import weblogic.jms.frontend.FESession;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class FEDDHandler
implements DDStatusListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    DDHandler ddHandler;
    JMSLoadBalancer loadBalancer = null;
    String boundJNDIName = null;

    public FEDDHandler(DDHandler dDHandler) {
        this.ddHandler = dDHandler;
        dDHandler.addStatusListener(this, 255);
    }

    public void statusChangeNotification(DDHandler dDHandler, int n) {
        if ((n & 0x10) != 0) {
            this.stop();
        } else {
            this.refresh();
        }
    }

    private boolean areAnyMembersUp() {
        Iterator iterator = this.ddHandler.memberCloneIterator();
        while (iterator.hasNext()) {
            DDMember dDMember = (DDMember)iterator.next();
            if (!dDMember.isUp()) continue;
            return true;
        }
        return false;
    }

    private synchronized void stop() {
        this.unbindFromJNDI();
        this.loadBalancer = null;
    }

    private synchronized void refresh() {
        boolean bl = this.areAnyMembersUp();
        if (!bl) {
            this.stop();
            return;
        }
        if (this.loadBalancer == null) {
            this.loadBalancer = new JMSLoadBalancer(this.ddHandler);
            this.bindIntoJNDI();
        } else {
            String string = JMSServerUtilities.transformJNDIName(this.ddHandler.getJNDIName(), this.ddHandler.getApplicationName());
            if (this.boundJNDIName != null && !this.boundJNDIName.equals(string)) {
                this.unbindFromJNDI();
            }
            if (this.boundJNDIName == null && string != null) {
                this.bindIntoJNDI();
            }
            this.loadBalancer.refresh();
        }
    }

    private void bindIntoJNDI() {
        String string = this.ddHandler.getJNDIName();
        if ((string = JMSServerUtilities.transformJNDIName(string, this.ddHandler.getApplicationName())) == null) {
            return;
        }
        this.boundJNDIName = string;
        try {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Binding " + this.boundJNDIName + " into JNDI for " + this.ddHandler.getName());
            }
            PrivilegedActionUtilities.bindAsSU(JMSService.getContext(false), this.boundJNDIName, this.ddHandler.getDDImpl(), kernelId);
        }
        catch (NamingException namingException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Bind failure", (Throwable)namingException);
            }
            if (!(namingException instanceof NameAlreadyBoundException)) {
                this.boundJNDIName = null;
                throw new AssertionError((Object)namingException);
            }
            JMSLogger.logNameConflictBindingGlobalJNDIName((String)this.boundJNDIName, (String)this.ddHandler.getName(), (String)this.ddHandler.getEARModuleName());
            this.boundJNDIName = null;
        }
    }

    private void unbindFromJNDI() {
        block4: {
            if (this.boundJNDIName == null) {
                return;
            }
            try {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("Unbinding " + this.boundJNDIName + " into JNDI for " + this.ddHandler.getName());
                }
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(false), this.boundJNDIName, kernelId);
            }
            catch (NamingException namingException) {
                if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block4;
                JMSDebug.JMSDistTopic.debug("Unbind failure", (Throwable)namingException);
            }
        }
        this.boundJNDIName = null;
    }

    public int getLoadBalancingPolicy() {
        return this.ddHandler.getLoadBalancingPolicyAsInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl producerLoadBalance(boolean bl, FESession fESession) {
        JMSLoadBalancer jMSLoadBalancer;
        FEDDHandler fEDDHandler = this;
        synchronized (fEDDHandler) {
            if (this.loadBalancer == null) {
                return null;
            }
            jMSLoadBalancer = this.loadBalancer;
        }
        return jMSLoadBalancer.producerLoadBalance(bl, fESession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl consumerLoadBalance(FESession fESession) {
        JMSLoadBalancer jMSLoadBalancer;
        FEDDHandler fEDDHandler = this;
        synchronized (fEDDHandler) {
            if (this.loadBalancer == null) {
                return null;
            }
            jMSLoadBalancer = this.loadBalancer;
        }
        return jMSLoadBalancer.consumerLoadBalance(fESession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl connectionConsumerLoadBalance() {
        JMSLoadBalancer jMSLoadBalancer;
        FEDDHandler fEDDHandler = this;
        synchronized (fEDDHandler) {
            if (this.loadBalancer == null) {
                return null;
            }
            jMSLoadBalancer = this.loadBalancer;
        }
        return jMSLoadBalancer.connectionConsumerLoadBalance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSFailover getProducerFailover(DistributedDestinationImpl distributedDestinationImpl, Throwable throwable, boolean bl, FESession fESession) {
        JMSLoadBalancer jMSLoadBalancer;
        FEDDHandler fEDDHandler = this;
        synchronized (fEDDHandler) {
            if (this.loadBalancer == null) {
                return null;
            }
            jMSLoadBalancer = this.loadBalancer;
        }
        return jMSLoadBalancer.getProducerFailover(distributedDestinationImpl, throwable, bl, fESession);
    }

    public DDMember findDDMemberByMemberName(String string) {
        if (this.ddHandler == null) {
            return null;
        }
        return this.ddHandler.findMemberByName(string);
    }

    public String getUnitOfOrderRouting() {
        return this.ddHandler.getUnitOfOrderRouting();
    }

    public DDHandler getDDHandler() {
        return this.ddHandler;
    }

    public String getName() {
        return this.ddHandler.getName();
    }

    public boolean isDDPartitionedDistributedTopic() {
        if (this.loadBalancer == null) {
            return false;
        }
        return this.loadBalancer.isPartitionedDistributedTopic();
    }

    public String toString() {
        return "FEDDHandler: " + this.ddHandler.getName() + ", hash: " + this.hashCode();
    }
}

