/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class FEDestinationCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -4660550797390037314L;
    private String destinationName;
    private int destinationType;
    private boolean temporary;
    private JMSServerId backEndId;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TEMPORARY_MASK = 256;
    static final int START = 0;
    static final int CONTINUE = 1;

    public FEDestinationCreateRequest(String string, int n, boolean bl) {
        super(null, 3841);
        this.destinationName = string;
        this.destinationType = n;
        this.temporary = bl;
    }

    public final String getDestinationName() {
        return this.destinationName;
    }

    public final void setDestinationName(String string) {
        this.destinationName = string;
    }

    public final int getDestType() {
        return this.destinationType;
    }

    public final JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public final void setBackEndId(JMSServerId jMSServerId) {
        this.backEndId = jMSServerId;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new JMSDestinationCreateResponse();
    }

    public FEDestinationCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        if (this.temporary) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.destinationName);
        objectOutput.writeInt(this.destinationType);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.destinationName = objectInput.readUTF();
        this.destinationType = objectInput.readInt();
        this.temporary = (n & 0x100) != 0;
    }
}

