/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import javax.jms.JMSException;
import weblogic.jms.backend.BEEnumerationNextElementRequest;
import weblogic.jms.common.JMSEnumerationNextElementResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.frontend.FEBrowser;
import weblogic.jms.frontend.FEEnumerationNextElementRequest;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;

public final class FEEnumeration
implements Invocable {
    private final FEBrowser browser;
    private final JMSID enumerationId;
    private final JMSDispatcher dispatcher;
    private final InvocableMonitor invocableMonitor;

    public FEEnumeration(FEBrowser fEBrowser, JMSID jMSID, JMSDispatcher jMSDispatcher) {
        this.browser = fEBrowser;
        this.enumerationId = jMSID;
        this.dispatcher = jMSDispatcher;
        this.invocableMonitor = fEBrowser.getInvocableMonitor();
    }

    public JMSID getJMSID() {
        return this.enumerationId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextElement(Request request) throws JMSException {
        FEEnumerationNextElementRequest fEEnumerationNextElementRequest = (FEEnumerationNextElementRequest)request;
        switch (fEEnumerationNextElementRequest.getState()) {
            case 0: {
                BEEnumerationNextElementRequest bEEnumerationNextElementRequest = new BEEnumerationNextElementRequest(this.enumerationId);
                FEEnumerationNextElementRequest fEEnumerationNextElementRequest2 = fEEnumerationNextElementRequest;
                synchronized (fEEnumerationNextElementRequest2) {
                    fEEnumerationNextElementRequest.rememberChild(bEEnumerationNextElementRequest);
                    fEEnumerationNextElementRequest.setState(1);
                }
                try {
                    fEEnumerationNextElementRequest.dispatchAsync(this.dispatcher, (Request)bEEnumerationNextElementRequest);
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error getting next element", (Throwable)dispatcherException);
                }
                return fEEnumerationNextElementRequest.getState();
            }
            case 1: {
                MessageImpl messageImpl;
                JMSEnumerationNextElementResponse jMSEnumerationNextElementResponse = (JMSEnumerationNextElementResponse)fEEnumerationNextElementRequest.useChildResult(JMSEnumerationNextElementResponse.class);
                if (jMSEnumerationNextElementResponse.getMessage() == null) {
                    this.browser.enumerationRemove(this.enumerationId);
                }
                if ((messageImpl = jMSEnumerationNextElementResponse.getMessage()) != null) {
                    jMSEnumerationNextElementResponse.setCompressionThreshold(this.browser.getConnection().getCompressionThreshold());
                }
                fEEnumerationNextElementRequest.setResult(jMSEnumerationNextElementResponse);
                return Integer.MAX_VALUE;
            }
        }
        return fEEnumerationNextElementRequest.getState();
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 4108: {
                return this.nextElement(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + this.getClass().getName() + "." + request.getMethodId());
    }
}

