/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationCreateRequest;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BERemoveSubscriptionRequest;
import weblogic.jms.backend.BEServerSessionPool;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.Sequencer;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.frontend.FEConnection;
import weblogic.jms.frontend.FEDestinationCreateRequest;
import weblogic.jms.frontend.FERemoveSubscriptionRequest;
import weblogic.jms.frontend.FEServerSessionPoolCloseRequest;
import weblogic.jms.frontend.FETempDestinationFactory;
import weblogic.jms.frontend.FrontEnd;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.JMSConnectionRuntimeMBean;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class FEManager
implements Invocable {
    private static FETempDestinationFactory feTemporaryDestinationFactory;
    private final InvocableMonitor invocableMonitor;

    public FEManager(InvocableMonitor invocableMonitor) {
        this.invocableMonitor = invocableMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMSConnectionRuntimeMBean[] getConnections() {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = InvocableManagerDelegate.delegate.getInvocableMap(7);
        synchronized (hashMap2) {
            JMSConnectionRuntimeMBean[] jMSConnectionRuntimeMBeanArray = new JMSConnectionRuntimeMBean[hashMap.size()];
            Iterator iterator = hashMap.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                jMSConnectionRuntimeMBeanArray[n++] = ((FEConnection)iterator.next()).getRuntimeDelegate();
            }
            return jMSConnectionRuntimeMBeanArray;
        }
    }

    public static long getConnectionsCurrentCount() {
        return InvocableManagerDelegate.delegate.getInvocablesCurrentCount(7);
    }

    public static long getConnectionsHighCount() {
        return InvocableManagerDelegate.delegate.getInvocablesHighCount(7);
    }

    public static long getConnectionsTotalCount() {
        return InvocableManagerDelegate.delegate.getInvocablesTotalCount(7);
    }

    public JMSID getJMSID() {
        return null;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FETempDestinationFactory getTemporaryDestinationFactory() throws JMSException {
        Class<FEManager> clazz = FEManager.class;
        synchronized (FEManager.class) {
            if (feTemporaryDestinationFactory == null) {
                try {
                    feTemporaryDestinationFactory = (FETempDestinationFactory)JMSService.getContext().lookup("weblogic.jms.TempDestinationFactory");
                }
                catch (NamingException namingException) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logNoTemporaryTemplatesLoggable(), (Throwable)namingException);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return feTemporaryDestinationFactory;
        }
    }

    private void serverSessionPoolClose(FEServerSessionPoolCloseRequest fEServerSessionPoolCloseRequest) throws JMSException {
        JMSService jMSService = JMSService.getJMSService();
        BackEnd backEnd = jMSService.getBEDeployer().findBackEnd(fEServerSessionPoolCloseRequest.getBackEndId());
        backEnd.checkShutdownOrSuspended("close server session pool");
        BEServerSessionPool bEServerSessionPool = backEnd.serverSessionPoolFind(fEServerSessionPoolCloseRequest.getServerSessionPoolId());
        if (bEServerSessionPool == null) {
            throw new JMSException("Server session pool not found");
        }
        backEnd.serverSessionPoolRemove(bEServerSessionPool);
        bEServerSessionPool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int destinationCreate(Request request) throws JMSException {
        FEDestinationCreateRequest fEDestinationCreateRequest = (FEDestinationCreateRequest)request;
        JMSService jMSService = JMSService.getJMSService();
        DestinationImpl destinationImpl = null;
        switch (fEDestinationCreateRequest.getState()) {
            case 0: {
                Object object;
                String string = fEDestinationCreateRequest.getDestinationName();
                if (string == null || string.length() <= 0) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logNoDestinationNameLoggable());
                }
                destinationImpl = DDManager.findDDImplByDDName(string);
                if (destinationImpl != null) {
                    this.checkAndProcessCreateDestination(destinationImpl, fEDestinationCreateRequest);
                    break;
                }
                int n = string.indexOf(47);
                if (n == -1 || n == string.length() - 1) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logInvalidDestinationFormatLoggable((String)string));
                }
                String string2 = string.startsWith("./") ? null : string.substring(0, n);
                String string3 = "weblogic.jms.backend." + string2;
                FrontEnd frontEnd = jMSService.getFEDeployer().getFrontEnd();
                string = string.substring(n + 1, string.length());
                if (string2 == null) {
                    frontEnd.checkShutdownOrSuspended();
                    BackEnd[] backEndArray = jMSService.getBEDeployer().getBackEnds();
                    for (int i = 0; backEndArray != null && i < backEndArray.length; ++i) {
                        assert (!backEndArray[i].getName().startsWith("!weblogicreserved!"));
                        try {
                            backEndArray[i].checkShutdownOrSuspendedNeedLock("create destination");
                        }
                        catch (JMSException jMSException) {
                            continue;
                        }
                        BEDestinationImpl bEDestinationImpl = backEndArray[i].findDestinationByCreateName(string);
                        if (bEDestinationImpl == null || bEDestinationImpl.getDestinationImpl().getType() != fEDestinationCreateRequest.getDestType() || !bEDestinationImpl.isStarted() || !bEDestinationImpl.isAvailableForCreateDestination()) continue;
                        fEDestinationCreateRequest.setResult(new JMSDestinationCreateResponse(bEDestinationImpl.getDestinationImpl()));
                        fEDestinationCreateRequest.setState(Integer.MAX_VALUE);
                        break;
                    }
                    if (fEDestinationCreateRequest.getState() == Integer.MAX_VALUE) break;
                    AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logDestinationNotFoundLoggable((String)string, (String)ManagementService.getRuntimeAccess(authenticatedSubject).getServerName()));
                }
                try {
                    object = JMSService.getContext().lookup(string3);
                }
                catch (NamingException namingException) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logBackEndUnreachableLoggable(), (Throwable)namingException);
                }
                if (!(object instanceof JMSServerId)) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logBackEndUnknownLoggable());
                }
                JMSServerId jMSServerId = (JMSServerId)object;
                frontEnd.checkShutdownOrSuspended();
                BEDestinationCreateRequest bEDestinationCreateRequest = new BEDestinationCreateRequest(jMSServerId.getId(), string, fEDestinationCreateRequest.getDestType(), true);
                fEDestinationCreateRequest.setBackEndId(jMSServerId);
                fEDestinationCreateRequest.setDestinationName(string);
                Object object2 = fEDestinationCreateRequest;
                synchronized (object2) {
                    fEDestinationCreateRequest.rememberChild(bEDestinationCreateRequest);
                    fEDestinationCreateRequest.setState(1);
                }
                try {
                    object2 = JMSDispatcherManager.dispatcherFindOrCreate(jMSServerId.getDispatcherId());
                    fEDestinationCreateRequest.dispatchAsync((JMSDispatcher)object2, (Request)bEDestinationCreateRequest);
                    break;
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logFindFailedLoggable(), (Throwable)dispatcherException);
                }
            }
            default: {
                JMSDestinationCreateResponse jMSDestinationCreateResponse = fEDestinationCreateRequest.getChild() != null ? (JMSDestinationCreateResponse)fEDestinationCreateRequest.useChildResult(JMSDestinationCreateResponse.class) : (JMSDestinationCreateResponse)fEDestinationCreateRequest.getResult();
                fEDestinationCreateRequest.setState(Integer.MAX_VALUE);
                destinationImpl = jMSDestinationCreateResponse.getDestination();
            }
        }
        return fEDestinationCreateRequest.getState();
    }

    private void checkAndProcessCreateDestination(DestinationImpl destinationImpl, FEDestinationCreateRequest fEDestinationCreateRequest) throws weblogic.jms.common.JMSException {
        if (destinationImpl.getType() != fEDestinationCreateRequest.getDestType()) {
            throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logInvalidDestinationTypeLoggable((String)fEDestinationCreateRequest.getDestinationName(), (String)(fEDestinationCreateRequest.getDestType() == 2 ? "topic" : "queue")));
        }
        fEDestinationCreateRequest.setResult(new JMSDestinationCreateResponse(destinationImpl));
        fEDestinationCreateRequest.setState(Integer.MAX_VALUE);
    }

    private int pushMessage(Request request) {
        JMSPushRequest jMSPushRequest = (JMSPushRequest)request;
        MessageImpl messageImpl = jMSPushRequest.getMessage();
        JMSPushEntry jMSPushEntry = null;
        JMSPushEntry jMSPushEntry2 = jMSPushRequest.getFirstPushEntry();
        JMSID jMSID = jMSPushEntry2.getSequencerId();
        do {
            if (!jMSID.equals(jMSPushEntry2.getSequencerId())) {
                try {
                    jMSPushEntry.setNext(null);
                    jMSPushRequest.setLastPushEntry(jMSPushEntry);
                    ((Sequencer)InvocableManagerDelegate.delegate.invocableFind(13, jMSID)).pushMessage(jMSPushRequest);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                jMSPushRequest = new JMSPushRequest(0, null, messageImpl);
                jMSPushRequest.setFirstPushEntry(jMSPushEntry2);
                jMSID = jMSPushEntry2.getSequencerId();
            }
            jMSPushEntry = jMSPushEntry2;
        } while ((jMSPushEntry2 = jMSPushEntry2.getNext()) != null);
        try {
            jMSPushEntry.setNext(null);
            jMSPushRequest.setLastPushEntry(jMSPushEntry);
            ((Sequencer)InvocableManagerDelegate.delegate.invocableFind(13, jMSID)).pushMessage(jMSPushRequest);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeSubscription(Request request) throws JMSException {
        FERemoveSubscriptionRequest fERemoveSubscriptionRequest = (FERemoveSubscriptionRequest)request;
        switch (fERemoveSubscriptionRequest.getState()) {
            case 0: {
                Object object;
                Object object2;
                JMSServerId jMSServerId = fERemoveSubscriptionRequest.getBackEndId();
                if (jMSServerId == null) {
                    if (fERemoveSubscriptionRequest.getClientIdPolicy() == 1) {
                        throw new InvalidDestinationException(JMSExceptionLogger.logInvalidUnrestrictedUnsubscribeLoggable((String)fERemoveSubscriptionRequest.getName(), (String)fERemoveSubscriptionRequest.getClientId()));
                    }
                    try {
                        object2 = JMSService.getContext();
                        object = BEConsumerImpl.JNDINameForSubscription(BEConsumerImpl.clientIdPlusName(fERemoveSubscriptionRequest.getClientId(), fERemoveSubscriptionRequest.getName()));
                        jMSServerId = ((DurableSubscription)object2.lookup((String)object)).getBackEndId();
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        throw new InvalidDestinationException("Subscription " + fERemoveSubscriptionRequest.getName() + " not found.");
                    }
                    catch (NamingException namingException) {
                        throw new InvalidDestinationException("Subscription " + fERemoveSubscriptionRequest.getName() + " not found", namingException);
                    }
                }
                object2 = new BERemoveSubscriptionRequest(jMSServerId, fERemoveSubscriptionRequest.getDestinationName(), fERemoveSubscriptionRequest.getClientId(), fERemoveSubscriptionRequest.getClientIdPolicy(), fERemoveSubscriptionRequest.getName());
                object = fERemoveSubscriptionRequest;
                synchronized (object) {
                    fERemoveSubscriptionRequest.rememberChild((Request)object2);
                    fERemoveSubscriptionRequest.setState(1);
                }
                try {
                    object = JMSDispatcherManager.dispatcherFindOrCreate(jMSServerId.getDispatcherId());
                    fERemoveSubscriptionRequest.dispatchAsync((JMSDispatcher)object, (Request)object2);
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logErrorRemovingSubscriptionLoggable(), (Throwable)dispatcherException);
                }
                return fERemoveSubscriptionRequest.getState();
            }
        }
        fERemoveSubscriptionRequest.useChildResult(VoidResponse.class);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FEConnection[] getFEConnections() {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = InvocableManagerDelegate.delegate.getInvocableMap(7);
        synchronized (hashMap2) {
            FEConnection[] fEConnectionArray = new FEConnection[hashMap.size()];
            return hashMap.values().toArray(fEConnectionArray);
        }
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 15617: {
                return this.pushMessage(request);
            }
            case 5377: {
                FERemoveSubscriptionRequest fERemoveSubscriptionRequest = (FERemoveSubscriptionRequest)request;
                DestinationImpl destinationImpl = fERemoveSubscriptionRequest.getDestination();
                if (destinationImpl != null) {
                    JMSServerId jMSServerId = FEManager.refreshBackEndId(destinationImpl.getServerName());
                    destinationImpl.setBackEndID(jMSServerId);
                    fERemoveSubscriptionRequest.setBackEndId(jMSServerId);
                }
                return this.removeSubscription(fERemoveSubscriptionRequest);
            }
            case 3841: {
                return this.destinationCreate(request);
            }
            case 5633: {
                this.serverSessionPoolClose((FEServerSessionPoolCloseRequest)request);
                break;
            }
            default: {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logNoMethodLoggable((int)request.getMethodId()));
            }
        }
        request.setResult(new VoidResponse());
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    static JMSServerId refreshBackEndId(String string) throws JMSException {
        JMSServerId jMSServerId = null;
        String string2 = "weblogic.jms.backend." + string;
        try {
            JMSService.getService();
            Object object = JMSService.getContext().lookup(string2);
            try {
                jMSServerId = (JMSServerId)object;
            }
            catch (ClassCastException classCastException) {
                String string3 = FEManager.debugClassCastException(string2, string, object);
                if (classCastException.getCause() == null) {
                    classCastException.initCause(new ClassCastException(string3));
                    throw classCastException;
                }
                ClassCastException classCastException2 = new ClassCastException(string3);
                classCastException2.initCause(classCastException);
                throw classCastException2;
            }
        }
        catch (NamingException namingException) {
            throw new weblogic.jms.common.JMSException(namingException);
        }
        catch (ManagementException managementException) {
            throw new weblogic.jms.common.JMSException(managementException);
        }
        return jMSServerId;
    }

    private static String debugClassCastException(String string, String string2, Object object) {
        String string3 = "destination for jndi " + string + " has backend " + string2 + " found object <";
        string3 = object == null ? string3 + object + ">" : string3 + object.getClass().getName() + " " + object + ">";
        return string3;
    }

    static boolean isStaleDestEx(JMSException jMSException) {
        Throwable throwable = null;
        for (throwable = jMSException; throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof InvalidDestinationException)) continue;
            return true;
        }
        return false;
    }
}

