/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.Serializable;
import java.security.AccessController;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.common.CompletionRequest;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEProducerSendRequest;
import weblogic.jms.backend.BEUOOMember;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DestinationPeerGoneAdapter;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSFailover;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageContextImpl;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.UOOHelper;
import weblogic.jms.dd.DDConstants;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.JMSOrderException;
import weblogic.jms.frontend.FEDDHandler;
import weblogic.jms.frontend.FEProducerSendRequest;
import weblogic.jms.frontend.FESession;
import weblogic.jms.frontend.FrontEnd;
import weblogic.jms.frontend.SAFReplyHandler;
import weblogic.jms.utils.tracing.MessageTimeStamp;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSProducerRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.interception.MessageInterceptionService;
import weblogic.messaging.interception.exceptions.InterceptionException;
import weblogic.messaging.interception.exceptions.InterceptionProcessorException;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.exceptions.MessageContextException;
import weblogic.messaging.interception.interfaces.CarrierCallBack;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.path.Member;
import weblogic.messaging.path.helper.KeyString;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.collections.SecondChanceCacheMap;

public final class FEProducer
extends RuntimeMBeanDelegate
implements JMSProducerRuntimeMBean,
Invocable,
CarrierCallBack,
DDConstants {
    static final long serialVersionUID = -2064739049461407314L;
    private volatile boolean inSend = false;
    private final JMSID producerId;
    private final Object statisticsLock = new Object();
    private long messagesSentCount = 0L;
    private long messagesPendingCount = 0L;
    private long bytesSentCount = 0L;
    private long bytesPendingCount = 0L;
    private final FESession session;
    private DestinationImpl producerDestination;
    private JMSDispatcher producerDispatcher;
    private final InvocableMonitor invocableMonitor;
    private static final int STALE_DEST_MAP_MAXSIZE = 10;
    private final SecondChanceCacheMap staleDestsLRUMap;
    private boolean pinned;
    private HashMap pinnedDests;
    private HashMap pinnedPersistentDests;
    private static final int REQUEST_COMPLETED = 1;
    private static final int REQUEST_IN_PROGRESS = 2;
    private InterceptionPointHandle[] IPHandles = new InterceptionPointHandle[2];
    private DestinationImpl[] IPDestinations = new DestinationImpl[2];
    private static final String[] IPStrings = new String[]{"Start", "After Authorization"};
    private static final int[] IPNextStates = new int[]{6, 7};
    private static final int START_IP = 0;
    private static final int POST_AUTH_IP = 1;
    private boolean interceptionSaidContinue = false;
    private static final int DONE = 1;
    private static final int IN_PROGRESS = 2;
    private FEProducerSendRequest currentRequest;
    private InterceptionProcessorException interceptionException = null;
    private static Object cacheUOOLock = new Object();
    private static Object interceptionPointLock = new Object();
    private CacheUOOMember cacheUOOMember;
    private String pathJndiName;
    private static int TTL_GUESS = 60000;
    private static int TTL_CONFIRMED = 3600000;
    private HashMap stickyDests;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static int nextGeneration = 1;

    public FEProducer(String string, JMSID jMSID, FESession fESession, DestinationImpl destinationImpl) throws JMSException, ManagementException {
        super(string, (RuntimeMBean)fESession);
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("FEProducer.<init>()");
        }
        this.producerId = jMSID;
        this.session = fESession;
        this.invocableMonitor = FrontEnd.getFrontEnd().getInvocableMonitor();
        this.interpretProducerDestination(destinationImpl);
        if (this.pinned) {
            this.pinnedDests = new HashMap();
            this.pinnedPersistentDests = new HashMap();
        }
        this.staleDestsLRUMap = new SecondChanceCacheMap(this.producerDestination == null ? 10 : 1);
        if (this.producerDestination == null) {
            return;
        }
        if (!(destinationImpl instanceof DistributedDestinationImpl)) {
            block7: {
                try {
                    this.producerDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(this.producerDestination.getDispatcherId());
                }
                catch (DispatcherException dispatcherException) {
                    if (DDManager.findDDHandlerByMemberName(this.producerDestination.getName()) == null) break block7;
                    throw new weblogic.jms.common.JMSException("Error creating producer for destination " + this.producerDestination.getName(), (Throwable)dispatcherException);
                }
            }
            if (this.producerDispatcher != null) {
                this.addAndNormalizeDestination(this.producerDestination, this.producerDispatcher);
            }
        }
    }

    private void interpretProducerDestination(DestinationImpl destinationImpl) throws JMSException {
        if (destinationImpl == null) {
            this.pinned = !this.session.getConnection().isLoadBalancingEnabled();
            return;
        }
        this.pinned = false;
        FEDDHandler fEDDHandler = DDManager.findFEDDHandlerByDDName(destinationImpl.getName());
        if (fEDDHandler != null) {
            if (!destinationImpl.isQueue() && !fEDDHandler.isDDPartitionedDistributedTopic() || !this.session.getConnection().isLoadBalancingEnabled()) {
                destinationImpl = fEDDHandler.producerLoadBalance(false, this.session);
                if (destinationImpl == null) {
                    throw new weblogic.jms.common.JMSException("Fail to find the destination");
                }
                this.pinned = true;
            }
        } else {
            this.pinned = true;
        }
        if (!(destinationImpl instanceof DistributedDestinationImpl) && destinationImpl.getDestinationId() == null) {
            try {
                destinationImpl = this.session.getConnection().createDestination(destinationImpl);
            }
            catch (Throwable throwable) {
                throw JMSUtilities.jmsExceptionThrowable("Destination " + destinationImpl.getName() + " not found", throwable);
            }
        }
        this.producerDestination = destinationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAndNormalizeDestination(DestinationImpl destinationImpl, JMSDispatcher jMSDispatcher) {
        if (destinationImpl == null) {
            throw new AssertionError((Object)"Destination should never be null here");
        }
        DestinationPeerGoneAdapter destinationPeerGoneAdapter = new DestinationPeerGoneAdapter(destinationImpl, this.session.getConnection());
        JMSDispatcher jMSDispatcher2 = jMSDispatcher;
        synchronized (jMSDispatcher2) {
            DestinationPeerGoneAdapter destinationPeerGoneAdapter2 = (DestinationPeerGoneAdapter)jMSDispatcher.addDispatcherPeerGoneListener(destinationPeerGoneAdapter);
            if (destinationPeerGoneAdapter2 == null || destinationPeerGoneAdapter2.equals(destinationPeerGoneAdapter)) {
                return;
            }
            DestinationImpl destinationImpl2 = destinationPeerGoneAdapter2.getDestinationImpl();
            if (destinationImpl2 != null) {
                this.producerDestination = destinationImpl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incMessagesSentCount(long l) {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.messagesSentCount;
            this.bytesSentCount += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incMessagesPendingCount(long l) {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.messagesPendingCount;
            this.bytesPendingCount += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decMessagesPendingCount(long l) {
        Object object = this.statisticsLock;
        synchronized (object) {
            --this.messagesPendingCount;
            this.bytesPendingCount -= l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesPendingCount() {
        Object object = this.statisticsLock;
        synchronized (object) {
            return this.bytesPendingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesSentCount() {
        Object object = this.statisticsLock;
        synchronized (object) {
            return this.bytesSentCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesPendingCount() {
        Object object = this.statisticsLock;
        synchronized (object) {
            return this.messagesPendingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessagesSentCount() {
        Object object = this.statisticsLock;
        synchronized (object) {
            return this.messagesSentCount;
        }
    }

    public void addPinnedDest(DestinationImpl destinationImpl) {
        if (this.pinnedDests == null || this.pinnedPersistentDests == null || destinationImpl == null) {
            return;
        }
        if (((DistributedDestinationImpl)destinationImpl).isPersistent()) {
            this.pinnedDests.put(destinationImpl.getName(), destinationImpl);
            this.pinnedPersistentDests.put(destinationImpl.getName(), destinationImpl);
        } else {
            this.pinnedDests.put(destinationImpl.getName(), destinationImpl);
        }
    }

    public DestinationImpl getPinnedDest(DestinationImpl destinationImpl, boolean bl) {
        if (this.pinnedDests == null || this.pinnedPersistentDests == null || destinationImpl == null) {
            return null;
        }
        DestinationImpl destinationImpl2 = bl ? (DestinationImpl)this.pinnedPersistentDests.get(destinationImpl.getName()) : (DestinationImpl)this.pinnedDests.get(destinationImpl.getName());
        if (destinationImpl2 != null && destinationImpl2.isStale()) {
            this.cleanFailure(destinationImpl2);
            destinationImpl2 = null;
        }
        return destinationImpl2;
    }

    private void cleanFailure(DestinationImpl destinationImpl) {
        if (this.pinnedDests == null || this.pinnedPersistentDests == null) {
            return;
        }
        this.pinnedDests.remove(destinationImpl.getName());
        this.pinnedPersistentDests.remove(destinationImpl.getName());
        if (this.session != null && this.session.isTransacted()) {
            this.session.cleanFailure(destinationImpl);
        }
    }

    private void responseCheck(Object object) {
    }

    private boolean sameNamedDestination(DestinationImpl destinationImpl, DestinationImpl destinationImpl2) {
        return destinationImpl != null && destinationImpl2 != null && destinationImpl.getServerName().equals(destinationImpl2.getServerName()) && destinationImpl.getName().equals(destinationImpl2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int interceptionPoint(int n, FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        Object object = interceptionPointLock;
        synchronized (object) {
            Object object2;
            this.interceptionException = null;
            InterceptionPointHandle interceptionPointHandle = this.IPHandles[n];
            DestinationImpl destinationImpl = this.IPDestinations[n];
            if (interceptionPointHandle != null && !this.sameNamedDestination(destinationImpl, fEProducerSendRequest.getDestination())) {
                try {
                    MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(interceptionPointHandle);
                }
                catch (InterceptionServiceException interceptionServiceException) {
                    throw new AssertionError((Object)("Failure to unregister" + interceptionServiceException));
                }
                interceptionPointHandle = null;
                this.IPHandles[n] = null;
                this.IPDestinations[n] = null;
            }
            if (interceptionPointHandle == null) {
                object2 = new String[3];
                this.IPDestinations[n] = fEProducerSendRequest.getDestination();
                object2[0] = fEProducerSendRequest.getDestination().getServerName();
                object2[1] = fEProducerSendRequest.getDestination().getName();
                object2[2] = IPStrings[n];
                if (object2[0] == null) {
                    object2[0] = new String();
                }
                if (object2[1] == null) {
                    object2[1] = new String();
                }
                try {
                    interceptionPointHandle = MessageInterceptionService.getSingleton().registerInterceptionPoint("JMS", (String[])object2);
                }
                catch (InterceptionServiceException interceptionServiceException) {
                    throw new weblogic.jms.common.JMSException("FAILED registerInterceptionPoint " + interceptionServiceException);
                }
                this.IPHandles[n] = interceptionPointHandle;
            }
            try {
                if (interceptionPointHandle.hasAssociation()) {
                    object2 = new JMSMessageContextImpl(fEProducerSendRequest.getMessage());
                    ((JMSMessageContextImpl)object2).setDestination(fEProducerSendRequest.getDestination());
                    ((JMSMessageContextImpl)object2).setUser(JMSSecurityHelper.getSimpleAuthenticatedName());
                    ((JMSMessageContextImpl)object2).setFailover((JMSFailover)fEProducerSendRequest.getFailover());
                    fEProducerSendRequest.setState(IPNextStates[n]);
                    fEProducerSendRequest.needOutsideResult();
                    this.currentRequest = fEProducerSendRequest;
                    interceptionPointHandle.processAsync((MessageContext)object2, this);
                    return 2;
                }
            }
            catch (InterceptionException interceptionException) {
                throw new weblogic.jms.common.JMSException("Processor: " + interceptionException);
            }
            catch (MessageContextException messageContextException) {
                throw new weblogic.jms.common.JMSException("Processor: " + messageContextException);
            }
            catch (InterceptionServiceException interceptionServiceException) {
                throw new weblogic.jms.common.JMSException("Processor: " + interceptionServiceException);
            }
        }
        return 1;
    }

    private void initializeRoutingCriteria(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        assert (fEProducerSendRequest.getDestination() != null);
        String string = fEProducerSendRequest.getMessage().getUnitOfOrder();
        if (!(fEProducerSendRequest.getDestination() instanceof DistributedDestinationImpl) && string == null) {
            return;
        }
        String string2 = null;
        try {
            string2 = fEProducerSendRequest.getMessage().getStringProperty("JMS_BEA_UnitOfWork");
        }
        catch (JMSException jMSException) {
            throw new AssertionError((Object)"We don't have exceptions on getProperty in the server");
        }
        if (string != null && string2 != null) {
            throw new weblogic.jms.common.JMSException("A JMS message cannot have both a Unit Of Order property and a Unit Of Work Property");
        }
        if (!(fEProducerSendRequest.getDestination() instanceof DistributedDestinationImpl)) {
            return;
        }
        if (string != null) {
            fEProducerSendRequest.setUnitForRouting(string);
        } else {
            DDHandler dDHandler = DDManager.findDDHandlerByDDName(fEProducerSendRequest.getDestination().getName());
            if (dDHandler != null && dDHandler.isUOWDestination()) {
                fEProducerSendRequest.setUnitForRouting(string2);
            } else {
                fEProducerSendRequest.setUnitForRouting(null);
            }
        }
    }

    private void pickFirstDestination(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        if (fEProducerSendRequest.getDestination() == null) {
            throw new weblogic.jms.common.JMSException("Null destination");
        }
        this.initializeRoutingCriteria(fEProducerSendRequest);
        DestinationImpl destinationImpl = fEProducerSendRequest.getDestination();
        if (this.pinned) {
            fEProducerSendRequest.setDestination(this.getPinnedDest(fEProducerSendRequest.getDestination(), fEProducerSendRequest.getMessage().getAdjustedDeliveryMode() == 2));
        } else {
            fEProducerSendRequest.setDestination(null);
        }
        if (fEProducerSendRequest.getDestination() == null || fEProducerSendRequest.getUnitForRouting() != null) {
            fEProducerSendRequest.setDestination(destinationImpl);
            if (fEProducerSendRequest.getUnitForRouting() != null) {
                this.selectUOOMember(fEProducerSendRequest, this.session);
            } else {
                fEProducerSendRequest.setDestination(this.computeTypicalLoadBalance(null, fEProducerSendRequest, this.session));
            }
        }
        if (this.pinned && fEProducerSendRequest.getDestination() instanceof DistributedDestinationImpl) {
            this.addPinnedDest(fEProducerSendRequest.getDestination());
        }
        if (fEProducerSendRequest.getDestination() == null) {
            throw new weblogic.jms.common.JMSException("no failover destination");
        }
    }

    private static boolean updateInitCause(String string, Throwable throwable) {
        if (throwable.getCause() == null) {
            try {
                throwable.initCause(new JMSException(string));
                return false;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return true;
    }

    private static JMSException linkedException(JMSException jMSException, String string) {
        try {
            jMSException.setLinkedException((Exception)((Object)new weblogic.jms.common.JMSException(string)));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return jMSException;
    }

    private JMSException cannotFailoverException(String string, Throwable throwable) throws JMSException {
        if (throwable instanceof JMSException) {
            JMSException jMSException = (JMSException)throwable;
            if (FEProducer.updateInitCause(string, jMSException) && jMSException.getLinkedException() == null) {
                FEProducer.linkedException(jMSException, string);
            }
            throw jMSException;
        }
        FEProducer.updateInitCause(string, throwable);
        throw JMSUtilities.throwJMSOrRuntimeException(throwable);
    }

    private void determineFailOver(FEProducerSendRequest fEProducerSendRequest, Throwable throwable) throws JMSException {
        FEDDHandler fEDDHandler = DDManager.findFEDDHandlerByDDName(fEProducerSendRequest.getDestination().getName());
        if (fEDDHandler == null) {
            throw this.cannotFailoverException("failover is null", throwable);
        }
        JMSFailover jMSFailover = fEDDHandler.getProducerFailover((DistributedDestinationImpl)fEProducerSendRequest.getDestination(), throwable, fEProducerSendRequest.getMessage().getAdjustedDeliveryMode() == 2, this.session);
        if (jMSFailover == null) {
            throw this.cannotFailoverException("failover is null", throwable);
        }
        fEProducerSendRequest.setFailover(jMSFailover);
    }

    private void stickyMaybePickNext(FEProducerSendRequest fEProducerSendRequest, Throwable throwable) {
        if (!JMSFailover.isRecoverableFailure(throwable)) {
            this.ratifyDestinationMember(fEProducerSendRequest);
            fEProducerSendRequest.setDestination(null);
            return;
        }
        if (this.stickyDests != null && this.stickyDests.get(fEProducerSendRequest.getDestination().getName()) != null) {
            if (fEProducerSendRequest.getNumberOfRetries() == 0) {
                DistributedDestinationImpl distributedDestinationImpl = (DistributedDestinationImpl)fEProducerSendRequest.getDestination();
                fEProducerSendRequest.setDestination(DDManager.findDDImplByMemberName(distributedDestinationImpl.getInstanceName()));
                if (fEProducerSendRequest.getDestination() != null) {
                    this.ratifyDestinationMember(fEProducerSendRequest);
                }
            } else {
                fEProducerSendRequest.setDestination(null);
            }
        } else {
            fEProducerSendRequest.setDestination(((JMSFailover)fEProducerSendRequest.getFailover()).failover((DistributedDestinationImpl)fEProducerSendRequest.getDestination(), throwable));
        }
    }

    private void pickNextDestination(FEProducerSendRequest fEProducerSendRequest, Throwable throwable) throws JMSException {
        FEDDHandler fEDDHandler;
        if (fEProducerSendRequest.getUOONoFailover()) {
            throw this.cannotFailoverException("DD UUO cannot failover", throwable);
        }
        if (fEProducerSendRequest.getFailover() == null) {
            this.determineFailOver(fEProducerSendRequest, throwable);
        }
        if ((fEDDHandler = DDManager.findFEDDHandlerByDDName(fEProducerSendRequest.getDestination().getName())).getLoadBalancingPolicy() == 2) {
            this.stickyMaybePickNext(fEProducerSendRequest, throwable);
        } else {
            fEProducerSendRequest.setDestination(((JMSFailover)fEProducerSendRequest.getFailover()).failover((DistributedDestinationImpl)fEProducerSendRequest.getDestination(), throwable));
        }
        if (fEProducerSendRequest.getDestination() != null) {
            return;
        }
        if (throwable instanceof JMSException) {
            throw this.cannotFailoverException("No destination to failover. ", throwable);
        }
        throw new weblogic.jms.common.JMSException("No failover destination. ", throwable);
    }

    private void checkAndProcessStaleness(FEProducerSendRequest fEProducerSendRequest) throws weblogic.jms.common.JMSException {
        DestinationImpl destinationImpl = fEProducerSendRequest.getDestination();
        boolean bl = destinationImpl.isStale();
        DestinationImpl destinationImpl2 = (DestinationImpl)this.staleDestsLRUMap.get((Object)destinationImpl);
        if (destinationImpl2 != null) {
            fEProducerSendRequest.setDispatcher(null);
            fEProducerSendRequest.setDestination(destinationImpl2);
            return;
        }
        if (!bl) {
            return;
        }
        fEProducerSendRequest.setDispatcher(null);
        try {
            destinationImpl2 = this.session.getConnection().createDestination(destinationImpl);
            this.staleDestsLRUMap.put((Object)destinationImpl, (Object)destinationImpl2);
            fEProducerSendRequest.setDestination(destinationImpl2);
        }
        catch (JMSException jMSException) {
            throw new weblogic.jms.common.JMSException("JMSException while creating destination. ", (Throwable)jMSException);
        }
    }

    private void updateProducerDestination(FEProducerSendRequest fEProducerSendRequest) {
        if (this.producerDestination == null) {
            return;
        }
        DestinationImpl destinationImpl = this.producerDestination;
        this.addAndNormalizeDestination(fEProducerSendRequest.getDestination(), fEProducerSendRequest.getDispatcher());
        if (this.producerDispatcher != null) {
            this.producerDispatcher.removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter(destinationImpl, null));
            this.producerDispatcher = fEProducerSendRequest.getDispatcher();
        }
    }

    private void findDispatcher(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        if (fEProducerSendRequest.getDispatcher() == null && fEProducerSendRequest.getDestination() != null) {
            try {
                try {
                    SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
                    fEProducerSendRequest.setDispatcher(JMSDispatcherManager.dispatcherFindOrCreate(fEProducerSendRequest.getDestination().getDispatcherId()));
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error producing message for destination " + fEProducerSendRequest.getDestination().getName(), (Throwable)dispatcherException);
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                throw throwable;
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            this.updateProducerDestination(fEProducerSendRequest);
        }
    }

    private void setupTransactionRelated(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        if (this.session.isTransacted() && !fEProducerSendRequest.isInfected()) {
            if (fEProducerSendRequest.getMessage().propertyExists("JMS_BEA_SAF_SEQUENCE_NAME")) {
                this.session.transactedInfect(true);
            } else {
                this.session.transactedInfect();
            }
            fEProducerSendRequest.setInfected(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doDispatch(FEProducerSendRequest fEProducerSendRequest, Request request) throws JMSException {
        int n;
        int n2;
        int n3;
        BEProducerSendRequest bEProducerSendRequest;
        block16: {
            int n4;
            block15: {
                int n5;
                block14: {
                    fEProducerSendRequest.getMessage().setClientId(this.session.getConnection().getConnectionClientId());
                    bEProducerSendRequest = new BEProducerSendRequest(fEProducerSendRequest.getDestination().getId(), fEProducerSendRequest.getMessage(), fEProducerSendRequest.getDestination().isQueue() ? null : this.session.getConnection().getJMSID(), fEProducerSendRequest.getSendTimeout(), this.producerId);
                    fEProducerSendRequest.setBackendRequest(bEProducerSendRequest);
                    if (fEProducerSendRequest.getDestination() instanceof DistributedDestinationImpl) {
                        bEProducerSendRequest.setCheckUOO(fEProducerSendRequest.getCheckUOO());
                    }
                    if (JMSDebug.JMSMessagePath.isDebugEnabled() || JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        FEProducer.messageOrFrontEndDebug("FRONTEND/FEProducer: Dispatching message to BACKEND/BEDestination");
                    }
                    try {
                        request.dispatchAsync(fEProducerSendRequest.getDispatcher(), (weblogic.messaging.dispatcher.Request)bEProducerSendRequest);
                    }
                    catch (DispatcherException dispatcherException) {
                        throw new weblogic.jms.common.JMSException("Error sending message", (Throwable)dispatcherException);
                    }
                    if (fEProducerSendRequest.isNoResponse()) {
                        return 1;
                    }
                    n3 = -117;
                    n2 = -117;
                    try {
                        BEProducerSendRequest bEProducerSendRequest2 = bEProducerSendRequest;
                        synchronized (bEProducerSendRequest2) {
                            if (bEProducerSendRequest.getState() == Integer.MAX_VALUE) {
                                n2 = 1;
                                n5 = 1;
                                // MONITOREXIT @DISABLED, blocks:[1, 5, 13] lbl23 : MonitorExitStatement: MONITOREXIT : var6_7
                                Object var10_11 = null;
                                if (n3 == -117) return n5;
                                break block14;
                            }
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                n3 = bEProducerSendRequest.getState();
                            }
                            if (bEProducerSendRequest.getState() == -42 && (bEProducerSendRequest.hasResults() || fEProducerSendRequest.hasResults())) {
                                n2 = 1;
                                n4 = 1;
                                // MONITOREXIT @DISABLED, blocks:[1, 5, 12] lbl33 : MonitorExitStatement: MONITOREXIT : var6_7
                                break block15;
                            }
                            n2 = 2;
                            n = 2;
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        if (n3 == -117) throw throwable;
                        JMSDebug.JMSFrontEnd.debug("feproducer doDispatch state=" + n3 + ", returnState=" + n2 + ", hasResults=" + bEProducerSendRequest.hasResults() + ", " + bEProducerSendRequest);
                        throw throwable;
                    }
                }
                JMSDebug.JMSFrontEnd.debug("feproducer doDispatch state=" + n3 + ", returnState=" + n2 + ", hasResults=" + bEProducerSendRequest.hasResults() + ", " + bEProducerSendRequest);
                return n5;
            }
            Object var10_12 = null;
            if (n3 == -117) return n4;
            JMSDebug.JMSFrontEnd.debug("feproducer doDispatch state=" + n3 + ", returnState=" + n2 + ", hasResults=" + bEProducerSendRequest.hasResults() + ", " + bEProducerSendRequest);
            return n4;
        }
        Object var10_13 = null;
        if (n3 == -117) return n;
        JMSDebug.JMSFrontEnd.debug("feproducer doDispatch state=" + n3 + ", returnState=" + n2 + ", hasResults=" + bEProducerSendRequest.hasResults() + ", " + bEProducerSendRequest);
        return n;
    }

    private static void messageOrFrontEndDebug(String string) {
        if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
            JMSDebug.JMSMessagePath.debug(string);
        } else {
            JMSDebug.JMSFrontEnd.debug(string);
        }
    }

    private void updateStatistics(FEProducerSendRequest fEProducerSendRequest) {
        MessageImpl messageImpl = fEProducerSendRequest.getMessage();
        if (!fEProducerSendRequest.isInfected() && !this.session.isTransacted()) {
            this.incMessagesSentCount(messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize());
            this.session.getStatistics().incrementSentCount(messageImpl);
        } else {
            this.session.transactionStat(null, this, messageImpl);
        }
    }

    private void cleanupTransactionRelated(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        if (fEProducerSendRequest.isInfected()) {
            this.session.transactedDisinfect();
            fEProducerSendRequest.setInfected(false);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendRetryDestination(FEProducerSendRequest var1_1) throws JMSException {
        var2_2 = null;
        block19: while (true) {
            if (var1_1.getState() == 0x7FFFFFFF) {
                return;
            }
            switch (var1_1.getState()) {
                case 4: {
                    this.pickFirstDestination(var1_1);
                    var3_3 = JMSSecurityHelper.getCurrentSubject();
                    var1_1.setAuthenticatedSubject(var3_3);
                }
                case 2: {
                    if (var1_1.getDestination() != null && this.interceptionPoint(1, var1_1) == 2) {
                        return;
                    }
                }
                case 5: {
                    try {
                        this.findDispatcher(var1_1);
                    }
                    catch (JMSException var4_5) {
                        var5_8 = var4_5.getCause();
                        if (!(var5_8 instanceof DispatcherException)) {
                            throw var4_5;
                        }
                        var2_2 = var5_8;
                        var1_1.setState(3);
                        continue block19;
                    }
                    this.setupTransactionRelated(var1_1);
                    var1_1.setState(1);
                    try {
                        try {
                            if (var1_1.getPushPopSubject()) {
                                SecurityServiceManager.pushSubject((AuthenticatedSubject)FEProducer.KERNEL_ID, (AuthenticatedSubject)((AuthenticatedSubject)var1_1.getAuthenticatedSubject()));
                            }
                            if (this.doDispatch(var1_1, var1_1) != 2) ** GOTO lbl63
                            var7_15 = null;
                            if (var1_1.getPushPopSubject() == false) return;
                        }
                        catch (JMSOrderException var4_6) {
                            this.setupFailover(var1_1);
                            this.throwIfUOOFanoutMessage(var1_1, (Throwable)var4_6);
                            this.processUOOCache(var1_1, null, var4_6);
                            var7_15 = null;
                            if (!var1_1.getPushPopSubject()) continue block19;
                            SecurityServiceManager.popSubject((AuthenticatedSubject)FEProducer.KERNEL_ID);
                            continue block19;
                        }
                        catch (JMSException var4_7) {
                            var5_8 = var4_7.getCause();
                            if (!(var5_8 instanceof DispatcherException)) {
                                throw var4_7;
                            }
                            var2_2 = var5_8;
                            var1_1.setState(3);
                            var7_15 = null;
                            if (!var1_1.getPushPopSubject()) continue block19;
                            SecurityServiceManager.popSubject((AuthenticatedSubject)FEProducer.KERNEL_ID);
                            continue block19;
                        }
                    }
                    catch (Throwable var6_14) {
                        var7_15 = null;
                        if (var1_1.getPushPopSubject()) {
                            SecurityServiceManager.popSubject((AuthenticatedSubject)FEProducer.KERNEL_ID);
                        }
                        throw var6_14;
                    }
                    SecurityServiceManager.popSubject((AuthenticatedSubject)FEProducer.KERNEL_ID);
                    return;
lbl63:
                    // 1 sources

                    var7_15 = null;
                    if (var1_1.getPushPopSubject()) {
                        SecurityServiceManager.popSubject((AuthenticatedSubject)FEProducer.KERNEL_ID);
                    }
                }
                case 1: {
                    try {
                        this.setupTransactionRelated(var1_1);
                        if (var1_1.getBackendRequest().hasResults()) {
                            var4_4 = var1_1.getBackendRequest().getResult();
                        } else {
                            var1_1.getBackendRequest().waitForNotRunningResult();
                            var4_4 = var1_1.getBackendRequest().getResult();
                        }
                        var1_1.setResult(var4_4);
                    }
                    catch (Error var5_9) {
                        throw var5_9;
                    }
                    catch (RuntimeException var5_10) {
                        throw var5_10;
                    }
                    catch (JMSOrderException var5_11) {
                        this.setupFailover(var1_1);
                        this.throwIfUOOFanoutMessage(var1_1, (Throwable)var5_11);
                        this.processUOOCache(var1_1, null, var5_11);
                        continue block19;
                    }
                    catch (Throwable var5_12) {
                        var6_13 = this.findOrderExceptionCause(var5_12);
                        if (var6_13 != null) {
                            this.setupFailover(var1_1);
                            this.throwIfUOOFanoutMessage(var1_1, (Throwable)var6_13);
                            this.processUOOCache(var1_1, null, var6_13);
                            continue block19;
                        }
                        if (!JMSFailover.isRecoverableFailure(var5_12)) {
                            var1_1.setState(0x7FFFFFFF);
                            var1_1.resumeRequest(var5_12, var1_1.getBackendRequest().isCollocated());
                            return;
                        }
                        var2_2 = var5_12;
                        var1_1.setState(3);
                        continue block19;
                    }
                    this.responseCheck(var4_4);
                    this.processUOOCache(var1_1, var4_4, null);
                    this.ratifyDestinationMember(var1_1);
                    var1_1.setState(0x7FFFFFFF);
                    return;
                }
                case 3: {
                    var1_1.setUpPushPopSubject(true);
                    this.setupFailover(var1_1);
                    this.throwIfUOOFanoutMessage(var1_1, var2_2);
                    this.pickNextDestination(var1_1, var2_2);
                    var1_1.setNumberOfRetries(var1_1.getNumberOfRetries() + 1);
                    continue block19;
                }
            }
        }
    }

    private void throwIfUOOFanoutMessage(FEProducerSendRequest fEProducerSendRequest, Throwable throwable) throws JMSException {
        if (fEProducerSendRequest.getMessage().getControlOpcode() == 196608) {
            throw this.cannotFailoverException("control DD cannot failover", throwable);
        }
    }

    private void ratifyDestinationMember(FEProducerSendRequest fEProducerSendRequest) {
        FEDDHandler fEDDHandler = DDManager.findFEDDHandlerByDDName(fEProducerSendRequest.getDestination().getName());
        if (fEDDHandler == null) {
            return;
        }
        if (fEDDHandler.getLoadBalancingPolicy() != 2) {
            return;
        }
        if (this.stickyDests == null) {
            this.stickyDests = new HashMap();
        }
        this.stickyDests.put(fEProducerSendRequest.getDestination().getName(), fEProducerSendRequest.getDestination());
    }

    private void setupFailover(FEProducerSendRequest fEProducerSendRequest) {
        this.cleanFailure(fEProducerSendRequest.getDestination());
        fEProducerSendRequest.setDispatcher(null);
        fEProducerSendRequest.clearState();
        fEProducerSendRequest.setState(2);
    }

    private void validateMessageOnSingleDestination(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        this.initializeRoutingCriteria(fEProducerSendRequest);
    }

    private void sendSingleDestination(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        block9: while (fEProducerSendRequest.getState() != Integer.MAX_VALUE) {
            switch (fEProducerSendRequest.getState()) {
                case 4: {
                    this.validateMessageOnSingleDestination(fEProducerSendRequest);
                    if (this.producerDestination == null) {
                        this.pickFirstDestination(fEProducerSendRequest);
                        if (fEProducerSendRequest.getDestination() instanceof DistributedDestinationImpl) {
                            fEProducerSendRequest.setState(2);
                            this.sendRetryDestination(fEProducerSendRequest);
                            return;
                        }
                    } else {
                        fEProducerSendRequest.setDispatcher(this.producerDispatcher);
                    }
                }
                case 2: {
                    this.checkAndProcessStaleness(fEProducerSendRequest);
                    if (this.interceptionPoint(1, fEProducerSendRequest) == 2) {
                        return;
                    }
                }
                case 5: {
                    this.findDispatcher(fEProducerSendRequest);
                    this.setupTransactionRelated(fEProducerSendRequest);
                    fEProducerSendRequest.setState(1);
                    if (this.doDispatch(fEProducerSendRequest, fEProducerSendRequest) == 2) {
                        return;
                    }
                }
                case 1: {
                    try {
                        Response response = null;
                        this.setupTransactionRelated(fEProducerSendRequest);
                        if (fEProducerSendRequest.isNoResponse()) {
                            fEProducerSendRequest.setState(Integer.MAX_VALUE);
                        } else {
                            response = fEProducerSendRequest.getBackendRequest().getResult();
                            this.responseCheck(response);
                            fEProducerSendRequest.setResult(response);
                            fEProducerSendRequest.setState(Integer.MAX_VALUE);
                        }
                        return;
                    }
                    catch (JMSException jMSException) {
                        this.handleStaleDest(fEProducerSendRequest, jMSException);
                    }
                }
                case 3: {
                    fEProducerSendRequest.clearResult();
                    fEProducerSendRequest.setState(2);
                    continue block9;
                }
            }
        }
    }

    private void handleStaleDest(FEProducerSendRequest fEProducerSendRequest, JMSException jMSException) throws JMSException {
        if (FESession.isStaleDestEx(jMSException) && fEProducerSendRequest.getNumberOfRetries() == 0) {
            fEProducerSendRequest.getDestination().markStale();
            fEProducerSendRequest.setNumberOfRetries(fEProducerSendRequest.getNumberOfRetries() + 1);
            fEProducerSendRequest.setState(3);
            return;
        }
        throw jMSException;
    }

    private void checkInterceptionReturn(FEProducerSendRequest fEProducerSendRequest, int n) throws JMSException {
        if (this.interceptionException != null) {
            throw new JMSException("Interception exception" + this.interceptionException);
        }
        if (!this.interceptionSaidContinue) {
            JMSMessageId jMSMessageId;
            try {
                jMSMessageId = JMSService.getService().getNextMessageId();
            }
            catch (ManagementException managementException) {
                throw new weblogic.jms.common.JMSException("Failed to get MessageID: " + (Object)((Object)managementException));
            }
            fEProducerSendRequest.setResult(new JMSProducerSendResponse(jMSMessageId));
            fEProducerSendRequest.setState(Integer.MAX_VALUE);
        } else {
            fEProducerSendRequest.setState(n);
        }
    }

    public void onCallBack(boolean bl) {
        this.interceptionSaidContinue = bl;
        this.currentRequest.resumeExecution(true);
        this.currentRequest = null;
    }

    public void onException(InterceptionProcessorException interceptionProcessorException) {
        this.interceptionException = interceptionProcessorException;
        this.currentRequest.resumeExecution(true);
        this.currentRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int send(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        boolean bl;
        this.session.checkShutdownOrSuspended();
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("FEProducer.send() : state = " + fEProducerSendRequest.getState());
        }
        do {
            Object var9_10;
            boolean bl2 = false;
            bl = false;
            try {
                switch (fEProducerSendRequest.getState()) {
                    case 8: {
                        int n = this.releaseFanoutComplete(fEProducerSendRequest);
                        var9_10 = null;
                        if (bl2) return n;
                        this.inSend = false;
                        this.cleanupTransactionRelated(fEProducerSendRequest);
                        return n;
                    }
                    case 7: {
                        this.checkInterceptionReturn(fEProducerSendRequest, 5);
                        bl = true;
                        var9_10 = null;
                        if (bl2) break;
                        this.inSend = false;
                        this.cleanupTransactionRelated(fEProducerSendRequest);
                        break;
                    }
                    case 6: {
                        this.checkInterceptionReturn(fEProducerSendRequest, 4);
                        bl = true;
                        var9_10 = null;
                        if (bl2) break;
                        this.inSend = false;
                        this.cleanupTransactionRelated(fEProducerSendRequest);
                        break;
                    }
                    case 0: {
                        MessageTimeStamp.record(1, fEProducerSendRequest.getMessage());
                        if (this.inSend) {
                            // empty if block
                        }
                        this.inSend = true;
                        MessageImpl messageImpl = fEProducerSendRequest.getMessage();
                        boolean bl3 = false;
                        if (messageImpl.getId() == null) {
                            messageImpl.setId(JMSService.getJMSService().getNextMessageId());
                            bl3 = true;
                        }
                        if (messageImpl.getJMSExpiration() != 0L) {
                            messageImpl.setJMSExpiration((bl3 ? messageImpl.getJMSTimestamp() : System.currentTimeMillis()) + messageImpl.getJMSExpiration());
                        }
                        if (messageImpl.getDeliveryTime() > 0L) {
                            messageImpl.setDeliveryTime((bl3 ? messageImpl.getJMSTimestamp() : System.currentTimeMillis()) + messageImpl.getDeliveryTime());
                        }
                        if (messageImpl.isForwardable()) {
                            messageImpl.incForwardsCount();
                            messageImpl.requestJMSXUserID(false);
                        } else {
                            if (this.session.getConnection().getAttachJMSXUserID()) {
                                messageImpl.requestJMSXUserID(true);
                            } else {
                                messageImpl.requestJMSXUserID(false);
                            }
                            messageImpl.setJMSXUserID(null);
                        }
                        if (this.producerDestination != null) {
                            fEProducerSendRequest.setDestination(this.producerDestination);
                        }
                        SAFReplyHandler.process(messageImpl);
                        if (this.interceptionPoint(0, fEProducerSendRequest) == 2) {
                            int n = fEProducerSendRequest.getState();
                            var9_10 = null;
                            if (bl2) return n;
                            this.inSend = false;
                            this.cleanupTransactionRelated(fEProducerSendRequest);
                            return n;
                        }
                        fEProducerSendRequest.setState(4);
                    }
                    default: {
                        DestinationImpl destinationImpl = fEProducerSendRequest.getDestination();
                        DestinationImpl destinationImpl2 = this.getDestinationForInterop(destinationImpl);
                        if (destinationImpl2 != null) {
                            destinationImpl = destinationImpl2;
                            fEProducerSendRequest.setDestination(destinationImpl);
                        }
                        if (destinationImpl instanceof DistributedDestinationImpl) {
                            this.sendRetryDestination(fEProducerSendRequest);
                        } else {
                            this.sendSingleDestination(fEProducerSendRequest);
                        }
                        bl2 = true;
                        var9_10 = null;
                        if (bl2) break;
                        this.inSend = false;
                        this.cleanupTransactionRelated(fEProducerSendRequest);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                var9_10 = null;
                if (!bl2) {
                    this.inSend = false;
                    this.cleanupTransactionRelated(fEProducerSendRequest);
                }
                throw throwable;
            }
        } while (bl);
        if (fEProducerSendRequest.getState() == Integer.MAX_VALUE) {
            this.inSend = false;
            this.updateStatistics(fEProducerSendRequest);
        }
        this.cleanupTransactionRelated(fEProducerSendRequest);
        return fEProducerSendRequest.getState();
    }

    private DestinationImpl getDestinationForInterop(DestinationImpl destinationImpl) {
        if (destinationImpl instanceof DistributedDestinationImpl) {
            return null;
        }
        DistributedDestinationImpl distributedDestinationImpl = DDManager.findDDImplByDDName(destinationImpl.getName());
        return distributedDestinationImpl;
    }

    public JMSID getJMSID() {
        return this.producerId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(weblogic.messaging.dispatcher.Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 5129: {
                FEProducerSendRequest fEProducerSendRequest = (FEProducerSendRequest)request;
                if (fEProducerSendRequest.getMessage().getControlOpcode() != 65536) {
                    return this.send(fEProducerSendRequest);
                }
                return this.controlSequenceReleaseFanout(fEProducerSendRequest);
            }
            case 4617: {
                this.session.checkShutdownOrSuspended();
                this.session.producerClose(this);
                this.removeDispatcher();
                break;
            }
            default: {
                throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
            }
        }
        request.setResult(new VoidResponse());
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int controlSequenceReleaseFanout(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        Externalizable externalizable;
        int n;
        DestinationImpl destinationImpl = this.producerDestination != null ? this.producerDestination : fEProducerSendRequest.getDestination();
        if (!(destinationImpl instanceof DistributedDestinationImpl)) {
            return this.send(fEProducerSendRequest);
        }
        FEDDHandler fEDDHandler = DDManager.findFEDDHandlerByDDName(fEProducerSendRequest.getDestination().getName());
        if (fEDDHandler == null) {
            return this.send(fEProducerSendRequest);
        }
        DDHandler dDHandler = fEDDHandler.getDDHandler();
        int n2 = dDHandler.getNumberOfMembers();
        if (n2 == 0) {
            return this.send(fEProducerSendRequest);
        }
        JMSException jMSException = null;
        FEProducerSendRequest[] fEProducerSendRequestArray = new FEProducerSendRequest[n2];
        try {
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
            for (n = 0; n < n2; ++n) {
                externalizable = dDHandler.getMemberByIndex(n).getDDImpl();
                fEProducerSendRequestArray[n] = new FEProducerSendRequest(this.producerId, fEProducerSendRequest.getMessage().cloneit(), (DestinationImpl)externalizable, fEProducerSendRequest.getSendTimeout(), fEProducerSendRequest.getCompressionThreshold());
                try {
                    fEProducerSendRequestArray[n].setDispatcher(JMSDispatcherManager.dispatcherFindOrCreate(((DestinationImpl)externalizable).getDispatcherId()));
                    continue;
                }
                catch (DispatcherException dispatcherException) {
                    jMSException = new weblogic.jms.common.JMSException(dispatcherException);
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        fEProducerSendRequest.needOutsideResult();
        for (n = 0; n < n2; ++n) {
            try {
                if (fEProducerSendRequestArray[n].getDispatcher() != null) {
                    this.doDispatch(fEProducerSendRequestArray[n], fEProducerSendRequest);
                    continue;
                }
                if ($assertionsDisabled || jMSException != null) continue;
                throw new AssertionError();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        if (jMSException != null) {
            throw jMSException;
        }
        fEProducerSendRequest.setSubRequest(fEProducerSendRequestArray);
        externalizable = fEProducerSendRequest;
        synchronized (externalizable) {
            if (!fEProducerSendRequest.fanoutCompleteSuspendIfHaveChildren(false)) {
                fEProducerSendRequest.setState(8);
                return 8;
            }
        }
        return this.releaseFanoutComplete(fEProducerSendRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int releaseFanoutComplete(FEProducerSendRequest fEProducerSendRequestArray) throws JMSException {
        FEProducerSendRequest[] fEProducerSendRequestArray2 = fEProducerSendRequestArray;
        synchronized (fEProducerSendRequestArray) {
            fEProducerSendRequestArray.setState(Integer.MAX_VALUE);
            if (this.hasProducerResult((FEProducerSendRequest)fEProducerSendRequestArray)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Integer.MAX_VALUE;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            fEProducerSendRequestArray2 = fEProducerSendRequestArray.getSubRequest();
            JMSProducerSendResponse jMSProducerSendResponse = null;
            for (int i = 0; i < fEProducerSendRequestArray2.length; ++i) {
                FEProducerSendRequest fEProducerSendRequest = fEProducerSendRequestArray2[i];
                synchronized (fEProducerSendRequest) {
                    if (fEProducerSendRequestArray2[i].hasResults()) {
                        jMSProducerSendResponse = (JMSProducerSendResponse)fEProducerSendRequestArray2[i].getResult();
                        break;
                    }
                    continue;
                }
            }
            assert (jMSProducerSendResponse != null);
            FEProducerSendRequest[] fEProducerSendRequestArray3 = fEProducerSendRequestArray;
            synchronized (fEProducerSendRequestArray) {
                if (this.hasProducerResult((FEProducerSendRequest)fEProducerSendRequestArray)) {
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return Integer.MAX_VALUE;
                }
                fEProducerSendRequestArray.setResult(jMSProducerSendResponse);
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return Integer.MAX_VALUE;
            }
        }
    }

    private boolean hasProducerResult(FEProducerSendRequest fEProducerSendRequest) throws JMSException {
        Response response = null;
        if (fEProducerSendRequest.hasResults() && (response = fEProducerSendRequest.getResult()) instanceof JMSProducerSendResponse) {
            return true;
        }
        assert (response == null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeProducer() {
        Object object = cacheUOOLock;
        synchronized (object) {
            this.cacheUOOMember = null;
        }
        object = interceptionPointLock;
        synchronized (object) {
            block15: {
                DestinationImpl destinationImpl;
                InterceptionPointHandle interceptionPointHandle;
                block14: {
                    InterceptionPointHandle interceptionPointHandle2 = this.IPHandles[0];
                    interceptionPointHandle = this.IPHandles[1];
                    DestinationImpl destinationImpl2 = this.IPDestinations[0];
                    destinationImpl = this.IPDestinations[1];
                    if (destinationImpl2 != null && (destinationImpl2.getType() == 8 || destinationImpl2.getType() == 4)) {
                        try {
                            if (interceptionPointHandle2 != null && !interceptionPointHandle2.hasAssociation()) {
                                MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(interceptionPointHandle2);
                                this.IPHandles[0] = null;
                                this.IPDestinations[0] = null;
                            }
                        }
                        catch (InterceptionServiceException interceptionServiceException) {
                            JMSLogger.logFailedToUnregisterInterceptionPoint((Exception)interceptionServiceException);
                            if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block14;
                            JMSDebug.JMSFrontEnd.debug("FEProducer.close(), Failure to unregister startIPHandle " + interceptionServiceException);
                        }
                    }
                }
                if (destinationImpl != null && (destinationImpl.getType() == 8 || destinationImpl.getType() == 4)) {
                    try {
                        if (interceptionPointHandle != null && !interceptionPointHandle.hasAssociation()) {
                            MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(interceptionPointHandle);
                            this.IPHandles[1] = null;
                            this.IPDestinations[1] = null;
                        }
                    }
                    catch (InterceptionServiceException interceptionServiceException) {
                        JMSLogger.logFailedToUnregisterInterceptionPoint((Exception)interceptionServiceException);
                        if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block15;
                        JMSDebug.JMSFrontEnd.debug("FEProducer.close(), Failure to unregister postAuthIPHandle " + interceptionServiceException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectUOOMember(FEProducerSendRequest fEProducerSendRequest, FESession fESession) throws JMSException {
        if (!(fEProducerSendRequest.getDestination() instanceof DistributedDestinationImpl)) {
            return;
        }
        FEDDHandler fEDDHandler = DDManager.findFEDDHandlerByDDName(fEProducerSendRequest.getDestination().getName());
        if (fEDDHandler == null) {
            throw new JMSOrderException("could not find distributed destination " + fEProducerSendRequest.getDestination().getName());
        }
        fEProducerSendRequest.setUooNoFailover(true);
        String string = fEDDHandler.getUnitOfOrderRouting();
        if ("Hash".equals(string)) {
            fEProducerSendRequest.setDestination(UOOHelper.getHashBasedDestination(fEDDHandler, fEProducerSendRequest.getUnitForRouting()));
            return;
        }
        if (PathHelper.retired && PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("FEProducer DD:" + fEProducerSendRequest.getDestination().getName() + ", JndiName " + this.pathJndiName);
        }
        assert ("PathService".equals(string));
        this.pathJndiName = PathHelper.DEFAULT_PATH_SERVICE_JNDI;
        fEProducerSendRequest.setCheckUOO(0x200000);
        Object object = cacheUOOLock;
        synchronized (object) {
            DistributedDestinationImpl distributedDestinationImpl;
            BEUOOMember bEUOOMember;
            KeyString keyString;
            if (this.cacheUOOMember != null && this.cacheUOOMember.getKey().getStringId().equals(fEProducerSendRequest.getUnitForRouting()) && this.cacheUOOMember.getKey().getAssemblyId().equals(fEProducerSendRequest.getDestination().getName())) {
                keyString = this.cacheUOOMember.getKey();
            } else {
                this.cacheUOOMember = null;
                keyString = new KeyString(1, fEProducerSendRequest.getDestination().getName().intern(), fEProducerSendRequest.getUnitForRouting().intern());
            }
            if (this.cacheUOOMember != null && this.cacheUOOMember.isCancelled()) {
                this.cacheUOOMember = null;
            }
            fEProducerSendRequest.setUOOInfo(this.pathJndiName, keyString);
            try {
                bEUOOMember = (BEUOOMember)PathHelper.manager().cachedGet(this.pathJndiName, keyString, 576);
            }
            catch (NamingException namingException) {
                PathHelper.PathSvcVerbose.debug("FEProd cache unavailable Key:" + keyString, (Throwable)namingException);
                throw new JMSOrderException(namingException.getMessage(), (Throwable)namingException);
            }
            catch (Throwable throwable) {
                PathHelper.PathSvc.debug("FEProd get Key:" + keyString, throwable);
                throw JMSUtilities.throwJMSOrRuntimeException(PathHelper.wrapExtensionImpl(throwable));
            }
            if (bEUOOMember != this.cacheUOOMember) {
                if (bEUOOMember instanceof CacheUOOMember) {
                    if (this.cacheUOOMember != null && this.cacheUOOMember.isCancelled()) {
                        this.cacheUOOMember = null;
                    }
                    if (this.cacheUOOMember == null) {
                        this.cacheUOOMember = (CacheUOOMember)bEUOOMember;
                    } else {
                        this.cacheUOOMember.merge(bEUOOMember);
                    }
                } else if (this.cacheUOOMember == null) {
                    this.cacheUOOMember = new CacheUOOMember(keyString, bEUOOMember, System.currentTimeMillis() + (long)TTL_GUESS);
                } else if (bEUOOMember != null) {
                    this.cacheUOOMember.merge(bEUOOMember);
                }
            }
            if (this.cacheUOOMember != null) {
                if (!UOOHelper.cacheUpToDate(fEDDHandler, (String)((Object)this.cacheUOOMember.getMemberId()), this.cacheUOOMember.getLastHasConsumers(), fEProducerSendRequest.getMessage())) {
                    this.cacheUOOMember = null;
                } else {
                    this.cacheUOOMember.setLastHasConsumers(UOOHelper.hasConsumers(fEDDHandler, (String)((Object)this.cacheUOOMember.getMemberId())));
                }
            }
            if (this.cacheUOOMember == null) {
                distributedDestinationImpl = (DistributedDestinationImpl)this.computeTypicalLoadBalance(fEDDHandler, fEProducerSendRequest, fESession);
                if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
                    PathHelper.PathSvcVerbose.debug("FEProd cache miss Key:" + keyString + ", balance:" + fEProducerSendRequest.getDestination().getName());
                }
                this.cacheUOOMember = new CacheUOOMember(keyString, distributedDestinationImpl.getMemberName(), distributedDestinationImpl.getServerName(), distributedDestinationImpl.getNonSystemSubscriberConsumers() != 0, TTL_GUESS);
            } else {
                distributedDestinationImpl = null;
            }
            if (PathHelper.retired && PathHelper.PathSvcVerbose.isDebugEnabled()) {
                PathHelper.PathSvcVerbose.debug("FEProd cache hit Key:" + keyString + ", got:" + this.cacheUOOMember);
            }
            String string2 = this.cacheUOOMember.getStringId();
            fEProducerSendRequest.setDestination(DDManager.findDDImplByMemberName(string2));
            if (fEProducerSendRequest.getDestination() == null) {
                throw new JMSOrderException("unable to reach member " + string2 + " of " + fEDDHandler.getName() + " from keys " + fEDDHandler.getDDHandler().debugKeys() + (distributedDestinationImpl == null ? " cached " : " typicalLoadBalance ") + this.cacheUOOMember.getStringId());
            }
            if (bEUOOMember instanceof CacheUOOMember) {
                if (bEUOOMember != this.cacheUOOMember) {
                    ((CacheUOOMember)bEUOOMember).copyValues(this.cacheUOOMember, this.cacheUOOMember.getExpireTime());
                }
                return;
            }
            try {
                CompletionRequest completionRequest = new CompletionRequest();
                PathHelper.manager().cachedPutIfAbsent(this.pathJndiName, this.cacheUOOMember.getKey(), this.cacheUOOMember, 512, completionRequest);
                completionRequest.getResult();
            }
            catch (NamingException namingException) {
                PathHelper.PathSvcVerbose.debug("FEProd cache unavailable Key:" + keyString, (Throwable)namingException);
                throw new JMSOrderException(namingException.getMessage(), (Throwable)namingException);
            }
            catch (Throwable throwable) {
                PathHelper.PathSvc.debug("FEProd get Key:" + keyString, throwable);
                throw JMSUtilities.throwJMSOrRuntimeException(PathHelper.wrapExtensionImpl(throwable));
            }
        }
    }

    private DestinationImpl computeTypicalLoadBalance(FEDDHandler fEDDHandler, FEProducerSendRequest fEProducerSendRequest, FESession fESession) throws JMSException {
        DestinationImpl destinationImpl;
        if (fEDDHandler == null) {
            assert (fEProducerSendRequest.getDestination() != null);
            fEDDHandler = DDManager.findFEDDHandlerByDDName(fEProducerSendRequest.getDestination().getName());
        }
        if (fEDDHandler == null) {
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("DD named: " + fEProducerSendRequest.getDestination().getName() + " not found");
            }
            return fEProducerSendRequest.getDestination();
        }
        if (fEDDHandler.getLoadBalancingPolicy() == 2 && this.stickyDests != null && (destinationImpl = (DestinationImpl)this.stickyDests.get(fEProducerSendRequest.getDestination().getName())) != null) {
            return destinationImpl;
        }
        boolean bl = fEProducerSendRequest.getMessage().getAdjustedDeliveryMode() == 2;
        DestinationImpl destinationImpl2 = fEDDHandler.producerLoadBalance(bl, fESession);
        if (destinationImpl2 == null) {
            if (JMSDebug.JMSMessagePath.isDebugEnabled() || JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("Load Balancer can't find a candidate for load balancing for DD: " + fEProducerSendRequest.getDestination().getName());
            }
            throw new weblogic.jms.common.JMSException("Distributed Destination " + fEProducerSendRequest.getDestination().getName() + " does not have any member destinations which are active");
        }
        return destinationImpl2;
    }

    private JMSOrderException findOrderExceptionCause(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof JMSOrderException) {
                return (JMSOrderException)((Object)throwable);
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUOOCache(FEProducerSendRequest fEProducerSendRequest, Object object, JMSOrderException jMSOrderException) throws JMSOrderException {
        BEUOOMember bEUOOMember;
        Object object2;
        block24: {
            if (JMSDebug.JMSMessagePath.isDebugEnabled() || JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                FEProducer.messageOrFrontEndDebug("FEProducer DD UOO Failover recalculation");
            }
            if (jMSOrderException != null) {
                object2 = jMSOrderException;
                do {
                    if ((bEUOOMember = (BEUOOMember)object2.getMember()) == null) continue;
                    object2.setMember(null);
                    fEProducerSendRequest.setDestination(DDManager.findDDImplByMemberName((String)((Object)bEUOOMember.getMemberId())));
                    if (fEProducerSendRequest.getDestination() == null) {
                        throw new JMSOrderException("unable to contact member " + bEUOOMember.getMemberId() + ", keys are " + DDManager.debugKeys(), (Throwable)((Object)jMSOrderException));
                    }
                    break block24;
                } while ((object2 = this.findOrderExceptionCause(object2.getCause())) != null);
                throw jMSOrderException;
            }
            object2 = (JMSProducerSendResponse)object;
            bEUOOMember = (BEUOOMember)((JMSProducerSendResponse)object2).getUOOInfo();
            ((JMSProducerSendResponse)object2).setUOOInfo(null);
        }
        fEProducerSendRequest.setNumberOfRetries(fEProducerSendRequest.getNumberOfRetries() + 1);
        if (fEProducerSendRequest.getMessage().getControlOpcode() == 196608) {
            object2 = cacheUOOLock;
            synchronized (object2) {
                if (this.cacheUOOMember == null) {
                    return;
                }
                this.cacheUOOMember.setCancelled(true);
                try {
                    try {
                        PathHelper.manager().cachedRemove(this.pathJndiName, this.cacheUOOMember.getKey(), this.cacheUOOMember, 512, new CompletionRequest());
                    }
                    catch (NamingException namingException) {
                        throw new JMSOrderException(namingException.getMessage(), (Throwable)namingException);
                    }
                    Object var8_6 = null;
                    this.cacheUOOMember = null;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    this.cacheUOOMember = null;
                    throw throwable;
                }
            }
            return;
        }
        if (bEUOOMember == null) {
            if (fEProducerSendRequest.getUOOKey() != null) {
                object2 = cacheUOOLock;
                synchronized (object2) {
                    if (this.cacheUOOMember != null) {
                        this.cacheUOOMember.setExpireTime(FEProducer.TTL_CONFIRMED);
                    }
                }
            }
            return;
        }
        if (PathHelper.PathSvcVerbose.isDebugEnabled()) {
            PathHelper.PathSvcVerbose.debug("FE Caching update " + bEUOOMember + " for key " + fEProducerSendRequest.getUOOKey());
        }
        object2 = cacheUOOLock;
        synchronized (object2) {
            assert (this.cacheUOOMember != null);
            this.cacheUOOMember.copyValues(bEUOOMember, System.currentTimeMillis() + (long)FEProducer.TTL_CONFIRMED);
        }
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        Serializable serializable;
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Producer");
        xMLStreamWriter.writeAttribute("id", this.producerId != null ? this.producerId.toString() : "");
        xMLStreamWriter.writeAttribute("messagesSentCount", String.valueOf(this.messagesSentCount));
        xMLStreamWriter.writeAttribute("messagesPendingCount", String.valueOf(this.messagesPendingCount));
        xMLStreamWriter.writeAttribute("bytesSentCount", String.valueOf(this.bytesSentCount));
        xMLStreamWriter.writeAttribute("bytesPendingCount", String.valueOf(this.bytesPendingCount));
        xMLStreamWriter.writeAttribute("isPinned", String.valueOf(this.pinned));
        if (this.cacheUOOMember != null) {
            xMLStreamWriter.writeAttribute("uooMemberKey", this.cacheUOOMember.getKey().toString());
        }
        if (this.producerDestination != null) {
            xMLStreamWriter.writeStartElement("Destination");
            JMSDiagnosticImageSource.dumpDestinationImpl(xMLStreamWriter, this.producerDestination);
            xMLStreamWriter.writeEndElement();
        }
        if (this.pinnedDests != null) {
            serializable = (HashMap)this.pinnedDests.clone();
            xMLStreamWriter.writeStartElement("PinnedDestinations");
            xMLStreamWriter.writeAttribute("currentCount", String.valueOf(((HashMap)serializable).size()));
            for (DestinationImpl destinationImpl : ((HashMap)serializable).values()) {
                xMLStreamWriter.writeStartElement("Destination");
                JMSDiagnosticImageSource.dumpDestinationImpl(xMLStreamWriter, destinationImpl);
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
        if ((serializable = this.currentRequest) != null) {
            xMLStreamWriter.writeStartElement("CurrentSendRequest");
            xMLStreamWriter.writeAttribute("jmsMessageID", ((FEProducerSendRequest)serializable).getMessage().getJMSMessageID().toString());
            xMLStreamWriter.writeAttribute("sendTimeout", String.valueOf(((FEProducerSendRequest)serializable).getSendTimeout()));
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
    }

    public void removeDispatcher() {
        if (this.producerDispatcher != null) {
            this.producerDispatcher.removeDispatcherPeerGoneListener(new DestinationPeerGoneAdapter(this.producerDestination, null));
        }
    }

    private class CacheUOOMember
    extends BEUOOMember
    implements ExtendedBEUOOMember {
        static final long serialVersionUID = 1771787601821860231L;
        private transient KeyString keyString;
        private transient boolean cancelled;
        private transient boolean lastHasConsumers;
        private transient long expireTime;

        CacheUOOMember(KeyString keyString, BEUOOMember bEUOOMember, long l) {
            super(bEUOOMember.getStringId(), bEUOOMember.getWLServerName(), bEUOOMember.getDynamic());
            this.keyString = keyString;
            this.lastHasConsumers = false;
            this.copyValues(bEUOOMember, l);
        }

        CacheUOOMember(KeyString keyString, String string, String string2, boolean bl, long l) {
            super(string, string2, true);
            this.keyString = keyString;
            this.lastHasConsumers = bl;
            this.expireTime = l;
        }

        public CacheUOOMember() {
        }

        private void copyValues(BEUOOMember bEUOOMember, long l) {
            this.serverName = bEUOOMember.getWLServerName();
            this.generation = bEUOOMember.getGeneration();
            this.timestamp = bEUOOMember.getTimeStamp();
            this.id = bEUOOMember.getStringId();
            this.dynamic = bEUOOMember.getDynamic();
            this.expireTime = l;
            if (bEUOOMember instanceof CacheUOOMember) {
                this.keyString = ((CacheUOOMember)bEUOOMember).keyString;
                this.lastHasConsumers = ((CacheUOOMember)bEUOOMember).lastHasConsumers;
            }
        }

        private void merge(BEUOOMember bEUOOMember) {
            long l;
            if (bEUOOMember instanceof CacheUOOMember) {
                if (this.expireTime > ((CacheUOOMember)bEUOOMember).expireTime) {
                    return;
                }
                l = ((CacheUOOMember)bEUOOMember).expireTime;
            } else {
                l = System.currentTimeMillis() + (long)TTL_GUESS;
                this.lastHasConsumers = false;
            }
            this.copyValues(bEUOOMember, l);
        }

        private KeyString getKey() {
            return this.keyString;
        }

        private void setLastHasConsumers(boolean bl) {
            this.lastHasConsumers = bl;
        }

        private boolean getLastHasConsumers() {
            return this.lastHasConsumers;
        }

        private long setExpireTime(int n) {
            this.expireTime = System.currentTimeMillis() + (long)n;
            return this.expireTime;
        }

        private long getExpireTime() {
            return this.expireTime;
        }

        private boolean isCancelled() {
            return this.cancelled;
        }

        private void setCancelled(boolean bl) {
            this.cancelled = bl;
        }
    }

    public static interface ExtendedBEUOOMember
    extends Member {
        public boolean getDynamic();

        public String getStringId();

        public void setTimestamp(long var1);

        public void setGeneration(int var1);
    }
}

