/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FERemoveSubscriptionRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 4562660717591850604L;
    private String clientId;
    private String name;
    private int clientIdPolicy = 0;
    private JMSServerId backEndId;
    private String destinationName;
    private DestinationImpl destination;
    private static final int EXTVERSION_PRE_1033 = 1;
    private static final int EXTVERSION_1033 = 2;
    private static final int EXTVERSION_1034 = 3;
    private static final int EXTVERSION = 3;
    private static final int VERSION_MASK = 255;
    private static final int HAS_JMSSERVER_ID = 256;
    private static final int HAS_DESTINATION_NAME = 512;
    private static final int HAS_DESTINATION = 1024;
    static final int START = 0;
    static final int WAIT = 1;

    public FERemoveSubscriptionRequest(String string, String string2) {
        super(null, 5377);
        this.clientId = string;
        this.name = string2;
    }

    public FERemoveSubscriptionRequest(String string, String string2, int n, JMSServerId jMSServerId, String string3) {
        this(string, string2);
        this.clientIdPolicy = n;
        this.destinationName = string3;
        this.backEndId = jMSServerId;
    }

    public FERemoveSubscriptionRequest(String string, String string2, int n, DestinationImpl destinationImpl) {
        this(string, string2);
        this.clientIdPolicy = n;
        this.destination = destinationImpl;
        this.backEndId = destinationImpl.getBackEndId();
        this.destinationName = destinationImpl.getTopicName();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public JMSServerId getBackEndId() {
        return this.backEndId;
    }

    void setBackEndId(JMSServerId jMSServerId) {
        this.backEndId = jMSServerId;
    }

    public DestinationImpl getDestination() {
        return this.destination;
    }

    void setDestination(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
        this.backEndId = destinationImpl.getBackEndId();
        this.destinationName = destinationImpl.getTopicName();
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FERemoveSubscriptionRequest() {
    }

    private byte getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1033) < 0) {
                return 1;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1034) < 0) {
                return 2;
            }
        }
        return 3;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        objectOutput = this.getVersionedStream(objectOutput);
        int n2 = n = this.getVersion(objectOutput);
        if (n >= 3) {
            if (this.destination != null) {
                n2 |= 0x400;
            }
        } else if (n >= 2) {
            if (this.backEndId != null) {
                n2 |= 0x100;
            }
            if (this.destinationName != null) {
                n2 |= 0x200;
            }
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.clientId);
        objectOutput.writeUTF(this.name);
        if (n >= 3) {
            objectOutput.writeInt(this.clientIdPolicy);
            if (this.destination != null) {
                this.destination.writeExternal(objectOutput);
            }
        } else if (n >= 2) {
            objectOutput.writeInt(this.clientIdPolicy);
            if (this.backEndId != null) {
                this.backEndId.writeExternal(objectOutput);
            }
            if (this.destinationName != null) {
                objectOutput.writeUTF(this.destinationName);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw JMSUtilities.versionIOException(n2, 1, 3);
        }
        super.readExternal(objectInput);
        this.clientId = objectInput.readUTF();
        this.name = objectInput.readUTF();
        if (n2 >= 3) {
            this.clientIdPolicy = objectInput.readInt();
            if ((n & 0x400) != 0) {
                this.destination = new DestinationImpl();
                this.destination.readExternal(objectInput);
                this.backEndId = this.destination.getBackEndId();
                this.destinationName = this.destination.getTopicName();
            }
        } else if (n2 >= 2) {
            this.clientIdPolicy = objectInput.readInt();
            if ((n & 0x100) != 0) {
                this.backEndId = new JMSServerId();
                this.backEndId.readExternal(objectInput);
            }
            if ((n & 0x200) != 0) {
                this.destinationName = objectInput.readUTF();
            }
        }
    }
}

