/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class FEServerSessionPoolCloseRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 4982031104004704411L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private JMSServerId backEndId;
    private JMSID serverSessionPoolId;

    public FEServerSessionPoolCloseRequest(JMSServerId jMSServerId, JMSID jMSID) {
        super(null, 5633);
        this.backEndId = jMSServerId;
        this.serverSessionPoolId = jMSID;
    }

    public final JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public final JMSID getServerSessionPoolId() {
        return this.serverSessionPoolId;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public FEServerSessionPoolCloseRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.backEndId.writeExternal(objectOutput);
        this.serverSessionPoolId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.backEndId = new JMSServerId();
        this.backEndId.readExternal(objectInput);
        this.serverSessionPoolId = new JMSID();
        this.serverSessionPoolId.readExternal(objectInput);
    }
}

