/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSServerSessionPoolCreateResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class FEServerSessionPoolCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 8825493097866359520L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TRANSACTED_MASK = 256;
    private static final int CLIENT_DATA_MASK = 512;
    private JMSServerId backEndId;
    private int sessionsMaximum;
    private int acknowledgeMode;
    private boolean transacted;
    private String messageListenerClass;
    private Serializable clientData;

    public FEServerSessionPoolCreateRequest(JMSID jMSID, JMSServerId jMSServerId, int n, int n2, boolean bl, String string, Serializable serializable) {
        super(jMSID, 5895);
        this.backEndId = jMSServerId;
        this.sessionsMaximum = n;
        this.acknowledgeMode = n2;
        this.transacted = bl;
        this.messageListenerClass = string;
        this.clientData = serializable;
    }

    public final JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public final int getSessionMaximum() {
        return this.sessionsMaximum;
    }

    public final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public final boolean isTransacted() {
        return this.transacted;
    }

    public final String getMessageListenerClass() {
        return this.messageListenerClass;
    }

    public final Serializable getClientData() {
        return this.clientData;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new JMSServerSessionPoolCreateResponse();
    }

    public FEServerSessionPoolCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.transacted) {
            n |= 0x100;
        }
        if (this.clientData != null) {
            n |= 0x200;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.backEndId.writeExternal(objectOutput);
        objectOutput.writeInt(this.sessionsMaximum);
        objectOutput.writeInt(this.acknowledgeMode);
        objectOutput.writeUTF(this.messageListenerClass);
        if (this.clientData != null) {
            objectOutput.writeObject(this.clientData);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.backEndId = new JMSServerId();
        this.backEndId.readExternal(objectInput);
        this.sessionsMaximum = objectInput.readInt();
        this.acknowledgeMode = objectInput.readInt();
        this.messageListenerClass = objectInput.readUTF();
        if ((n & 0x200) != 0) {
            this.clientData = (Serializable)objectInput.readObject();
        }
        this.transacted = (n & 0x100) != 0;
    }
}

