/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEBrowserCreateRequest;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BESessionAcknowledgeRequest;
import weblogic.jms.backend.BESessionCloseRequest;
import weblogic.jms.backend.BESessionCreateRequest;
import weblogic.jms.backend.BESessionRecoverRequest;
import weblogic.jms.backend.BESessionSetRedeliveryDelayRequest;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DDTxLoadBalancingOptimizer;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageContextImpl;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSSessionRecoverResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageStatistics;
import weblogic.jms.common.PushTarget;
import weblogic.jms.common.Sequencer;
import weblogic.jms.common.Subscription;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.frontend.FEBrowser;
import weblogic.jms.frontend.FEBrowserCreateRequest;
import weblogic.jms.frontend.FEConnection;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.jms.frontend.FEConsumer;
import weblogic.jms.frontend.FEConsumerCreateRequest;
import weblogic.jms.frontend.FEConsumerCreateResponse;
import weblogic.jms.frontend.FEDDHandler;
import weblogic.jms.frontend.FEProducer;
import weblogic.jms.frontend.FEProducerCreateRequest;
import weblogic.jms.frontend.FEProducerCreateResponse;
import weblogic.jms.frontend.FESessionAcknowledgeRequest;
import weblogic.jms.frontend.FESessionCloseRequest;
import weblogic.jms.frontend.FESessionRecoverRequest;
import weblogic.jms.frontend.FESessionSetRedeliveryDelayRequest;
import weblogic.jms.frontend.FrontEnd;
import weblogic.jms.frontend.UnackedMessage;
import weblogic.jms.utils.tracing.MessageTimeStamp;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSConsumerRuntimeMBean;
import weblogic.management.runtime.JMSProducerRuntimeMBean;
import weblogic.management.runtime.JMSSessionRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.interception.MessageInterceptionService;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.messaging.interception.interfaces.InterceptionPointHandle;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.work.IDBasedConstraintEnforcement;
import weblogic.work.WorkManagerFactory;

public final class FESession
extends RuntimeMBeanDelegate
implements PushTarget,
JMSSessionRuntimeMBean,
Invocable,
JMSPeerGoneListener,
DDTxLoadBalancingOptimizer {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    static final long serialVersionUID = -2124132935744596179L;
    private final JMSID sessionId;
    private final FEConnection connection;
    private HashMap sequencers = new HashMap();
    private long nextSequenceNumber = 1L;
    private final JMSService service;
    private final MessageStatistics statistics = new MessageStatistics();
    private final boolean transacted;
    private final boolean xaSession;
    private volatile boolean transactionInUse;
    private TransactionManager tranManager;
    private weblogic.transaction.Transaction transactedSessionTx;
    private JMSException transactedException;
    private final InvocableMonitor invocableMonitor;
    private Hashtable tranDestinations;
    private Hashtable tranPersistentDestinations;
    private Set tranDispatchers;
    private AuthenticatedSubject subjectForQOS = null;
    private final int acknowledgeMode;
    private final int originalAcknowledgeMode;
    private String pushWorkManager;
    private JMSPushEntry firstUnackedPushEntry;
    private JMSPushEntry lastUnackedPushEntry;
    private UnackedMessage firstTranStatUnackedMessage;
    private UnackedMessage lastTranStatUnackedMessage;
    private final HashMap consumers = new HashMap();
    private long consumersHighCount = 0L;
    private long consumersTotalCount = 0L;
    private final HashMap producers = new HashMap();
    private long producersHighCount = 0L;
    private long producersTotalCount = 0L;
    private final HashMap browsers = new HashMap();
    private long browsersHighCount = 0L;
    private HashMap beDispatchers = new HashMap();
    private InterceptionPointHandle receiveIPHandle = null;
    private DestinationImpl receiveIPDestination = null;
    private static Object interceptionPointLock = new Object();
    private boolean disableMultiSend = false;
    private transient int refCount;

    public FESession(FEConnection fEConnection, String string, JMSID jMSID, boolean bl, boolean bl2, int n, String string2) throws ManagementException {
        super(string, (RuntimeMBean)fEConnection.getRuntimeDelegate());
        this.connection = fEConnection;
        this.sessionId = jMSID;
        this.transacted = bl;
        this.xaSession = bl2;
        this.invocableMonitor = FrontEnd.getFrontEnd().getInvocableMonitor();
        this.pushWorkManager = string2;
        this.service = fEConnection.getFrontEnd().getService();
        this.originalAcknowledgeMode = n;
        if (bl) {
            this.tranManager = TxHelper.getTransactionManager();
            this.acknowledgeMode = 2;
            this.tranDestinations = new Hashtable();
            this.tranPersistentDestinations = new Hashtable();
            this.tranDispatchers = Collections.synchronizedSet(new HashSet());
        } else {
            this.acknowledgeMode = n;
        }
        String string3 = System.getProperty("weblogic.jms.DisableMultiSender");
        String string4 = System.getProperty("weblogic.jms.DisablePushEnvelope");
        if (string3 != null && Boolean.valueOf(string3) == Boolean.TRUE || string4 != null && Boolean.valueOf(string4) == Boolean.TRUE) {
            System.err.println("JMS FE Multi Sender DISABLED");
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("FRONTEND/FESession (id: " + this.sessionId + ") : Disable MultiSend ");
            }
            this.disableMultiSend = true;
        }
    }

    private synchronized AuthenticatedSubject getSubjectForQOS() {
        return this.subjectForQOS;
    }

    synchronized void updateQOS() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (authenticatedSubject == null) {
            return;
        }
        if (this.subjectForQOS == null || this.subjectForQOS.getQOS() < authenticatedSubject.getQOS()) {
            this.subjectForQOS = authenticatedSubject;
        }
    }

    public boolean isServerAffinityEnabled() {
        return this.connection.isServerAffinityEnabled();
    }

    public boolean visited(DistributedDestinationImpl distributedDestinationImpl) {
        if (distributedDestinationImpl == null || this.tranDispatchers == null) {
            return false;
        }
        return this.tranDispatchers.contains(distributedDestinationImpl.getDispatcherId());
    }

    public void addVisitedDispatcher(DistributedDestinationImpl distributedDestinationImpl) {
        if (distributedDestinationImpl == null || this.tranDispatchers == null) {
            return;
        }
        this.tranDispatchers.add(distributedDestinationImpl.getDispatcherId());
    }

    public void addCachedDest(DistributedDestinationImpl distributedDestinationImpl) {
        if (this.tranDestinations == null || this.tranPersistentDestinations == null || distributedDestinationImpl == null) {
            return;
        }
        if (distributedDestinationImpl.isPersistent()) {
            this.tranDestinations.put(distributedDestinationImpl.getName(), distributedDestinationImpl);
            this.tranPersistentDestinations.put(distributedDestinationImpl.getName(), distributedDestinationImpl);
        } else {
            this.tranDestinations.put(distributedDestinationImpl.getName(), distributedDestinationImpl);
        }
    }

    public DistributedDestinationImpl getCachedDest(String string, boolean bl) {
        if (this.tranDestinations == null || this.tranPersistentDestinations == null || string == null) {
            return null;
        }
        DistributedDestinationImpl distributedDestinationImpl = bl ? (DistributedDestinationImpl)this.tranPersistentDestinations.get(string) : (DistributedDestinationImpl)this.tranDestinations.get(string);
        if (distributedDestinationImpl != null && distributedDestinationImpl.isStale()) {
            this.cleanFailure(distributedDestinationImpl);
            distributedDestinationImpl = null;
        }
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            if (distributedDestinationImpl != null) {
                System.out.println("Session Pick: " + distributedDestinationImpl.getInstanceName());
            } else {
                System.out.println("Session Pick: null");
            }
        }
        return distributedDestinationImpl;
    }

    public void cleanFailure(DestinationImpl destinationImpl) {
        if (destinationImpl == null) {
            return;
        }
        if (this.tranDestinations != null) {
            this.tranDestinations.remove(destinationImpl.getName());
        }
        if (this.tranPersistentDestinations != null) {
            this.tranPersistentDestinations.remove(destinationImpl.getName());
        }
        if (this.tranDispatchers != null) {
            this.tranDispatchers.remove(destinationImpl.getDispatcherId());
        }
    }

    public void cleanAll() {
        if (this.tranDestinations != null) {
            this.tranDestinations.clear();
        }
        if (this.tranPersistentDestinations != null) {
            this.tranPersistentDestinations.clear();
        }
        if (this.tranDispatchers != null) {
            this.tranDispatchers.clear();
        }
    }

    FEConnection getConnection() {
        return this.connection;
    }

    long getNextSequenceNumber() {
        return this.nextSequenceNumber++;
    }

    private long getSequenceNumber() {
        return this.nextSequenceNumber;
    }

    private void close(long l) throws JMSException {
        this.close(false, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void close(boolean var1_1, long var2_2, JMSException var4_3) throws JMSException {
        block74: {
            var6_4 = null;
            var9_5 = FESession.interceptionPointLock;
            synchronized (var9_5) {
                block70: {
                    if (this.receiveIPHandle != null && this.receiveIPDestination != null && (this.receiveIPDestination.getType() == 8 || this.receiveIPDestination.getType() == 4)) {
                        try {
                            if (!this.receiveIPHandle.hasAssociation()) {
                                MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(this.receiveIPHandle);
                                this.receiveIPHandle = null;
                            }
                        }
                        catch (InterceptionServiceException var10_6) {
                            JMSLogger.logFailedToUnregisterInterceptionPoint((Exception)var10_6);
                            if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block70;
                            JMSDebug.JMSFrontEnd.debug("FESession.close(), Failure to unregister " + var10_6);
                        }
                    }
                }
            }
            var9_5 = this;
            synchronized (var9_5) {
                block71: {
                    if (this.transacted && this.transactedSessionTx != null) {
                        var10_7 = null;
                        this.tranManager.forceResume((Transaction)this.transactedSessionTx);
                        try {
                            this.tranManager.rollback();
                            var13_10 = null;
                            this.transactedSessionTx = null;
                            this.transactedException = null;
                            this.transactionInUse = false;
                            this.cleanAll();
                            this.lastTranStatUnackedMessage = null;
                            this.firstTranStatUnackedMessage = null;
                            ** if (var10_7 == null) goto lbl-1000
                        }
                        catch (Throwable var12_12) {
                            var13_11 = null;
                            this.transactedSessionTx = null;
                            this.transactedException = null;
                            this.transactionInUse = false;
                            this.cleanAll();
                            this.lastTranStatUnackedMessage = null;
                            this.firstTranStatUnackedMessage = null;
                            if (var10_7 != null) {
                                throw var10_7;
                            }
                            throw var12_12;
                        }
lbl-1000:
                        // 1 sources

                        {
                            throw var10_7;
                        }
lbl-1000:
                        // 1 sources

                        {
                            break block71;
                            catch (SystemException var11_9) {
                                var10_7 = new weblogic.jms.common.JMSException(var11_9.getMessage(), (Throwable)var11_9);
                                var13_10 = null;
                                this.transactedSessionTx = null;
                                this.transactedException = null;
                                this.transactionInUse = false;
                                this.cleanAll();
                                this.lastTranStatUnackedMessage = null;
                                this.firstTranStatUnackedMessage = null;
                                if (var10_7 != null) {
                                    throw var10_7;
                                }
                            }
                        }
                    }
                }
            }
            var16_14 = null;
            var17_16 = this;
            synchronized (var17_16) {
                this.transactionInUse = false;
                this.transactedException = null;
                var18_18 = ((HashMap)this.consumers.clone()).values().iterator();
                while (var18_18.hasNext()) {
                    try {
                        var19_20 = ((FEConsumer)var18_18.next()).getJMSID();
                        if (JMSDebug.JMSCommon.isDebugEnabled()) {
                            JMSDebug.JMSCommon.debug("FRONTEND/FESession (id: " + this.sessionId + ") : Closing consumer " + var19_20);
                        }
                        if (var4_3 != null) {
                            this.pushException(6, (JMSID)var19_20, (weblogic.jms.common.JMSException)var4_3);
                        }
                        this.consumerRemove((JMSID)var19_20);
                    }
                    catch (Throwable var19_20) {}
                }
                var18_18 = ((HashMap)this.producers.clone()).values().iterator();
                while (var18_18.hasNext()) {
                    try {
                        var19_20 = (FEProducer)var18_18.next();
                        if (JMSDebug.JMSCommon.isDebugEnabled()) {
                            JMSDebug.JMSCommon.debug("FRONTEND/FESession (id: " + this.sessionId + ") : Closing Producer " + var19_20.getJMSID());
                        }
                        this.producerRemove(var19_20.getJMSID());
                        var19_20.removeDispatcher();
                    }
                    catch (Throwable var19_20) {}
                }
                var18_18 = ((HashMap)this.browsers.clone()).values().iterator();
                while (var18_18.hasNext()) {
                    try {
                        this.browserRemove(((FEBrowser)var18_18.next()).getJMSID());
                    }
                    catch (Throwable var19_20) {}
                }
                var5_22 = this.firstUnackedPushEntry;
                this.lastUnackedPushEntry = null;
                this.firstUnackedPushEntry = null;
                var7_24 = this.beDispatchers;
                this.beDispatchers = new HashMap<K, V>();
                var8_26 = this.sequencers;
                this.sequencers = new HashMap<K, V>();
                var18_18 = var7_24.values().iterator();
                while (var18_18.hasNext()) {
                    ((JMSDispatcher)var18_18.next()).removeDispatcherPeerGoneListener(this);
                }
            }
            if (var2_2 != 0L) {
                while (var5_22 != null && var5_22.getFrontEndSequenceNumber() != var2_2) {
                    var5_22 = var5_22.getNextUnacked();
                }
                while (var5_22 != null) {
                    var17_16 = var5_22.getDispatcher();
                    var17_16 = (JMSDispatcher)var7_24.remove(var17_16.getId());
                    try {
                        if (var17_16 != null) {
                            var17_16.dispatchSync(new BESessionCloseRequest(var1_1, this.sessionId, var5_22.getBackEndSequenceNumber()));
                        }
                    }
                    catch (Throwable var18_18) {
                        var6_4 = new weblogic.jms.common.JMSException("Error closing session", (Throwable)var18_18);
                    }
                    var5_22 = var5_22.getPrevUnacked();
                }
            }
            var17_16 = var7_24.values().iterator();
            var18_18 = new BESessionCloseRequest(var1_1, this.sessionId, 0L);
            while (var17_16.hasNext()) {
                try {
                    var19_20 = (JMSDispatcher)var17_16.next();
                    var19_20.dispatchSync((Request)var18_18);
                    var18_18.clearResult();
                }
                catch (Throwable var19_20) {
                    var6_4 = new weblogic.jms.common.JMSException("Error closing session", (Throwable)var19_20);
                }
            }
            for (ManagementException var20_29 : var8_26.values()) {
                InvocableManagerDelegate.delegate.invocableRemove(13, var20_29 /* !! */ .getJMSID());
            }
            try {
                PrivilegedActionUtilities.unregister(this, FESession.KERNEL_ID);
            }
            catch (ManagementException var20_29 /* !! */ ) {
                JMSLogger.logErrorUnregisteringFrontEndSession((String)this.getConnection().getFrontEnd().getMbeanName(), (Object)this, (Throwable)var20_29 /* !! */ );
            }
            break block74;
            catch (Throwable var15_32) {
                var16_15 = null;
                var17_17 = this;
                synchronized (var17_17) {
                    this.transactionInUse = false;
                    this.transactedException = null;
                    var18_19 = ((HashMap)this.consumers.clone()).values().iterator();
                    while (var18_19.hasNext()) {
                        try {
                            var19_21 = ((FEConsumer)var18_19.next()).getJMSID();
                            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                                JMSDebug.JMSCommon.debug("FRONTEND/FESession (id: " + this.sessionId + ") : Closing consumer " + var19_21);
                            }
                            if (var4_3 != null) {
                                this.pushException(6, (JMSID)var19_21, (weblogic.jms.common.JMSException)var4_3);
                            }
                            this.consumerRemove((JMSID)var19_21);
                        }
                        catch (Throwable var19_21) {}
                    }
                    var18_19 = ((HashMap)this.producers.clone()).values().iterator();
                    while (var18_19.hasNext()) {
                        try {
                            var19_21 = (FEProducer)var18_19.next();
                            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                                JMSDebug.JMSCommon.debug("FRONTEND/FESession (id: " + this.sessionId + ") : Closing Producer " + var19_21.getJMSID());
                            }
                            this.producerRemove(var19_21.getJMSID());
                            var19_21.removeDispatcher();
                        }
                        catch (Throwable var19_21) {}
                    }
                    var18_19 = ((HashMap)this.browsers.clone()).values().iterator();
                    while (var18_19.hasNext()) {
                        try {
                            this.browserRemove(((FEBrowser)var18_19.next()).getJMSID());
                        }
                        catch (Throwable var19_21) {}
                    }
                    var5_23 = this.firstUnackedPushEntry;
                    this.lastUnackedPushEntry = null;
                    this.firstUnackedPushEntry = null;
                    var7_25 = this.beDispatchers;
                    this.beDispatchers = new HashMap<K, V>();
                    var8_27 = this.sequencers;
                    this.sequencers = new HashMap<K, V>();
                    var18_19 = var7_25.values().iterator();
                    while (var18_19.hasNext()) {
                        ((JMSDispatcher)var18_19.next()).removeDispatcherPeerGoneListener(this);
                    }
                }
                if (var2_2 != 0L) {
                    while (var5_23 != null && var5_23.getFrontEndSequenceNumber() != var2_2) {
                        var5_23 = var5_23.getNextUnacked();
                    }
                    while (var5_23 != null) {
                        var17_17 = var5_23.getDispatcher();
                        var17_17 = (JMSDispatcher)var7_25.remove(var17_17.getId());
                        try {
                            if (var17_17 != null) {
                                var17_17.dispatchSync(new BESessionCloseRequest(var1_1, this.sessionId, var5_23.getBackEndSequenceNumber()));
                            }
                        }
                        catch (Throwable var18_19) {
                            var6_4 = new weblogic.jms.common.JMSException("Error closing session", (Throwable)var18_19);
                        }
                        var5_23 = var5_23.getPrevUnacked();
                    }
                }
                var17_17 = var7_25.values().iterator();
                var18_19 = new BESessionCloseRequest(var1_1, this.sessionId, 0L);
                while (var17_17.hasNext()) {
                    try {
                        var19_21 = (JMSDispatcher)var17_17.next();
                        var19_21.dispatchSync((Request)var18_19);
                        var18_19.clearResult();
                    }
                    catch (Throwable var19_21) {
                        var6_4 = new weblogic.jms.common.JMSException("Error closing session", (Throwable)var19_21);
                    }
                }
                for (ManagementException var20_31 : var8_27.values()) {
                    InvocableManagerDelegate.delegate.invocableRemove(13, var20_31 /* !! */ .getJMSID());
                }
                try {
                    PrivilegedActionUtilities.unregister(this, FESession.KERNEL_ID);
                }
                catch (ManagementException var20_31 /* !! */ ) {
                    JMSLogger.logErrorUnregisteringFrontEndSession((String)this.getConnection().getFrontEnd().getMbeanName(), (Object)this, (Throwable)var20_31 /* !! */ );
                }
                throw var15_32;
            }
        }
        this.connection.sessionRemove(this);
        if (var6_4 != null) {
            throw var6_4;
        }
    }

    private int producerCreate(FEProducerCreateRequest fEProducerCreateRequest) throws JMSException {
        FEProducer fEProducer;
        DestinationImpl destinationImpl = fEProducerCreateRequest.getDestination();
        this.checkShutdownOrSuspended();
        final JMSID jMSID = this.service.getNextId();
        final String string = "producer" + jMSID.getCounter();
        final DestinationImpl destinationImpl2 = destinationImpl;
        try {
            try {
                fEProducer = (FEProducer)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ManagementException, JMSException {
                        return new FEProducer(string, jMSID, FESession.this, destinationImpl2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            this.producerAdd(fEProducer);
        }
        catch (Exception exception) {
            this.cleanFailure(destinationImpl);
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                ManagementException managementException = (ManagementException)((Object)exception);
                Throwable throwable = managementException.getNestedException();
                if (throwable == null) {
                    throwable = managementException;
                }
                throw new weblogic.jms.common.JMSException("Error creating producer" + throwable.getMessage(), (Throwable)managementException);
            }
            throw new weblogic.jms.common.JMSException("Error creating producer " + exception.getMessage(), (Throwable)exception);
        }
        fEProducerCreateRequest.setResult(new FEProducerCreateResponse(jMSID, fEProducer.getName()));
        fEProducerCreateRequest.setState(Integer.MAX_VALUE);
        return fEProducerCreateRequest.getState();
    }

    void producerClose(FEProducer fEProducer) {
        this.producerRemove(fEProducer.getJMSID());
    }

    private synchronized void producerAdd(FEProducer fEProducer) throws JMSException {
        if (this.producers.put(fEProducer.getJMSID(), fEProducer) == null) {
            InvocableManagerDelegate.delegate.invocableAdd(9, fEProducer);
            this.producersHighCount = Math.max(this.producersHighCount, (long)this.producers.size());
            ++this.producersTotalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void producerRemove(JMSID jMSID) {
        Object object;
        if (this.producers == null) {
            return;
        }
        while (true) {
            object = IDBasedConstraintEnforcement.getInstance();
            IDBasedConstraintEnforcement iDBasedConstraintEnforcement = object;
            synchronized (iDBasedConstraintEnforcement) {
                if (((IDBasedConstraintEnforcement)object).getExecutingCount(jMSID.getCounter()) + ((IDBasedConstraintEnforcement)object).getPendingCount(jMSID.getCounter()) == 0) {
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = (FEProducer)this.producers.remove(jMSID);
        if (object == null) {
            return;
        }
        ((FEProducer)object).closeProducer();
        InvocableManagerDelegate.delegate.invocableRemove(9, jMSID);
        try {
            PrivilegedActionUtilities.unregister((RuntimeMBeanDelegate)object, KERNEL_ID);
        }
        catch (ManagementException managementException) {
            JMSLogger.logErrorUnregisteringProducer((String)this.getConnection().getFrontEnd().getMbeanName(), (Object)object, (Throwable)managementException);
        }
    }

    void checkShutdownOrSuspended() throws JMSException {
        this.connection.checkShutdownOrSuspended();
    }

    public synchronized JMSProducerRuntimeMBean[] getProducers() {
        JMSProducerRuntimeMBean[] jMSProducerRuntimeMBeanArray = new JMSProducerRuntimeMBean[this.producers.size()];
        Iterator iterator = this.producers.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jMSProducerRuntimeMBeanArray[n++] = (JMSProducerRuntimeMBean)iterator.next();
        }
        return jMSProducerRuntimeMBeanArray;
    }

    public synchronized long getProducersCurrentCount() {
        return this.producers.size();
    }

    public long getProducersHighCount() {
        return this.producersHighCount;
    }

    public synchronized long getProducersTotalCount() {
        return this.producersTotalCount;
    }

    public int getSubscriptionSharingPolicy() throws JMSException {
        this.checkShutdownOrSuspended();
        return this.connection.getSubscriptionSharingPolicyAsInt();
    }

    HashMap getConsumersMap() {
        return this.consumers;
    }

    HashMap getBEDispatchers() {
        return this.beDispatchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequencer setUpBackEndSession(DispatcherId dispatcherId) throws JMSException {
        long l;
        boolean bl;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("FESession.setUpBackEndSession()");
        }
        FEConnection fEConnection = this.connection;
        synchronized (fEConnection) {
            bl = this.connection.isStopped();
            l = this.connection.getStartStopSequenceNumber();
        }
        byte by = this.connection.getPeerVersion();
        FESession fESession = this;
        synchronized (fESession) {
            JMSDispatcher jMSDispatcher = (JMSDispatcher)this.beDispatchers.get(dispatcherId);
            if (jMSDispatcher != null) {
                return (Sequencer)this.sequencers.get(dispatcherId);
            }
            try {
                jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(dispatcherId);
            }
            catch (DispatcherException dispatcherException) {
                throw new weblogic.jms.common.JMSException("Error creating session", (Throwable)dispatcherException);
            }
            Sequencer sequencer = new Sequencer(this, jMSDispatcher);
            jMSDispatcher.dispatchSync(new BESessionCreateRequest(JMSDispatcherManager.getLocalDispatcher().getId(), this.connection.getJMSID(), this.getJMSID(), sequencer.getJMSID(), this.transacted, this.xaSession, this.acknowledgeMode, bl, l, by, this.connection.getAddressAndMBeanInfo(), this.pushWorkManager));
            InvocableManagerDelegate.delegate.invocableAdd(13, sequencer);
            this.sequencers.put(dispatcherId, sequencer);
            this.beDispatchers.put(dispatcherId, jMSDispatcher);
            jMSDispatcher.addDispatcherPeerGoneListener(this);
            return sequencer;
        }
    }

    private int consumerCreate(FEConsumerCreateRequest fEConsumerCreateRequest) throws JMSException {
        FEConsumer fEConsumer;
        Externalizable externalizable;
        Object object;
        this.checkShutdownOrSuspended();
        Object object2 = null;
        FEDDHandler fEDDHandler = null;
        ConsumerReconnectInfo consumerReconnectInfo = fEConsumerCreateRequest.getConsumerReconnectInfo();
        if (consumerReconnectInfo != null && consumerReconnectInfo.getServerDestId() == null && fEConsumerCreateRequest.getName() != null && this.connection.getConnectionClientId() != null) {
            object = fEConsumerCreateRequest.getDestination();
            try {
                object = this.connection.createDestination(((DestinationImpl)object).getServerName(), ((DestinationImpl)object).getName(), ((DestinationImpl)object).getType());
                fEConsumerCreateRequest.setDestination((DestinationImpl)object);
                consumerReconnectInfo.setServerDestId(((DestinationImpl)object).getDestinationId());
                fEConsumerCreateRequest.setConsumerReconnectInfo(consumerReconnectInfo);
            }
            catch (Throwable throwable) {
                throw JMSUtilities.jmsExceptionThrowable("Destination " + ((DestinationImpl)object).getName() + " not found", throwable);
            }
        }
        if (!fEConsumerCreateRequest.getDestination().isQueue()) {
            object = fEConsumerCreateRequest.getName();
            if (object != null && DDManager.isDD(fEConsumerCreateRequest.getDestination().getName())) {
                throw new weblogic.jms.common.JMSException("Topic must not be Distributed Topic");
            }
            if (object != null && this.connection.getConnectionClientId() != null) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("in FESessionConsumer durable");
                }
                if (fEConsumerCreateRequest.getSelector() != null && fEConsumerCreateRequest.getSelector().trim().equals("TRUE")) {
                    fEConsumerCreateRequest.setSelector(null);
                }
                if (this.getConnection().getClientIdPolicy() == 0) {
                    try {
                        FESession fESession = this;
                        externalizable = (DurableSubscription)fESession.service.getContext().lookup(BEConsumerImpl.JNDINameForSubscription(BEConsumerImpl.clientIdPlusName(this.connection.getConnectionClientId(), fEConsumerCreateRequest.getName())));
                        if (DurableSubscription.noLocalAndSelectorMatch((Subscription)((Object)externalizable), fEConsumerCreateRequest.getNoLocal(), fEConsumerCreateRequest.getSelector())) {
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("in FESessionConsumer matched consumer");
                            }
                            if (fEConsumerCreateRequest.getDestination().equals(((DurableSubscription)externalizable).getDestinationImpl())) {
                                object2 = ((DurableSubscription)externalizable).getDestinationImpl();
                            }
                        } else if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                            JMSDebug.JMSFrontEnd.debug("FESession re/create new durable subscriber");
                        }
                    }
                    catch (NamingException namingException) {}
                } else if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession re/create new durable subscriber using an Unrestricted ClientID");
                }
            } else {
                fEDDHandler = DDManager.findFEDDHandlerByDDName(fEConsumerCreateRequest.getDestination().getName());
                if (fEDDHandler != null && JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("will load balance non-durable on dist Topic " + fEDDHandler.getName());
                }
            }
        }
        if (object2 == null && fEDDHandler == null) {
            object2 = fEConsumerCreateRequest.getDestination();
            fEDDHandler = DDManager.findFEDDHandlerByDDName(((DestinationImpl)object2).getName());
        }
        if (fEDDHandler != null) {
            if (fEConsumerCreateRequest.getDestination().isQueue() || fEConsumerCreateRequest.getName() != null && this.connection.getConnectionClientId() != null) {
                object2 = fEDDHandler.consumerLoadBalance(this);
            } else {
                if (fEDDHandler.getName().equals(fEConsumerCreateRequest.getDestination().getName())) {
                    object2 = fEDDHandler.consumerLoadBalance(null);
                } else {
                    object = DDManager.findDDImplByDDName(fEConsumerCreateRequest.getDestination().getName());
                    if (object == null) {
                        throw new JMSException("Destination not found " + fEConsumerCreateRequest.getDestination().getName());
                    }
                    object2 = ((DistributedDestinationImpl)object).isLocal() ? object : fEDDHandler.consumerLoadBalance(null);
                }
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("local non durable topic available " + (object2 == null ? null : ((DistributedDestinationImpl)object2).getInstanceName()));
                }
            }
        } else if (object2 != null && ((DestinationImpl)object2).getDestinationId() == null) {
            try {
                object2 = this.connection.createDestination(((DestinationImpl)object2).getServerName(), ((DestinationImpl)object2).getName(), ((DestinationImpl)object2).getType());
            }
            catch (Throwable throwable) {
                throw JMSUtilities.jmsExceptionThrowable("Destination " + ((DestinationImpl)object2).getName() + " not found", throwable);
            }
        }
        if (object2 == null) {
            throw new JMSException("Destination not found " + fEConsumerCreateRequest.getDestination().getName());
        }
        object = null;
        try {
            object = this.setUpBackEndSession(((DestinationImpl)object2).getDispatcherId());
        }
        catch (JMSException jMSException) {
            if (object2 instanceof DistributedDestinationImpl) {
                throw jMSException;
            }
            try {
                object2 = this.connection.createDestination(((DestinationImpl)object2).getServerName(), ((DestinationImpl)object2).getName(), ((DestinationImpl)object2).getType());
                object = this.setUpBackEndSession(((DestinationImpl)object2).getDispatcherId());
            }
            catch (JMSException jMSException2) {
                throw jMSException;
            }
        }
        externalizable = object2;
        Object object3 = object;
        JMSID jMSID = this.service.getNextId();
        final String string = "consumer" + jMSID.getCounter();
        AuthenticatedSubject authenticatedSubject = JMSSecurityHelper.getCurrentSubject();
        String string2 = JMSSecurityHelper.getSimpleAuthenticatedName();
        try {
            try {
                fEConsumer = (FEConsumer)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction((Sequencer)object3, (DestinationImpl)externalizable, jMSID, string2, authenticatedSubject, fEConsumerCreateRequest){
                    final /* synthetic */ Sequencer val$sequencerFinal;
                    final /* synthetic */ DestinationImpl val$destinationFinal;
                    final /* synthetic */ JMSID val$consumerId;
                    final /* synthetic */ String val$subject;
                    final /* synthetic */ AuthenticatedSubject val$authenticatedSubject;
                    final /* synthetic */ FEConsumerCreateRequest val$request;
                    {
                        this.val$sequencerFinal = sequencer;
                        this.val$destinationFinal = destinationImpl;
                        this.val$consumerId = jMSID;
                        this.val$subject = string2;
                        this.val$authenticatedSubject = authenticatedSubject;
                        this.val$request = fEConsumerCreateRequest;
                    }

                    public Object run() throws ManagementException, JMSException {
                        return new FEConsumer(string, FESession.this, this.val$sequencerFinal, FESession.this.connection.getConnectionClientId(), this.val$destinationFinal, this.val$consumerId, this.val$subject, this.val$authenticatedSubject, this.val$request);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            this.consumerAdd(fEConsumer);
        }
        catch (Exception exception) {
            this.cleanFailure((DestinationImpl)object2);
            if (exception instanceof JMSException) {
                throw (JMSException)((Object)exception);
            }
            if (exception instanceof ManagementException) {
                ManagementException managementException = (ManagementException)((Object)exception);
                Throwable throwable = managementException.getNestedException();
                if (throwable == null) {
                    throwable = managementException;
                }
                throw new weblogic.jms.common.JMSException("Error creating consumer " + throwable.getMessage(), (Throwable)managementException);
            }
            throw new weblogic.jms.common.JMSException("Error creating consumer " + exception.getMessage(), (Throwable)exception);
        }
        fEConsumerCreateRequest.setResult(new FEConsumerCreateResponse(fEConsumer.getJMSID(), fEConsumer.getName(), fEConsumer.getConsumerReconnectInfo()));
        fEConsumerCreateRequest.setState(Integer.MAX_VALUE);
        return fEConsumerCreateRequest.getState();
    }

    private synchronized FEConsumer consumerFind(JMSID jMSID) throws JMSException {
        FEConsumer fEConsumer = (FEConsumer)this.consumers.get(jMSID);
        if (fEConsumer != null) {
            return fEConsumer;
        }
        throw new weblogic.jms.common.JMSException("Consumer not found, " + jMSID);
    }

    private synchronized void consumerAdd(FEConsumer fEConsumer) throws JMSException {
        if (this.consumers.put(fEConsumer.getJMSID(), fEConsumer) == null) {
            this.consumersHighCount = Math.max(this.consumersHighCount, (long)this.consumers.size());
            ++this.consumersTotalCount;
        }
        InvocableManagerDelegate.delegate.invocableAdd(10, fEConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized FEConsumer consumerRemove(JMSID jMSID) throws JMSException {
        FEConsumer fEConsumer = (FEConsumer)this.consumers.remove(jMSID);
        if (fEConsumer == null) {
            throw new weblogic.jms.common.JMSException("Consumer not found, " + jMSID);
        }
        InvocableManagerDelegate.delegate.invocableRemove(10, jMSID);
        try {
            try {
                PrivilegedActionUtilities.unregister(fEConsumer, KERNEL_ID);
            }
            catch (ManagementException managementException) {
                JMSLogger.logErrorUnregisteringConsumer((String)this.getConnection().getFrontEnd().getMbeanName(), (Object)fEConsumer, (Throwable)managementException);
                Object var5_4 = null;
                fEConsumer.getBackEndDispatcher().removeDispatcherPeerGoneListener(this);
                fEConsumer.getBackEndDispatcher().removeDispatcherPeerGoneListener(fEConsumer);
                return fEConsumer;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fEConsumer.getBackEndDispatcher().removeDispatcherPeerGoneListener(this);
            fEConsumer.getBackEndDispatcher().removeDispatcherPeerGoneListener(fEConsumer);
            throw throwable;
        }
        fEConsumer.getBackEndDispatcher().removeDispatcherPeerGoneListener(this);
        fEConsumer.getBackEndDispatcher().removeDispatcherPeerGoneListener(fEConsumer);
        return fEConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long consumerClose(FEConsumer fEConsumer, long l) {
        FESession fESession = this;
        synchronized (fESession) {
            if (l != 0L) {
                JMSPushEntry jMSPushEntry;
                for (jMSPushEntry = this.firstUnackedPushEntry; jMSPushEntry != null && jMSPushEntry.getFrontEndSequenceNumber() != l; jMSPushEntry = jMSPushEntry.getNextUnacked()) {
                }
                while (jMSPushEntry != null && !jMSPushEntry.getConsumerId().equals(fEConsumer.getJMSID())) {
                    jMSPushEntry = jMSPushEntry.getPrevUnacked();
                }
                l = jMSPushEntry == null ? 0L : jMSPushEntry.getBackEndSequenceNumber();
            }
        }
        return l;
    }

    private synchronized void browserAdd(FEBrowser fEBrowser) throws JMSException {
        if (this.browsers.put(fEBrowser.getJMSID(), fEBrowser) == null) {
            InvocableManagerDelegate.delegate.invocableAdd(11, fEBrowser);
            this.browsersHighCount = Math.max(this.browsersHighCount, (long)this.browsers.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int browserCreate(FEBrowserCreateRequest fEBrowserCreateRequest) throws JMSException {
        this.checkShutdownOrSuspended();
        switch (fEBrowserCreateRequest.getState()) {
            case 0: {
                DestinationImpl destinationImpl = fEBrowserCreateRequest.getDestination();
                FEDDHandler fEDDHandler = DDManager.findFEDDHandlerByDDName(destinationImpl.getName());
                if (fEDDHandler != null) {
                    destinationImpl = fEDDHandler.consumerLoadBalance(null);
                }
                BEBrowserCreateRequest bEBrowserCreateRequest = new BEBrowserCreateRequest(this.sessionId, destinationImpl.getDestinationId(), fEBrowserCreateRequest.getMessageSelector());
                Externalizable externalizable = fEBrowserCreateRequest;
                synchronized (externalizable) {
                    fEBrowserCreateRequest.rememberChild(bEBrowserCreateRequest);
                    fEBrowserCreateRequest.setState(1);
                }
                try {
                    externalizable = destinationImpl.getDispatcherId();
                    fEBrowserCreateRequest.setDispatcher(JMSDispatcherManager.dispatcherFindOrCreate((DispatcherId)externalizable));
                    this.setUpBackEndSession((DispatcherId)externalizable);
                    fEBrowserCreateRequest.dispatchAsync(fEBrowserCreateRequest.getDispatcher(), (Request)bEBrowserCreateRequest);
                }
                catch (DispatcherException dispatcherException) {
                    throw new weblogic.jms.common.JMSException("Error creating browser", (Throwable)dispatcherException);
                }
                return fEBrowserCreateRequest.getState();
            }
        }
        JMSBrowserCreateResponse jMSBrowserCreateResponse = (JMSBrowserCreateResponse)fEBrowserCreateRequest.useChildResult(JMSBrowserCreateResponse.class);
        FEBrowser fEBrowser = new FEBrowser(this.connection, this, jMSBrowserCreateResponse.getBrowserId(), fEBrowserCreateRequest.getDispatcher());
        this.browserAdd(fEBrowser);
        return Integer.MAX_VALUE;
    }

    synchronized void browserRemove(JMSID jMSID) throws JMSException {
        if (this.browsers.remove(jMSID) == null) {
            throw new weblogic.jms.common.JMSException("Browser not found, " + jMSID);
        }
        InvocableManagerDelegate.delegate.invocableRemove(11, jMSID);
    }

    public synchronized JMSConsumerRuntimeMBean[] getConsumers() {
        JMSConsumerRuntimeMBean[] jMSConsumerRuntimeMBeanArray = new JMSConsumerRuntimeMBean[this.consumers.size()];
        Iterator iterator = this.consumers.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jMSConsumerRuntimeMBeanArray[n++] = (JMSConsumerRuntimeMBean)iterator.next();
        }
        return jMSConsumerRuntimeMBeanArray;
    }

    public synchronized long getConsumersCurrentCount() {
        return this.consumers.size();
    }

    public synchronized long getConsumersHighCount() {
        return this.consumersHighCount;
    }

    public synchronized long getConsumersTotalCount() {
        return this.consumersTotalCount;
    }

    private int recover(FESessionRecoverRequest fESessionRecoverRequest) throws JMSException {
        if (fESessionRecoverRequest.getPipelineGeneration() == 0) {
            return this.recover81(fESessionRecoverRequest);
        }
        return this.recover90(fESessionRecoverRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int recover81(FESessionRecoverRequest var1_1) throws JMSException {
        var2_2 = var1_1.doRollback();
        var3_3 = var1_1.getState();
        var4_4 = null;
        var3_3 = this.recover81Init(var3_3, var1_1, var2_2);
        switch (var3_3) {
            case 0: {
                this.recover81TransactionSetup(var1_1);
            }
            case 1: {
                var5_5 = var1_1.getLastSequenceNumber();
                var3_3 = 2;
                var1_1.setState(2);
                var10_7 = this;
                synchronized (var10_7) {
                    var1_1.setLastSequenceNumber(this.getSequenceNumber());
                    var8_9 = var7_8 = this.firstUnackedPushEntry;
                    this.lastUnackedPushEntry = null;
                    this.firstUnackedPushEntry = null;
                    var9_10 = (HashMap)this.sequencers.clone();
                }
                var1_1.needOutsideResult();
                this.recover81Statistics(var8_9, var5_5);
                if (var5_5 != 0L) {
                    while (var7_8 != null && var7_8.getFrontEndSequenceNumber() != var5_5) {
                        var7_8 = var7_8.getNextUnacked();
                    }
                }
                if (var7_8 == null) ** GOTO lbl46
                while (var7_8 != null) {
                    var10_7 = (Sequencer)var9_10.remove(var7_8.getDispatcher().getId());
                    if (var10_7 == null) ** GOTO lbl44
                    var11_12 = new BESessionRecoverRequest(this.sessionId, var7_8.getBackEndSequenceNumber(), (Sequencer)var10_7, 0);
                    try {
                        var11_12.setNext(var1_1.getChildRequests());
                        var1_1.setChildRequests(var11_12);
                        var1_1.dispatchAsync(var10_7.getDispatcher(), (Request)var11_12);
                    }
                    catch (DispatcherException var12_13) {
                        if (var4_4 != null) ** GOTO lbl44
                        var4_4 = new weblogic.jms.common.JMSException("Error recovering messages", (Throwable)var12_13);
                    }
lbl44:
                    // 4 sources

                    var7_8 = var7_8.getPrevUnacked();
                }
lbl46:
                // 2 sources

                if (var2_2 != false ? var1_1.fanoutCompleteSuspendIfHaveChildren(false) != false : var1_1.fanoutComplete(false) != false) break;
            }
            case 2: {
                var3_3 = 0x7FFFFFFF;
                var1_1.setState(0x7FFFFFFF);
                for (var5_6 = (BESessionRecoverRequest)var1_1.getChildRequests(); var5_6 != null; var5_6 = (BESessionRecoverRequest)var5_6.getNext()) {
                    try {
                        var6_14 = var5_6.getResult();
                        var5_6.getSequencer().changeExpectedSequenceNumberCanHaveRemainder(((JMSSessionRecoverResponse)var6_14).getSequenceNumber());
                        continue;
                    }
                    catch (Throwable var6_15) {
                        var4_4 = var6_15 instanceof JMSException != false ? (JMSException)var6_15 : new weblogic.jms.common.JMSException("Error recovering session", var6_15);
                    }
                }
                if (var4_4 != null) {
                    if (!var2_2) {
                        throw var4_4;
                    }
                } else {
                    var1_1.setResult(new JMSSessionRecoverResponse(var1_1.getLastSequenceNumber()));
                    if (!var2_2) break;
                }
            }
            case 3: {
                if (this.transactedException == null) {
                    this.transactedException = var4_4;
                }
                this.rollbackAfterRecover();
            }
        }
        return var3_3;
    }

    private int recover81Init(int n, FESessionRecoverRequest fESessionRecoverRequest, boolean bl) throws JMSException {
        if (n == 0 && !bl) {
            this.checkShutdownOrSuspended();
            n = 1;
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("FERecover start");
            }
        }
        return n;
    }

    private final JMSPushEntry recover81Statistics(JMSPushEntry jMSPushEntry, long l) {
        JMSPushEntry jMSPushEntry2 = null;
        while (jMSPushEntry != null) {
            block4: {
                FEConsumer fEConsumer;
                if (jMSPushEntry.getFrontEndSequenceNumber() <= l) {
                    jMSPushEntry2 = jMSPushEntry;
                }
                this.statistics.decrementPendingCount(jMSPushEntry.getMessageSize());
                try {
                    fEConsumer = this.consumerFind(jMSPushEntry.getConsumerId());
                }
                catch (JMSException jMSException) {
                    break block4;
                }
                fEConsumer.statistics.decrementPendingCount(jMSPushEntry.getMessageSize());
            }
            jMSPushEntry = jMSPushEntry.getNextUnacked();
        }
        return jMSPushEntry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover81TransactionSetup(FESessionRecoverRequest fESessionRecoverRequest) {
        fESessionRecoverRequest.setTranInfo(1);
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("FERollback start");
        }
        FESession fESession = this;
        synchronized (fESession) {
            if (this.transactionInUse) {
                if (this.transactedException == null) {
                    this.transactedException = new weblogic.jms.common.JMSException("Only one thread may use a JMS Session at a time.");
                }
            } else {
                this.transactionInUse = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recover90(FESessionRecoverRequest fESessionRecoverRequest) throws JMSException {
        int n = fESessionRecoverRequest.getState();
        JMSException jMSException = null;
        n = this.recover81Init(n, fESessionRecoverRequest, fESessionRecoverRequest.doRollback());
        switch (n) {
            case 0: {
                this.recover81TransactionSetup(fESessionRecoverRequest);
            }
            case 1: {
                BESessionRecoverRequest bESessionRecoverRequest;
                n = 2;
                fESessionRecoverRequest.setState(2);
                Object object = this;
                synchronized (object) {
                    JMSPushEntry jMSPushEntry = this.recover81Statistics(this.firstUnackedPushEntry, fESessionRecoverRequest.getLastSequenceNumber());
                    bESessionRecoverRequest = this.get90beRecoverRequests(jMSPushEntry, fESessionRecoverRequest.getPipelineGeneration());
                    this.lastUnackedPushEntry = null;
                    this.firstUnackedPushEntry = null;
                }
                fESessionRecoverRequest.setChildRequests(bESessionRecoverRequest);
                while (bESessionRecoverRequest != null) {
                    try {
                        object = bESessionRecoverRequest;
                        bESessionRecoverRequest = (BESessionRecoverRequest)bESessionRecoverRequest.getNext();
                        ((BESessionRecoverRequest)object).getSequencer().getDispatcher().dispatchSyncTran((Request)object);
                    }
                    catch (JMSException jMSException2) {
                        if (jMSException != null) continue;
                        jMSException = jMSException2;
                    }
                }
                if (fESessionRecoverRequest.doRollback()) {
                    if (jMSException != null && this.transactedException == null) {
                        this.transactedException = jMSException;
                    }
                    this.rollbackAfterRecover();
                }
                if (jMSException != null) {
                    throw jMSException;
                }
            }
            case 2: {
                BESessionRecoverRequest bESessionRecoverRequest;
                Object object;
                for (bESessionRecoverRequest = (BESessionRecoverRequest)fESessionRecoverRequest.getChildRequests(); bESessionRecoverRequest != null; bESessionRecoverRequest = (BESessionRecoverRequest)bESessionRecoverRequest.getNext()) {
                    object = bESessionRecoverRequest.getResult();
                }
                fESessionRecoverRequest.setResult(new JMSSessionRecoverResponse(fESessionRecoverRequest.getLastSequenceNumber()));
                n = Integer.MAX_VALUE;
                fESessionRecoverRequest.setState(Integer.MAX_VALUE);
                return n;
            }
        }
        throw new AssertionError();
    }

    private final BESessionRecoverRequest get90beRecoverRequests(JMSPushEntry jMSPushEntry, int n) {
        Object object;
        BESessionRecoverRequest bESessionRecoverRequest = null;
        HashMap hashMap = (HashMap)this.sequencers.clone();
        while (jMSPushEntry != null) {
            object = (Sequencer)hashMap.remove(jMSPushEntry.getDispatcher().getId());
            if (object == null) {
                jMSPushEntry = jMSPushEntry.getPrevUnacked();
                continue;
            }
            bESessionRecoverRequest = this.one90beRecoverRequest((Sequencer)object, jMSPushEntry.getBackEndSequenceNumber(), n, bESessionRecoverRequest);
            for (jMSPushEntry = jMSPushEntry.getPrevUnacked(); jMSPushEntry != null && jMSPushEntry.getSequencerId() == ((Sequencer)object).getJMSID(); jMSPushEntry = jMSPushEntry.getPrevUnacked()) {
            }
        }
        if (hashMap.isEmpty()) {
            return bESessionRecoverRequest;
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            bESessionRecoverRequest = this.one90beRecoverRequest((Sequencer)object.next(), 0L, n, bESessionRecoverRequest);
        }
        return bESessionRecoverRequest;
    }

    private BESessionRecoverRequest one90beRecoverRequest(Sequencer sequencer, long l, int n, BESessionRecoverRequest bESessionRecoverRequest) {
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("FESession recover message " + l);
        }
        BESessionRecoverRequest bESessionRecoverRequest2 = new BESessionRecoverRequest(this.sessionId, l, sequencer, n);
        bESessionRecoverRequest2.setNext(bESessionRecoverRequest);
        return bESessionRecoverRequest2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int acknowledge(FESessionAcknowledgeRequest var1_1) throws JMSException {
        var2_2 = false;
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = var1_1.getLastSequenceNumber();
        var9_8 = var1_1.doCommit();
        var10_9 = var1_1.getState();
        if (var10_9 == 0 && !var9_8) {
            this.checkShutdownOrSuspended();
            var10_9 = 1;
        }
        switch (var10_9) {
            case 0: {
                var1_1.setTranInfo(1);
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.commit " + this.hashCode());
                }
                var13_10 = this;
                synchronized (var13_10) {
                    v0 = var12_15 = this.lastUnackedPushEntry == null;
                    if (this.transactionInUse) {
                        if (this.transactedException == null) {
                            this.transactedException = new weblogic.jms.common.JMSException("Only one thread may use a JMS Session at a time.");
                        }
                    } else if (this.transactedException == null && var7_7 != 0L) {
                        for (var11_14 = this.lastUnackedPushEntry; var11_14 != null && var11_14.getFrontEndSequenceNumber() != var7_7; var11_14 = var11_14.getPrevUnacked()) {
                        }
                    }
                }
                try {
                    if (this.transactedException == null) ** GOTO lbl58
                    var2_2 = true;
                    var3_3 = this.transactedException;
                    var13_11 = 0x7FFFFFFF;
                    var16_19 = null;
                }
                catch (Throwable var15_25) {
                    var16_23 = null;
                    if (var10_9 != 1) {
                        this.commitAfterAcknowledge(var2_2, var1_1, var3_3);
                        return 0x7FFFFFFF;
                    }
                    throw var15_25;
                }
                if (var10_9 != 1) {
                    this.commitAfterAcknowledge(var2_2, var1_1, var3_3);
                    return 0x7FFFFFFF;
                }
                return var13_11;
lbl58:
                // 3 sources

                if (this.transactedSessionTx != null || var11_14 != null && !var12_15) ** GOTO lbl73
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("JMSSession.commit had no work");
                }
                var13_12 = 0x7FFFFFFF;
                var16_20 = null;
                if (var10_9 != 1) {
                    this.commitAfterAcknowledge(var2_2, var1_1, var3_3);
                    return 0x7FFFFFFF;
                }
                return var13_12;
lbl73:
                // 3 sources

                this.transactedInfect();
                {
                    catch (Throwable var13_13) {
                        this.transactedSessionTx = null;
                        this.cleanAll();
                        var3_3 = var13_13;
                        var2_2 = true;
                        var14_17 = 0x7FFFFFFF;
                        var16_21 = null;
                        if (var10_9 != 1) {
                            this.commitAfterAcknowledge(var2_2, var1_1, var3_3);
                            return 0x7FFFFFFF;
                        }
                        return var14_17;
                    }
                }
                if (var11_14 != null || var7_7 == 0L && !var12_15) {
                    var10_9 = 1;
                }
                var16_22 = null;
                if (var10_9 != 1) {
                    this.commitAfterAcknowledge(var2_2, var1_1, var3_3);
                    return 0x7FFFFFFF;
                }
            }
            case 1: {
                var10_9 = 2;
                var13_10 = this;
                synchronized (var13_10) {
                    for (var11_14 = this.lastUnackedPushEntry; var11_14 != null && var7_7 != var11_14.getFrontEndSequenceNumber(); var11_14 = var11_14.getPrevUnacked()) {
                    }
                    if (var11_14 != null) {
                        this.firstUnackedPushEntry = var11_14.getNextUnacked();
                        if (this.firstUnackedPushEntry != null) {
                            this.firstUnackedPushEntry.setPrevUnacked(null);
                        } else {
                            this.lastUnackedPushEntry = null;
                        }
                    }
                }
                if (var11_14 == null) {
                    if (!var9_8) {
                        var1_1.setResult(new VoidResponse());
                    } else {
                        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                            JMSDebug.JMSFrontEnd.debug("FESession.acknowlege unackedPushEntry null, sequenceNumber=" + var7_7);
                        }
                        this.commitAfterAcknowledge(var2_2, var1_1, (Throwable)new weblogic.jms.common.JMSException("commit message not found"));
                    }
                    return 0x7FFFFFFF;
                }
                var1_1.needOutsideResult();
                var13_10 = new HashMap<DispatcherId, JMSDispatcher>();
                while (var11_14 != null) {
                    try {
                        var15_26 = this.consumerFind(var11_14.getConsumerId());
                        var15_26.statistics.decrementPendingCount(var11_14.getMessageSize());
                        var15_26.statistics.incrementReceivedCount(var11_14.getMessageSize());
                    }
                    catch (JMSException var15_27) {
                        // empty catch block
                    }
                    this.statistics.decrementPendingCount(var11_14.getMessageSize());
                    this.statistics.incrementReceivedCount(var11_14.getMessageSize());
                    var14_18 = var11_14.getDispatcher();
                    var15_26 = new BESessionAcknowledgeRequest(this.sessionId, var11_14.getBackEndSequenceNumber());
                    if (var13_10.put(var14_18.getId(), var14_18) != null) ** GOTO lbl154
                    if (var5_5 == null) {
                        var5_5 = var6_6 = var15_26;
                    } else {
                        var6_6.setNext((Request)var15_26);
                        var6_6 = var15_26;
                    }
                    try {
                        var1_1.dispatchAsync(var14_18, (Request)var15_26);
                    }
                    catch (DispatcherException var16_24) {
                        if (var4_4 != null) ** GOTO lbl154
                        var4_4 = new weblogic.jms.common.JMSException("Error acknowledging messages", (Throwable)var16_24);
                    }
lbl154:
                    // 4 sources

                    var11_14 = var11_14.getPrevUnacked();
                }
                var1_1.rememberChild((Request)var5_5);
                if (var9_8 != false ? var1_1.fanoutCompleteSuspendIfHaveChildren(true) != false : var1_1.fanoutComplete(true) != false) {
                    if (var4_4 == null) break;
                    throw var4_4;
                }
            }
            case 2: {
                if (!var9_8) {
                    var13_10 = this.checkChildExceptions(var1_1);
                    var1_1.setResult((Response)var13_10);
                    return 0x7FFFFFFF;
                }
            }
            case 3: {
                this.commitAfterAcknowledge(var2_2, var1_1, var3_3);
                var10_9 = 0x7FFFFFFF;
            }
        }
        var1_1.setState(var10_9);
        return var10_9;
    }

    private JMSException transactedException(String string, Throwable throwable) {
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("throwTransactedException() B " + string, throwable);
        }
        if (!(throwable instanceof JMSException) || ((JMSException)throwable).getErrorCode() == null || !((JMSException)throwable).getErrorCode().equals("ReservedRollbackOnly")) {
            string = throwable.getMessage() + ":" + string;
        }
        if (this.transactedSessionTx != null) {
            try {
                int n = this.transactedSessionTx.getStatus();
                if (n == 9 || n == 4 || n == 1) {
                    return new weblogic.jms.common.TransactionRolledBackException(string, "ReservedRollbackOnly", throwable);
                }
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
        return new weblogic.jms.common.JMSException(string, throwable);
    }

    private void throwTransactedException(String string, Throwable throwable) throws JMSException {
        JMSException jMSException = this.transactedException(string, throwable);
        if (this.transactedException == null) {
            this.transactedException = jMSException;
        }
        throw jMSException;
    }

    public synchronized void transactedInfect() throws JMSException {
        this.transactedInfect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transactedInfect(boolean bl) throws JMSException {
        block14: {
            if (this.transactionInUse) {
                if (this.transactedException == null) {
                    String string = "Only one thread may use a JMS Session at a time.";
                    this.throwTransactedException(string, (Throwable)((Object)new weblogic.jms.common.JMSException(string)));
                }
                throw this.transactedException;
            }
            if (this.transactedSessionTx != null && this.transactedException != null) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.transactedInfect() failed ", (Throwable)this.transactedException);
                }
                throw this.transactedException;
            }
            String string = null;
            try {
                if (this.transactedSessionTx != null) {
                    string = "error resuming transacted session's internal transaction";
                    this.tranManager.resume((Transaction)this.transactedSessionTx);
                    this.transactionInUse = true;
                    if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        JMSDebug.JMSFrontEnd.debug("FESession.transactedInfect() resume tx=" + TxHelper.getTransaction());
                    }
                    break block14;
                }
                string = "error beginning transacted session's internal transaction";
                int n = bl ? FEConnectionFactory.DEFAULT_SAF_TX_TIMEOUT : (this.connection.getTransactionTimeout() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.connection.getTransactionTimeout() > 0L ? (int)this.connection.getTransactionTimeout() : 3600));
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.transactedInfect() begin, timeout = " + n);
                }
                this.tranManager.setTransactionTimeout(n);
                this.tranManager.begin("JMS Internal");
                this.transactedSessionTx = TxHelper.getTransaction();
                this.transactionInUse = true;
                FESession fESession = this;
                synchronized (fESession) {
                    this.transactedSessionTx.setName(this.getName());
                }
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.transactedInfect() begin = " + this.transactedSessionTx);
                }
            }
            catch (Exception exception) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.transactedInfect() failed ", (Throwable)exception);
                }
                this.throwTransactedException(string, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void transactedDisinfect() throws JMSException {
        try {
            block9: {
                try {
                    Transaction transaction = this.tranManager.suspend();
                    if (this.transactedSessionTx != null && this.transactedSessionTx != transaction && transaction != null) {
                        Error error = new Error("dis transactedSessionTx !suspended|null");
                        JMSLogger.logStackTrace((Throwable)error);
                        if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) throw error;
                        JMSDebug.JMSFrontEnd.debug("FESession.transactedDisinfect() expected:" + this.transactedSessionTx + ", but got:" + transaction);
                        throw error;
                    }
                    if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) break block9;
                    JMSDebug.JMSFrontEnd.debug("FESession.transactedDisinfect() suspend tx = " + this.transactedSessionTx);
                }
                catch (SystemException systemException) {
                    if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        JMSDebug.JMSFrontEnd.debug("FESession.pTransactedDisinfect() failed", (Throwable)systemException);
                    }
                    this.throwTransactedException("SystemException suspending transacted session's internal transaction", systemException);
                    Object var4_5 = null;
                    if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        JMSDebug.JMSFrontEnd.debug("disinfected in finally");
                    }
                    this.transactionInUse = false;
                    return;
                }
            }
            Object var4_4 = null;
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("disinfected in finally");
            }
            this.transactionInUse = false;
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("disinfected in finally");
            }
            this.transactionInUse = false;
            throw throwable;
        }
    }

    private synchronized void transactedUnackedStatistics(boolean bl) {
        for (UnackedMessage unackedMessage = this.firstTranStatUnackedMessage; unackedMessage != null; unackedMessage = unackedMessage.getNext()) {
            if (bl) {
                unackedMessage.commitTransactedStatistics(this);
                continue;
            }
            unackedMessage.rollbackTransactedStatistics(this);
        }
        this.firstTranStatUnackedMessage = null;
        this.lastTranStatUnackedMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollbackAfterRecover() throws JMSException {
        Throwable throwable;
        block18: {
            block17: {
                throwable = this.transactedException;
                try {
                    FESession fESession = this;
                    synchronized (fESession) {
                        if (this.transactedSessionTx == null) {
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("FESession.rollback had no tran");
                            }
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                            Object var6_4 = null;
                            this.transactedException = null;
                            this.transactionInUse = false;
                            this.transactedSessionTx = null;
                            this.cleanAll();
                            break block17;
                        }
                        try {
                            this.tranManager.forceResume((Transaction)this.transactedSessionTx);
                        }
                        catch (Exception exception) {
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("FESession.rollback resume failed", (Throwable)exception);
                            }
                            throwable = exception;
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 7] lbl23 : MonitorExitStatement: MONITOREXIT : var2_2
                            Object var6_5 = null;
                            this.transactedException = null;
                            this.transactionInUse = false;
                            this.transactedSessionTx = null;
                            this.cleanAll();
                            this.tranManager.forceSuspend();
                            this.transactedUnackedStatistics(false);
                            if (throwable != null) {
                                if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
                                JMSDebug.JMSFrontEnd.debug("FERollback ends", throwable);
                                throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
                            }
                            if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) return;
                            JMSDebug.JMSFrontEnd.debug("FERollback end");
                            return;
                        }
                    }
                    try {
                        this.tranManager.rollback();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    break block18;
                }
                catch (Throwable throwable3) {
                    Object var6_7 = null;
                    this.transactedException = null;
                    this.transactionInUse = false;
                    this.transactedSessionTx = null;
                    this.cleanAll();
                    this.tranManager.forceSuspend();
                    this.transactedUnackedStatistics(false);
                    if (throwable != null) {
                        if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
                        JMSDebug.JMSFrontEnd.debug("FERollback ends", throwable);
                        throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
                    }
                    if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) throw throwable3;
                    JMSDebug.JMSFrontEnd.debug("FERollback end");
                    throw throwable3;
                }
            }
            this.tranManager.forceSuspend();
            this.transactedUnackedStatistics(false);
            if (throwable != null) {
                if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
                JMSDebug.JMSFrontEnd.debug("FERollback ends", throwable);
                throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
            }
            if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) return;
            JMSDebug.JMSFrontEnd.debug("FERollback end");
            return;
        }
        Object var6_6 = null;
        this.transactedException = null;
        this.transactionInUse = false;
        this.transactedSessionTx = null;
        this.cleanAll();
        this.tranManager.forceSuspend();
        this.transactedUnackedStatistics(false);
        if (throwable != null) {
            if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
            JMSDebug.JMSFrontEnd.debug("FERollback ends", throwable);
            throw new weblogic.jms.common.JMSException(throwable.getMessage(), throwable);
        }
        if (!JMSDebug.JMSFrontEnd.isDebugEnabled()) return;
        JMSDebug.JMSFrontEnd.debug("FERollback end");
    }

    private Response checkChildExceptions(FESessionAcknowledgeRequest fESessionAcknowledgeRequest) throws JMSException {
        VoidResponse voidResponse = null;
        for (Request request = fESessionAcknowledgeRequest.getChild(); request != null; request = request.getNext()) {
            try {
                voidResponse = (VoidResponse)request.getResult();
                continue;
            }
            catch (JMSException jMSException) {
                throw jMSException;
            }
            catch (Throwable throwable) {
                return FESessionAcknowledgeRequest.handleThrowable(throwable);
            }
        }
        if (voidResponse == null) {
            voidResponse = new VoidResponse();
        }
        return voidResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitAfterAcknowledge(boolean bl, FESessionAcknowledgeRequest fESessionAcknowledgeRequest, Throwable throwable) throws JMSException {
        try {
            if (throwable == null) {
                try {
                    this.checkChildExceptions(fESessionAcknowledgeRequest);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (throwable == null && this.transactedSessionTx != null && !bl) {
                try {
                    if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck is called");
                    }
                    this.tranManager.commit();
                    this.transactedUnackedStatistics(true);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    bl = false;
                    this.transactedUnackedStatistics(false);
                }
            }
            Object var6_6 = null;
            this.transactionInUse = false;
            this.transactedException = null;
            this.transactedSessionTx = null;
            this.cleanAll();
        }
        catch (Throwable throwable4) {
            Object var6_7 = null;
            this.transactionInUse = false;
            this.transactedException = null;
            this.transactedSessionTx = null;
            this.cleanAll();
            try {
                if (bl) {
                    this.transactedUnackedStatistics(false);
                    if (TxHelper.getTransaction() != null) {
                        try {
                            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                                JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck forceRollback");
                            }
                            this.tranManager.rollback();
                        }
                        catch (Throwable throwable5) {
                            fESessionAcknowledgeRequest.clearResult();
                            throw JMSUtilities.jmsExceptionThrowable("commit failed, then follback exception", throwable5);
                        }
                    }
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable6) {
                Object var9_13 = null;
                this.tranManager.forceSuspend();
                throw throwable6;
            }
            this.tranManager.forceSuspend();
            if (throwable != null) {
                if (throwable instanceof TransactionRolledBackException && ((JMSException)throwable).getErrorCode() != null && ((JMSException)throwable).getErrorCode().equals("ReservedRollbackOnly")) {
                    if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                        JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck throw error code", throwable);
                    }
                    fESessionAcknowledgeRequest.clearResult();
                    throw JMSUtilities.jmsExceptionThrowable(throwable.getMessage(), throwable);
                }
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck throws", throwable);
                }
                fESessionAcknowledgeRequest.clearResult();
                throw this.transactedException("commit failure", throwable);
            }
            fESessionAcknowledgeRequest.setResult(new VoidResponse());
            throw throwable4;
        }
        try {
            if (bl) {
                this.transactedUnackedStatistics(false);
                if (TxHelper.getTransaction() != null) {
                    try {
                        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                            JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck forceRollback");
                        }
                        this.tranManager.rollback();
                    }
                    catch (Throwable throwable7) {
                        fESessionAcknowledgeRequest.clearResult();
                        throw JMSUtilities.jmsExceptionThrowable("commit failed, then follback exception", throwable7);
                    }
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable8) {
            Object var9_11 = null;
            this.tranManager.forceSuspend();
            throw throwable8;
        }
        this.tranManager.forceSuspend();
        if (throwable != null) {
            if (throwable instanceof TransactionRolledBackException && ((JMSException)throwable).getErrorCode() != null && ((JMSException)throwable).getErrorCode().equals("ReservedRollbackOnly")) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck throw error code", throwable);
                }
                fESessionAcknowledgeRequest.clearResult();
                throw JMSUtilities.jmsExceptionThrowable(throwable.getMessage(), throwable);
            }
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("FESession.commitAfterAck throws", throwable);
            }
            fESessionAcknowledgeRequest.clearResult();
            throw this.transactedException("commit failure", throwable);
        }
        fESessionAcknowledgeRequest.setResult(new VoidResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transactionStat(FEConsumer fEConsumer, FEProducer fEProducer, MessageImpl messageImpl) {
        if (!this.transacted) {
            if (fEConsumer != null) {
                fEConsumer.statistics.incrementReceivedCount(messageImpl);
                this.statistics.incrementReceivedCount(messageImpl);
            } else {
                fEProducer.incMessagesSentCount(messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize());
                this.statistics.incrementSentCount(messageImpl);
            }
            return;
        }
        this.statistics.incrementPendingCount(messageImpl);
        if (fEConsumer != null) {
            fEConsumer.statistics.incrementPendingCount(messageImpl);
        } else {
            fEProducer.incMessagesPendingCount(messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize());
        }
        UnackedMessage unackedMessage = new UnackedMessage(fEConsumer, fEProducer, messageImpl);
        FESession fESession = this;
        synchronized (fESession) {
            unackedMessage.setPrev(this.lastTranStatUnackedMessage);
            if (this.firstTranStatUnackedMessage == null) {
                this.firstTranStatUnackedMessage = unackedMessage;
            } else {
                this.lastTranStatUnackedMessage.setNext(unackedMessage);
            }
            this.lastTranStatUnackedMessage = unackedMessage;
        }
    }

    public String getAcknowledgeMode() {
        if (this.originalAcknowledgeMode == 4) {
            return "None";
        }
        if (this.originalAcknowledgeMode == 128) {
            return "Multicast None";
        }
        if (this.originalAcknowledgeMode == 2) {
            return "Client";
        }
        if (this.originalAcknowledgeMode == 1) {
            return "Auto";
        }
        return "Dups-Ok";
    }

    MessageStatistics getStatistics() {
        return this.statistics;
    }

    public long getBytesPendingCount() {
        return this.statistics.getBytesPendingCount();
    }

    public long getBytesReceivedCount() {
        return this.statistics.getBytesReceivedCount();
    }

    public long getBytesSentCount() {
        return this.statistics.getBytesSentCount();
    }

    public long getMessagesPendingCount() {
        return this.statistics.getMessagesPendingCount();
    }

    public long getMessagesReceivedCount() {
        return this.statistics.getMessagesReceivedCount();
    }

    public long getMessagesSentCount() {
        return this.statistics.getMessagesSentCount();
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setRedeliveryDelay(FESessionSetRedeliveryDelayRequest fESessionSetRedeliveryDelayRequest) throws JMSException {
        switch (fESessionSetRedeliveryDelayRequest.getState()) {
            case 0: {
                Iterator iterator;
                this.checkShutdownOrSuspended();
                DispatcherException dispatcherException = null;
                Object object = this;
                synchronized (object) {
                    iterator = ((HashMap)this.beDispatchers.clone()).values().iterator();
                }
                Object object2 = null;
                Object object3 = null;
                while (iterator.hasNext()) {
                    object = new BESessionSetRedeliveryDelayRequest(this.sessionId, fESessionSetRedeliveryDelayRequest.getRedeliveryDelay());
                    if (object3 == null) {
                        object3 = object2 = object;
                    } else {
                        ((Request)object2).setNext((Request)object);
                        object2 = object;
                    }
                    try {
                        fESessionSetRedeliveryDelayRequest.dispatchAsync((JMSDispatcher)iterator.next(), (Request)object);
                    }
                    catch (DispatcherException dispatcherException2) {
                        dispatcherException = dispatcherException2;
                    }
                }
                if (dispatcherException != null) {
                    throw new weblogic.jms.common.JMSException("Error setting redelivery delay", dispatcherException);
                }
                object = fESessionSetRedeliveryDelayRequest;
                synchronized (object) {
                    fESessionSetRedeliveryDelayRequest.setState(2);
                    fESessionSetRedeliveryDelayRequest.rememberChild((Request)object3);
                }
                return 2;
            }
        }
        VoidResponse voidResponse = null;
        for (Request request = fESessionSetRedeliveryDelayRequest.getChild(); request != null; request = request.getNext()) {
            voidResponse = (VoidResponse)((BESessionSetRedeliveryDelayRequest)request).getResult();
        }
        if (voidResponse == null) {
            voidResponse = new VoidResponse();
        }
        fESessionSetRedeliveryDelayRequest.setResult(voidResponse);
        return Integer.MAX_VALUE;
    }

    void addUnackedPushEntry(JMSPushEntry jMSPushEntry, long l) {
        jMSPushEntry.setMessageSize(l);
        jMSPushEntry.setFrontEndSequenceNumber(this.getNextSequenceNumber());
        if (this.acknowledgeMode == 4) {
            return;
        }
        jMSPushEntry.setPrevUnacked(this.lastUnackedPushEntry);
        jMSPushEntry.setNextUnacked(null);
        if (this.firstUnackedPushEntry == null) {
            this.firstUnackedPushEntry = jMSPushEntry;
        } else {
            this.lastUnackedPushEntry.setNextUnacked(jMSPushEntry);
        }
        this.lastUnackedPushEntry = jMSPushEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(MessageImpl messageImpl, JMSPushEntry jMSPushEntry) {
        long l = messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize();
        FESession fESession = this;
        synchronized (fESession) {
            if (!jMSPushEntry.getClientResponsibleForAcknowledge()) {
                if (this.acknowledgeMode != 4) {
                    this.statistics.incrementPendingCount(l);
                }
                this.addUnackedPushEntry(jMSPushEntry, l);
            } else {
                this.statistics.incrementReceivedCount(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageImpl receiveInterceptionPoint(DestinationImpl destinationImpl, MessageImpl messageImpl) throws JMSException {
        Object object = interceptionPointLock;
        synchronized (object) {
            String[] stringArray;
            if (this.receiveIPHandle != null && this.receiveIPDestination != destinationImpl) {
                try {
                    MessageInterceptionService.getSingleton().unRegisterInterceptionPoint(this.receiveIPHandle);
                }
                catch (InterceptionServiceException interceptionServiceException) {
                    throw new AssertionError((Object)("Failure to unregister" + interceptionServiceException));
                }
                this.receiveIPHandle = null;
            }
            if (this.receiveIPHandle == null) {
                this.receiveIPDestination = destinationImpl;
                stringArray = new String[]{destinationImpl.getServerName(), destinationImpl.getName(), "Receive"};
                if (stringArray[0] == null) {
                    stringArray[0] = new String();
                }
                if (stringArray[1] == null) {
                    stringArray[1] = new String();
                }
                try {
                    this.receiveIPHandle = MessageInterceptionService.getSingleton().registerInterceptionPoint("JMS", stringArray);
                }
                catch (InterceptionServiceException interceptionServiceException) {
                    throw new weblogic.jms.common.JMSException("FAILED registerInterceptionPoint " + interceptionServiceException);
                }
            }
            try {
                if (this.receiveIPHandle.hasAssociation()) {
                    messageImpl = messageImpl.copy();
                    stringArray = new JMSMessageContextImpl(messageImpl);
                    this.receiveIPHandle.process((MessageContext)stringArray);
                    return messageImpl;
                }
            }
            catch (Exception exception) {
                throw new weblogic.jms.common.JMSException("FAILED in interception " + exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(JMSPushRequest jMSPushRequest) {
        block32: {
            MessageImpl messageImpl;
            JMSPushRequest jMSPushRequest2 = jMSPushRequest;
            Request request = null;
            Object object = this;
            synchronized (object) {
                while (jMSPushRequest != null) {
                    messageImpl = jMSPushRequest.getMessage();
                    if (this.connection.getCompressionThreshold() < jMSPushRequest.getCompressionThreshold()) {
                        jMSPushRequest.setCompressionThreshold(this.connection.getCompressionThreshold());
                    }
                    long l = messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize();
                    JMSPushEntry jMSPushEntry = null;
                    JMSPushEntry jMSPushEntry2 = jMSPushRequest.getFirstPushEntry();
                    while (jMSPushEntry2 != null) {
                        Object var15_15;
                        try {
                            block31: {
                                try {
                                    FEConsumer fEConsumer = this.consumerFind(jMSPushEntry2.getConsumerId());
                                    if (jMSPushEntry2.getClientResponsibleForAcknowledge()) {
                                        this.statistics.incrementReceivedCount(l);
                                        fEConsumer.statistics.incrementReceivedCount(l);
                                        jMSPushEntry2.setFrontEndSequenceNumber(this.getNextSequenceNumber());
                                    } else {
                                        if (this.acknowledgeMode != 4) {
                                            this.statistics.incrementPendingCount(l);
                                            fEConsumer.statistics.incrementPendingCount(l);
                                        }
                                        this.addUnackedPushEntry(jMSPushEntry2, l);
                                    }
                                    MessageImpl messageImpl2 = this.receiveInterceptionPoint(fEConsumer.getDestination(), messageImpl);
                                    if (messageImpl2 != null) {
                                        if (jMSPushEntry == null && jMSPushEntry2.getNext() == null) {
                                            jMSPushRequest.setMessage(messageImpl2);
                                        } else {
                                            JMSPushRequest jMSPushRequest3 = new JMSPushRequest();
                                            jMSPushRequest3.setNext(jMSPushRequest2);
                                            jMSPushRequest2 = jMSPushRequest3;
                                            jMSPushRequest3.setMessage(messageImpl2);
                                            jMSPushRequest3.setFirstPushEntry(jMSPushEntry2);
                                            if (jMSPushEntry == null) {
                                                jMSPushRequest.setFirstPushEntry(jMSPushEntry2.getNext());
                                            } else {
                                                jMSPushEntry.setNext(jMSPushEntry2.getNext());
                                            }
                                            JMSPushEntry jMSPushEntry3 = new JMSPushEntry();
                                            jMSPushEntry3.setNext(jMSPushEntry2.getNext());
                                            jMSPushEntry2.setNext(null);
                                            jMSPushEntry2 = jMSPushEntry3;
                                        }
                                        break block31;
                                    }
                                    jMSPushEntry = jMSPushEntry2;
                                }
                                catch (JMSException jMSException) {
                                    if (jMSPushEntry == null) {
                                        jMSPushRequest.setFirstPushEntry(jMSPushEntry2.getNext());
                                    } else {
                                        jMSPushEntry.setNext(jMSPushEntry2.getNext());
                                    }
                                    var15_15 = null;
                                    jMSPushEntry2 = jMSPushEntry2.getNext();
                                    continue;
                                }
                            }
                            var15_15 = null;
                            jMSPushEntry2 = jMSPushEntry2.getNext();
                        }
                        catch (Throwable throwable) {
                            var15_15 = null;
                            jMSPushEntry2 = jMSPushEntry2.getNext();
                            throw throwable;
                        }
                    }
                    if (jMSPushRequest.getFirstPushEntry() == null) {
                        if (request == null) {
                            jMSPushRequest2 = (JMSPushRequest)jMSPushRequest.getNext();
                        } else {
                            request.setNext(jMSPushRequest.getNext());
                        }
                    }
                    MessageTimeStamp.record(5, jMSPushRequest.getMessage());
                    request = jMSPushRequest;
                    jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext();
                }
            }
            if (jMSPushRequest2 != null) {
                try {
                    object = this.connection.getClientDispatcher();
                    jMSPushRequest = object.isLocal() ? new JMSPushRequest(jMSPushRequest2) : jMSPushRequest2;
                    jMSPushRequest.setInvocableType(4);
                    if (JMSDebug.JMSMessagePath.isDebugEnabled()) {
                        JMSDebug.JMSMessagePath.debug("FRONTEND/FESession (id: " + this.sessionId + ") : " + "Pushing to the client, message " + jMSPushRequest.getMessage().getJMSMessageID());
                    }
                    messageImpl = (AuthenticatedSubject)CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject((JMSDispatcher)object, (AbstractSubject)this.getSubjectForQOS(), false);
                    if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
                        JMSDebug.JMSCrossDomainSecurity.debug("Push messages:subject to use = " + messageImpl);
                    }
                    if (this.disableMultiSend && !object.isLocal()) {
                        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new PushDispatchThread((JMSDispatcher)object, jMSPushRequest, (AuthenticatedSubject)messageImpl));
                        break block32;
                    }
                    SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)messageImpl);
                    try {
                        object.dispatchNoReply(jMSPushRequest);
                        Object var18_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_19 = null;
                        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                        throw throwable;
                    }
                    SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                    {
                    }
                }
                catch (JMSException jMSException) {
                    JMSLogger.logErrorPushingMessage((String)jMSException.toString(), (Throwable)jMSException);
                }
            }
        }
    }

    public JMSID getJMSID() {
        return this.sessionId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 6152: {
                return this.acknowledge((FESessionAcknowledgeRequest)request);
            }
            case 6920: {
                return this.recover((FESessionRecoverRequest)request);
            }
            case 4872: {
                return this.producerCreate((FEProducerCreateRequest)request);
            }
            case 2824: {
                try {
                    return this.consumerCreate((FEConsumerCreateRequest)request);
                }
                catch (JMSException jMSException) {
                    this.checkStaleDestination(jMSException, request);
                    return this.consumerCreate((FEConsumerCreateRequest)request);
                }
            }
            case 520: {
                try {
                    return this.browserCreate((FEBrowserCreateRequest)request);
                }
                catch (JMSException jMSException) {
                    this.checkStaleDestination(jMSException, request);
                    return this.browserCreate((FEBrowserCreateRequest)request);
                }
            }
            case 7176: {
                this.setRedeliveryDelay((FESessionSetRedeliveryDelayRequest)request);
                break;
            }
            case 6408: {
                this.checkShutdownOrSuspended();
                this.close(((FESessionCloseRequest)request).getLastSequenceNumber());
                break;
            }
            default: {
                throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
            }
        }
        request.setResult(new VoidResponse());
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    void checkStaleDestination(JMSException jMSException, Request request) throws JMSException {
        if (!FESession.isStaleDestEx(jMSException)) {
            throw jMSException;
        }
        if (request instanceof FEBrowserCreateRequest) {
            FEBrowserCreateRequest fEBrowserCreateRequest = (FEBrowserCreateRequest)request;
            if (fEBrowserCreateRequest.getNumberOfRetries() > 0) {
                throw jMSException;
            }
            DestinationImpl destinationImpl = fEBrowserCreateRequest.getDestination();
            if (destinationImpl instanceof DistributedDestinationImpl) {
                throw jMSException;
            }
            fEBrowserCreateRequest.setDestination(this.createFromStaleDestination(destinationImpl));
            fEBrowserCreateRequest.setNumberOfRetries(fEBrowserCreateRequest.getNumberOfRetries() + 1);
        } else if (request instanceof FEConsumerCreateRequest) {
            FEConsumerCreateRequest fEConsumerCreateRequest = (FEConsumerCreateRequest)request;
            if (fEConsumerCreateRequest.getNumberOfRetries() > 0) {
                throw jMSException;
            }
            DestinationImpl destinationImpl = fEConsumerCreateRequest.getDestination();
            if (destinationImpl instanceof DistributedDestinationImpl) {
                throw jMSException;
            }
            fEConsumerCreateRequest.setDestination(this.createFromStaleDestination(destinationImpl));
            fEConsumerCreateRequest.setNumberOfRetries(fEConsumerCreateRequest.getNumberOfRetries() + 1);
        } else {
            throw jMSException;
        }
        request.clearResult();
        request.setState(0);
    }

    private DestinationImpl createFromStaleDestination(DestinationImpl destinationImpl) throws JMSException {
        DestinationImpl destinationImpl2 = this.getConnection().createDestination(destinationImpl);
        destinationImpl2.setDispatcherId(destinationImpl.getDispatcherId());
        return destinationImpl2;
    }

    static boolean isStaleDestEx(JMSException jMSException) {
        Throwable throwable = null;
        for (throwable = jMSException; throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof InvalidDestinationException)) continue;
            return true;
        }
        return false;
    }

    private synchronized JMSDispatcher beDispatcherRemove(DispatcherId dispatcherId) {
        JMSDispatcher jMSDispatcher = (JMSDispatcher)this.beDispatchers.remove(dispatcherId);
        Sequencer sequencer = (Sequencer)this.sequencers.remove(dispatcherId);
        if (sequencer != null) {
            InvocableManagerDelegate.delegate.invocableRemove(13, sequencer.getJMSID());
        }
        return jMSDispatcher;
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("FEConsumer.jmsPeerGone()");
        }
        this.beDispatcherRemove(dispatcher.getId());
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        HashMap hashMap = (HashMap)this.producers.clone();
        HashMap hashMap2 = (HashMap)this.consumers.clone();
        xMLStreamWriter.writeStartElement("Session");
        xMLStreamWriter.writeAttribute("id", this.sessionId != null ? this.sessionId.toString() : "");
        xMLStreamWriter.writeAttribute("isTransacted", String.valueOf(this.transacted));
        xMLStreamWriter.writeAttribute("consumersCurrentCount", String.valueOf(hashMap2.size()));
        xMLStreamWriter.writeAttribute("consumersHighCount", String.valueOf(this.consumersHighCount));
        xMLStreamWriter.writeAttribute("consumersTotalCount", String.valueOf(this.consumersTotalCount));
        xMLStreamWriter.writeAttribute("producersCurrentCount", String.valueOf(hashMap.size()));
        xMLStreamWriter.writeAttribute("producersHighCount", String.valueOf(this.producersHighCount));
        xMLStreamWriter.writeAttribute("producersTotalCount", String.valueOf(this.producersTotalCount));
        xMLStreamWriter.writeAttribute("browsersCurrentCount", String.valueOf(this.browsers.size()));
        xMLStreamWriter.writeAttribute("browsersHighCount", String.valueOf(this.browsersHighCount));
        this.statistics.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeStartElement("Producers");
        for (RuntimeMBeanDelegate runtimeMBeanDelegate : hashMap.values()) {
            runtimeMBeanDelegate.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Consumers");
        for (RuntimeMBeanDelegate runtimeMBeanDelegate : hashMap2.values()) {
            runtimeMBeanDelegate.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    public void pushException(int n, JMSID jMSID, JMSException jMSException) throws JMSException {
        JMSPushExceptionRequest jMSPushExceptionRequest = new JMSPushExceptionRequest(n, jMSID, (weblogic.jms.common.JMSException)jMSException);
        if (this.getSubjectForQOS() == null) {
            this.updateQOS();
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)CrossDomainSecurityManager.getCrossDomainSecurityUtil().getRemoteSubject(this.getConnection().getClientDispatcher(), (AbstractSubject)this.getSubjectForQOS(), false);
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
        try {
            try {
                this.getConnection().getClientDispatcher().dispatchNoReply(jMSPushExceptionRequest);
            }
            catch (Exception exception) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("Failure pushing exception " + exception);
                }
                throw new JMSException("Failure pushing exception " + exception);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
    }

    private class PushDispatchThread
    implements Runnable {
        JMSPushRequest pushRequest;
        JMSDispatcher dispatcher;
        AuthenticatedSubject subject;

        private PushDispatchThread(JMSDispatcher jMSDispatcher, JMSPushRequest jMSPushRequest, AuthenticatedSubject authenticatedSubject) {
            this.pushRequest = jMSPushRequest;
            this.dispatcher = jMSDispatcher;
            this.subject = authenticatedSubject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)this.subject);
            try {
                try {
                    this.dispatcher.dispatchNoReply(this.pushRequest);
                }
                catch (JMSException jMSException) {
                    JMSLogger.logErrorPushingMessage((String)jMSException.toString(), (Throwable)jMSException);
                    Object var3_2 = null;
                    SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                throw throwable;
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        }
    }
}

