/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class FESessionCreateResponse
extends Response
implements Externalizable {
    static final long serialVersionUID = 7264039147425603407L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private JMSID sessionId;
    private String runtimeMBeanName;

    public FESessionCreateResponse(JMSID jMSID, String string) {
        this.sessionId = jMSID;
        this.runtimeMBeanName = string;
    }

    public JMSID getSessionId() {
        return this.sessionId;
    }

    public String getRuntimeMBeanName() {
        return this.runtimeMBeanName;
    }

    public FESessionCreateResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        PeerInfo peerInfo = null;
        if (objectOutput instanceof PeerInfoable) {
            peerInfo = ((PeerInfoable)objectOutput).getPeerInfo();
        }
        int n = peerInfo == null || peerInfo.compareTo((Object)PeerInfo.VERSION_81) >= 0 ? 2 : 1;
        objectOutput.writeByte(n);
        super.writeExternal(objectOutput);
        this.sessionId.writeExternal(objectOutput);
        if (n >= 2) {
            objectOutput.writeUTF(this.runtimeMBeanName);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1 && by != 2) {
            throw JMSUtilities.versionIOException(by, 1, 2);
        }
        super.readExternal(objectInput);
        this.sessionId = new JMSID();
        this.sessionId.readExternal(objectInput);
        if (by >= 2) {
            this.runtimeMBeanName = objectInput.readUTF();
        }
    }
}

