/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.frontend.FETemporaryDestinationCreateResponse;
import weblogic.messaging.dispatcher.Response;

public final class FETemporaryDestinationCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 8448408102807078690L;
    private int destinationType;
    private boolean temporary;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TEMPORARY_MASK = 256;

    public FETemporaryDestinationCreateRequest(JMSID jMSID, int n, boolean bl) {
        super(jMSID, 7687);
        this.destinationType = n;
        this.temporary = bl;
    }

    public final int getDestType() {
        return this.destinationType;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new FETemporaryDestinationCreateResponse();
    }

    public FETemporaryDestinationCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = 1;
        if (this.temporary) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.destinationType);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.destinationType = objectInput.readInt();
        this.temporary = (n & 0x100) != 0;
    }
}

