/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.LeaderManager;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.frontend.FEConnection;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.messaging.dispatcher.InvocableMonitor;

public final class FrontEnd {
    private final String mbeanName;
    private final HashMap connectionFactories = new HashMap();
    private long connectionFactoriesCurrentCount;
    private long connectionFactoriesHighCount;
    private long connectionFactoriesTotalCount;
    private final HashMap beDestinationTables = new HashMap();
    public static final String JMS_TEMP_DESTINATION_FTY_JNDI = "weblogic.jms.TempDestinationFactory";
    private static JMSService jmsService;
    private final LeaderManager leaderManager;
    private final JMSServerId frontEndId;
    private static FrontEnd frontEnd;
    private final InvocableMonitor invocableMonitor;
    private int state = 0;

    public FrontEnd(JMSService jMSService) {
        jmsService = jMSService;
        this.mbeanName = jMSService.getMbeanName();
        this.frontEndId = jMSService.getNextServerId();
        this.invocableMonitor = new InvocableMonitor(jMSService.getInvocableMonitor());
        this.leaderManager = LeaderManager.getLeaderManager(this.frontEndId.getId());
        frontEnd = this;
        this.state = 1;
    }

    public static FrontEnd getFrontEnd() {
        return frontEnd;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    JMSService getService() {
        return jmsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void markShuttingDown() {
        if ((this.state & 0x18) != 0) {
            return;
        }
        this.state = 8;
        Iterator iterator = this.connectionFactories.values().iterator();
        while (iterator.hasNext()) {
            ((FEConnectionFactory)iterator.next()).markShuttingDown();
        }
        FrontEnd frontEnd = this;
        synchronized (frontEnd) {
            iterator = ((HashMap)this.getConnectionsMap().clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            ((FEConnection)iterator.next()).markShuttingDown();
        }
    }

    private synchronized void checkShutdown() throws JMSException {
        if ((this.state & 0x18) != 0) {
            throw new weblogic.jms.common.JMSException("JMS Server is shutdown or suspended");
        }
    }

    synchronized void checkShutdownOrSuspended() throws JMSException {
        if ((this.state & 0x1B) != 0) {
            throw new weblogic.jms.common.JMSException("JMS server is shutdown or suspended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void markSuspending() {
        if ((this.state & 0x1B) != 0) {
            return;
        }
        this.state = 2;
        Iterator iterator = this.connectionFactories.values().iterator();
        while (iterator.hasNext()) {
            ((FEConnectionFactory)iterator.next()).markSuspending();
        }
        FrontEnd frontEnd = this;
        synchronized (frontEnd) {
            iterator = ((HashMap)this.getConnectionsMap().clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            ((FEConnection)iterator.next()).markSuspending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForSuspend(boolean bl) {
        Iterator<Object> iterator;
        Object object = this;
        synchronized (object) {
            if ((this.state & 0x18) != 0) {
                return;
            }
            if ((this.state & 2) == 0) {
                this.markSuspending();
            }
            iterator = ((HashMap)this.connectionFactories.clone()).keySet().iterator();
        }
        while (iterator.hasNext()) {
            try {
                object = (String)iterator.next();
                FEConnectionFactory fEConnectionFactory = (FEConnectionFactory)this.connectionFactories.get(object);
                fEConnectionFactory.suspend();
            }
            catch (Throwable throwable) {}
        }
        if (!bl) {
            object = this;
            synchronized (object) {
                iterator = ((HashMap)this.getConnectionsMap().clone()).values().iterator();
            }
            while (iterator.hasNext()) {
                try {
                    object = (FEConnection)iterator.next();
                    ((FEConnection)object).stop();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(boolean bl) throws Exception {
        FrontEnd frontEnd;
        boolean bl2 = false;
        Throwable throwable = null;
        Object object = this;
        synchronized (object) {
            if ((this.state & 0x18) != 0) {
                return;
            }
            if ((this.state & 2) == 0) {
                bl2 = true;
                this.markSuspending();
            }
            if (bl) {
                this.invocableMonitor.forceInvocablesCompletion();
            }
        }
        try {
            Iterator iterator;
            block27: {
                if (bl2) {
                    try {
                        this.prepareForSuspend(bl);
                    }
                    catch (Throwable throwable2) {
                        if (throwable != null) break block27;
                        throwable = throwable2;
                    }
                }
            }
            if (!bl && bl2) {
                this.invocableMonitor.waitForInvocablesCompletion();
            }
            object = this;
            synchronized (object) {
                iterator = ((HashMap)this.getConnectionsMap().clone()).values().iterator();
            }
            while (iterator.hasNext()) {
                try {
                    object = (FEConnection)iterator.next();
                    ((FEConnection)object).normalClose();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) continue;
                    throwable = throwable3;
                }
            }
            Object var9_10 = null;
            frontEnd = this;
        }
        catch (Throwable throwable4) {
            Object var9_11 = null;
            FrontEnd frontEnd2 = this;
            synchronized (frontEnd2) {
                this.state = 1;
            }
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new weblogic.jms.common.JMSException("Error occurred in suspending JMS Service", throwable);
            }
            throw throwable4;
        }
        synchronized (frontEnd) {
            this.state = 1;
        }
        if (throwable != null) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new weblogic.jms.common.JMSException("Error occurred in suspending JMS Service", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws JMSException {
        Iterator iterator;
        Object object = this;
        synchronized (object) {
            if ((this.state & 4) != 0) {
                return;
            }
            if ((this.state & 1) == 0) {
                throw new JMSException("Failed to start JMS connection factories: wrong state");
            }
            iterator = ((HashMap)this.connectionFactories.clone()).keySet().iterator();
        }
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            FEConnectionFactory fEConnectionFactory = (FEConnectionFactory)this.connectionFactories.get(object);
            String string = fEConnectionFactory.getJNDIName();
            if (fEConnectionFactory == null) continue;
            try {
                fEConnectionFactory.bind();
                if (fEConnectionFactory.isDefaultConnectionFactory()) {
                    JMSLogger.logDefaultCFactoryDeployed((String)object, (String)string);
                    continue;
                }
                JMSLogger.logCFactoryDeployed((String)object);
            }
            catch (JMSException jMSException) {
                if (fEConnectionFactory.isDefaultConnectionFactory()) {
                    JMSLogger.logErrorBindDefaultCF((String)object, (String)string, (Exception)((Object)jMSException));
                } else {
                    JMSLogger.logErrorBindCF((String)object, (Exception)((Object)jMSException));
                }
                throw jMSException;
            }
        }
        object = this;
        synchronized (object) {
            this.state = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Iterator<Object> iterator;
        Object object = this;
        synchronized (object) {
            if ((this.state & 0x10) != 0) {
                return;
            }
            if ((this.state & 8) == 0) {
                this.markShuttingDown();
            }
            iterator = ((HashMap)this.connectionFactories.clone()).keySet().iterator();
        }
        while (iterator.hasNext()) {
            try {
                object = (String)iterator.next();
                FEConnectionFactory fEConnectionFactory = (FEConnectionFactory)this.connectionFactories.get(object);
                fEConnectionFactory.unbind();
                FrontEnd frontEnd = this;
                synchronized (frontEnd) {
                    this.connectionFactoryRemove(fEConnectionFactory);
                }
            }
            catch (Throwable throwable) {
            }
        }
        object = this;
        synchronized (object) {
            iterator = ((HashMap)this.getConnectionsMap().clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            try {
                object = (FEConnection)iterator.next();
                ((FEConnection)object).normalClose();
            }
            catch (Throwable throwable) {}
        }
        object = this;
        synchronized (object) {
            this.state = 16;
        }
    }

    public synchronized void connectionFactoryAdd(FEConnectionFactory fEConnectionFactory) throws JMSException {
        this.checkShutdown();
        String string = fEConnectionFactory.getName();
        if (this.connectionFactories.put(string, fEConnectionFactory) != null) {
            return;
        }
        ++this.connectionFactoriesTotalCount;
        if (++this.connectionFactoriesCurrentCount > this.connectionFactoriesHighCount) {
            this.connectionFactoriesHighCount = this.connectionFactoriesCurrentCount;
        }
    }

    public synchronized void connectionFactoryRemove(FEConnectionFactory fEConnectionFactory) {
        String string = fEConnectionFactory.getName();
        if (this.connectionFactories.remove(string) == null) {
            return;
        }
        --this.connectionFactoriesCurrentCount;
    }

    public synchronized FEConnectionFactory connectionFactoryFind(String string) {
        return (FEConnectionFactory)this.connectionFactories.get(string);
    }

    public FEConnectionFactory[] getConnectionFactories() {
        return this.connectionFactories.values().toArray(new FEConnectionFactory[this.connectionFactories.size()]);
    }

    synchronized void addBackEndDestination(JMSServerId jMSServerId, String string, DestinationImpl destinationImpl, FEConnection fEConnection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeBackEndDestination(DestinationImpl destinationImpl) {
        HashMap hashMap = (HashMap)this.beDestinationTables.get(destinationImpl.getBackEndId());
        if (hashMap == null) {
            return;
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            hashMap.remove(destinationImpl.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DestinationImpl findBackEndDestination(JMSServerId jMSServerId, String string) {
        HashMap hashMap = (HashMap)this.beDestinationTables.get(jMSServerId);
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = hashMap;
        synchronized (hashMap2) {
            return (DestinationImpl)hashMap.get(string);
        }
    }

    public static JMSService getJMSService() {
        return jmsService;
    }

    InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    private HashMap getConnectionsMap() {
        return InvocableManagerDelegate.delegate.getInvocableMap(7);
    }

    public JMSServerId getFrontEndId() {
        return this.frontEndId;
    }
}

