/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDStatusListener;

public final class SAFReplyHandler
implements DDStatusListener {
    private static Map idMap;
    private static SAFReplyHandler singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(MessageImpl messageImpl) {
        DestinationImpl destinationImpl = (DestinationImpl)messageImpl.getJMSReplyTo();
        if (destinationImpl == null) {
            return;
        }
        String string = destinationImpl.getReferenceName();
        if (string == null) {
            return;
        }
        destinationImpl.setReferenceName(null);
        if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
            JMSDebug.JMSFrontEnd.debug("Reply to with a reference name of " + string);
        }
        SAFReplyHandler sAFReplyHandler = singleton;
        synchronized (sAFReplyHandler) {
            DDHandler dDHandler;
            if (idMap == null) {
                SAFReplyHandler.init();
            }
            if ((dDHandler = (DDHandler)idMap.get(string)) == null) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug(string + ": not found");
                }
                return;
            }
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug(string + " found as destination: " + dDHandler.getName());
            }
            messageImpl.setJMSReplyTo(dDHandler.getDDImpl());
        }
    }

    private static synchronized void init() {
        idMap = new HashMap();
        Iterator iterator = DDManager.getAllDDHandlers();
        while (iterator.hasNext()) {
            DDHandler dDHandler = (DDHandler)iterator.next();
            if (dDHandler.getReferenceName() == null) continue;
            if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                JMSDebug.JMSFrontEnd.debug("Adding " + dDHandler.getName() + " to table with referenceName " + dDHandler.getReferenceName());
            }
            idMap.put(dDHandler.getReferenceName(), dDHandler);
        }
        DDHandler.addGeneralStatusListener(singleton, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusChangeNotification(DDHandler dDHandler, int n) {
        SAFReplyHandler sAFReplyHandler = this;
        synchronized (sAFReplyHandler) {
            Iterator iterator = idMap.values().iterator();
            while (iterator.hasNext()) {
                DDHandler dDHandler2 = (DDHandler)iterator.next();
                if (dDHandler2 != dDHandler) continue;
                iterator.remove();
                break;
            }
            if ((n & 0x10) != 0) {
                return;
            }
            if (dDHandler.getReferenceName() != null) {
                if (JMSDebug.JMSFrontEnd.isDebugEnabled()) {
                    JMSDebug.JMSFrontEnd.debug("Adding " + dDHandler.getName() + " to table with referenceName " + dDHandler.getReferenceName());
                }
                idMap.put(dDHandler.getReferenceName(), dDHandler);
            }
        }
    }

    static {
        singleton = new SAFReplyHandler();
    }
}

